﻿<%@ Page Language="C#" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <meta name="viewport" content="width=device-width" />
      <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.5/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-SgOJa3DmI69IUzQ2PVdRZhwQ+dy64/BUtbMJw1MZ8t5HZApcHrRKUc4W0kG879m7" crossorigin="anonymous">
    <title>Bank Statement</title>
        <%: Scripts.Render("~/bundles/jquery") %>
        <%: Scripts.Render("~/bundles/jqueryui") %>
        <%: Scripts.Render("~/bundles/modernizr") %>
        <%: Scripts.Render("~/bundles/CryptoJS") %>
        <%: Scripts.Render("~/bundles/form2js") %>
        <%: Scripts.Render("~/bundles/printThis") %>
        <%: Scripts.Render("~/bundles/jquerymaskedinput") %>
        <%: Scripts.Render("~/bundles/jquery_dataTables") %>
        <%: Scripts.Render("~/bundles/Q") %>
        <%: Scripts.Render("~/bundles/CustomUtils") %>
        <%: Scripts.Render("~/bundles/toWords") %>

        <%: Styles.Render("~/Content/site") %>
        <%: Styles.Render("~/Content/style") %>
        <%: Styles.Render("~/Content/jquery_dataTables_min") %>
        <%: Styles.Render("~/Content/smoothness") %>
        <%: Styles.Render("~/Content/jqrejectcss") %>
        <%: Styles.Render("~/Content/jquery_dataTables_themeroller_min") %>
        <%: Styles.Render("~/Content/themes/base/css") %>
    <style type="text/css">
        
        .td_amount_col {
            text-align: right;
        }
        
        
    </style>
</head>

<body>
    <div>
        <form id="frmBankStatement" name="frmBankStatement">
    <%= Html.AntiForgeryToken() %>
     <div class="card">
            <div class="card-body">
                <div class="row g-3 mb-1">
                    <div class="col-md-3">
                        <label class='form-label'>Financial year</label>
                        <select id="cboYear" class="form-select">
                            <option value="selectyear">SELECT YEAR</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class='form-label'>Start period</label>
                        <select id="cboStartMonth" class="form-select">
                            <option value="selectstartperiod">Select Start Period</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class='form-label'>End period</label>
                        <select id="cboEndMonth" class="form-select">
                            <option value="selectEndperiod">Select End Period</option>
                        </select>
                    </div>
                </div>
                <div class="row g-3 mb-1">
                    <div class="col-md-3">
                        <label class='form-label'>Search by</label>
                        <select id="cboSearchBy" class="form-select">
                            <option value="accountno" selected>AccountNo</option>
                            <option value="memberno">MemberNo</option>
                            <option value="idnumber">IDNo</option>
                            <option value="payrollno">PayrollNo</option>
                        </select>
                    </div>
                    <div class="col-md-3 mt-4">
                        <label id="divSearchDisplay">Search value</label>
                        <input type="text" id="txtSearchValue" class="form-control"/>
                    </div>
                    <div class="col-md-3">
                        <label class='form-label'>Employer</label>
                        <select id="cboEmployer" class="form-select">
                            <option value="" selected>SELECT EMPLOYER</option>
                        </select>
                    </div>
                </div>
                <div class="row g-3 mb-1">
                    <div class="col-md-3">
                        <label class='form-label'>Select Account</label>
                        <select id="cboAccount" class="form-select">
                            <option>SELECT ACCOUNT</option>
                        </select>
                    </div>
                </div>
                <div class="row g-3 mt-1">
                    <div class="col-md-3">
                        <input type="button" id="btnGetStatement" value="Get Statement" class="btn btn-primary"/>
                    </div>
                    <div class="col-md-3">
                        <input type="button" id="btnPrint" value="Print Statement" class="btn btn-warning"/>
                    </div>
                    <div class="col-md-3" >
                        <input type="button" value="test report" id="btnTestReport" hidden="hidden" />
                        <input type="button" value="test print report" id="btnTestPrintReport" hidden="hidden" />
                        <span id="divPDF" class="btn btn-secondary">PDF Report</span>
                    </div>
                </div>
            </div>
        </div>
    </form>
    <div class="card mt-2">
            <div class="card-body">
                <h4>Account Information</h4>
                <div class="row g-3 mt-1">
                    <div id="divAccountInfo"></div>
                </div>
            </div>
        </div>
     <div class="card mt-2" id="divStatement" style="padding-left: 10px;padding-right: 10px;padding-bottom: 10px;">
            <div class="table-responsive mt-4 mb30" style="height: 350px;">
                <table class="table table-bordered" id='tblStatement'>
                    <thead>
                        <tr>
                            <th>TRX ID</th>
                            <th>Date</th>
                            <th>Description</th>
                            <th>Doc No</th>
                            <th>Debit</th>
                            <th>Credit</th>
                            <th>Balance</th>
                        </tr>
                    </thead>
                    <tbody id='bdStatement'>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>
    <script type="text/javascript"  >

        $(document).ready(function () {
            var SaccoSettings = Object(<%= Json.Encode(ViewBag.SaccoSettings) %>);
            var UserDetails = Object(<%= Json.Encode(ViewBag.UserDetails) %>);
            var strLoginUserName = UserDetails.UserName;
            var AccountMask = SaccoSettings.AccountFormat;
            var CompanyName = SaccoSettings.CompanyName;
            var CompanyAddress = SaccoSettings.CompanyAddress;
            var FinYears = Object(<%= Json.Encode(ViewBag.FinYears as List<XtremeERP.Common.Data.FinancialYear>) %>);

            var BankStatementItems = null;
            $('#tblStatement tbody td:nth-child(1),th:nth-child(1)').hide();

            //self init coz is not part of StaffMaster
            

            //global_site_root defined in CustomUtils.js
            //global_site_root =String(<% =Url.Content("~/") %>);

            global_site_root = "<% =MvcHtmlString.Create(Url.Content("~/")) %>"; //is for creating safe html strings
            if (global_site_root.endsWith("/")) global_site_root = global_site_root.substring(0, global_site_root.length - 1);;//remove ending slash

            /*
            NOTE: if app is published in iis under Default Web Site global_site_root will be eg / SaccoSystem / else it will return / if it is published directly as a web app under Sites (which is the recommended way to avoid problems with urls ie publish directly under Sites not underanother website)
            In View/Controller/WebApi use
            httpContext.Request.ApplicationPath or
            var httpRequest = HttpContext.Current.Request;
            var appPathUrl = httpRequest.ApplicationPath.ToString();
            see also var rootUrl = getRootUrl(); in CustomUtils to get app main url
            https://www.codeproject.com/Articles/142013/There-is-something-about-Paths-for-Asp-net-beginne
            https://www.cambiaresearch.com/articles/35/how-do-i-get-the-application-path-in-an-aspnet-application
            */


                $("#cboYear").empty();
                $("#txtSearchValue").val("");
                $("#btnSelectAcc").on('click', function () {
                    $("#cboSearchBy").prop("selectedIndex", 0);
                    xDialogSelectGLAccount("ALL").then(function (data) {
                        $("#txtSearchValue").val(data);
                        $("#txtSearchValue").focus();
                    });
                });
                /*
                $('#tblStatement').dataTable({
                    "paging": false,
                    "ordering": false,
                    "info": false,
                    "searching": false
                });
                $('#tblTransactionDetails').dataTable({
                    "paging": false,
                    "ordering": false,
                    "info": false,
                    "searching": false
                });
                */
                $("#cboSearchBy").on('click', function () {
                    $('#divSearchDisplay').empty();
                    $('#divSearchDisplay').append('Enter ' + $("#cboSearchBy option:selected").text());
                    if (AccountMask != "") {
                        if ($("#cboSearchBy").val() == "accountno") {
                            $("#txtSearchValue").mask(AccountMask);
                        } else {
                            $("#txtSearchValue").unmask();
                        }
                    }
                });
                $("#cboSearchBy").trigger('click');

                $("#txtSearchValue").on('focusout', function () {
                    LoadBankStatementAccounts();
                });
                $("#txtSearchValue").keypress(function (ev) {
                    if (ev.keyCode == 13 || ev.which == 13) {
                        $("#txtSearchValue").trigger('focusout');
                        ev.preventDefault();
                        return false;
                    }
                });
                $("#cboAccount").on('change', function () {
                    LoadBankStatement();
                });
                $('#tblStatement tbody').on('click', 'tr', function () {
                    var TrxID = $(this).find('td').eq(0).text();
                    DispTransactionsDetails(TrxID);
                });
                $("#btnGetAccounts").on('click', function () {
                    LoadBankStatementAccounts();
                });

                $("#cboYear").on('change', function () {
                    var dbname = $("#cboYear").val();
                    if (dbname == null) { return; }
                    $("#cboStartMonth").empty();
                    $("#cboEndMonth").empty();

                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/BankSystemApi/GetAllBOSAFinancialMonths") %>",
                        data: JSON.stringify({ 'DBName': $("#cboYear").val() }),
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            var fmonths = response;
                            var objEnd = document.getElementById("cboEndMonth");
                            var objStart = document.getElementById("cboStartMonth");
                            $("#cboStartMonth").empty();
                            $("#cboEndMonth").empty();
                            $.each(fmonths, function (index, fmonth) {
                                var opt = document.createElement("option");
                                opt.value = fmonth.MonthID;
                                opt.text = fmonth.MonthName;
                                objEnd.appendChild(opt);
                                if (fmonth.Status == "OPENED") {
                                    objEnd.selectedIndex = index
                                }
                                opt = document.createElement("option");
                                opt.value = fmonth.MonthID;
                                opt.text = fmonth.MonthName;
                                objStart.appendChild(opt);
                                if (fmonth.MonthID == "01") {
                                    objStart.selectedIndex = index
                                }
                            });
                        },
                        error: function (xhr, status, error) {

                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            alert('Error - ' + errorMessage); 
                        }
                    });
                });
                $("#btnSearchAccount").on('click', function () {
                    xDialogSearchCustomerAccount().then(function (data) {
                        $("#cboSearchBy").prop('selectedIndex', 0);
                        $("#txtSearchValue").val(data.AccountNo);
                        $("#txtSearchValue").trigger('focusout');
                    });
                });
                //$("#tblStatement").on('keydown','tr',function (evt) {
                //    alert("not working!!");
                //    var TrxID = $(this).find('td').eq(0).text();
                //    DispTransactionsDetails(TrxID);
                //});
                $("#tblStatement").on('keyup',function (evt) {
                    alert("not working!!");
                    var TrxID = $(this).find('td').eq(0).text();
                    DispTransactionsDetails(TrxID);
                });
                $("#btnPrint").click(function () {
                    //$("#mySelector").printThis({
                    //debug: false,              * show the iframe for debugging
                    //importCSS: true,           * import page CSS
                    //printContainer: true,      * grab outer container as well as the contents of the selector
                    //loadCSS: "path/to/my.css", * path to additional css file
                    //pageTitle: "",             * add title to print page
                    //removeInline: false        * remove all inline styles from print elements

                    var rptHeader = "<b>" + CompanyName + "<br>" + CompanyAddress + "</br>" + "Bank Statement" + "</b>";
                    $("#divStatement").printThis({
                        debug: false,
                        pageTitle: "Report",
                        removeInline: true,
                        printContainer: true,
                        importCSS: true,
                        header: rptHeader
                    });

                });

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetAllEmployer") %>",
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var employers = response;
                        var obj = document.getElementById("cboEmployer");
                        $.each(employers, function (index, empl) {
                            var opt = document.createElement("option");
                            opt.value = empl.EmployerCode;
                            opt.text = empl.EmployerName;
                            obj.appendChild(opt);
                        });
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }

                });
            $("#cboYear").empty();
            $.each(FinYears, function (index, FinYr) {
                $("#cboYear").append("<option value='" + FinYr.DBName + "'>" + FinYr.UserDefinedYearName + "</option>");
            });
            $("#cboYear").get(0).selectedIndex = 0;
            $("#cboYear").trigger('change');



                function DispTransactionsDetails(TrxID)
                {
                    
                    $("#tblTransactionDetails > tbody:last").children().remove();
                    if (BankStatementItems == null) return;
                    var TransDetails = $.grep(BankStatementItems, function (e) {
                        return e.Trx == TrxID.toString();
                    });
                    if (TransDetails[0] !== undefined) {
                        var tbl_row = "";
                        tbl_row += "<tr><td>User: </td><td>" + TransDetails[0].CLERK + "</td></tr>";
                        tbl_row += "<tr><td>Debit A/C: </td><td>" + TransDetails[0].DebitAccountCode + "</td></tr>";
                        tbl_row += "<tr><td>Dr A/c Name: </td><td>" + TransDetails[0].DebitAccountName + "</td></tr>";
                        tbl_row += "<tr><td>Credit A/C: </td><td>" + TransDetails[0].CreditAccountCode + "</td></tr>";
                        tbl_row += "<tr><td>Cr A/c Name: </td><td>" + TransDetails[0].CreditAccountName + "</td></tr>";
                        tbl_row += "<tr><td>Activity: </td><td>" + TransDetails[0].Activity + "</td></tr>";
                        tbl_row += "<tr><td>MemberNo: </td><td>" + TransDetails[0].MemberNo + "</td></tr>";
                        tbl_row += "<tr><td>MemberName: </td><td>" + TransDetails[0].MemberNames + "</td></tr>";
                        tbl_row += "<tr><td>BranchName: </td><td>" + TransDetails[0].BranchName + "</td></tr>";
                        tbl_row += "<tr><td>BranchCD: </td><td>" + TransDetails[0].BranchCD + "</td></tr>";
                        tbl_row += "<tr><td>Day: </td><td>" + TransDetails[0].TransDay + "</td></tr>";
                        tbl_row += "<tr><td>Time: </td><td>" + TransDetails[0].TransTime + "</td></tr>";
                        $("#tblTransactionDetails").append(tbl_row);
                    }
                    
                }



                function LoadBankStatement() {
                    BankStatementItems = null;
                    $('#divAccountInfo').html("");
                    $("#tblStatement > tbody:last").children().remove();
                    $("#tblTransactionDetails > tbody:last").children().remove();
                    $("#divPDF").html("PDF Report");
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/BankSystemApi/GetBankStatement") %>",
                        data: JSON.stringify({ 'DBName': $("#cboYear").val(), 'StartPeriod': $("#cboStartMonth").val(), 'EndPeriod': $("#cboEndMonth").val(), 'AccountNo': $("#cboAccount").val() }),
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            BankStatementItems = response.StatementItems;
                            $('#divAccountInfo').html('<p><strong>Account Name: ' + response.StatementAccount.AccountName + '<br>'
                                                                + 'Account Code: ' + response.StatementAccount.UserCode + '<br>'
                                                                + 'Account Type: ' + response.StatementAccount.ParentAccName + '<br>'

                                                                 + '</strong></p>');
                            if (response.StatementAccount.MemberDetails != null) {
                                $('#divAccountInfo').append('<p><strong>MemberName: ' + response.StatementAccount.MemberDetails.FullNames + '<br>'
                                                                    + 'MemberNo: ' + response.StatementAccount.MemberDetails.MemberNo + '<br>'
                                                                    + 'PayrollNo: ' + response.StatementAccount.MemberDetails.PayrollNo + '<br>'
                                                                + 'IDNo: ' + response.StatementAccount.MemberDetails.IDNumber + '<br>'
                                                                 + '</strong></p>');
                            }

                            var lineitems = response.StatementItems;
                            var tbl_row = "";
                            var pdf_url = "<b><a href='" + global_site_root + "/Bank/BankSystem/GetBankStatementReport?DBName=" + $("#cboYear").val() + "&StartPeriod=" + $("#cboStartMonth").val() + "&EndPeriod=" + $("#cboEndMonth").val() + "&AccountNo=" + response.StatementAccount.UserCode + "'>PDF Report</a></b>";
                            $("#divPDF").html(pdf_url);
                            $.each(lineitems, function (index, lineitem) {
                                tbl_row += "<tr><td>" + lineitem.Trx + "</td><td>" + lineitem.Document_Date + "</td><td class='td_description'>" + lineitem.Description + "</td><td class='td_description'>" + lineitem.Document_no + "</td><td class='td_amount_col'>" + lineitem.Debit.formatMoney() + "</td><td class='td_amount_col'>" + lineitem.Credit.formatMoney() + "</td><td class='td_amount_col'>" + lineitem.RunBal.formatMoney() + "</td></tr>";
                            });

                            tbl_row += "<tr>";
                            tbl_row += "<td></td><td colspan=6><i>**************End of Statement***********</i></td>";
                            tbl_row += "</tr>";
                            $("#bdStatement").append(tbl_row);
                            $('#tblStatement tbody td:nth-child(1),th:nth-child(1)').hide();
                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            alert('Error - ' + errorMessage);
                        }
                    });
                }
                function LoadBankStatementAccounts() {

                    $("#cboAccount").empty();
                    $("#cboAccount").append('<option selected>NO ACCOUNT</option>');

                    $('#divAccountInfo').html("");
                    $("#tblStatement > tbody:last").children().remove();
                    $("#tblTransactionDetails > tbody:last").children().remove();
                    $("#divPDF").html("PDF Report");
                    if ($("#txtSearchValue").val().trim() == "") { return; }
                    if ($("#txtSearchValue").val().trim() == AccountMask) { return; }

                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/BankSystemApi/GetBankStatementAccounts") %>",
                        data: JSON.stringify({ 'SearchBy': $("#cboSearchBy").val(), 'SearchValue': $("#txtSearchValue").val(), 'EmpCode': $("#cboEmployer").val() }),
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            var bankaccounts = response;
                            var obj = document.getElementById("cboAccount");
                            $("#cboAccount").empty();
                            $.each(bankaccounts, function (index, bankaccount) {
                                var opt = document.createElement("option");
                                opt.value = bankaccount.UserCode;
                                opt.text = "A/C: " + bankaccount.UserCode + " A/C Name: " + bankaccount.AccountName;
                                obj.appendChild(opt);
                            });
                            LoadBankStatement();
                        },
                        error: function (xhr, status, error) {

                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            alert('Error - ' + errorMessage);
                        }
                    });
            }

            function setCookie(c_name, value, expiredays) {
                var exdate = new Date();
                exdate.setDate(exdate.getDate() + expiredays);
                document.

                    e = c_name + "=" + escape(value) +
                    ((expiredays == null) ? "" : ";expires=" + exdate.toUTCString());
            }
            function getCookie(c_name) {
                if (document.cookie.length > 0) {
                    c_start = document.cookie.indexOf(c_name + "=");
                    if (c_start != -1) {
                        c_start = c_start + c_name.length + 1;
                        c_end = document.cookie.indexOf(";", c_start);
                        if (c_end == -1) c_end = document.cookie.length;
                        return unescape(document.cookie.substring(c_start, c_end));
                    }
                }
                return "";
            }

            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion();
            });
        });

    </script>
</html>
