﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Members/Views/Shared/MembersMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Guarantorship Information
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        
        .td_amount_col {
            text-align: right;
        }
        
    </style>

    
    <script type="text/javascript"  >
        $(document).ready(function () {
            var LoanTypeList = null;
            var TotalDeposits = 0;
            var TotalGuaranteedToOthers = 0;
            var bolIsSaccoBalozi =<%= (XtremeERP.Common.Utilities.Utils.bolIsSaccoBalozi ? "true" : "false") %>;

            InitSummary();

            


            function InitSummary() {

                $("#tblMemberDetails > tbody:last").children().remove();
                $("#tblBalances > tbody:last").children().remove();
                $("#tblLoansGuaranteedToMe > tbody:last").children().remove();
                $("#tblLoansGuaranteedByMe > tbody:last").children().remove();
                $("#tblLoansDetails > tbody:last").children().remove();

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: '<%: Url.Content("~/api/MembersSystemApi/GetMemberSummary") %>',
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var MemberDetails = response.GeneralSummary.MemberDetails;
                        var MemberBalances = response.GeneralSummary.MemberBals;
                        
                        var LoansGuaranteedByMe = response.LoansGuaranteedByMe;
                        var LoansGuaranteedToMe = response.LoansGuaranteedToMe;
                        var LoansInService = response.LoansInService;
                        

                        LoanTypeList = response.LoansForCalc;
                        $("#cboLoanType").empty();
                        $("#cboLoanType").append('<option selected>(SELECT LOAN)</option>');
                        $.each(LoanTypeList, function (index, LoanType) {
                            $("#cboLoanType").append("<option value='" + LoanType.LoanTypeCode + "'>" + LoanType.LoanTypeName + "</option'>");
                        });

                        var tbl_row = "";
                        tbl_row += "<tr><td>Surname</td><td>" + MemberDetails.Surname + "</td></tr>";
                        tbl_row += "<tr><td>Other Names</td><td>" + MemberDetails.OtherNames + "</td></tr>";
                        tbl_row += "<tr><td>Member No:</td><td>" + MemberDetails.MemberNo + "</td></tr>";
                        tbl_row += "<tr><td>PayrollNo</td><td>" + MemberDetails.PayrollNo + "</td></tr>";
                        tbl_row += "<tr><td>IDNo</td><td>" + MemberDetails.IDNumber + "</td></tr>";
                        tbl_row += "<tr><td>EmpCode</td><td>" + MemberDetails.EmployerCode + "</td></tr>";
                        tbl_row += "<tr><td>DOB</td><td>" + MemberDetails.DOB + "</td></tr>";
                        tbl_row += "<tr><td>Age</td><td>" + MemberDetails.Age + "</td></tr>";
                        tbl_row += "<tr><td>Default A/C</td><td>" + MemberDetails.SalaryAccount + "</td></tr>";
                        tbl_row += "<tr><td>Phone No.</td><td>" + MemberDetails.PhoneNo + "</td></tr>";
                        tbl_row += "<tr><td>EMail Address</td><td>" + MemberDetails.EMailAddress + "</td></tr>";
                        tbl_row += "<tr><td>Present Address</td><td>" + MemberDetails.PresentAddress + "</td></tr>";
                        tbl_row += "<tr><td>Home Address</td><td>" + MemberDetails.HomeAddress + "</td></tr>";

                        

                        if (bolIsSaccoBalozi) {
                            tbl_row += "<tr><td>Bank</td><td>" + MemberDetails.MainBankName + "</td></tr>";
                            tbl_row += "<tr><td>Bank Branch</td><td>" + MemberDetails.BankBranchName + "</td></tr>";
                            tbl_row += "<tr><td>Bank Account No:</td><td>" + MemberDetails.AccountNo + "</td></tr>";

                            tbl_row += "<tr><td>Land Line:</td><td>" + MemberDetails.LandLine + "</td></tr>";
                            tbl_row += "<tr><td>Land Line1:</td><td>" + MemberDetails.LandLine1 + "</td></tr>";
                            tbl_row += "<tr><td>Land Line2:</td><td>" + MemberDetails.LandLine2 + "</td></tr>";
                            tbl_row += "<tr><td>EMail2:</td><td>" + MemberDetails.Email2 + "</td></tr>";
                        }

                        TotalDeposits = response.GeneralSummary.TotalDeposits;
                        TotalGuaranteedToOthers = response.GeneralSummary.TotalGuaranteedToOthers;

                        tbl_row += "<tr><td>Total Loan Balance:</td><td class='td_amount_col'>" + (+response.GeneralSummary.TotalLoanBalance).formatMoney() + "</td></tr>";
                        tbl_row += "<tr><td>Total Deposits:</td><td class='td_amount_col'>" + (+TotalDeposits).formatMoney() + "</td></tr>";
                        tbl_row += "<tr><td>Total Amount Guaranteed to Others:</td><td class='td_amount_col'>" + (+TotalGuaranteedToOthers).formatMoney() + "</td></tr>";

                        $("#bdMemberDetails").append(tbl_row);

                        $("#lblDepositsMultiplied").text((+0).formatMoney());
                        $("#lblDepositsBalance").text((+TotalDeposits).formatMoney());
                        $("#lblAmountGuaranteedOthers").text((+TotalGuaranteedToOthers).formatMoney());
                        $("#lblAmountYouCanGuaranteedOthers").text((+0).formatMoney());
                        $("#lblMultiplier").text((+0).formatMoney());


                        tbl_row = "";

                        $.each(MemberBalances, function (index, MemberBalance) {
                            if ((+MemberBalance.BalAmount) != 0) {
                                tbl_row += "<tr><td>" + MemberBalance.BalType + "</td><td>" + MemberBalance.BalCode + "</td><td>" + MemberBalance.BalName + "</td><td class='td_amount_col'>" + (+MemberBalance.BalAmount).formatMoney() + "</td></tr>";
                            }
                        });
                        //tbl_row += "<tr><td></td><td></td><td>TOTAL DEPOSITS</td><td class='td_amount_col'>" + (+TotalDeposits).formatMoney() + "</td></tr>";
                        tbl_row += "<tr><td></td><td></td><td>TOTAL LOANS</td><td class='td_amount_col'>" + (+response.GeneralSummary.TotalLoanBalance).formatMoney() + "</td></tr>";
                        $("#bdBalances").append(tbl_row);
                        //hide column with BalType
                        $('#tblBalances tr').find('td:eq(0),th:eq(0)').hide();
                        //hide column with BalCode
                        $('#tblBalances tr').find('td:eq(1),th:eq(1)').hide();

                        tbl_row = "";
                        $.each(LoansInService, function (index, lnInService) {

                            tbl_row += "<tr><td>" + lnInService.LoanSerialNumber + "</td><td>" + lnInService.LoanTypeName + "</td><td>" + lnInService.IssueDate + "</td><td>" + lnInService.ExpectedEndDate + "</td><td class='td_amount_col'>" + (+lnInService.LoanAmount).formatMoney() + "</td><td class='td_amount_col'>" + (+lnInService.LoanBalance).formatMoney() + "</td><td class='td_amount_col'>" + (+lnInService.InstallmentAmount).formatMoney() + "</td><td class='td_amount_col'>" + (+lnInService.RepaymentPeriod).formatMoney() + "</td><td class='td_amount_col'>" + (+lnInService.Interest).formatMoney() + "</td></tr>";
                            
                        });
                        
                        $("#bdLoansDetails  ").append(tbl_row);

                        tbl_row = "";
                        var lnSn = "";
                        var totalPledgedAmount = 0;
                        var totalCommittedAmount = 0;
                        $.each(LoansGuaranteedToMe, function (index, LoanGuaranteedToMe) {
                            if ((lnSn != LoanGuaranteedToMe.LoanSerialNumber)) {
                                if (index != 0) {
                                    tbl_row += "<tr><td>TOTAL GUARANTEED</td><td></td><td></td><td></td><td></td><td></td><td class='td_amount_col'>" + (+totalPledgedAmount).formatMoney() + "</td><td class='td_amount_col'>" + (+totalCommittedAmount).formatMoney() + "</td><td></td></tr>";
                                    tbl_row += "<tr>";
                                    tbl_row += "<td colspan=9><hr/></td>";
                                    tbl_row += "</tr>";
                                    
                                }
                                totalPledgedAmount = 0;
                                totalCommittedAmount = 0;
                                lnSn = LoanGuaranteedToMe.LoanSerialNumber;
                            }
                            totalPledgedAmount += (+LoanGuaranteedToMe.PledgedAmt);
                            totalCommittedAmount += (+LoanGuaranteedToMe.CommittedAmount);

                            tbl_row += "<tr><td>" + LoanGuaranteedToMe.LoanSerialNumber + "</td><td>" + LoanGuaranteedToMe.LoanTypeName + "</td><td>" + (+LoanGuaranteedToMe.LoanBalance).formatMoney() + "</td><td>" + LoanGuaranteedToMe.GuarantorMemberNo + "</td><td>" + LoanGuaranteedToMe.GuarantorName + "</td><td>" + LoanGuaranteedToMe.GuarantorPhoneNo + "</td><td class='td_amount_col'>" + (+LoanGuaranteedToMe.PledgedAmt).formatMoney() + "</td><td class='td_amount_col'>" + (+LoanGuaranteedToMe.CommittedAmount).formatMoney() + "</td><td>" + LoanGuaranteedToMe.ExpectedEndDate + "</td></tr>";
                        });
                        if (totalPledgedAmount != 0 || totalCommittedAmount!=0) {
                            tbl_row += "<tr><td>TOTAL GUARANTEED</td><td></td><td></td><td></td><td></td><td></td><td class='td_amount_col'>" + (+totalPledgedAmount).formatMoney() + "</td><td class='td_amount_col'>" + (+totalCommittedAmount).formatMoney() + "</td><td></td></tr>";
                            tbl_row += "<tr>";
                            tbl_row += "<td colspan=9><hr/></td>";
                            tbl_row += "</tr>";
                        }
                        
                        $("#bdLoansGuaranteedToMe").append(tbl_row);

                        tbl_row = "";
                        $.each(LoansGuaranteedByMe, function (index, LoanGuaranteedByMe) {
                            tbl_row += "<tr><td>" + LoanGuaranteedByMe.LoanSerialNumber + "</td><td>" + LoanGuaranteedByMe.LoanTypeName + "</td><td>" + LoanGuaranteedByMe.LoaneeMemberNo + "</td><td>" + LoanGuaranteedByMe.LoaneeName + "</td><td>" + LoanGuaranteedByMe.LoaneePhoneNo + "</td><td class='td_amount_col'>" + (+LoanGuaranteedByMe.PledgedAmt).formatMoney() + "</td><td class='td_amount_col'>" + (+LoanGuaranteedByMe.CommittedAmount).formatMoney() + "</td><td class='td_amount_col'>" + (+LoanGuaranteedByMe.LoanBalance).formatMoney() + "</td><td>" + LoanGuaranteedByMe.ExpectedEndDate + "</td></tr>";
                        });
                        $("#bdLoansGuaranteedByMe").append(tbl_row);
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });

            }
            
            function getCookie(c_name) {
                if (document.cookie.length > 0) {
                    c_start = document.cookie.indexOf(c_name + "=");
                    if (c_start != -1) {
                        c_start = c_start + c_name.length + 1;
                        c_end = document.cookie.indexOf(";", c_start);
                        if (c_end == -1) c_end = document.cookie.length;
                        return unescape(document.cookie.substring(c_start, c_end));
                    }
                }
                return "";
            }

            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion({
                    heightStyle: "content"
                });
            });

        });
    </script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
   
<div class="card p-0 m-4"> 
        <%= Html.AntiForgeryToken() %> 
        <% XtremeERP.Common.Data.SaccoSettings saccoSettings = ViewBag.saccoSettings as XtremeERP.Common.Data.SaccoSettings; %>
        <% XtremeERP.Common.Data.SaccoMember saccoMember = ViewBag.SaccoMember as XtremeERP.Common.Data.SaccoMember; %>
        <% XtremeERP.Common.Data.MemberPortalSettings portalSettings = ViewBag.PortalSettings as XtremeERP.Common.Data.MemberPortalSettings; %>
       
        <h2  class="p-3 fs-5">Guarantorship Information</h2>
        <hr class="m-0 p-0">
<div class="p-3">
        <div >
            <div class="table-responsive " id="divLoansGuaranteedToMe">
                <h5 id="lnkGuarantors" class="fs-6">Loans You Have Been Guaranteed</h5>
                <table id='tblLoansGuaranteedToMe' class="table table-striped table-bordered text-nowrap">
                        <thead class="thead-dark">
                            <tr>
                            <th>Loan No</th>
                            <th>Loan Name</th>
                            <th>Loan Balance</th>
                            <th>Member No</th>
                            <th>Name</th>
                            <th>PhoneNo</th>
                            <th style="text-align: right;padding:7px">Pledged</th>
                            <th style="text-align: right;padding:7px">Committed</th>
                            <th>Expected End Date</b></th>
                            </tr>
                        </thead>
                        <tbody id='bdLoansGuaranteedToMe'>
                        </tbody>
                        
                    </table>
            </div>
        </div>
        
        <div class="row mt-4">
            <div class="col-md-12 table-responsive" id="divLoansGuaranteedByMe">
                <h4 class="fs-6">Loans You Have Guaranteed Others</h4>
                <table id='tblLoansGuaranteedByMe' class="table table-striped table-bordered text-nowrap">
                    <thead class="thead-dark">
                        <tr>
                            <th>Loan No</th>
                            <th>Loan Name</th>
                            <th>Member No</th>
                            <th>Name</th>
                            <th>PhoneNo</th>
                            <th style="text-align: right; padding: 7px">Pledged</th>
                            <th style="text-align: right; padding: 7px">Committed</th>
                            <th style="text-align: right; padding: 7px">Loan Balance</th>
                            <th>Expected End Date</th>
                        </tr>
                    </thead>
                    <tbody id='bdLoansGuaranteedByMe'>
                    </tbody>

                </table>
              
                <p class="text-center small fs-6 text-secondary">End of Report</p>
                
                
            </div>
        </div>

</div>
        </div>  
      
    <div id="loading" style="display:none"><img src="<%: Url.Content("~/Content/images/ajax-loader.gif") %>"  alt="Ajax Loader" />Contacting server....</div>
    <div id="divStatementDlg" style="display:none" ><iframe id="ifStatementDlg" style="height:640px;width:1140px"></iframe></div>
    
</asp:Content>
