﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Members/Views/Shared/MembersMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    BOSA Statement
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        .td_amount_col {
            text-align: right;
        }
        .statementFooter{
            text-align:center;
        }
    </style>
    <script type="text/javascript"  >
        $(document).ready(function () {
            
            //$("#btnPrint").toggle();
            $("#btnPrint").click(function () {
                var rptHeader = "" + CompanyName + "<br>" + CompanyAddress + "</br>" + "BOSA Statement" + "" + $("#divAccountInfo").html();
                
                $("#divStatement").printThis({
                    debug: false,
                    pageTitle: "Report",
                    removeInline: true,
                    printContainer: true,
                    importCSS: true,
                    header: rptHeader
                });
            });

            
            
            
            $("#cboYear").empty();
            var bolIsLoading = true;
            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: '<%: Url.Content("~/api/MembersSystemApi/GetYears") %>',
                data: "{}",
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    var years = response;
                    var obj = document.getElementById("cboYear");
                    $.each(years, function (index, yrs) {
                        var opt = document.createElement("option");
                        opt.value = yrs.DBName;
                        opt.text = yrs.UserDefinedYearName;
                        opt.selected = true;
                        obj.appendChild(opt);
                    });
                    //$("#cboYear option:first").attr('selected', true);
                    $("#cboYear").get(0).selectedIndex = 0;
                    LoadFinancialPeriods();
                },
                error: function (xhr, status, error) {

                    var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                }
            });

            $("#cboYear").on("change", function () {
                LoadFinancialPeriods();
            });
            $("#cboEndMonth").on("change", function () {
                LoadBOSAStatement();
            });
            $("#cboFormat").on("change", function () {
                LoadBOSAStatement();
            });

            $('#tblStatement').dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            
            function LoadFinancialPeriods() {
                var dbname = $("#cboYear").val();
                if (dbname == null) { return; }
                $("#cboEndMonth").empty();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: '<%: Url.Content("~/api/MembersSystemApi/GetAllBOSAFinancialMonths") %>',
                    data: JSON.stringify({ 'DBName': $("#cboYear").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var fmonths = response;
                        var objEnd = document.getElementById("cboEndMonth");


                        $("#cboEndMonth").empty();
                        $.each(fmonths, function (index, fmonth) {
                            var opt = document.createElement("option");
                            opt.value = fmonth.MonthID;
                            opt.text = fmonth.MonthName;
                            objEnd.appendChild(opt);
                            if (fmonth.Status == "OPENED") {
                                objEnd.selectedIndex = index
                            }
                        });
                        if (dbname.trim().toLowerCase() !== SaccoSettings.LatestDB.trim().toLowerCase()) //not test
                        {
                            $("#cboEndMonth option:last").attr('selected', true);
                            //$("#cboEndMonth option:last").attr('selected', 'selected');
                            //or depending on jq version
                            //$("#cboEndMonth option:last").prop('selected', 'selected');
                        }
                        $("#cboFormat").val(PortalSettings.DefaultBOSAStatementView.toLowerCase()); //this will trigger LoadBOSAStatement() if val is not the same; TODO add variable isLoading

                        bolIsLoading = false;
                        LoadBOSAStatement();
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                    }
                });
            }



            function LoadBOSAStatement() {
                if (bolIsLoading) return;
                
                row = 1;
                $('#divAccountInfo').html("");
                $("#tblStatement > tbody:last").children().remove();
                $("#divPDF").html("View Report");

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: '<%: Url.Content("~/api/MembersSystemApi/GetBOSAStatement") %>',
                    data: JSON.stringify({ 'DBName': $("#cboYear").val(), 'StatementFormat': $("#cboFormat").val(), 'EndPeriod': $("#cboEndMonth").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        row = 1;
                        $('#divAccountInfo').empty();
                        $("#tblStatement > tbody:last").children().remove();
                        if (response.StatementMember != null) {
                            $('#memName').text( response.StatementMember.FullNames);
                            $('#memNo').text( response.StatementMember.MemberNo);
                            $("#payrollNo").text( response.StatementMember.PayrollNo);
                            $('#idNo').text( response.StatementMember.IDNumber);
                          
                        }

                        var lineitems = response.StatementItems;
                        var statref = "";
                        var total = 0;
                        var inttotal = 0;
                        var tbl_row = "";

                        var pdf_url = "<a target='_blank' href='" + global_site_root + "/Members/MembersSystem/BOSAStatementReport?DBName=" + $("#cboYear").val() + "&EndPeriod=" + $("#cboEndMonth").val() + "&StatementFormat=" + $("#cboFormat").val() + "'>View Report <i class='fa-solid fa-expand'></i></a>";
                        $("#divPDF").html(pdf_url);

                         $("#downloadLink").click(function () {
                                var rptHeader = "" + CompanyName + "<br>" + CompanyAddress + "</br>" + "BOSA Statement" + "" + $("#divAccountInfo").html();
                                var pdfUrl = $("#divPDF a").attr("href");;
                                var link = document.createElement('a');
                                link.href = pdfUrl;
                                link.download = 'BOSA-Statement-' + $('#memName').text() + $(' #memNo').text() + '.pdf';
                                console.log(link.download);
                                document.body.appendChild(link);
                                link.click();
                                document.body.removeChild(link);

                            });

                        $.each(lineitems, function (index, lineitem) {
                            row = row + index;
                            if (statref != lineitem.StatRef) {
                                total = 0;
                                inttotal = 0;
                                statref = lineitem.StatRef;

                                if (index != 0) {
                                    tbl_row = "<tr>";
                                    tbl_row += "<td colspan=8><hr/></td>";
                                    tbl_row += "</tr>";
                                }

                                tbl_row = "<tr>";
                                tbl_row += "<td style='text-align: left;'>" + lineitem.RefCode + "</td>";
                                tbl_row += "<td style='text-align: left;'>" + lineitem.RefName + "</td>";
                                tbl_row += "<td style='text-align: left;'>Doc. No.</td>";
                                tbl_row += "<td class='td_amount_col' >Debit</td>";
                                tbl_row += "<td class='td_amount_col' >Credit</td>";
                                tbl_row += "<td class='td_amount_col' >Balance</td>";
                                tbl_row += "<td class='td_amount_col' >Int. Debit</td>";
                                tbl_row += "<td class='td_amount_col' >Int. Credit</td>";
                                tbl_row += "<td class='td_amount_col' >Balance</td>";
                                tbl_row += "</tr>";
                                $("#bdStatement").append(tbl_row);
                            }

                            if (statref.substring(0, 1) == "S") {
                                total = +total - +lineitem.Debit + +lineitem.Credit;
                                inttotal = +inttotal - +lineitem.IntDebit + +lineitem.IntCredit;
                            } else {
                                total = +total + +lineitem.Debit - +lineitem.Credit;
                                inttotal = +inttotal + +lineitem.IntDebit - +lineitem.IntCredit;
                            }

                            tbl_row = "<tr>";

                            tbl_row += "<td style='text-align: left;'>" + lineitem.DocDate + "</td>";
                            tbl_row += "<td style='text-align: left;'>" + lineitem.Description + "</td>";
                            tbl_row += "<td style='text-align: left;'>" + lineitem.DocNo + "</td>";
                            tbl_row += "<td class='td_amount_col' >" + lineitem.Debit.formatMoney() + "</td>";
                            tbl_row += "<td class='td_amount_col' >" + lineitem.Credit.formatMoney() + "</td>";
                            tbl_row += "<td class='td_amount_col' >" + total.formatMoney() + "</td>";
                            tbl_row += "<td class='td_amount_col ColIntDebit' >" + lineitem.IntDebit.formatMoney() + "</td>";
                            tbl_row += "<td class='td_amount_col ColIntCredit' >" + lineitem.IntCredit.formatMoney() + "</td>";
                            tbl_row += "<td class='td_amount_col ColIntBalance' >" + inttotal.formatMoney() + "</td>";

                            tbl_row += "</tr>";
                            $("#bdStatement").append(tbl_row);



                        });


                        tbl_row = "<tr>";
                        tbl_row += "<td colspan=9 class='statementFooter'><i>**************End of Statement***********</i></td>";
                        tbl_row += "</tr>";
                        $("#bdStatement").append(tbl_row);

                        //hide InterestDR,InterestCr,InterestBal
                        if (PortalSettings.LoansAndInterestAreCombinedInSystem) {
                            $('#tblStatement tr').find('td:eq(6),th:eq(6)').hide();
                            $('#tblStatement tr').find('td:eq(7),th:eq(7)').hide();
                            $('#tblStatement tr').find('td:eq(8),th:eq(8)').hide();
                        }
                        
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                    }
                });


            }

            function setCookie(c_name, value, expiredays) {
                var exdate = new Date();
                exdate.setDate(exdate.getDate() + expiredays);
                document.

                    e = c_name + "=" + escape(value) +
                ((expiredays == null) ? "" : ";expires=" + exdate.toUTCString());
            }
            function getCookie(c_name) {
                if (document.cookie.length > 0) {
                    c_start = document.cookie.indexOf(c_name + "=");
                    if (c_start != -1) {
                        c_start = c_start + c_name.length + 1;
                        c_end = document.cookie.indexOf(";", c_start);
                        if (c_end == -1) c_end = document.cookie.length;
                        return unescape(document.cookie.substring(c_start, c_end));
                    }
                }
                return "";
            }

            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion({
                    heightStyle: "content"
                });
            });

        });
    </script>
</asp:Content>


<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    

<div class="">
    
    
    
    
    
    
    
    <div class="pb-5" > 
        
        
        
        <div id="div1" class="card">
            <h6 class="fw-bold p-2 my-2 text-center">Bosa Statement</h6>
            <form id="frmBOSAStatement" name="frmBOSAStatement">
                <%= Html.AntiForgeryToken() %>
                <hr class="p-0 m-0"/>
               <div class="row p-3">
                  
                   
                    <div class="col-md-4  ">
                        <label for=" Financial Year:" class="form-label" > Financial Year</label>

                        <select id="cboYear" class="form-select"><option value="selectyear">SELECT YEAR</option></select>
                    </div>

                      <div class="col-md-4">
                        <label for=" Period:" class="form-label" > Period</label>

                     
                            <select id="cboEndMonth" class=" form-select"><option value="selectEndperiod">Select End Period</option></select>
                      </div>
                      <div class="col-md-4">
                        <label for=" Format" class="form-label" >Format</label>

                       <select class="form-select" id="cboFormat"><option value="standard">Standard</option><option value="groupbyloantype">Group By Loan Type</option></select>
                      </div>
                  
                      
                      
                    </div>
                    <div class="p-3 gap-2 d-flex flex-wrap">
                      
                        <div class="">
                            <div id="btnPrint" class="btn btn-success">Print Statement <i class="fa-solid fa-print"></i></div>
                        </div>
                        <div class="btn btn-warning" id="divPDF">View Report </div>
                        <div class=" btn btn-secondary" id="downloadLink"> Download PDF <i class="fa-solid fa-download">
                    
                            </i>
                        </div>
                    
               </div>



            </form>
        </div>
    
        <div class="col-md-12 p-3 my-2 card" >
           
            <div class="row">
                <div class="col-sm-auto">
                    <label class="form-label">Member Name</label>
                    <div id="memName" class="form-control"></div>
                </div>
            <div class="col-sm-auto">
                <label class="form-label">Member No</label>
                <div class="form-control" id="memNo"></div>
            </div>
            <div class="col-sm-auto">
                <label class="form-label">Payroll No</label>
                <div id="payrollNo" class="form-control"></div>
            </div>
            <div class="col-sm-auto">
                <label class="form-label">ID No</label>
                <div id="idNo" class="form-control"></div>
            </div>
            </div>
      

        <div id="divStatement"  class="col-md-12 table-responsive mt-4" >
            <table id='tblStatement'  class="table table-striped table-bordered table-sm row-fluid text-nowrap">
                    <thead>
                        <tr>
                        <th style="text-align: left;">Date</th>
                        <th style="text-align: left;">Description</th>
                        <th style="text-align: left;">Doc No</th>
                        <th style="text-align: right;">Debit</th>
                        <th style="text-align: right;">Credit</th>
                        <th style="text-align: right;">Balance</th>
                        <th style="text-align: right;" class="ColHDIntDebit">Int. Debit</th>
                        <th style="text-align: right;" class="ColHDIntCredit">Int. Credit</th>
                        <th style="text-align: right;" class="ColHDIntBalance">Int. Balance</th>
                        </tr>
                    </thead>
                    <tbody id='bdStatement'>
                    </tbody>
                <tfoot style="display:none">
                    <tr>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td class="td_amount_col"></td>
                        <td class="td_amount_col"></td>
                        <td class="td_amount_col"></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    
    </div>
    </div>
</div>



   </asp:Content>


