﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Members/Views/Shared/MembersMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Guarantors Requests
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        .td_amount_col {
            text-align: right;
        }
    </style>
    <script type="text/javascript"  >
        $(document).ready(function () {
            $("#cboYear").empty();
            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url:'<%: Url.Content("~/api/MembersSystemApi/GetYears") %>',
                data: "{}",
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    var years = response;
                    var obj = document.getElementById("cboYear");
                    $.each(years, function (index, yrs) {
                        var opt = document.createElement("option");
                        opt.value = yrs.DBName;
                        opt.text = yrs.UserDefinedYearName;
                        opt.selected = true;
                        obj.appendChild(opt);
                    });
                    $("#cboYear").get(0).selectedIndex = 0;
                    LoadGuarantorsRequests();
                },
                error: function (xhr, status, error) {

                    var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                }
            });

            $("#cboYear").on("change", function () {
                LoadGuarantorsRequests();
            });
            $("#cboLnApplicationStatus").on("change", function () {
                LoadGuarantorsRequests();
            });
            
            /*
            $('#tblGuarantorsRequests').dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            */
            $('#bdGuarantorsRequests').on('click', 'a', function (event) {
                event.preventDefault();
                var ln_ref_no = $(this).closest('tr').find('td').eq(1).text();
                var ln_mem_no = $(this).closest('tr').find('td').eq(2).text();
                var ln_requested_loanee_name = $(this).closest('tr').find('td').eq(3).text();
                var ln_requested_loan_type = $(this).closest('tr').find('td').eq(4).text();
                var ln_loan_amt = $(this).closest('tr').find('td').eq(5).text();
                var ln_requested_amt = $(this).closest('tr').find('td').eq(6).text();
                var ln_type_code = $(this).closest('tr').find('td').eq(10).text();
                
                $('<div id="divGuarantorsRequestDialog"></div>').dialog({
                    modal: true,
                    title: "Respond to Guarantorship Request",
                    height: 'auto',
                    width: Math.min(500, $(window).width() * .8), /*https://stackoverflow.com/questions/16471890/responsive-jquery-ui-dialog-and-a-fix-for-maxwidth-bug see answer - Not responsive in the sense that if the width is narrowed the dialog shrinks, but responsive in the sense that on a specific device, the dialog will not be too wide.*/
                    autoOpen: true,
                    responsive:true,
                    show: {
                        effect: "drop",
                        direction: "up",
                        duration: 500
                    },

                    buttons: {
                        'OK': {
                            'text': 'OK',
                            'id': 'btnOKGuarantorship',
                            'class': 'btn btn-primary',/*Use className if you get errors in some browsers like IE just remove styling!!!*/
                            'click': function () {
                                var accepted_amount = $("#txtAcceptedAmt").val();
                                var ConfirmMessage = "";
                                if (document.getElementById("cboGuarantorResponse").selectedIndex == 1) {
                                    if (!isNumber(accepted_amount)) {
                                        alert("Invalid Amount");
                                        return;
                                    }
                                    else if (+accepted_amount <= 0) {
                                        alert("Amount should be more than zero");
                                        return;
                                    }
                                    ConfirmMessage = "Confirm Acceptance of Guarantorship Request of " + (+accepted_amount).formatMoney() + " ?";
                                } else if (document.getElementById("cboGuarantorResponse").selectedIndex == 2) {
                                    ConfirmMessage = "Confirm Rejection of Guarantorship Request?";
                                } else if (document.getElementById("cboGuarantorResponse").selectedIndex == 0) {
                                    alert("Select Response");
                                    return;
                                }
                                xDialogConfirm(ConfirmMessage, "Confirm").then(function () {
                                    xDialogMemberCredetials().then(function (data) {
                                        var csrfToken = $("input[name='__RequestVerificationToken']").val();
                                        var Password = data.UserPass;
                                        var pwdslt = getRandomInt(1000, 30000);
                                        pwdslt = pwdslt.toString();
                                        var pwd = CryptoJS.MD5(Password).toString();
                                        pwd = pwd + pwdslt;
                                        var sltpwd = CryptoJS.MD5(pwd).toString();
                                        var outData = {
                                            'DBName': $("#cboYear").val(),
                                            'LoanRefNo': $("#txtRequestLoanRefNo").val(),
                                            'AcceptedAmount': $("#txtAcceptedAmt").val(),
                                            'Response': $("#cboGuarantorResponse").val(),
                                            'Notes': $("#txtResponseReason").val(),
                                            'Password': sltpwd,
                                            'Salt': pwdslt
                                        }
                                        outData = JSON.stringify(outData);
                                        $.ajax({
                                            headers: { __RequestVerificationToken: csrfToken },
                                            type: "POST",
                                            url: '<%: Url.Content("~/api/MembersSystemApi/ProcessMemberLoanApplicationGuarantorResponse") %>',
                                            data: outData,
                                            contentType: "application/json; charset=utf-8",
                                            dataType: "json",
                                            success: function (response) {
                                                alert(response);
                                                $("#divGuarantorsRequestDialog").dialog("close");
                                                LoadGuarantorsRequests();
                                            },
                                            error: function (xhr, status, error) {
                                                var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                                            }
                                        });
                                    });
                                });
                            }
                        },
                        'Cancel': {
                            'text': 'Cancel',
                            'class': 'btn btn-danger',/*Use className if you get errors in some browsers like IE just remove styling!!!*/
                            'id': 'btnCancel',
                            'click': function () {
                                $(this).dialog("close");
                                deferred.reject();
                            }
                        }
                    },
                    open: function () {
                        var tbl = "<div class='table-responsive p-3'><table id='tblRespondGuarantorRequest'  class='table table-responsive table-bordered'>";
                        tbl += "<tbody>";
                        tbl += "<tr><td>Loan Ref. No:</td><td><input type='text' id='txtRequestLoanRefNo' value='" + ln_ref_no + "' disabled /></td></tr>";
                        tbl += "<tr><td>Loanee:</td><td><input type='text' id='txtRequestLoaneeName' value='" + ln_requested_loanee_name + "' disabled /></td></tr>";
                        tbl += "<tr><td>Loane MemberNo:</td><td><input type='text' id='txtRequestLoaneeMemberNo' value='" + ln_mem_no + "' disabled /></td></tr>";
                        tbl += "<tr><td>Loan Type:</td><td><input type='text' id='txtRequestLoanType' value='" + ln_requested_loan_type + "' disabled /></td></tr>";
                        tbl += "<tr><td>Loan Amount:</td><td><input type='text' id='txtRequestLoanAmount' value='" + ln_loan_amt + "' disabled class='td_amount_col' /></td></tr>";
                        tbl += "<tr><td>Requested:</td><td><input type='text' id='txtRequestGuarAmt' value='" + ln_requested_amt + "' disabled class='td_amount_col' /></td></tr>";

                        tbl += "<tr><td>Scheme:</td><td><input type='text' id='txtSchemeName' value='" + "0.00" + "' disabled  /></td></tr>";
                        tbl += "<tr><td>Balance:</td><td><input type='text' id='txtSchemeBalance' value='" + "0.00" + "' disabled class='td_amount_col' /></td></tr>";
                        tbl += "<tr><td>Available to Pledge:</td><td><input type='text' id='txtAvailableShares' value='" + "0.00" + "' disabled class='td_amount_col' /></td></tr>";

                        tbl += "<tr><td>Reponse:</td><td><select id='cboGuarantorResponse'><option value='' selected>(SELECT)</option><option value='accepted'>Accept</option><option value='rejected'>Reject</option></select></td></tr>";
                        tbl += "<tr><td>Accepted Amt:</td><td><input type='text' id='txtAcceptedAmt' value='0.00' class='td_amount_col' /></td></tr>";
                        tbl += "<tr><td>Amt In Words:</td><td><div id='divAcceptedAmtInWords'></td></tr>";
                        tbl += "<tr style='display:none'><td>Notes/Reason:</td><td><textarea id='txtResponseReason' disabled/></textarea></td></tr>";
                        tbl += '<tr><td colspan="2"><input type="checkbox" id="chkGuarantorTOC" /> I have read, understood and accepted the <p ><a style="color:blue" target="_blank" href="<%: Url.Content("~/TermsAndConditions/GuarantorsTOC.pdf") %>"> terms and conditions </a></p><br /><br /></td></tr>';
                        
                        tbl += "</tbody></table></div>";
                        $(this).html(tbl);
                        $("#cboGuarantorResponse").focus;
                        $("#btnOKGuarantorship").prop('disabled', true);
                        $("#chkGuarantorTOC").on('change', function (e) {
                            $("#btnOKGuarantorship").prop('disabled', true);
                            if ($(this).is(':checked')) {
                                $("#btnOKGuarantorship").prop('disabled', false);
                            }
                        });
                        chkGuarantorTOC

                        var csrfToken = $("input[name='__RequestVerificationToken']").val();
                        $.ajax({
                            headers: { __RequestVerificationToken: csrfToken },
                            type: "POST",
                            url: global_site_root + '/api/MembersSystemApi/GetMemberAvailableShares',
                            data: JSON.stringify({ 'LoanTypeCode': ln_type_code, 'AppliedLoanNo': "" }),
                            contentType: "application/json; charset=utf-8",
                            dataType: "json"
                        }).success(function (response) {
                            //alert(JSON.stringify(response));
                            $("#txtSchemeName").val(response.SchemeName);
                            $("#txtSchemeBalance").val((+response.SchemeBalance).formatMoney());
                            $("#txtAvailableShares").val((+response.AvailableShares).formatMoney());
                        }).error(function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            alert('Error to get Available Shares - ' + errorMessage);
                        });


                    },
                    close: function (event, ui) {
                        $(this).dialog("destroy").remove();
                    }
                });
                $("#txtPassword").on("keyup", function (e) {
                    var kcode = (e.keyCode ? e.keyCode : e.which);
                    if (kcode == $.ui.keyCode.ENTER) {
                        $("#btnOK").trigger("click");
                    }
                    e.stopPropagation();
                });
                $("#txtAcceptedAmt").on('change keyup paste mouseup', function () {
                    $("#divAcceptedAmtInWords").html("");
                    try {
                        $("#divAcceptedAmtInWords").html(toWords($(this).val()));
                    } catch (err) {

                    }
                });
                $("#cboGuarantorResponse").on('change', function () {
                    $("#txtAcceptedAmt").val(0);
                    $("#divAcceptedAmtInWords").html("");
                    $("#txtAcceptedAmt").attr("disabled", true);
                    $("#txtResponseReason").attr("disabled", true);
                    $("#txtResponseReason").val("");

                    if ($("#cboGuarantorResponse option:selected").index() == 1) {
                        $("#txtAcceptedAmt").attr("disabled", false);
                        $("#txtResponseReason").attr("disabled", false);
                        //$("#txtAcceptedAmt").val(ConvertMoneyToDouble(ln_requested_amt));
                        $("#txtAcceptedAmt").val(ConvertMoneyToDouble($("#txtRequestGuarAmt").val()));

                    }
                    else if ($("#cboGuarantorResponse option:selected").index() == 2) {
                        $("#txtAcceptedAmt").attr("disabled", true);
                        $("#txtAcceptedAmt").val(0);
                        $("#txtResponseReason").attr("disabled", true);
                    }
                });
            });

            

            function LoadGuarantorsRequests() {
                $("#tblGuarantorsRequests > tbody:last").children().remove();
                var dbname = $("#cboYear").val();
                if (dbname == null) { return; }
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url:'<%: Url.Content("~/api/MembersSystemApi/GetMemberGuarantorsRequests") %>',
                    data: JSON.stringify({ 'DBName': $("#cboYear").val(), 'LoanStatus': $("#cboLnApplicationStatus").val()  }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var GuarantorsRequests = response;
                        var tbl_row = "";
                        $.each(GuarantorsRequests, function (index, GuarantorsRequest) {
                            $("#tblGuarantorsRequests > tbody:last").children().remove();
                            tbl_row += "<tr>";
                            tbl_row += "<td>" + GuarantorsRequest.LoanDate + "</td>";
                            tbl_row += "<td>" + GuarantorsRequest.LoanRefNo + "</td>";
                            tbl_row += "<td>" + GuarantorsRequest.LoaneeMemberNo + "</td>";
                            tbl_row += "<td>" + GuarantorsRequest.LoaneeNames + "</td>";
                            tbl_row += "<td>" + GuarantorsRequest.LoanTypeName + "</td>";
                            tbl_row += "<td>" + (+GuarantorsRequest.LoanAmount).formatMoney() + "</td>";
                            tbl_row += "<td>" + (+GuarantorsRequest.RequestedAmount).formatMoney() + "</td>";
                            tbl_row += "<td>" + (+GuarantorsRequest.AcceptedAmount).formatMoney() + "</td>";
                            tbl_row += "<td>" + GuarantorsRequest.GuarantorResponse + "</td>";
                            tbl_row += "<td><a href=''>Respond</td>";
                            tbl_row += "<td>" + GuarantorsRequest.LoanTypeCode + "</td>";
                            tbl_row += "<td>" + GuarantorsRequest.ProcessStatus + "</td>";
                            tbl_row += "</tr>";
                        });
                        if (tbl_row != "") {
                            $("#bdGuarantorsRequests").append(tbl_row);
                            $('#tblGuarantorsRequests td:nth-child(11),th:nth-child(11)').hide(); //hide loan code from user. not importanttblGuarantorsRequests
                        }
                        
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                    }
                });
            }

            function setCookie(c_name, value, expiredays) {
                var exdate = new Date();
                exdate.setDate(exdate.getDate() + expiredays);
                document.

                    e = c_name + "=" + escape(value) +
                ((expiredays == null) ? "" : ";expires=" + exdate.toUTCString());
            }
            function getCookie(c_name) {
                if (document.cookie.length > 0) {
                    c_start = document.cookie.indexOf(c_name + "=");
                    if (c_start != -1) {
                        c_start = c_start + c_name.length + 1;
                        c_end = document.cookie.indexOf(";", c_start);
                        if (c_end == -1) c_end = document.cookie.length;
                        return unescape(document.cookie.substring(c_start, c_end));
                    }
                }
                return "";
            }

           // $(function () {
             //   $("#tabs").tabs();
            //});
            $(function () {
                $("#accordion").accordion({
                    heightStyle: "content"
                });
            });
        });
    </script>
</asp:Content>


<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <div class="container-fluid">
        <div class="card bg-white">
        <h3 class="p-3 fs-5">Guarantors Requests</h3>
        <hr class="m-0 p-0"/>
        <div class="row p-3">
            <div id="div1">
                <form id="frmMain" name="frmMain" class="form">
                    <%= Html.AntiForgeryToken() %>
                    <div>
                        <div class="row mb-3">
                            <div class="col-md-4">
                                <label for="txtYear" class="form-label">Financial Year:</label>
                                <select id="cboYear" class="form-select">
                                    <option value="selectyear">SELECT YEAR</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label for="txtLoanApplicationStatus" class="form-label">Loan Application Status:</label>
                                <select id="cboLnApplicationStatus" class="form-select">
                                    <option value="pending" selected>ACTIVE</option>
                                    <option value="">ANY</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="row p-3">
            
            <h6>List of Guarantors Requests</h6>
             <div id="divGuarantorsRequests" class="table-responsive">
                        <table id='tblGuarantorsRequests' class='table table-responsive table-stripped table-bordered text-nowrap'>
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Ref.No</th>
                                    <th>MemberNo</th>
                                    <th>Names</th>
                                    <th>Loan Type</th>
                                    <th>Loan Amount</th>
                                    <th>Requested</th>
                                    <th>Accepted Amt</th>
                                    <th>Status</th>
                                    <th>Respond</th>
                                    <th>LoanCode</th>
                                    <th>ProcessStatus</th>
                                </tr>
                            </thead>
                            <tbody id='bdGuarantorsRequests'>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
            
        </div>
    </div>
</div>
</asp:Content>


