﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Members/Views/Shared/MembersMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Loan Application
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        #tblSasraLoanSectors tr.header, #tblSasraLoanSectors tr:hover {
            /* Add a grey background color to the table header and on hover */
            background-color: #f1f1f1;
        }

        .tblDRCRDetails {
            margin: 1px;
            border: 1em;
            padding-left: 1em;
            padding-top: 1em;
            border-collapse: separate;
        }

        /*use this for to calculate totals*/
        .colamount {
            text-align: right;
        }

        .td_amount_col {
            text-align: right;
        }

        
    </style>


    <script type="text/javascript">

        var hod_managers_list = null;

        var LoanTypeList = null;
        var MemberBalances = null;
        var MemberDetails = null;
        var AppliedLoanType = null;
        $(document).ready(function () {
            var loan_saving_scheme = "";
            var SavedLoanApplicationNumber = "";
            var bolNomineeRequired = true;

            var SASRASubSector2 = null;
            var SASRASubSector1 = null;
            var SASRAMainSectors = null;

            var ln_app_to_edit = null;
            $('#frmMain').on('mouseup', '[type=text],[type=date]', function (e) { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                e.preventDefault();
            });
            $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).select();
            });
            $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).addClass("textfocused");
            });
            $('#frmMain').on('focusout', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).removeClass("textfocused");
            });

            $("#txtLoanAmount").on('change keyup paste mouseup', function () {
                $("#divAmountInWords").html("");
                try {
                    var amtToWords = toWords($("#txtLoanAmount").val());
                    amtToWords = toTitleCase(amtToWords);
                    $("#divAmountInWords").html(amtToWords);
                    CalcRepayAmount();
                } catch (err) {

                }
            });
            $("#txtRepaymentPeriod").on('change keyup paste mouseup', function () {
                CalcRepayAmount();
            });

            $('#btnAddFile').on('click', function (event) {
                $('#divSelectFiles').append('<div class="input-group mt-2"><input type="file" class="form-control" accept=".pdf,.doc,.docx,.jpeg,.jpg,.bmp"> <a href="#" id="lnkRemoveFile" class="btn btn-secondary"> Remove File<a/></div>');
            });
            $('#divSelectFiles').on('click', 'a', function (event) {
                event.preventDefault();
                var parentDiv = $(this).closest('div');
                //var rm_memnames = $(this).closest('tr').find('td').eq(1).text();
                //var rm_row = $(this).closest('tr');
                xDialogConfirm("Remove file?", "Confirm").then(function () {
                    parentDiv.remove();
                });
                return false;
            });

            $("#flAddFileToLoanApplication").on('change', function () {
                
                try {
                    //coz error will be thrown ( seems error is thrown in console only) if user cancels select file dialog
                    //var file = $(this).files[0]; will not work see members masterfile for alternative //https://stackoverflow.com/questions/19954073/whats-the-reason-that-document-getelementbyid-works-but-jquery-doesnt
                    var file = $(this)[0].files[0]; //https://stackoverflow.com/questions/19954073/whats-the-reason-that-document-getelementbyid-works-but-jquery-doesnt
                    var filename = file.name;
                    var filesize = file.size;
                    var filetype = file.type;
                    var maxFileMB = 5 * 1024 * 1024; //5MB
                    var filepath = $(this).val();

                    //alert("New File Selected " + filepath + " File Name " + filename + " Size MB " + filesize / (1024 * 1024) + " File Type " + filetype); //returns fake path!!
                    //return;
                    if (file) {
                        var postdata = new FormData();
                        var fileCount = 0;
                        postdata.append("MemberLoanApplicationFile" + fileCount, file, filename);

                        if (filesize > maxFileMB) {
                            DispUserError("Maximum file attachment for upload is 5MB. " + filename + " is " + filesize / 1024 / 1024 + " MB which exceeds the acceptable size.");
                            return;
                        }
                        //alert("Done Size is" + filesize);

                        postdata.append("LoanRefNo", ln_app_to_edit.LoanRefNo);
                        postdata.append("IsNewLoan", "N");
                        postdata.append("DBName", $("#cboApplicationYear").val()); // will force controller to use latest dbname


                        var csrfToken = $("input[name='__RequestVerificationToken']").val();
                        $.ajax({
                            headers: { __RequestVerificationToken: csrfToken },
                            type: "POST",
                            url: '<%: Url.Content("~/api/MembersSystemApi/UploadMemberLoanApplicationFiles") %>',
                            contentType: false,
                            data: postdata,
                            processData: false,
                            success: function (data) {
                                alert("File Added");
                                DispAppliedLoanDocs(data);

                            },
                            error: function (xhr, status, error) {
                                var errorMessage = xhr.status + ': ' + xhr.responseText;
                                DispUserError('Error Uploading Files: - ' + errorMessage);
                            }
                        });

                    } else {
                        DispUserError("No File Selected");
                    }

                }
                catch (err) {
                    alert(err.message);
                    DispUserError(err.message);
                }
            });

            $('#divSelectFilesSavedLoan').on('click', 'a', function (event) {
                event.preventDefault();
                var parentDiv = $(this).closest('div');
                //var rm_memnames = $(this).closest('tr').find('td').eq(1).text();
                //var rm_row = $(this).closest('tr');
                xDialogConfirm("Remove file?", "Confirm").then(function () {
                    parentDiv.remove();
                });
                return false;
            });

            $('#btnTestSaveFile').on('click', function () {
                //SaveFiles();
            });

            /*
            $("#tblLoanProperties").dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            */

            /*
            $("#tblOffsets").dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            */

            //$("#tblGuarantors").dataTable({
            //    "paging": false,
            //    "ordering": false,
            //    "info": false,
            //    "searching": false
            //});
            //$("#tblLoanApplicationList").dataTable({
            //    "paging": false,
            //    "ordering": false,
            //    "info": false,
            //    "searching": false
            //});

            //$("#tblLoanProgress").dataTable({
            //    "paging": false,
            //    "ordering": false,
            //    "info": false,
            //    "searching": false
            //});

            /*
            $("#tblSavedLoanGuarantors").dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            */

            //$("#tblSavedAppliedLoanProperties").dataTable({
            //    "paging": false,
            //    "ordering": false,
            //    "info": false,
            //    "searching": false
            //});


            $('#bdGuarantors').on('click', 'a', function (event) {
                event.preventDefault();
                var rm_memno = $(this).closest('tr').find('td').eq(0).text();
                var rm_memnames = $(this).closest('tr').find('td').eq(1).text();
                var rm_row = $(this).closest('tr');
                xDialogConfirm("Remove Guarantor Member No: " + rm_memno + " Name: " + rm_memnames + "?", "Confirm").then(function () {
                    $(rm_row).remove();
                    AddNewGuarantorsTotals();
                });
                return false;
            });


            $("#cboLoanMainSector").on('change', function () {
                //alert($("#cboLoanMainSector").val());
                var filteredSectors = SASRASubSector1;
                if ($("#cboLoanMainSector").val() != "") {
                    filteredSectors = SASRASubSector1.filter(function (lnSector) {
                        return lnSector.MainSectorCode == $("#cboLoanMainSector").val();
                    });
                }
                $("#cboLoanSector1").empty();
                $("#cboLoanSector1").append('<option selected>(SELECT REASON FOR LOAN)</option>');
                $("#cboLoanSector2").empty();
                $("#cboLoanSector2").append('<option selected>(SELECT REASON FOR LOAN)</option>');
                $.each(filteredSectors, function (index, objSASRASubsector1) {
                    $("#cboLoanSector1").append("<option value='" + objSASRASubsector1.SubSector1Code + "'>" + objSASRASubsector1.SubSector1Name + "</option'>");
                });
            });
            $("#cboLoanSector1").on('change', function () {
                //alert($("#cboLoanMainSector").val());
                var filteredSectors = SASRASubSector2;
                if ($("#cboLoanSector1").val() != "") {
                    filteredSectors = SASRASubSector2.filter(function (lnSector) {
                        return lnSector.SubSector1Code == $("#cboLoanSector1").val();
                    });
                }
                $("#cboLoanSector2").empty();
                $("#cboLoanSector2").append('<option selected>(SELECT REASON FOR LOAN)</option>');
                $.each(filteredSectors, function (index, objSASRASubsector2) {
                    $("#cboLoanSector2").append("<option value='" + objSASRASubsector2.SubSector2Code + "'>" + objSASRASubsector2.SubSector2Name + "</option'>");
                });
            });

            $('#bdWitnesses').on('click', 'a', function (event) {
                event.preventDefault();
                var rm_memno = $(this).closest('tr').find('td').eq(0).text();
                var rm_memnames = $(this).closest('tr').find('td').eq(1).text();
                var rm_row = $(this).closest('tr');
                xDialogConfirm("Remove Witness Member No: " + rm_memno + " Name: " + rm_memnames + "?", "Confirm").then(function () {
                    $(rm_row).remove();
                });
                return false;
            });

            function DispAppliedLoanDocs(appliedLoanDocs) {
                var tbl_row = "";
                $("#tblSavedLoanAttachments > tbody:last").children().remove();
                var rootUrl = getRootUrl();
                //alert(rootUrl);
                //alert(global_site_root);
                $.each(appliedLoanDocs, function (index, lnDoc) {
                    tbl_row += "<tr>";
                    tbl_row += "<td><a target='_blank' href='" + global_site_root + "/Members/MembersSystem/GetMemberLoanApplicationFile?DBName=" + $("#cboApplicationYear").val() + "&LoanRefNo=" + ln_app_to_edit.LoanRefNo +"&DocID=" + lnDoc.DocID + "'>" + lnDoc.FileName + "</a></td>";
                    //tbl_row += "<td><a href='" + rootUrl + "Members/MembersSystem/GetMemberLoanApplicationFile?DBName=" + $("#cboApplicationYear").val() + "&LoanRefNo=" + ln_app_to_edit.LoanRefNo + "&DocID=" + lnDoc.DocID + "'>" + lnDoc.FileName + "</a></td>";
                    tbl_row += "<td style='display:none'>" + lnDoc.DocID + "</td>";
                    tbl_row += "<td><a href=''>Remove</a></td>";
                    tbl_row += "</tr>";
                });
                $("#bdSavedLoanAttachments").append(tbl_row);
            }


            $("#tblSavedLoanAttachments").on("click", "a", function (e) {
                e.preventDefault();
                var row = $(this).closest("tr");

                var col = $(this).closest("td");
                var col_index = col.index();
                //alert("col index is " + col_index + " col text is " + col.text()) ;

                //var firstCellValue = row.find("td").first().text();
                //alert(firstCellValue);
                //console.log(firstCellValue);
                if (col_index == 0)  //disp doc
                {
                    var docUrl = $(this).attr("href");
                    alert(editurl);
                    return false;
                } else if (col_index == 2) {  //remove saved doc

                    //var rm_memnames = $(this).closest('tr').find('td').eq(1).text();
                    //var rm_row = $(this).closest('tr');
                    var docurl = $(this).closest('tr').find('td').eq(0).find('a').attr("href");
                    var docid = $(this).closest('tr').find('td').eq(1).text();
                    var docUserFileName = $(this).closest('tr').find('td').eq(0).text();
                    //alert("File Name " + docUserFileName + " doc id " + docid);
                    //return;
                    xDialogConfirm("Remove file name " + docUserFileName + " from loan application number " + ln_app_to_edit.LoanRefNo + "?", "Confirm").then(function () { //TODO -security- ensure user file name is html encoded
                        var csrfToken = $("input[name='__RequestVerificationToken']").val();
                        var outData = {
                            'DBName': $("#cboApplicationYear").val(),
                            'LoanRefNo': ln_app_to_edit.LoanRefNo,
                            'DocID': docid
                        }
                        
                        outData = JSON.stringify(outData);
                        

                        $.ajax({
                            headers: { __RequestVerificationToken: csrfToken },
                            type: "POST",
                            url: '<%: Url.Content("~/api/MembersSystemApi/RemoveMemberLoanApplicationFile") %>',
                            data: outData,
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            success: function (response) {
                                DispAppliedLoanDocs(response);
                                //$(row).remove();
                            },
                            error: function (xhr, status, error) {
                                var errorMessage = xhr.status + ': ' + xhr.responseText;
                                //alert('Error - ' + errorMessage);
                                DispUserError('Error - ' + errorMessage);
                            }
                        });
                    });
                    return false;
                }
            });

            $('#bdLoanApplicationList').on('click', 'tr', function (event) {
                var sel_row = $(this)
                $("#lblLoanRefNo").html("");
                var loan_ref_no = sel_row.find('td').eq(0).text();
                $("#lblLoanRefNo").html("Loan Details for Ref No.: " + loan_ref_no + "<br/>");


                ln_app_to_edit = null;
                $('#bdLoanApplicationList tr').removeClass('row_selected');
                $(this).addClass('row_selected');

                $("#bdSavedLoanWitnesses > tbody:last").children().remove();
                $("#tblSavedLoanGuarantors > tbody:last").children().remove();
                $("#tblSavedFXDBalances > tbody:last").children().remove();
                $("#tblSavedOffsets > tbody:last").children().remove();
                $("#tblSavedAppliedLoanProperties > tbody:last").children().remove();
                $("#tblLoanProperties > tbody:last").children().remove();
                $("#tblSavedLoanWitnesses > tbody:last").children().remove();

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                var outData = {
                    'DBName': $("#cboApplicationYear").val(),
                    'LoanRefNo': loan_ref_no
                }
                outData = JSON.stringify(outData);

                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: '<%: Url.Content("~/api/MembersSystemApi/GetMemberLoanApplicationDetails") %>',
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {

                        ln_app_to_edit = response;
                        var row_datas = response.memberLoanApplicationGuarantor;
                        var tbl_row = "";
                        var savedFXDBalances = response.FXDBalances;
                        var savedOffsets = response.memberLoanApplicationOffset;
                        $.each(row_datas, function (index, row_data) {
                            tbl_row += "<tr>";
                            tbl_row += "<td>" + row_data.GuarantorMemberNo + "</td>";
                            tbl_row += "<td>" + row_data.GuarantorName + "</td>";
                            tbl_row += "<td>" + (+row_data.RequestedAmount).formatMoney() + "</td>";
                            tbl_row += "<td>" + (+row_data.AcceptedAmount).formatMoney() + "</td>";
                            tbl_row += "<td>" + row_data.GuarantorResponse + "</td>";
                            tbl_row += "<td>" + row_data.GuarantorNotes + "</td>";
                            tbl_row += "<td><a href=''>Remove</a></td>";

                            tbl_row += "</tr>";
                        });
                        $("#bdSavedLoanGuarantors").append(tbl_row);

                        DispAppliedLoanDocs(response.memberLoanApplicationDocs);


                        CalculateSavedGuarantorsTotals();

                        var tbl_row = "";
                        //below checkboxes disabled coz we dont support editing of saved FXD Amounts
                        $.each(savedFXDBalances, function (index, savedFXDBalance) {
                            tbl_row += "<tr><td><input type='checkbox' " + ((+savedFXDBalance.TransAmount) > 0 ? "checked" : "") + " disabled /></td><td>" + savedFXDBalance.BalType + "</td><td>" + savedFXDBalance.BalCode + "</td><td>" + savedFXDBalance.BalName + "</td><td>" + (+savedFXDBalance.BalAmount).formatMoney() + "</td><td><input type='text' value='" + savedFXDBalance.BalAmount + "' disabled /></td></tr>"
                        });
                        $("#bdSavedFXDBalances").append(tbl_row);

                        var tbl_row = "";
                        //below checkboxes disabled coz we dont support editing of saved Offsets
                        $.each(savedOffsets, function (index, savedOffset) {
                            tbl_row += "<tr><td><input type='checkbox' " + ((+savedOffset.Amount) > 0 ? "checked" : "") + " disabled /></td><td>" + savedOffset.OffsetType + "</td><td>" + savedOffset.LoanSerialNo + "</td><td>" + savedOffset.LN_LoanTypeName + "</td><td>" + (+savedOffset.LN_LoanBalance).formatMoney() + "</td><td><input type='text' value='" + savedOffset.Amount + "' disabled /></td></tr>"
                        });
                        $("#bdSavedOffsets").append(tbl_row);

                        row_datas = response.memberLoanApplicationWitness;
                        tbl_row = "";
                        $.each(row_datas, function (index, row_data) {
                            tbl_row += "<tr>";
                            tbl_row += "<td>" + row_data.WitnessMemberNo + "</td>";
                            tbl_row += "<td>" + row_data.WitnessNames + "</td>";
                            tbl_row += "<td>" + row_data.WitnessResponse + "</td>";
                            tbl_row += "<td>" + row_data.WitnessNotes + "</td>";
                            tbl_row += "<td>" + row_data.RequestDate + "</td>";
                            tbl_row += "<td>" + row_data.ResponseDate + "</td>";
                            tbl_row += "<td><a href=''>Remove</a></td>";

                            tbl_row += "</tr>";
                        });
                        $("#bdSavedLoanWitnesses").append(tbl_row);

                        row_datas = response.memberLoanApplication;
                        tbl_row = "";

                        tbl_row += "<tr>";
                        tbl_row += "<td>Payment Mode</td>";
                        tbl_row += "<td>" + row_datas.PaymentMode.toUpperCase() + "</td>";
                        tbl_row += "</tr>";

                        if (row_datas.PaymentMode.toLowerCase() == "BANK".toLowerCase()) {


                            tbl_row += "<tr>";
                            tbl_row += "<td>Bank Name</td>";
                            tbl_row += "<td>" + row_datas.BankName.toUpperCase() + "</td>";
                            tbl_row += "</tr>";

                            tbl_row += "<tr>";
                            tbl_row += "<td>Bank A/c: </td>";
                            tbl_row += "<td>" + row_datas.BankAccountNo.toUpperCase() + "</td>";
                            tbl_row += "</tr>";
                        } else if (row_datas.PaymentMode.toLowerCase() == "MOBILE".toLowerCase()) {
                            tbl_row += "<tr>";
                            tbl_row += "<td>Mobile No:</td>";
                            tbl_row += "<td>" + row_datas.MobileNo.toUpperCase() + "</td>";
                            tbl_row += "</tr>";

                            tbl_row += "<tr>";
                            tbl_row += "<td>Mobile Provider:</td>";
                            tbl_row += "<td>" + row_datas.MobilePaymentType.toUpperCase() + "</td>";
                            tbl_row += "</tr>";
                        } else if (row_datas.PaymentMode.toLowerCase() == "FOSA".toLowerCase()) {
                            tbl_row += "<tr>";
                            tbl_row += "<td>FOSA Account:</td>";
                            tbl_row += "<td>" + row_datas.FOSAAccount.toUpperCase() + "</td>";
                            tbl_row += "</tr>";

                        } else {
                            tbl_row += "<tr>";
                            tbl_row += "<td></td>";
                            tbl_row += "<td>Invalid Payment Details Provided</td>";
                            tbl_row += "</tr>";
                        }

                        tbl_row += "<tr>";
                        tbl_row += "<td>Reason Code</td>";
                        tbl_row += "<td>" + row_datas.SubSector2Code + "</td>";
                        tbl_row += "</tr>";

                        tbl_row += "<tr>";
                        tbl_row += "<td>Reason Name</td>";
                        tbl_row += "<td>" + row_datas.SubSector2Name + "</td>";
                        tbl_row += "</tr>";

                        tbl_row += "<tr>";
                        tbl_row += "<td>Manager Comments</td>";
                        tbl_row += "<td>" + row_datas.ManagerComments + "</td>";
                        tbl_row += "</tr>";

                        tbl_row += "<tr>";
                        tbl_row += "<td>Manager Response Date</td>";
                        tbl_row += "<td>" + row_datas.ManagerApprovalDate + "</td>";
                        tbl_row += "</tr>";

                        $("#bdSavedAppliedLoanProperties").append(tbl_row);


                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        //alert('Error - ' + errorMessage);
                        //$("#txtErrorMessage").val('Error - ' + errorMessage);
                        //$("#txtErrorMessage").focus();
                        DispUserError('Error - ' + errorMessage);
                    }
                });

                return false;
            });

            $('#bdSavedLoanGuarantors').on('click', 'a', function (event) {
                event.preventDefault();
                var rm_memno = $(this).closest('tr').find('td').eq(0).text();
                var rm_memnames = $(this).closest('tr').find('td').eq(1).text();
                var rm_row = $(this).closest('tr');
                xDialogConfirm("Remove Guarantor Member No: " + rm_memno + " Name: " + rm_memnames + "?", "Confirm").then(function () {
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    var outData = {
                        'DBName': $("#cboApplicationYear").val(),
                        'LoanApplicationNo': ln_app_to_edit.LoanRefNo,
                        'GuarantorMemberNo': rm_memno
                    }
                    outData = JSON.stringify(outData);
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: '<%: Url.Content("~/api/MembersSystemApi/RemoveGuarantorFromMemberLoanApplication") %>',
                        data: outData,
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            $(rm_row).remove();
                            CalculateSavedGuarantorsTotals();
                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            //alert('Error - ' + errorMessage);
                            DispUserError('Error - ' + errorMessage);
                        }
                    });
                });
                return false;
            });


            $('#bdSavedLoanWitnesses').on('click', 'a', function (event) {
                event.preventDefault();
                var rm_memno = $(this).closest('tr').find('td').eq(0).text();
                var rm_memnames = $(this).closest('tr').find('td').eq(1).text();
                var rm_row = $(this).closest('tr');
                xDialogConfirm("Remove Witness Member No: " + rm_memno + " Name: " + rm_memnames + "?", "Confirm").then(function () {
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    var outData = {
                        'DBName': $("#cboApplicationYear").val(),
                        'LoanApplicationNo': ln_app_to_edit.LoanRefNo,
                        'WitnessMemberNo': rm_memno
                    }
                    outData = JSON.stringify(outData);
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: '<%: Url.Content("~/api/MembersSystemApi/RemoveWitnessFromMemberLoanApplication") %>',
                        data: outData,
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            $(rm_row).remove();
                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            //alert('Error - ' + errorMessage);
                            DispUserError('Error - ' + errorMessage);
                        }
                    });
                });
                return false;
            });

            InitForm();
            $("#btnListManagers").on('click', function () {
                xDialogSelectManager(hod_managers_list).then(function (data) {
                    $("#txtNormnieeUserID").val(data);
                    $("#txtNormnieeUserID").trigger('focusout');
                    $("#txtNormnieeUserID").focus();
                });
            });
            $("#txtNormnieeUserID").on("focusout", function () {
                $("#divNormineeName").html("");
                if ($("#txtNormnieeUserID").val().trim() != "") {
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: '<%: Url.Content("~/api/MembersSystemApi/GetExternalUserName") %>',
                        data: JSON.stringify({ 'UserID': $("#txtNormnieeUserID").val() }),
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            $("#divNormineeName").html(response);
                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            //alert('Error - ' + errorMessage);
                            DispUserError('Error - ' + errorMessage);
                        }
                    });
                }
            });

            $("#cboLoanType").on('change', function () {
                AppliedLoanType = null;
                $("#tblLoanProperties > tbody:last").children().remove();
                loan_saving_scheme = "";
                var csrfToken = $("input[name='__RequestVerificationToken']").val();

                var LoanType = LoanTypeList.filter(function (lnType) {
                    return lnType.LoanTypeCode == $("#cboLoanType").val();
                });
                if (LoanType.length > 0) {
                    AppliedLoanType = LoanType[0];
                    //console.log(AppliedLoanType);
                    $("#txtRepaymentPeriod").val(AppliedLoanType.LoanMaxDuration + " Months");
                    loan_saving_scheme = AppliedLoanType.SchemeUsed;
                    $("#loanName").text(AppliedLoanType.LoanTypeName);
                    $("#maxAmount").val((+AppliedLoanType.LoanMaxAmount).formatMoney());
                    $("#interestRate").val(AppliedLoanType.Percentage + "%");
                    $("#canAlmagmateAll").text(AppliedLoanType.CanAlmagmateAll ? "YES" : "NO");
                    $("#canBridgeItself").text(AppliedLoanType.CanBridgeItself ? "YES" : "NO");
                    
                    $("#bdLoanProperties").append(tbl_row);
                    //var x = (AppliedLoanType.CanBridgeItself && !AppliedLoanType.CanAlmagmateAll).toString();
                    //alert(x);
                    //$("#divOnlyBridgeAllowed").html(x);


                    //Default to displaying all loans
                    var LoansToDisplayForOffset = MemberBalances.filter(function (lnType) {
                        return lnType.BalType.toString().toUpperCase() == "L".toUpperCase() || lnType.BalType.toString().toUpperCase() == "I".toUpperCase()
                    });


                    if (!AppliedLoanType.CanBridgeItself && !AppliedLoanType.CanAlmagmateAll) {
                        LoansToDisplayForOffset = null;
                    } else if (AppliedLoanType.CanAlmagmateAll) {
                        LoansToDisplayForOffset = LoansToDisplayForOffset;
                    } else if (AppliedLoanType.CanBridgeItself) {
                        //only display loans of the same type
                        LoansToDisplayForOffset = LoansToDisplayForOffset.filter(function (lnType) {
                            return lnType.BalCode.charAt(0).toUpperCase() == AppliedLoanType.LoanSerialIdentifier.toUpperCase()
                        });
                    }
                    $("#tblOffsets > tbody:last").children().remove();
                    if (LoansToDisplayForOffset != null) {
                        var tbl_row = "";
                        $.each(LoansToDisplayForOffset, function (index, LnOffset) {
                            tbl_row += "<tr><td><input type='checkbox' /></td><td>" + LnOffset.BalType + "</td><td>" + LnOffset.BalCode + "</td><td>" + LnOffset.BalName + "</td><td class='colamount'>" + (+LnOffset.BalAmount).formatMoney() + "</td><td><input type='text' class='colamount' value='" + LnOffset.BalAmount + "' disabled /></td></tr>"
                        });
                        $("#bdOffsets").append(tbl_row);
                    }
                    CalcRepayAmount();
                }

            });








            $("#cboApplicationYear").on('change', function () {
                GetMemberLoanApplicationsListing();
            });
            $("#cboProgressYear").on('change', function () {
                GetMemberLoansInProgress();
            });
            $("#cboLoanProgressStatus").on('change', function () {
                GetMemberLoansInProgress();
            });
            $("#btnProgressRefresh").on('click', function () {
                GetMemberLoansInProgress();
            });




            $("#btnRefresh").on('click', function () {
                GetMemberLoanApplicationsListing();
            });
            $("#btnCancel").on('click', function () {
                InitForm();
            });
           
            $(document).ready(function () {
  // Trigger name fetch on focusout
        $("#txtGuarantorMemberNo").on("focusout", function (e) {
            const memberNo = $(this).val().trim();
            const scheme = loan_saving_scheme; // assuming you have this globally

            //$("#divGuarantorNames").empty();
            $("#pghErrorAddGuarantor").text("");

            if (memberNo === "") return;

            const csrfToken = $("input[name='__RequestVerificationToken']").val();

            $.ajax({
            headers: { __RequestVerificationToken: csrfToken },
            type: "POST",
            url: global_site_root + "/api/MembersSystemApi/GetMemberSchemeBalance",
            data: JSON.stringify({ MemberNo: memberNo, SchemeCode: scheme }),
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            success: function (data) {
                $("#divGuarantorNames").val(data.saccoMember.FullNames);
            },
            error: function (xhr) {
                $("#pghErrorAddGuarantor").text("Invalid Member Number or Request Error");
            },
            });
        });

  // Add Guarantor
        $("#btnAddGuarantor").on("click", function (e) {
                e.preventDefault();
                const memberNo = $("#txtGuarantorMemberNo").val().trim();
                const guarantorNames = $("#divGuarantorNames").val().trim();
                const amountVal = $("#txtGuarantorAmount").val().trim();

                if (!memberNo || !guarantorNames || !amountVal) {
                alert("Please fill all fields before adding.");
                return;
                }

                const amount = ConvertMoneyToDouble(amountVal);
                if (isNaN(amount) || amount <= 0) {
                alert("Invalid amount");
                return;
                }

                const row = `
                <tr>
                    <td>${memberNo}</td>
                    <td>${guarantorNames}</td>
                    <td>${amount.formatMoney()}</td>
                    <td><a href="#" class="remove-guarantor text-danger text-center"><i class="fa-solid fa-trash"></i></a></td>
                </tr>`;

                $("#bdGuarantors").append(row);
                AddNewGuarantorsTotals();

                // clear input fields
                $("#txtGuarantorMemberNo, #txtGuarantorAmount","#divGuarantorNames").val("");
                
            });

            // Remove guarantor row
            $(document).on("click", ".remove-guarantor", function (e) {
                e.preventDefault();
                $(this).closest("tr").remove();
                AddNewGuarantorsTotals();
            });
            });
            $(document).ready(function () {
            // Auto-fetch Witness Name
            $("#txtWitnessMemberNo").on("focusout", function () {
                const memberNo = $(this).val().trim();
                $("#divWitnessNames").val();
                $("#pghErrorAddWitness").text("");

                if (memberNo === "") return;

                const csrfToken = $("input[name='__RequestVerificationToken']").val();

                $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: global_site_root + "/api/MembersSystemApi/GetMemberName",
                data: JSON.stringify({ MemberNo: memberNo }),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (data) {
                    $("#divWitnessNames").val(data);
                },
                error: function (xhr) {
                    $("#pghErrorAddWitness").text("Invalid Member Number or server error.");
                },
                });
            });

            // Add Witness (for new application)
            $("#btnAddWitness").on("click", function (e) {
                 e.preventDefault();
                const memberNo = $("#txtWitnessMemberNo").val().trim();
                const witnessNames = $("#divWitnessNames").val().trim();

                if (!memberNo || !witnessNames) {
                alert("Please enter a valid member number and wait for the name to load.");
                return;
                }

                const row = `
                <tr>
                    <td>${memberNo}</td>
                    <td>${witnessNames}</td>
                    <td><a href="#" class="remove-witness text-danger">Remove</a></td>
                </tr>`;

                $("#bdWitnesses").append(row);

                // Reset fields
                $("#txtWitnessMemberNo","#divWitnessNames").val("");
            });

            // Add More Witness (when editing existing application)
            $("#btnAddMoreWitness").on("click", function () {
                if (ln_app_to_edit == null) return;

                const memberNo = $("#txtWitnessMemberNo").val().trim();
                const witnessNames = $("#divWitnessNames").val().trim();

                if (!memberNo || !witnessNames) {
                alert("Please enter a valid member number and wait for the name to load.");
                return;
                }

                const csrfToken = $("input[name='__RequestVerificationToken']").val();

                $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: global_site_root + "/api/MembersSystemApi/AddWitnessToMemberLoanApplication",
                data: JSON.stringify({
                    DBName: $("#cboApplicationYear").val(),
                    LoanApplicationNo: ln_app_to_edit.LoanRefNo,
                    WitnessMemberNo: memberNo,
                }),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function () {
                    const row = `
                    <tr>
                        <td>${memberNo}</td>
                        <td>${witnessNames}</td>
                        <td>Pending</td>
                        <td></td><td></td><td></td>
                        <td><a href="#" class="remove-witness text-danger">Remove</a></td>
                    </tr>`;
                    $("#bdSavedLoanWitnesses").append(row);

                    $("#txtWitnessMemberNo","#divWitnessNames").val("");
                    
                },
                error: function (xhr) {
                    alert("Error saving witness: " + xhr.responseText);
                },
                });
            });

            // Remove Witness (from either table)
            $(document).on("click", ".remove-witness", function (e) {
                e.preventDefault();
                $(this).closest("tr").remove();
            });
            });


            $("#btnCancelApplication").on('click', function () {
                if (ln_app_to_edit == null) {
                    alert("Select Loan to cancel");
                    return;
                }
                xDialogConfirm("Are you sure you want to Cancel the selected loan application?<br/>Loan No=" + ln_app_to_edit.LoanRefNo + "<br/>Loan Type=" + ln_app_to_edit.LoanType.LoanTypeName + "<br/>Applied Amount " + (ln_app_to_edit.memberLoanApplication.RequestedAmount).formatMoney() + " ?", "Confirm").then(function () {
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    var outData = {
                        'DBName': $("#cboApplicationYear").val(),
                        'LoanApplicationNo': ln_app_to_edit.LoanRefNo,
                    }
                    outData = JSON.stringify(outData);
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: '<%: Url.Content("~/api/MembersSystemApi/CancelMemberLoanApplication") %>',
                        data: outData,
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            GetMemberLoanApplicationsListing();
                            alert("Loan application  number " + ln_app_to_edit.LoanRefNo + " successfully cancelled");
                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            //alert('Error - ' + errorMessage);
                            DispUserError('Error - ' + errorMessage);
                        }
                    });
                });
            });

            $("#btnSubmitLoanApplication").on('click', function () {
                if (ln_app_to_edit == null) {
                    alert("Select Loan to Submit");
                    return;
                }

                xDialogConfirm("Are you sure you want to Submit the selected loan application for processing?<br/>Loan No=" + ln_app_to_edit.LoanRefNo + "<br/>Loan Type=" + ln_app_to_edit.LoanType.LoanTypeName + "<br/>Applied Amount " + (ln_app_to_edit.memberLoanApplication.RequestedAmount).formatMoney() + " ?", "Confirm").then(function () {

                    xDialogMemberCredetials().then(function (data) {
                        SubmitLoanApplication(data);
                    });

                });
            });
            $("#chkLoanTOC").on('change', function (e) {
                $("#btnSave").prop('disabled', true);
                if ($(this).is(':checked')) {
                    $("#btnSave").prop('disabled', false);
                }
            });
            $("#cboPreferredPaymentMode").on('change', function () {
                $("#divFOSAAccounts").hide();
                $("#divBankDetails").hide();
                $("#divMobileDetails").hide();
                var prefPayMode = $("#cboPreferredPaymentMode option:selected").text();
                prefPayMode = prefPayMode.toString().toLowerCase();
                if (prefPayMode == "bank".toLowerCase()) $("#divBankDetails").show();
                if (prefPayMode == "fosa".toLowerCase()) $("#divFOSAAccounts").show();
                if (prefPayMode == "mobile".toLowerCase()) $("#divMobileDetails").show();

            });
            $("#btnSave").on('click', function () {
                if (document.getElementById("cboLoanType").selectedIndex == 0) {
                    //alert("Select Loan Type");
                    DispUserError("Select Loan Type");
                    return;
                }
                if (document.getElementById("cboPreferredPaymentMode").selectedIndex == 0) {
                    //alert("Select Loan Type");
                    DispUserError("Select Preferred Payment Mode");
                    return;
                }

                if (!isNumber(ConvertMoneyToDouble($("#txtLoanAmount").val()))) {
                    DispUserError("Invalid Amount");
                    return;
                }
                if (!isNumber(ConvertMoneyToDouble($("#txtRepaymentAmount").val()))) {
                    DispUserError("Invalid Repayment Amount");
                    return;
                }
                if (!isNumber(ConvertMoneyToDouble($("#txtRepaymentPeriod").val()))) {
                    DispUserError("Invalid Repayment Period");
                    return;
                }
                //if ($("#txtSasraLoanPurpose").val() == "") {
                  //  DispUserError("Specify loan purpose");
               //     return;
                //}
                var fileCount = 0;
                var shouldSendFiles = true;
                $('#divSelectFiles input[type=file]').each(function () {
                    if (!window.FileReader) { // This is VERY unlikely, browser support is near-universal ( 30Apri2023 tested and working in Android WebView. Check File Size and File Type though)
                        DispUserError("Please update your browser");
                        return;
                    }
                    var file = $(this)[0].files[0]; //https://stackoverflow.com/questions/19954073/whats-the-reason-that-document-getelementbyid-works-but-jquery-doesnt
                    var maxFileMB = 5 * 1024 * 1024; //5MB
                    if (file) {
                        var filename = file.name;
                        var filesize = file.size;
                        //alert("File " + filename + " is " + file.size + " bytes in size");
                        if (filesize > maxFileMB) {
                            DispUserError("Maximum file attachment for upload is 5MB. " + filename + " is " + filesize / 1024 / 1024 + " MB which exceeds the acceptable size.");
                            shouldSendFiles = false;
                            return;
                        }
                        if (IsValidUploadFile(filename)) {
                            fileCount++;
                        } else {
                            DispUserError("Error - Invalid File:" + filename);
                            return;
                        }
                    } else {
                        //https://stackoverflow.com/questions/3717793/javascript-file-upload-size-validation
                        DispUserError("Please update your browser.")// This is VERY unlikely, browser support is near-universal
                        return;
                    }
                });
                if (shouldSendFiles) {
                    xDialogConfirm("Ensure you have attached all the necessary documents.\n " + fileCount + " file(s) will be attached. \n Confirm Loan Application<br/>Loan Type=" + $("#cboLoanType option:selected").text() + "<br/>Amount " + (ConvertMoneyToDouble($("#txtLoanAmount").val())).formatMoney() + " ?", "Confirm Loan Application...").then(function () {
                        xDialogMemberCredetials().then(function (data) {
                            SaveMemberLoanApplication(data);
                        });
                    });
                }
            });
            function SaveFiles() {
                var postdata = new FormData();
                var fileCount = 0;
                $('#divSelectFiles input[type=file]').each(function () {
                    var file = $(this)[0].files[0]; //https://stackoverflow.com/questions/19954073/whats-the-reason-that-document-getelementbyid-works-but-jquery-doesnt
                    if (file) {
                        filename = file.name;
                        //                        alert(filename);
                        if (IsValidUploadFile(filename)) {
                            var ext = filename.substring(filename.lastIndexOf('.') + 1).toLowerCase();
                            fileCount++;
                            postdata.append("MemberLoanApplicationFile" + fileCount, file, filename);
                        }
                    }
                });

                postdata.append("LoanRefNo", SavedLoanApplicationNumber);
                postdata.append("IsNewLoan", "Y");
                postdata.append("DBName", ""); // will force controller to use latest dbname
                if (+fileCount > 0) {
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: '<%: Url.Content("~/api/MembersSystemApi/UploadMemberLoanApplicationFiles") %>',
                        contentType: false,
                        data: postdata,
                        processData: false,
                        success: function (messages) {
                            alert("File(s) Updated");
                            InitForm();
                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            DispUserError('Error Uploading Files: - ' + errorMessage);
                            InitForm(); //member to restart application or delete applied loan from system if we cannot attach required files
                        }
                    });
                } else {
                    InitForm();
                }
            }
            function IsValidUploadFile(filename) {


                if (filename.length < 1) {
                    alert("File Name cannot be empty"); return false;
                }


                var validExtensions = new Array();
                var ext = filename.substring(filename.lastIndexOf('.') + 1).toLowerCase();

                validExtensions[0] = 'jpg';
                validExtensions[1] = 'jpeg';
                validExtensions[2] = 'bmp';
                validExtensions[3] = 'png';
                validExtensions[4] = 'gif';
                validExtensions[5] = 'pdf';
                validExtensions[6] = 'doc';
                validExtensions[7] = 'docx';


                for (var i = 0; i < validExtensions.length; i++) {
                    if (ext == validExtensions[i]) return true;
                }

                alert('The file extension ' + ext.toUpperCase() + ' is not allowed!');
                return false;
            }
            function SubmitLoanApplication(credentials) {
                if (ln_app_to_edit == null) {
                    alert("Select Loan to Submit");
                    return;
                }
                var Password = credentials.UserPass;
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                var pwdslt = getRandomInt(1000, 30000);
                pwdslt = pwdslt.toString();

                var pwd = CryptoJS.MD5(Password).toString();
                pwd = pwd + pwdslt;
                var sltpwd = CryptoJS.MD5(pwd).toString();

                var outData = {
                    'DBName': $("#cboApplicationYear").val(),
                    'LoanApplicationNo': ln_app_to_edit.LoanRefNo,
                    'Password': sltpwd,
                    'Salt': pwdslt
                }



                outData = JSON.stringify(outData);

                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: '<%: Url.Content("~/api/MembersSystemApi/SubmitMemberLoanApplication") %>',
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        GetMemberLoanApplicationsListing();
                        alert("Loan application  number " + ln_app_to_edit.LoanRefNo + " successfully submitted for processing");
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        //alert('Error - ' + errorMessage);
                        DispUserError('Error - ' + errorMessage);
                    }
                });

            }

            function CalcRepayAmount() {
                $("#txtRepaymentAmount").val(0);
                if (AppliedLoanType == null) return;
                try {
                    var LoanAmount = $("#txtLoanAmount").val();
                    var RepayPeriod = $("#txtRepaymentPeriod").val();
                    var RepayAmt = 0;
                    if (AppliedLoanType.IsAmortized) {
                        console.log("Loan Is Amortized");
                        RepayAmt = GetAmortizedLoanRepayment(LoanAmount, AppliedLoanType.Percentage, RepayPeriod);
                    } else {
                        console.log("Loan Is Not Amortized");
                        RepayAmt = GetNonAmortizedLoanRepayment(LoanAmount, AppliedLoanType.Percentage, RepayPeriod);
                    }
                    RepayAmt = Math.round(RepayAmt);
                    $("#txtRepaymentAmount").val(RepayAmt.formatMoney());
                } catch (err) {
                    alert(err.message);
                }
            }
            function GetMemberLoanApplicationsListing() {


                $("#lblLoanRefNo").html("");
                $("#tblLoanApplicationList > tbody:last").children().remove();
                $("#tblSavedLoanGuarantors > tbody:last").children().remove();
                $("#tblSavedLoanWitnesses > tbody:last").children().remove();
                $("#tblSavedAppliedLoanProperties > tbody:last").children().remove();

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                var outData = {
                    'DBName': $("#cboApplicationYear").val(),
                }
                outData = JSON.stringify(outData);
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: '<%: Url.Content("~/api/MembersSystemApi/GetMemberLoanApplicationsListing") %>',
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        $("#tblLoanApplicationList > tbody:last").children().remove();
                        var row_datas = response;
                        var tbl_row = "";
                        $.each(row_datas, function (index, row_data) {
                            tbl_row += "<tr>";
                            tbl_row += "<td>" + row_data.LoanRefNo + "</td>";
                            tbl_row += "<td>" + row_data.LoanDate + "</td>";
                            tbl_row += "<td>" + row_data.LoanTypeName + "</td>";
                            tbl_row += "<td>" + (+row_data.RequestedAmount).formatMoney() + "</td>";
                            tbl_row += "<td>" + row_data.ProcessStatus + "</td>";
                            tbl_row += "<td>" + row_data.ManagerApprovalStatus + "</td>";
                            tbl_row += "</tr>";
                        });
                        $("#bdLoanApplicationList").append(tbl_row);
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        //alert('Error - ' + errorMessage);
                        DispUserError('Error - ' + errorMessage);
                    }

                });
            }
            function GetMemberLoansInProgress() {
                $("#tblLoanProgress > tbody:last").children().remove();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                var outData = {
                    'DBName': $("#cboProgressYear").val(),
                    'LoanStatus': $("#cboLoanProgressStatus").val()
                }
                outData = JSON.stringify(outData);
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: '<%: Url.Content("~/api/MembersSystemApi/GetMemberLoansInProgress") %>',
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        $("#tblLoanProgress > tbody:last").children().remove();
                        var row_datas = response;
                        var tbl_row = "";
                        $.each(row_datas, function (index, row_data) {
                            tbl_row += "<tr>";
                            tbl_row += "<td>" + row_data.LoanSerialNumber + "</td>";
                            tbl_row += "<td>" + row_data.OnlineApplicationNo + "</td>";
                            tbl_row += "<td>" + row_data.LoanDate + "</td>";
                            tbl_row += "<td>" + row_data.LoanTypeName + "</td>";
                            tbl_row += "<td>" + row_data.LoanStatus + "</td>";
                            tbl_row += "<td>" + (+row_data.RequestedAmount).formatMoney() + "</td>";
                            tbl_row += "<td>" + (+row_data.RecommendedAmount).formatMoney() + "</td>";
                            tbl_row += "<td>" + (+row_data.ApprovedAmount).formatMoney() + "</td>";
                            tbl_row += "<td><a href='" + row_data.LoanSerialNumber + "' class='approveLink'>" + row_data.MemberAcceptance + "</a></td>";
                            if (row_data.LoanStatus.toString().toLowerCase() == "approved".toLowerCase()) {
                                tbl_row += "<td><a href='/Members/MembersSystem/OfferLetter?DBName=" + $("#cboProgressYear").val() + "&LoanSerialNumber=" + row_data.LoanSerialNumber + "'>Offer Letter</a></td>";
                            } else {
                                tbl_row += "<td>N/A</td>";
                            }
                            tbl_row += "</tr>";
                        });
                        $("#bdLoanProgress").append(tbl_row);
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        //alert('Error - ' + errorMessage);
                        DispUserError('Error - ' + errorMessage);
                    }

                });
            }

            $('body').on('click', '.approveLink', function (e) {
                MemberAcceptRejectLoan(this);
                e.preventDefault();
                return false;
            });
            function MemberAcceptRejectLoan(approvelink) {

                var ApproveLoanSerialNumber = approvelink.getAttribute("href");
                var Criteria = {
                    "LoanSerialNumber": ApproveLoanSerialNumber,
                    "DBName": $("#cboProgressYear").val()
                }
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: '<%: Url.Content("~/api/MembersSystemApi/GetLoanDetails") %>',
                    data: JSON.stringify(Criteria),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        ProcessMemberLoanAcceptance(response);
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        //alert('Error - ' + errorMessage);
                        DispUserError('Error - ' + errorMessage);
                    }
                });
            }
            function AddNewGuarantorsTotals() {
                var GuarantorsRequestsTotals = +0;
                $("#spanGuarantorTotals").text(GuarantorsRequestsTotals.formatMoney());
                $("#bdGuarantors tr").each(function (i) {
                    var row = $(this);
                    var requestedAmt = ConvertMoneyToDouble(row.find('td:eq(2)').text());
                    GuarantorsRequestsTotals += requestedAmt;
                    $("#spanGuarantorTotals").text(GuarantorsRequestsTotals.formatMoney());
                });
            }
            function CalculateSavedGuarantorsTotals() {
                var GuarantorsRequestsTotals = +0;
                var GuarantorsAcceptedTotals = +0;
                var GuarantorCount = +0;
                var TotalRequested = +0;
                var TotalAcceptedCount = +0;

                $("#spanNoOfGuarantors").text("0");
                $("#spanGuarantorsAcceptedCount").text("0");
                $("#spanTotalGuarantorsRequested").text("0.00");
                $("#spanTotalGuarantorsAccepted").text("0.00");

                $("#bdSavedLoanGuarantors tr").each(function (i) {
                    GuarantorCount++;
                    var row = $(this);
                    var Amt = ConvertMoneyToDouble(row.find('td:eq(2)').text());
                    GuarantorsRequestsTotals += Amt;
                    Amt = ConvertMoneyToDouble(row.find('td:eq(3)').text());
                    GuarantorsAcceptedTotals += Amt;
                    var AcceptedStatus = row.find('td:eq(4)').text();
                    AcceptedStatus = String(AcceptedStatus);
                    if (AcceptedStatus === "Accepted") {
                        TotalAcceptedCount++;
                    }
                    $("#spanGuarantorTotals").text(GuarantorsRequestsTotals.formatMoney());

                    $("#spanNoOfGuarantors").text(GuarantorCount);
                    $("#spanGuarantorsAcceptedCount").text(TotalAcceptedCount);
                    $("#spanTotalGuarantorsRequested").text(GuarantorsRequestsTotals.formatMoney());
                    $("#spanTotalGuarantorsAccepted").text(GuarantorsAcceptedTotals.formatMoney());
                });
            }
            function ProcessMemberLoanAcceptance(LoanToApprove) {
                $('<div id="divApproveLoanDialog"></div>').dialog({
                    modal: true,
                    title: "Accept/Reject Loan",
                    height: 700,
                    width: 500,
                    autoOpen: true,
                    show: {
                        effect: "drop",
                        direction: "up",
                        duration: 500
                    },

                    buttons: {
                        'OK': {
                            'text': 'OK',
                            'id': 'btnOK',
                            'click': function () {
                                var ConfirmMessage = "";
                                if (document.getElementById("cboMemberResponse").selectedIndex == 0) {
                                    alert("Select Response");
                                    return;
                                }
                                ConfirmMessage = "Please confirm you want to " + $("#cboMemberResponse option:selected").text() + " this loan?";

                                xDialogConfirm(ConfirmMessage, "Confirm").then(function () {
                                    xDialogMemberCredetials().then(function (data) {
                                        var csrfToken = $("input[name='__RequestVerificationToken']").val();
                                        var Password = data.UserPass;
                                        var pwdslt = getRandomInt(1000, 30000);
                                        pwdslt = pwdslt.toString();
                                        var pwd = CryptoJS.MD5(Password).toString();
                                        pwd = pwd + pwdslt;
                                        var sltpwd = CryptoJS.MD5(pwd).toString();

                                        var outData = {
                                            'DBName': LoanToApprove.DBName,
                                            'MemberNo': LoanToApprove.mLoanAppraisals.MemberNumber,
                                            'LoanSerialNumber': LoanToApprove.LoanSerialNumber,
                                            'Response': $("#cboMemberResponse").val(),
                                            'Salt': pwdslt,
                                            'Password': sltpwd
                                        }
                                        outData = JSON.stringify(outData);
                                        $.ajax({
                                            headers: { __RequestVerificationToken: csrfToken },
                                            type: "POST",
                                            url: '<%: Url.Content("~/api/MembersSystemApi/ProcessMemberLoanResponse") %>',
                                            data: outData,
                                            contentType: "application/json; charset=utf-8",
                                            dataType: "json",
                                            success: function (response) {
                                                $("#tblLoanProgress tr").each(function (i) {
                                                    var row = $(this);
                                                    if (row.find('td:eq(1)').text() == LoanToApprove.LoanSerialNumber) {
                                                        row.find('td:eq(8)').html("<a href='" + LoanToApprove.LoanSerialNumber + "' class='approveLink'>" + $("#cboMemberResponse").val() + "</a>");

                                                    }
                                                });
                                                alert("Response successfully updated");
                                                $("#divApproveLoanDialog").dialog("close");

                                            },
                                            error: function (xhr, status, error) {
                                                var errorMessage = xhr.status + ': ' + xhr.responseText;
                                                //alert('Error - ' + errorMessage);
                                                DispUserError('Error - ' + errorMessage);
                                            }
                                        });
                                    });
                                });
                            }
                        },
                        Cancel: function () {
                            $(this).dialog("close");
                        }
                    },
                    open: function () {
                        var approved_amount = 0;
                        var recommended_amount = 0;
                        var repay_period = 1;

                        if (LoanToApprove.mAppraisalReport) {
                            recommended_amount = LoanToApprove.mAppraisalReport.RecommendedAmount;
                            repay_period = LoanToApprove.mAppraisalReport.RepaymentPeriod;
                        }
                        if (LoanToApprove.mApprovedLoans) {
                            approved_amount = LoanToApprove.mApprovedLoans.ApprovedAmount;
                            repay_period = LoanToApprove.mApprovedLoans.RepaymentPeriod;
                        }
                        var tbl = "<table id='tblApproveLoan' border=1>";
                        tbl += "<tbody>";
                        tbl += "<tr><td>Loan Serial Number:</td><td><input type='text' id='txtLoanSerialNumber' value='" + LoanToApprove.LoanSerialNumber + "' disabled /></td></tr>";
                        tbl += "<tr><td>Loanee:</td><td><input type='text' id='txtLoaneeName' value='" + LoanToApprove.saccoMember.FullNames + "' disabled /></td></tr>";
                        tbl += "<tr><td>MemberNo:</td><td><input type='text' id='txtLoaneeMemberNo' value='" + LoanToApprove.saccoMember.MemberNo + "' disabled /></td></tr>";
                        tbl += "<tr><td>PayrollNo:</td><td><input type='text' id='txtLoaneePayrollNo' value='" + LoanToApprove.saccoMember.PayrollNo + "' disabled /></td></tr>";
                        tbl += "<tr><td>Loan Type:</td><td><input type='text' id='txtLoanType' value='" + LoanToApprove.mLoanType.LoanTypeName + "' disabled /></td></tr>";
                        tbl += "<tr><td>Requested Amount:</td><td><input type='text' id='txtRequestedAmount' value='" + (+LoanToApprove.mLoanAppraisals.RequestedAmount).formatMoney() + "' disabled /></td></tr>";
                        tbl += "<tr><td>Loan Status:</td><td><input type='text' id='txtLoanStatus' value='" + LoanToApprove.mLoanAppraisals.LoanStatus + "' disabled /></td></tr>";
                        tbl += "<tr><td>Recommended Amount</td><td><input type='text' id='txtRecommendedAmount' value='" + (+recommended_amount).formatMoney() + "' disabled /></td></tr>";
                        tbl += "<tr><td>Approved Amount</td><td><input type='text' id='txtApprovedAmount' value='" + (+approved_amount).formatMoney() + "' disabled /></td></tr>";
                        tbl += "<tr><td>Amt In Words:</td><td><div id='divAmountInWords' /></td></tr>";
                        tbl += "<tr><td>HR Ability:</td><td><input type='text' id='txtHRRepayAmt' value='" + LoanToApprove.mLoanAppraisals.HRRepayAmt + "' disabled /></td></tr>";
                        tbl += "<tr><td>HR Approved:</td><td><input type='text' id='txtHRAbility' value='" + LoanToApprove.mLoanAppraisals.HRApproved + "' disabled /></td></tr>";
                        tbl += "<tr><td>Repayment Period:</td><td><input type='text' id='txtRepaymentPeriod' value='" + repay_period + "' /></td></tr>";
                        tbl += "<tr><td>Reponse:</td><td><select id='cboMemberResponse'><option value='' selected>(SELECT)</option><option value='accepted'>Accept</option><option value='rejected'>Reject</option></select></td></tr>";
                        tbl += "<tr><td>Notes/Reason:</td><td><textarea id='txtResponseReason' value='" + LoanToApprove.mLoanAppraisals.MemberAcceptanceComments + "' /></textarea></td></tr>";

                        tbl += "</tbody></table>";
                        $(this).html(tbl);
                        ShowAmtInWords();
                        $("#cboMemberResponse").focus;

                        function ShowAmtInWords() {
                            $("#divAmountInWords").html("");
                            try {
                                $("#divAmountInWords").html(toWords($("#txtApprovedAmount").val()));
                            } catch (err) {

                            }
                        }
                    },
                    close: function (event, ui) {
                        $(this).dialog("destroy").remove();
                    }
                });
            }

            function SaveMemberLoanApplication(credetials) {
                var LoanApplicationValid = true;
                var validCount = 0;
                var OffSetsList = new Array();
                var dblTotalAmount = 0;
                $("#tblOffsets tbody").find('tr').each(function (i) {
                    var OffSetEntry = {};
                    var row = $(this); //store in variable for faster access

                    OffSetEntry.BalType = row.find('td:eq(1)').text();
                    OffSetEntry.BalCode = row.find('td:eq(2)').text();
                    OffSetEntry.BalName = row.find('td:eq(3)').text();
                    OffSetEntry.BalAmount = row.find('td:eq(4)').text();
                    var txtAmt = row.find('td:eq(5)').find('input:eq(0)');


                    if (!isNumber(txtAmt.val())) {
                        LoanApplicationValid = false;
                        alert("Invalid offset amount at row " + i);
                        return;
                    }
                    var line_amount = txtAmt.val();
                    line_amount = +line_amount;
                    if (line_amount < 0) {
                        LoanApplicationValid = false;
                        alert("Offset Amount  " + line_amount + " should be more than or equal to Zero. At row " + i);
                        return;
                    }
                    if (row.find('input[type="checkbox"]').is(':checked')) {
                        if (line_amount > 0) {
                            dblTotalAmount = dblTotalAmount + line_amount;
                            OffSetEntry.TransAmount = line_amount;
                            OffSetsList[validCount] = OffSetEntry;
                            validCount++;
                        }
                    }
                });

                var validCount = 0;
                var FXDSecurityList = new Array();
                var dblTotalAmount = 0;
                $("#tblFXDBalances tbody").find('tr').each(function (i) {
                    var FXDSecurityEntry = {};
                    var row = $(this); //store in variable for faster access

                    FXDSecurityEntry.BalType = row.find('td:eq(1)').text();
                    FXDSecurityEntry.BalCode = row.find('td:eq(2)').text();
                    FXDSecurityEntry.BalName = row.find('td:eq(3)').text();
                    FXDSecurityEntry.BalAmount = row.find('td:eq(4)').text();
                    var txtAmt = row.find('td:eq(5)').find('input:eq(0)');


                    if (!isNumber(txtAmt.val())) {
                        LoanApplicationValid = false;
                        alert("Invalid FXD Amount amount at row " + i);
                        return;
                    }
                    var line_amount = txtAmt.val();
                    line_amount = +line_amount;
                    if (line_amount < 0) {
                        LoanApplicationValid = false;
                        alert("FXD Amount  " + line_amount + " should be more than or equal to Zero. At row " + i);
                        return;
                    }
                    if (row.find('input[type="checkbox"]').is(':checked')) {
                        if (line_amount > 0) {
                            dblTotalAmount = dblTotalAmount + line_amount;
                            FXDSecurityEntry.TransAmount = line_amount;
                            FXDSecurityList[validCount] = FXDSecurityEntry;
                            validCount++;
                        }
                    }
                });

                var GuarantorsList = new Array();
                var dblTotalAmount = 0;

                $("#tblGuarantors tbody").find('tr').each(function (i) {
                    var GuarantorEntry = {};
                    var row = $(this); //store in variable for faster access
                    GuarantorEntry.LoanSerialNumber = "";
                    GuarantorEntry.GuarantorMemberNumber = row.find('td:eq(0)').text();

                    var GuarantorAmt = row.find('td:eq(2)').text();

                    if (!isNumber(GuarantorAmt)) { //contains commas at this point
                        LoanApplicationValid = false;
                        alert("Invalid Guarantor amount " + GuarantorAmt + " at row " + i);
                        return;
                    }
                    GuarantorAmt = ConvertMoneyToDouble(GuarantorAmt);
                    var line_amount = GuarantorAmt;
                    line_amount = +line_amount;
                    if (line_amount <= 0) {
                        LoanApplicationValid = false;
                        alert("Guarantor's Amount " + line_amount + " should be more than Zero. At row " + i);
                        return;
                    }


                    GuarantorEntry.SharesToCommit = line_amount;
                    GuarantorsList[i] = GuarantorEntry;


                });

                var WitnessesList = new Array();
                var dblTotalAmount = 0;

                $("#tblWitnesses tbody").find('tr').each(function (i) {
                    var WitnessesEntry = {};
                    var row = $(this); //store in variable for faster access
                    var WitnessMemberNo = row.find('td:eq(0)').text();
                    WitnessesList[i] = WitnessMemberNo;

                });
                if ($("#txtSasraReasonCode").val() == "") {
                  LoanApplicationValid = false;
                alert("Specify reason/purpose for loan");
                }
                if (LoanApplicationValid == false) {
                    return;
                }
                var Password = credetials.UserPass;
                var csrfToken = $("input[name='__RequestVerificationToken']").val();

                var pwdslt = getRandomInt(1000, 30000);
                pwdslt = pwdslt.toString();
                var pwd = CryptoJS.MD5(Password).toString();
                pwd = pwd + pwdslt;
                var sltpwd = CryptoJS.MD5(pwd).toString();

                var outData = {
                    'Guarantors': GuarantorsList,
                    'Witnesses': WitnessesList,
                    'OffSets': OffSetsList,
                    'FXDSecurityList': FXDSecurityList,
                    'LoanTypeCode': $("#cboLoanType").val(),
                    'LoanAmount': $("#txtLoanAmount").val(),
                    'RepaymentPeriod': $("#txtRepaymentPeriod").val(),
                    'LoanPurpose': $("#txtLoanPurpose").val(),
                    'SasraReason2Code': $("#txtSasraReasonCode").val(),

                    'PaymentMode': $("#cboPreferredPaymentMode").val(),
                    'MobilePaymentType': $("#cboMobileProvider").val(),
                    'FOSAAccount': $("#cboFOSAAccount").val(),
                    'BankName': $("#lblBankName").val(),
                    'BankAccountNo': $("#lblBankAccNo").val(),
                    'MobileNo': $("#lblPhoneNo").val(),

                    'Instructions': $("#txtInstructions").val(),
                    'NormineeUserID': $("#txtNormnieeUserID").val(),
                    'Password': sltpwd,
                    'Salt': pwdslt
                }
              

                //https://www.w3schools.com/js/js_json_stringify.asp
                //var objToString = JSON.stringify(outData, null, 4);
                //console.log(objToString);
                outData = JSON.stringify(outData);
                

                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: '<%: Url.Content("~/api/MembersSystemApi/SaveMemberLoanApplication") %>',
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {

                        alert("Loan Application Saved Successfully. Uploading files...");
                        SavedLoanApplicationNumber = response;

                        SaveFiles();
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        //alert('Error - ' + errorMessage);
                        DispUserError('Error - ' + errorMessage);
                    }

                });

            }
            $('#tabs').on('tabsactivate', function (event, ui) {//jquery
                var newIndex = ui.newTab.index();
                if (newIndex == 1) {
                    GetMemberLoanApplicationsListing();
                } else if (newIndex == 2) {
                    GetMemberLoansInProgress();
                }
            });
            $('#tabs').on('tabs-activate', function (e, activeTab) {//jquery-responsive-tabs
                var newTabId = activeTab.id
                if (newTabId == 1) {
                    GetMemberLoanApplicationsListing();
                } else if (newTabId == 2) {
                    GetMemberLoansInProgress();
                }
            });
            $("#btnTab2").on('click', function (e) {
                $('#tabs').responsiveTabs('activate', 1);
            });

            
            
            

            

         
            function InitForm() {

                $("#cboLoanType").empty();
                $("#cboFOSAAccount").empty();
                $("#txtLoanAmount").val(0.00);
                $("#txtRepaymentPeriod").val(0.00);
                $("#txtRepaymentAmount").val(0.00);
                $("#txtInstructions").val("");
                $("#txtLoanPurpose").val("");
                $("#txtSasraLoanPurpose").val("");
                $("#txtSasraReasonCode").val("");
                $("#txtNormnieeUserID").val("");
                $("#cboApplicationYear").empty();
                $("#cboProgressYear").empty();
                $("#tblLoanProperties > tbody:last").children().remove();
                $("#tblOffsets > tbody:last").children().remove();
                $("#tblFXDBalances > tbody:last").children().remove();
                $("#tblGuarantors > tbody:last").children().remove();
                $("#tblWitnesses > tbody:last").children().remove();
                $("#tblLoanApplicationList > tbody:last").children().remove();

                $("#tblSavedLoanGuarantors > tbody:last").children().remove();
                $("#tblSavedLoanWitnesses > tbody:last").children().remove();
                $("#divSelectFiles").empty();
                $("#divAmountInWords").empty();
                $("#tblMemberBalances > tbody:last").children().remove();

                AddNewGuarantorsTotals();

                $("#cboPreferredPaymentMode").prop('selectedIndex', 0);
                $("#divFOSAAccounts").hide();
                $("#divBankDetails").hide();
                $("#divMobileDetails").hide();

                $('#chkLoanTOC').prop('checked', false);

              
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: '<%: Url.Content("~/api/MembersSystemApi/GetMemberLoanApplicationConfig") %>',
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        //console.log(response);
                        MemberDetails = response.MemberDetails;
                        $("#lblPhoneNo").val(MemberDetails.PhoneNo);
                        $("#lblBankName").val(MemberDetails.MainBankName);
                        $("#lblBankAccNo").val(MemberDetails.AccountNo);
                        LoanTypeList = response.LoanTypes;
                        MemberBalances = response.MemberBalances.MemberBals;
                        var Years = response.Years;
                        SASRASubSector2 = response.SASRASubsector2;
                        SASRASubSector1 = response.SASRASubsector1;
                        //console.log(SASRASubSector2);
                        SASRAMainSectors = response.SASRAMainSectors;
                        bolNomineeRequired = response.NomineeRequired;
                        FXD_Balances = response.FXD_Balances
                        var FOSAAccounts = response.FOSAAccounts;
                        //console.log(SASRASubSector2);
                        //console.log(SASRASubSector1);
                        //console.log(SASRAMainSectors);
                        //console.log(response.NomineeRequired);
                        //console.log(typeof response.NomineeRequired);
                        //console.log(MemberDetails.Surname);
                        //console.log(typeof MemberDetails.Surname);

                        //bolNomineeRequired = (bolNomineeRequired === "True" || bolNomineeRequired === "true" || bolNomineeRequired === true);
                        //console.log(bolNomineeRequired);
                        if (bolNomineeRequired) {
                            //console.log("bolNomineeRequired is True ");

                        } else {
                            //console.log("bolNomineeRequired is False ");
                            $("#trNormineeID").hide();
                            $("#trNormineeName").hide();
                        }
                        hod_managers_list = response.Managers;
                        

                        $("#cboFOSAAccount").append('<option value="" selected>(SELECT)</option>');
                        $.each(FOSAAccounts, function (index, objFOSAAcc) {
                            $("#cboFOSAAccount").append("<option value='" + objFOSAAcc.AccountNo + "'>" + objFOSAAcc.AccountNo + "(" + objFOSAAcc.AccountName + ")" + "</option'>");
                        });
                        var PayModes = response.PaymentModes;
                        $("#cboPreferredPaymentMode").empty();
                        $("#cboPreferredPaymentMode").append('<option value="" selected>(SELECT)</option>');

                        $.each(PayModes, function (index, objPayMode) {
                            $("#cboPreferredPaymentMode").append("<option value='" + objPayMode + "'>" + objPayMode + "</option'>");
                        });
                        $("#cboLoanType").empty();
                        $("#cboApplicationYear").empty();

                        $("#cboLoanType").append('<option selected>(SELECT LOAN TYPE)</option>');

                        $("#txtSasraLoanPurpose").empty();
                        $("#txtSasraLoanPurpose").append('<option value="" selected>(SELECT REASON FOR LOAN)</option>');
                        $.each(SASRASubSector2, function (index, objSASRASubsector2) {
                            function truncateAtWord(str, maxLength) {
                                if (str.length <= maxLength) {
                                    return str;
                                }

                                const trimmedString = str.slice(0, maxLength); 
                                // Find the index of the last space in the trimmed portion
                                const lastSpaceIndex = trimmedString.lastIndexOf(' '); 

                                // If a space is found, cut there and add ellipsis
                                if (lastSpaceIndex !== -1) {
                                    return trimmedString.slice(0, lastSpaceIndex) + '...';
                                }

                                // If no space found in the limit, just cut at the character limit as a fallback
                                return trimmedString + '...'; 
                                }
                                $("#txtSasraReasonCode").val(objSASRASubsector2.SubSector2Code);
                            $("#txtSasraLoanPurpose").append("<option value='" + objSASRASubsector2.SubSector2Code + "'>" + truncateAtWord(objSASRASubsector2.SubSector2Name,60) + "</option'>");
                        
                            });
                        $("#cboLoanSector1").empty();
                        $("#cboLoanSector1").append('<option value="" selected>(SELECT REASON FOR LOAN)</option>');
                        $.each(SASRASubSector1, function (index, objSASRASubsector1) {
                            $("#cboLoanSector1").append("<option value='" + objSASRASubsector1.SubSector1Code + "'>" + objSASRASubsector1.SubSector1Name + "</option'>");
                        });
                        $("#cboLoanMainSector").empty();
                        $("#cboLoanMainSector").append('<option value="" selected>(SELECT REASON FOR LOAN)</option>');
                        $.each(SASRAMainSectors, function (index, objSASRAMainSector) {
                            $("#cboLoanMainSector").append("<option value='" + objSASRAMainSector.MainSectorCode + "'>" + objSASRAMainSector.MainSectorName + "</option'>");
                        });

                        $.each(LoanTypeList, function (index, LoanType) {
                            $("#cboLoanType").append("<option value='" + LoanType.LoanTypeCode + "'>" + LoanType.LoanTypeName + "</option'>");
                        });

                        var tbl_row = "";
                        $.each(MemberBalances, function (index, MemberBalance) {
                            if (MemberBalance.BalType.toString().toUpperCase() == "L".toUpperCase() || MemberBalance.BalType.toString().toUpperCase() == "I".toUpperCase()) {
                                tbl_row += "<tr><td><input type='checkbox' /></td><td>" + MemberBalance.BalType + "</td><td>" + MemberBalance.BalCode + "</td><td>" + MemberBalance.BalName + "</td><td>" + (+MemberBalance.BalAmount).formatMoney() + "</td><td><input type='text' value='" + MemberBalance.BalAmount + "' disabled /></td></tr>"
                            }
                        });
                        $("#bdOffsets").append(tbl_row);

                        var tbl_row = "";
                        $.each(FXD_Balances, function (index, MemberBalance) {
                            tbl_row += "<tr><td><input type='checkbox' /></td><td>" + MemberBalance.BalType + "</td><td>" + MemberBalance.BalCode + "</td><td>" + MemberBalance.BalName + "</td><td>" + (+MemberBalance.BalAmount).formatMoney() + "</td><td><input type='text' value='" + MemberBalance.BalAmount + "' disabled /></td></tr>"
                        });
                        $("#bdFXDBalances").append(tbl_row);

                        $.each(Years, function (index, yr) {
                            $("#cboApplicationYear").append("<option value='" + yr.DBName + "' selected>" + yr.UserDefinedYearName + "</option'>");
                        });
                        $("#cboApplicationYear").get(0).selectedIndex = 0;
                        $.each(Years, function (index, yr) {
                            $("#cboProgressYear").append("<option value='" + yr.DBName + "' selected>" + yr.UserDefinedYearName + "</option'>");
                        });
                        $("#cboProgressYear").get(0).selectedIndex = 0;
                        $("#cboProgressYear").get(0).selectedIndex = 0; //first $("#cboProgressYear").get(0).selectedIndex = 0; not working
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        //alert('Error - ' + errorMessage);
                        DispUserError('Error - ' + errorMessage);

                    }
                });
            }



            /*
            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion({
                    heightStyle: "content"
                });
            });
            */

            // $('#tabs').responsiveTabs({
            //     // Start with the panels collapsed if the view is currently accordion based
            //     startCollapsed: 'accordion',
            //     // Tabs can be collapsed
            //     collapsible: true,
            //     // Tabs auto rotate
            //     rotate: false
            // });

        });
    </script>
</asp:Content>




<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <div id="tabs" class="mx-auto d-flex justify-content-center col-12 col-md-8 ">
        <div id="customTabs" class="custom-tabs  position-relative overflow-hidden" style="z-index: 0;">
            <ul class="custom-tabs-nav mb-0 d-flex list-unstyled">
            <li><a href="#tabs1" data-tab="tabs1" class="custom-tab-label active">Loan Application</a></li>
            <li><a href="#tabs2" data-tab="tabs2" class="custom-tab-label">Loan Status</a></li>
            <li><a href="#tabs3" data-tab="tabs3" class="custom-tab-label">Loan Progress</a></li>
        </ul>
        <span class="custom-glider position-absolute d-flex" style="transform: translateX(0);"></span>
    </div>
</div>
    <div class="" >
        <div class="">

                    <%= Html.AntiForgeryToken() %>
                    <div id="tabs1" class="tab-content-panel active p-3">
                        <form id="frmMain" name="frmMain" class="form" role="form">
                            
                            
                            <!-- <div class="row">
                                <div class="col-md-12">
                                    
                                    <div id="divLoanProperties" style="height: auto; width: auto;" class="table-responsive">
                                        <table id='tblLoanProperties' class="table table-responsive table-striped table-bordered">
                                            <caption>Loan Properties</caption>
                                            <thead>
                                                <tr>
                                                    <th>Property</th>
                                                    <th>Value</th>
                                                </tr>
                                            </thead>
                                            <tbody id='bdLoanProperties'>
                                            </tbody>
                                        </table><hr/>
                                    </div>
                                </div>
                            </div> -->
                            <div class="card bg-white"> 
                               <h6 class="fs-6 text-center p-2">Loan Application</h6>
                               <hr class="m-0">
                           <div class="row mb-3 p-3">
                                <div class=" col-md-4 my-1">
                                    <label for="cboLoanType" class="form-label">Loan Type</label>
                                    <select id="cboLoanType" class="form-select">
                                    </select>
                                </div>
                                <div class="form-group col-md-4 my-1">
                                    <label for="" class="form-label">Max Loan Amount</label>
                                    <input id="maxAmount" class="form-control" placeholder="---------" readonly/>
                                </div>
                                <div class="form-group col-md-4 my-1">
                                    
                                    <label for="txtLoanAmount" class="form-label">Applied Loan Amount</label>
                                    <input type="number" class="form-control" id="txtLoanAmount" placeholder="e.g 1000">
                                </div>
                            
                                <div class="form-group col-md-4 d-none">
                                    <label for="txtLoanAmountInWords" class="form-label">Loan Amount In Words</label>
                                    <%--<input type="number" class="form-control" id="txtLoanAmountInWords" readonly placeholder="Loan Amount">--%>
                                    <div id="divAmountInWords"></div>
                                </div>
                            
                                <div class="form-group col-md-4 my-1">
                                    <label for="txtRepaymentPeriod" class="form-label">Repayment Period in Months</label>
                                    <input type="number" class="form-control" id="txtRepaymentPeriod" placeholder="e.g 12">
                                </div>
                            
                                <div class="form-group col-md-4 my-1">
                                    <label for="txtRepaymentAmount" class="form-label">Intrest Per Month</label>
                                    <input type="text" class="form-control" id="txtRepaymentAmount" readonly>
                                </div>

                                <div class="col-md-4 my-1">
                                    <label for="interestRate" class="form-label">Interest Rate</label>
                                    <input type="text" id="interestRate" class="form-control" readonly/>
                                </div>
                          
                                <div class="form-group col-md-4 my-1">
                                    <label for="txtSasraLoanPurpose" class="form-label">Purpose</label>
                                    <select id="txtSasraLoanPurpose"  class="form-select"></select>
                                    <input type="text" id="txtSasraReasonCode" style="display: none" />
                                

                                </div></div>
                            
                                <!-- <div class="form-group col-md-4 my-1">
                                    <label for="button" style="visibility: hidden;">Search Loan</label>
                                    <input type="button" value="Search Loan Purpose" id="btnSearchSasra" class="btn btn-primary btn-sm mt-2 form-control" />
                                    <%-- unhide table tblLoanPurpose to let user select from drop downlist--%>
                                    <input type="button" value="Tab 2" id="btnTab2" style="display: none" />
                                </div> -->
                            </div>

                            <div id="divOnlyBridgeAllowed"></div>
                            <!-- <table class="table-bordered">
                                <tr style="display: none">
                                    <td>Purpose for Loan:
                                    </td>
                                    <td>
                                        <textarea id="txtLoanPurpose"></textarea>
                                    </td>
                                </tr>
                                <tr style="display: none">
                                    <td>Any Instructions:
                                    </td>
                                    <td>
                                        <textarea id="txtInstructions"></textarea>
                                    </td>
                                </tr>
                                <tr id="trNormineeID">
                                    <td>Send Approval Request to PF. No:
                                    </td>
                                    <td>
                                        <input type="text" id="txtNormnieeUserID" /><input type="button" id="btnListManagers" value="Find" />
                                    </td>

                                </tr>
                                <tr id="trNormineeName">
                                    <td>Normiee Names:</td>
                                    <td>
                                        <div id="divNormineeName"></div>
                                    </td>
                                </tr>
                            </table>
                            <br />
                            <br /> -->
                            <!-- <div class="row">
                                <div class="col-md-12">
                                    <table id="tblLoanPurpose" class="table table-responsive table-bordered" style="width: 100%; ">
                                        <caption>Loan Purpose/Reasons</caption>
                                        <tr>
                                            <td>Main Purpose for Loan:</td>
                                            <td>
                                                <select id="cboLoanMainSector" style="width: 100%" /></td>
                                        </tr>
                                        <tr>
                                            <td>Sub purpose</td>
                                            <td>
                                                <select id="cboLoanSector1" style="width: 100%" /></td>
                                        </tr>
                                        <tr>
                                            
                                    </table>
                                </div>
                            </div> -->

                           <div class="card p-3 mt-2"> 
                            <div id="guarantorSection" class="row my-2">
                                
                                    <div class="col-md-4 my-1">
                                        <label class="form-label" for="txtGuarantorMemberNo">Member No</label>
                                        <input id="txtGuarantorMemberNo" type="text" class="form-control"/>
                                    </div>
                                    <div class="col-md-4 my-1">
                                        <label class="form-label" for="divGuarantorNames">Guarantor Names</label>
                                        <input id="divGuarantorNames" class="form-control" readonly type="text"/>
                                    </div>
                                    <div class="col-md-4 my-1">
                                        <label class="form-label" for="txtGuarantorAmount">Amount Guaranteed</label>
                                        <input id="txtGuarantorAmount" type="text" class="form-control"/>
                                    </div>
                                    <div class="col-md-4 my-1">
                                        <button id="btnAddGuarantor" class="btn btn-primary">Add Guarantor <i class="fa-solid fa-user-plus"></i></button>
                                    </div>
                                <p id="pghErrorAddGuarantor" class="text-danger"></p>
                                </div>

                                <hr>

                                <!-- Guarantors List Table -->
                                <table id="tblGuarantors" class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                    <th>Member No</th>
                                    <th>Names</th>
                                    <th>Amount</th>
                                    <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody id="bdGuarantors"></tbody>
                                </table>
                            </div>

                            
                            <div class="row d-none">
                                <div class="col-md-12">
                                    <div id="divFXDBalances" style="height: auto; overflow: auto; width: auto;" class="table-responsive">
                                        <table id='tblFXDBalances' class="table table-responsive table-stripped table-bordered">
                                            <caption style="font-size: larger">Use Fixed Deposits As Security</caption>
                                            <thead>
                                                <tr>
                                                    <th>X</th>
                                                    <th>Type</th>
                                                    <th>Code</th>
                                                    <th>Name</th>
                                                    <th>Amount</th>
                                                    <th>UseAmount</th>
                                                </tr>
                                            </thead>
                                            <tbody id='bdFXDBalances'>
                                            </tbody>
                                        </table><hr/>
                                    </div>
                                </div>
                            </div>
                            <br />

                            <div id="witnessSection" class="card p-3 mt-2">
                                    <div class="row my-2">
                                    <div class="col-md-4 my-1">
                                        <label class="form-label" for="">Member No</label>
                                        <input id="txtWitnessMemberNo" type="text" class="form-control"/>
                                    </div>
                                    <div class="col-md-4 my-1">
                                        <label class="form-label" for="">Witness Names</label>
                                        <input id="divWitnessNames" class="form-control" readonly/>
                                    </div>
                                    <div class="col-md-4 mt-4">
                                       <label class="form-label mt-1" for="">&nbsp;</label>
                                        <button id="btnAddWitness" class="btn btn-primary">Add Witness</button>
                                    </div>
                                </div>
                                <p id="pghErrorAddWitness" class="text-danger"></p>
                                
    
                                <hr>
    
                                <!-- Witnesses List Table -->
                                <table id="tblWitnesses" class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                    <th>Member No</th>
                                    <th>Names</th>
                                    <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody id="bdWitnesses"></tbody>
                                </table>

                                <table id="tblSavedLoanWitnesses" class="table table-striped d-none">
                                    <thead>
                                        <tr>
                                        <th>Member No</th>
                                        <th>Names</th>
                                        <th>Status</th>
                                        <th colspan="3"></th>
                                        <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="bdSavedLoanWitnesses"></tbody>
                                </table>
                            </div>
                           

                          

                           <div class="card p-3 mt-2"> <div class="row mb-3">
                                <div class="col-md-3">
                                    <label for="cboOffsetType" class="form-label">Offset Type</label>
                                    <select name="cboOffsetType" class="form-select" id="cboOffsetType">
                                        <option>(SELECT)</option>
                                        <option>BRIDGING</option>
                                        <option>AMALGAMATION</option>
                                    </select>
                                </div>
                            </div>

                           

                            <div class="row">
                                <div class="col-md-12">
                                    <div id="divOffsets" style="height: auto; overflow: auto; width: auto;" class="table-responsive">
                                        <table id='tblOffsets' class="table table-responsive table-stripped table-bordered">
                                            <h6>Loan Offsets</h6>
                                            <thead>
                                                <tr>
                                                    <th>X</th>
                                                    <th>Type</th>
                                                    <th>Code</th>
                                                    <th>Name</th>
                                                    <th>Amount</th>
                                                    <th>Offset</th>
                                                </tr>
                                            </thead>
                                            <tbody id='bdOffsets'>
                                            </tbody>
                                        </table><hr/>
                                    </div>
                                </div>
                            </div></div>

                            <div id="divAttachments" class="card p-3 mt-1">
                               <div class="col-md-4 row"> 
                                    <label class="form-label" for="">Files to Attach eg payslips,logbook etc.</label>
                                    <input type="button" id="btnAddFile" value="Add File" class="btn btn-primary" />
                                    <div id="divSelectFiles" style="height: auto; overflow: auto; width: auto">
                                    </div>
                            </div>
                            </div>
                            <br />
                            <%--Payment Modes--%>
                            <div class="card p-3">
                                <div id="panelSourceAccDetails" class="panel panel-default">
                                    <h6 class="">Preferred Payment Mode</h6>
                                    <div class="row">
                                            <div class="col-md-4">
                                                <label class="form-label" for="cboPreferredPaymentMode">Payment Mode </label>
                                                <select id="cboPreferredPaymentMode" class="form-select">
                                                    <option selected>(SELECT)</option>
                                                </select>
                                            </div>
                                        <div class="form-group" id="divFOSAAccounts" style="display: none">
                                            <div class="col-md-4">
                                            <label class="form-label" for="">FOSA Account:</label>
                                                <select id="cboFOSAAccount" class="form-select">
                                                    <option selected>(SELECT)</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group" id="divBankDetails" style="display: none">
                                            <div class="col-md-4">
                                            <label class="form-label" for="">Bank Name:</label>
                                                <input class="form-control" for="" id="lblBankName" readonly/>
                                            </div>
                                            <div class="col-md-4">
                                                <label class="form-label" for="">Bank AccNo:</label>
                                                <input class="form-control" for="" id="lblBankAccNo" readonly/>
                                            </div>
                                        </div>
                                        <div class="form-group" id="divMobileDetails" style="display: none">
                                            <div class="col-md-4">
                                            <label class="form-label" for="">Mobile Provider:</label>
                                                <select id="cboMobileProvider" class="form-select">
                                                    <option>(SELECT)</option>
                                                    <option selected>MPESA</option>
                                                </select>
                                            </div>
                                           
                                            <div class="col-md-4">
                                            <label class="form-label" for="">PhoneNo:</label>
                                                <input class="form-control" id="lblPhoneNo" readonly/>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <%--End Payment Modes--%>
                            <div class="card p-3 mt-1">
                                <div class="col-md-4">
                                    <input class="form-check-input" type="checkbox" type="checkbox" id="chkLoanTOC">
                                    <label class="form-check-label" for="chkLoanTOC">
                                        I have read, understood and accepted the <a target="_blank=" href="<%: Url.Content("~/TermsAndConditions/LoansTOC.pdf") %>">terms and conditions </a>
                                    </label>
                                </div>
                            <div class="my-3">
                                <input type="button" value="Save Application" id="btnSave" class="btn btn-primary" disabled />
                                <input type="button" value="Cancel Application" id="btnCancel" class="btn btn-danger" />
                               
                            </div>
                           
                            <p style="font-size: 10px; font-style:italic;">Please note that you must accept the terms and conditions before saving the loan application</p>
                        </div>
                        </form>
                    </div>


                    <div id="tabs2" class="tab-content-panel p-3">
                        <div class="card p-3">
                            <div class="row mb-3">
                                <div class="col-md-5">
                                    <label for="txtApplicatioYear" class="form-label">Financial Year:</label>
                                    <select id="cboApplicationYear" class="form-select">
                                        <option value="selectyear">SELECT YEAR</option>
                                    </select>
                                </div>
                            </div>
                            <div class="my-1">
                                <input type="button" id="btnRefresh" value="Refresh" class="btn btn-info my-1" />
                                <input type="button" id="btnAddMoreGuarantor" value="Add Guarantor" class="btn btn-primary my-1" />
                                <input type="button" id="btnAddMoreWitness" value="Add Witness" class="btn btn-secondary my-1" />
                            </div>
                           <div class="my-1"> 
                               <input type="button" id="btnSubmitLoanApplication" value="Submit Application" class="btn btn-success my-1" />
                               <input type="button" id="btnCancelApplication" value="Cancel Application" class="btn btn-danger my-1" />
                        </div>
                        </div>

                        <div id="divLoanApplicationList" style="" class="table table-responsive card p-3 mt-1">
                           <h6>Loan Application List</h6> 
                            <table id='tblLoanApplicationList' class="table table-responsive table-bordered">
                                <thead>
                                    <tr>
                                        <th>RefNo</th>
                                        <th>Date</th>
                                        <th>Loan Type</th>
                                        <th>Amount</th>
                                        <th>Loan Status</th>
                                        <th>Manager Status</th>
                                    </tr>
                                </thead>
                                <tbody id='bdLoanApplicationList'>
                                </tbody>
                            </table><hr/>
                        </div>
                        
                        <div id="lblLoanRefNo"></div>
                        
                        <div id="divSavedLoanGuarantors" class="card p-3 mt-1">
                          <div class="table-responsive">
                                <table id='tblSavedLoanGuarantors' class='table table-responsive table-bordered text-nowrap'>
                                    <h6>Guarantors</h6>
                                        <thead>
                                            <tr>
                                                <th>Guarantor No</th>
                                                <th>Name</th>
                                                <th>Requested Amt</th>
                                                <th>Accepted Amt</th>
                                                <th>Status</th>
                                                <th>Notes</th>
                                                <th>Remove</th>
                                                </tr>
                                                </thead>
                                                <tbody id='bdSavedLoanGuarantors'>
                                                </tbody>
                                </table>
                          </div>

                                <div class="col-md-4">
                                    <label class="form-label" for="">No Of Guarantors</label>
                                <span id="spanNoOfGuarantors" class="form-control" readonly>N/A</span>
                                </div>
                                <div class="col-md-4"> <label class="form-label" for=""> Accepted Count</label>
                                    <span id="spanGuarantorsAcceptedCount" class="form-control" readonly>0</span>
                                </div>
                                <div class="col-md-4"><label class="form-label" for="">Total Requested</label>
                                    <span id="spanTotalGuarantorsRequested" class="form-control" readonly>0.00</span>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label" for="">Total Accepted</label>
                                    <span id="spanTotalGuarantorsAccepted" class="form-control" readonly>0.00</span>
                                </div>
                        </div>

                        <div class="card p-3 mt-1">
                                <div id="divSavedFXDBalances" style="height: auto; overflow: auto; width: auto;" class="table-responsive">
                                    <table id='tblSavedFXDBalances' class="table table-responsive table-stripped table-bordered">
                                        <h6>Use Fixed Deposits As Security</h6>
                                        <thead>
                                            <tr>
                                                <th>X</th>
                                                <th>Type</th>
                                                <th>Code</th>
                                                <th>Name</th>
                                                <th>Amount</th>
                                                <th>UseAmount</th>
                                            </tr>
                                        </thead>
                                        <tbody id='bdSavedFXDBalances'>
                                        </tbody>
                                    </table>
                            </div>
                        </div>

                        <div class="card p-3 mt-1">
                                <div id="divSavedOffsets" class="table-responsive">
                                    <h6>Loan Offsets</h6>
                                    <table id='tblSavedOffsets' class="table table-responsive table-stripped table-bordered">
                                        <thead>
                                            <tr>
                                                <th>X</th>
                                                <th>Type</th>
                                                <th>Code</th>
                                                <th>Name</th>
                                                <th>Amount</th>
                                                <th>Offset</th>
                                            </tr>
                                        </thead>
                                        <tbody id='bdSavedOffsets'>
                                        </tbody>
                                    </table>
                            </div>
                        </div>

                        <div class="card p-3 mt-1">
                            <div id="divSavedLoanWitnesses"  class="table-responsive">
                                <h6>Witnessess</h6>
                            <table id='tblSavedLoanWitnesses' class='table table-responsive table-bordered text-nowrap'>
                                <thead>
                                    <tr>
                                        <th>MemNo</th>
                                        <th>Name</th>
                                        <th>Response</th>
                                        <th>Notes</th>
                                        <th>Requested On</th>
                                        <th>Response Date</th>
                                        <th>Remove</th>
                                    </tr>
                                </thead>
                                <tbody id='bdSavedLoanWitnesses'>
                                </tbody>
                            </table>
                        </div></div>
                       
                        <div class="card p-3 mt-1">
                            <div class="table table-responsive">
                                <h6>Already Attached Files</h6>
                                <table id='tblSavedLoanAttachments' class='table table-responsive table-striped table-bordered'>
                                    <thead>
                                        <tr>
                                            <th>FileName</th>
                                            <th style="display: none">SysFileName</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id='bdSavedLoanAttachments'>
                                    </tbody>
                                </table><hr/>
                            </div>
                            <div class="row mt-1">
                                <div id="divAdditionalAttachments" class="input-group col-md-4">
                                    <label class="form-label" for=""> Add Files to Attach eg payslips,logbook etc.</label>
                                    <input class="form-control" type="file" id="flAddFileToLoanApplication" name="flAddFileToLoanApplication" value="Add File"  />
                                </div>
                            </div>
                        </div>
                        

                        <div id="divOtherLoanProperties" class="card p-3 mt-1">
                            <h6>Other Loan Properties</h6>
                            <table id='tblSavedAppliedLoanProperties' class='table table-bordered'>
                                <thead>
                                    <tr>
                                        <th>Property</th>
                                        <th>Value</th>
                                    </tr>
                                </thead>
                                <tbody id='bdSavedAppliedLoanProperties'>
                                </tbody>
                            </table>
                        </div>
                    </div>


                    <div id="tabs3" class="tab-content-panel p-2">
                        <div class="card p-3">
                        <div class="row mb-1">
                            <div class="col-md-4">
                                <label for="txtFinancialYear" class="form-label">Financial Year:</label>
                                <select id="cboProgressYear" class="form-select">
                                    <option value="">SELECT YEAR</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label for="txtLoanStatus" class="form-label">Loan Status</label>
                                <select id="cboLoanProgressStatus" class="form-select">
                                    <option value="" selected>(ALL)</option>
                                    <option value="In-Service">Active</option>
                                    <option value="appraised">Appraised</option>
                                    <option value="approved">Approved</option>
                                    <option value="rejected">Rejected</option>
                                </select>
                            </div>
                        </div>
                              <input type="button" id="btnProgressRefresh" value="Refresh" class="btn btn-info my-2" />
                        </div>

                        <div class="card p-3 mt-1"><div id="divLoanProgress" class="table-responsive">
                            <table id='tblLoanProgress' class='table table-responsive table-bordered text-nowrap'>
                                <thead>
                                    <tr>
                                        <th>Loan Number</th>
                                        <th>App.No</th>
                                        <th>Date</th>
                                        <th>Loan Type</th>
                                        <th>Status</th>
                                        <th>Requested</th>
                                        <th>Recommended</th>
                                        <th>Approved</th>
                                        <th>Acceptance</th>
                                        <th>Offer Letter</th>
                                    </tr>
                                </thead>
                                <tbody id='bdLoanProgress'>
                                </tbody>
                            </table>
                        </div></div>
                        <div class="card p-3 mt-1"><div id="divLoanDetails" >
                            
                        </div></div>
                    </div>
                </div>
             </div>
</asp:Content>


