﻿<%@ Page Language="C#" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <meta name="viewport" content="width=device-width" />
    <title>Chat</title>
    <style type="text/css">
        .containerMain {
            background-color: #99CCFF;
            border: thick solid #808080;
            padding: 20px;
            margin: 20px;
        }
        .notransition {
          -webkit-transition: none !important;
          -moz-transition: none !important;
          -o-transition: none !important;
          /*-ms-transition: none !important;*/
          transition: none !important;
        }
    </style>
    
</head>
<body>
    <div class="container">
        <br />
        <br />
        <input type="button" id="btnProcessBatch" value="Process Batch" />
        <input type="text" id="txtProgress" />
        <br />
        <br />
        <div class="progress">
            <div id="prgProgress" class="progress-bar  progress-bar-striped" role="progressbar" aria-valuenow="0"
                aria-valuemin="0" aria-valuemax="100" style="min-width:1px">
                
            </div>
        </div>
        <br />
        <br />
    </div>
    <div class="containerMain">
        <input type="text" id="message" />
        <input type="button" id="sendmessage" value="Send" />
        <input type="hidden" id="displayname" />
        <input type="text" id="progress" />
        <ul id="discussion">
        </ul>
    </div>
    <link href="/Content/bootstrap.css" rel="stylesheet" />
    <link href="/Content/bootstrap-theme.css" rel="stylesheet" />
    <!--Script references. -->
    <!--Reference the jQuery library. -->
    <script src="/Scripts/jquery-2.1.0.js" ></script>
    <!--Reference the SignalR library. -->
    <script src="/Scripts/jquery.signalR-2.2.0.js"></script>
    <!--Reference the autogenerated SignalR hub script. -->
    <!-- <script src="/signalr/hubs"></script>  -->
    <!-- dynamically generated proxy --> see salaries and admin/dbupdate.aspx for more notes on how to load in IIS(production)

    <script src='<%: ResolveClientUrl("~/signalr/hubs") %>'></script> <!-- dynamically generated proxy -->

    <!--Add script to update the page and send messages.--> 
    <script type="text/javascript">


        $(function () {
            // Declare a proxy to reference the hub. 
            var progresProxy = $.connection.progressHub; //note name of class starts with lower case (SignalRChart.SignalRChat.progressHub)
            // Create a function that the hub can call to broadcast messages.
            progresProxy.client.broadcastMessage = function (name, message) {
                // Html encode display name and message. 
                var encodedName = $('<div />').text(name).html();
                var encodedMsg = $('<div />').text(message).html();
                // Add the message to the page. 
                $('#discussion').append('<li><strong>' + encodedName
                    + '</strong>:&nbsp;&nbsp;' + encodedMsg + '</li>');
                
            };
            progresProxy.client.processingProgress = function (progressMessage, progressPercentage) {
                $("#txtProgress").val(progressMessage);
                $("#prgProgress").css("width", progressPercentage + "%").text(progressMessage).attr('aria-valuenow', progressPercentage);
                //$("#prgProgress").css("width", progressPercentage + "%").attr('aria-valuenow', progressPercentage);
                //if (progressPercentage == 100) {
                //    $("#prgProgress").addClass('notransition');
                //    $("#prgProgress").css("width", "0%");
                //    $("#prgProgress").removeClass('notransition');
                //}
            };
            // Get the user name and store it to prepend to messages.
            $('#displayname').val(prompt('Enter your name:', ''));
            // Set initial focus to message input box.  
            $('#message').focus();
            // Start the connection.
            $.connection.hub.start().done(function () {
                var connectionId = $.connection.hub.id;
                //https://docs.microsoft.com/en-us/aspnet/signalr/overview/guide-to-the-api/hubs-api-guide-javascript-client#connectionlifetime
                $('#sendmessage').click(function () {
                    // Call the Send method on the hub. 
                    //progresProxy.server.send($('#displayname').val(), $('#message').val());

                    progresProxy.server.send($('#displayname').val(), $('#message').val())
                        .fail(function (e) {
                            if (e.source === 'HubException') {
                                alert(e.message + ' : ' + e.data.user);
                                console.log(e.message + ' : ' + e.data.user);
                            }
                        });

                    //progresProxy.server.send($('#displayname').val(), "<script>")
                    //    .fail(function (e) {
                    //        if (e.source === 'HubException') {
                    //            alert(e.message + ' : ' + e.data.user);
                    //            console.log(e.message + ' : ' + e.data.user);
                    //        }
                    //    });
                    // Clear text box and reset focus for next comment. 
                    $('#message').val('').focus();
                    
                });
                $('#btnProcessBatch').click(function () {
                    // Call the ProcessBatch method on the hub. note change in case processBatch
                    //$("#prgProgress").css("width", "1%").text("").attr('aria-valuenow', 1);

                    $("#prgProgress").hide();
                    $("#prgProgress").css("width", "1%");
                    //$("#prgProgress").attr("style", "width: 1%");
                    $("#prgProgress").show();

                    //progresProxy.server.doWork($('#displayname').val(), $('#message').val());
                    //progresProxy.server.postBatch($('#displayname').val(), $('#message').val());
                    progresProxy.server.processBatch($('#displayname').val(), $('#message').val());
                    //progresProxy.server.postBatch2($('#displayname').val(), $('#message').val());
                    
                    //$("#prgProgress").addClass('notransition');
                    //$("#prgProgress").attr("style", "width: 1%");
                    //$("#prgProgress").removeClass('notransition');

                    //setTimeout(function () {
                    //    progresProxy.server.processBatch2($('#displayname').val(), $('#message').val());
                    //}, 1000);
                    //progresProxy.server.processBatch($('#displayname').val(), $('#message').val());
                    

                });
            });


            $.connection.hub.error(function (error) {
                console.log('SignalR error: ' + error)
            });
            //https://docs.microsoft.com/en-us/aspnet/signalr/overview/guide-to-the-api/handling-connection-lifetime-events
            $.connection.hub.connectionSlow(function () {
                //notifyUserOfConnectionProblem(); // Your function to notify user.
            });
            $.connection.hub.reconnecting(function () {
                //notifyUserOfTryingToReconnect(); // Your function to notify user.
            });

            //How to continuously reconnect
            //A potential problem to be aware of in mobile clients is that continuous reconnection attempts when the server or physical connection isn't available could cause unnecessary battery drain.
            $.connection.hub.disconnected(function () {
                if ($.connection.hub.lastError) { alert("Hub Disconnected. Reason: " + $.connection.hub.lastError.message); }
                setTimeout(function () {
                    $.connection.hub.start();
                }, 5000); // Restart connection after 5 seconds.
            });
            //How to disconnect a client in server code
            //var myHubProxy = $.connection.myHub;
            //$.connection.hub.client.stopClient = function () {
            //    $.connection.hub.stop();
            //};
        });
    </script>
</body>
</html>
