﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Bank/Views/Shared/StaffMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    BOSA Statement
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        .td_amount_col {
            text-align: right;
        }
       
    </style>

    
    <script type="text/javascript"  >
        $(document).ready(function () {
                $("#btnGetStatement").on('click', function () {
                    LoadBOSAStatement();
                });

                
                $('#txtSearchValue').focus();
                $('#txtSearchValue').on('focusout', function (ev) {
                    LoadBOSAStatement();
                });
                $('#txtSearchValue').keypress(function (ev) {
                    ev.preventDefault;
                    ev.stopPropagation;
                    if (ev.keyCode == 13 || ev.which == 13) {
                        $("#btnGetStatement").trigger('click');
                        return false;
                    }
                });
                $("#btnPrint").click(function () {
                    //$("#mySelector").printThis({
                    //debug: false,              * show the iframe for debugging
                    //importCSS: true,           * import page CSS
                    //printContainer: true,      * grab outer container as well as the contents of the selector
                    //loadCSS: "path/to/my.css", * path to additional css file
                    //pageTitle: "",             * add title to print page
                    //removeInline: false        * remove all inline styles from print elements

                    var rptHeader = "<b>" + CompanyName + "<br>" + CompanyAddress + "</br>" + "BOSA Statement" + "</b>" + $("#divAccountInfo").html();
                    $("#divStatement").printThis({
                        debug: false,
                        pageTitle: "Report",
                        removeInline: true,
                        printContainer: true,
                        importCSS: true,
                        header: rptHeader
                    });

                });
                $("#cboSearchBy").on('change', function () {
                    $('#divSearchDisplay').html('Enter ' + $("#cboSearchBy option:selected").text());
                });
                
                $("#cboYear").on("change", function () {
                    LoadFinancialPeriods();
                });
                /*
                $('#tblStatement').dataTable({
                    "paging": false,
                    "ordering": false,
                    "info": false,
                    "searching": false
                });
                */

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetAllEmployer") %>",
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var employers = response;
                        var obj = document.getElementById("cboEmployer");
                        $.each(employers, function (index, empl) {
                            var opt = document.createElement("option");
                            opt.value = empl.EmployerCode;
                            opt.text = empl.EmployerName;
                            obj.appendChild(opt);
                        });
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        // alert('Error - ' + errorMessage);
                        toastr["error"](errorMessage, "Error!");
                    }

                });
                $("#cboYear").empty();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetYears") %>",
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var years = response;
                        var obj = document.getElementById("cboYear");
                        $.each(years, function (index, yrs) {
                            var opt = document.createElement("option");
                            opt.value = yrs.DBName;
                            opt.text = yrs.UserDefinedYearName;
                            opt.selected = true;
                            obj.appendChild(opt);
                        });
                        LoadFinancialPeriods();
                    },
                    error: function (xhr, status, error) {
                        
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        // alert('Error - ' + errorMessage);
                        toastr["error"](errorMessage, "Error!");
                    }
                });
            
        
            
          
        function LoadFinancialPeriods() {
            var dbname = $("#cboYear").val();
            if (dbname == null) { return; }
            $("#cboStartMonth").empty();
            $("#cboEndMonth").empty();
            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/BankSystemApi/GetAllBOSAFinancialMonths") %>",
                data: JSON.stringify({'DBName' : $("#cboYear").val()}),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    var fmonths = response;
                    var objEnd = document.getElementById("cboEndMonth");

                    $("#cboStartMonth").empty();
                    $("#cboEndMonth").empty();
                    $.each(fmonths, function (index, fmonth) {
                        var opt = document.createElement("option");
                        opt.value = fmonth.MonthID;
                        opt.text = fmonth.MonthName;
                        objEnd.appendChild(opt);
                        if (fmonth.Status == "OPENED") {
                            objEnd.selectedIndex = index
                        }

                    });
                },
                error: function (xhr, status, error) {
                    var errorMessage = xhr.status + ': ' + xhr.responseText;
                    // alert('Error - ' + errorMessage);
                    toastr["error"](errorMessage, "Error!");
                }
            });
        }

        

        function LoadBOSAStatement() {
            row = 1;
            $('#divAccountInfo').html("");
            $("#tblStatement > tbody:last").children().remove();
            $("#divPDF").html("PDF Report");
            if($("#txtSearchValue").val().trim()==""){return;}
            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/BankSystemApi/GetBOSAStatement") %>",
                data: JSON.stringify({'DBName' :  $("#cboYear").val(),'StatementFormat' : $("#cboFormat").val(),'EndPeriod' : $("#cboEndMonth").val() ,'SearchBy' : $("#cboSearchBy").val() ,'SearchValue' :  $("#txtSearchValue").val() ,'EmpCode' : $("#cboEmployer").val() }),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    row = 1;
                    $('#divAccountInfo').empty();
                    $("#tblStatement > tbody:last").children().remove();
                    if (response.StatementMember != null) {
                        $('#divAccountInfo').append('<p><strong>MemberName: ' + response.StatementMember.FullNames + '<br>'
                                                            + 'MemberNo: ' + response.StatementMember.MemberNo + '<br>'
                                                            + 'PayrollNo: ' + response.StatementMember.PayrollNo + '<br>'
                                                        + 'IDNo: ' + response.StatementMember.IDNumber + '<br>'
                                                         + '</strong></p>');
                    }

                    var lineitems = response.StatementItems;
                    var statref = "";
                    var total = 0;
                    var inttotal = 0;
                    var tbl_row = "";

                    var pdf_url = "<b><a href='" + global_site_root + "/Bank/BankSystem/BOSAStatementReport?DBName=" + $("#cboYear").val() + "&EmpCode=" + response.StatementMember.EmployerCode + "&PayrollNo=" + response.StatementMember.PayrollNo + "&EndPeriod=" + $("#cboEndMonth").val() + "&StatementFormat=" + $("#cboFormat").val() + "'>PDF Report</a></b>";
                    $("#divPDF").html(pdf_url);

                    $.each(lineitems, function (index, lineitem) {
                        row = row + index;
                        if (statref != lineitem.StatRef) {
                            total = 0;
                            inttotal = 0;
                            statref = lineitem.StatRef;

                            if (index != 0) {
                                tbl_row = "<tr>";
                                tbl_row += "<td colspan=8><hr/></td>";
                                tbl_row += "</tr>";
                            }

                            tbl_row = "<tr>";
                            tbl_row += "<td style='text-align: left;padding:7px'><b>" + lineitem.RefCode + "</b></td>";
                            tbl_row += "<td style='text-align: left;padding:7px'><b>" + lineitem.RefName + "</b></td>";
                            tbl_row += "<td style='text-align: left;padding:7px'><b>Doc. No.</b></td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'><b>Debit</b></td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'><b>Credit</b></td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'><b>Balance</b></td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'><b>Int. Debit</b></td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'><b>Int. Credit</b></td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'><b>Balance</b></td>";
                            tbl_row += "</tr>";
                            $("#bdStatement").append(tbl_row);
                        } 

                        if (statref.substring(0, 1) == "S") {
                            total = +total + +lineitem.Debit + +lineitem.Credit;
                            inttotal = +inttotal + +lineitem.IntDebit + +lineitem.IntCredit;
                        } else {
                            total = +total + +lineitem.Debit - +lineitem.Credit;
                            inttotal = +inttotal + +lineitem.IntDebit - +lineitem.IntCredit;
                        }

                        tbl_row = "<tr>";
                        tbl_row += "<td style='text-align: left;padding:7px'>" + lineitem.DocDate + "</td>";
                        tbl_row += "<td style='text-align: left;padding:7px'>" + lineitem.Description + "</td>";
                        tbl_row += "<td style='text-align: left;padding:7px'>" + lineitem.DocNo + "</td>";
                        tbl_row += "<td class='td_amount_col' style='padding:7px'>" + lineitem.Debit.formatMoney() + "</td>";
                        tbl_row += "<td class='td_amount_col' style='padding:7px'>" + lineitem.Credit.formatMoney() + "</td>";
                        tbl_row += "<td class='td_amount_col' style='padding:7px'>" + total.formatMoney() + "</td>";
                        tbl_row += "<td class='td_amount_col' style='padding:7px'>" + lineitem.IntDebit.formatMoney() + "</td>";
                        tbl_row += "<td class='td_amount_col' style='padding:7px'>" + lineitem.IntCredit.formatMoney() + "</td>";
                        tbl_row += "<td class='td_amount_col' style='padding:7px'>" + inttotal.formatMoney() + "</td>";
                        tbl_row += "</tr>";
                        $("#bdStatement").append(tbl_row);

                    });
                    

                    tbl_row = "<tr>";
                    tbl_row += "<td colspan=9><i>**************End of Statement***********</i></td>";
                    tbl_row += "</tr>";
                    $("#bdStatement").append(tbl_row);
                },
                error: function (xhr, status, error) {
                    var errorMessage = xhr.status + ': ' + xhr.responseText;
                    // alert('Error - ' + errorMessage);
                    toastr["error"](errorMessage, "Error!");
                }
            });


        }

        function setCookie(c_name, value, expiredays) {
            var exdate = new Date();
            exdate.setDate(exdate.getDate() + expiredays);
            document.

                e = c_name + "=" + escape(value) +
            ((expiredays == null) ? "" : ";expires=" + exdate.toUTCString());
        }
        function getCookie(c_name) {
            if (document.cookie.length > 0) {
                c_start = document.cookie.indexOf(c_name + "=");
                if (c_start != -1) {
                    c_start = c_start + c_name.length + 1;
                    c_end = document.cookie.indexOf(";", c_start);
                    if (c_end == -1) c_end = document.cookie.length;
                    return unescape(document.cookie.substring(c_start, c_end));
                }
            }
            return "";
        }

        $(function () {
            $("#tabs").tabs();
        });
        $(function () {
            $("#accordion").accordion({
                heightStyle: "content"
            });
        });
    });

    </script>
</asp:Content>
<asp:Content ID="Content6" ContentPlaceHolderID="FeaturedContent" runat="server">

</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <div class="card bg-white mt-3">
        <h3 class="p-3 fs-5">Bosa Statement</h3>
        <hr class="m-0 mb-3"/>
    
    <form id="frmBOSAStatement" name="frmBOSAStatement">
    <%= Html.AntiForgeryToken() %>
    <div>
        <div class="p-3">
            <div class="row g-3 mb-1">
                <div class="col-md-3">
                    <label>Financial year</label>
                    <select id="cboYear" class="form-select">
                        <option value="selectyear">SELECT YEAR</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label>Period</label>
                    <select id="cboEndMonth" class="form-select">
                        <option value="selectEndperiod">Select End Period</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label>Format</label>
                    <select id="cboFormat" class="form-select">
                        <option value="standard">Standard</option>
                        <option value="groupbyloantype" selected>Group By Loan Type</option>
                    </select>
                </div>
            </div>
            <div class="row g-3 mb-1">
                <div class="col-md-3">
                    <label>Search By</label>
                    <select id="cboSearchBy" class="form-select">
                        <option value="memberno">MemberNo</option>
                        <option value="idnumber">IDNo</option>
                        <option value="payrollno">PayrollNo</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label id="divSearchDisplay">Search value</label>
                    <input type="text" id="txtSearchValue" class="form-control"/>
                </div>
                <div class="col-md-3">
                    <label>Employer</label>
                    <select id="cboEmployer" class="form-select">
                        <option value="selectemployer">SELECT EMPLOYER</option>
                    </select>
                </div>
            </div>
            <div class="row g-3 mt-1">
                <div class="col-md-3">
                    <input type="button" id="btnGetStatement" value="Get Statement" class="btn btn-primary"/>
                </div>
                <div class="col-md-3">
                    <input type="button" id="btnPrint" value="Print Statement" class="btn btn-warning"/>
                </div>
                <div class="col-md-3" >
                    <input type="button" value="test report" id="btnTestReport" hidden="hidden" />
                    <input type="button" value="test print report" id="btnTestPrintReport" hidden="hidden" />
                    <span id="divPDF" class="btn btn-secondary text-white">PDF Report</span>
                </div>
            </div>
        </div>
    </div>

    <div class="mt-2">
        <div class="card-body">
            <h4>Member Information</h4>
            <div class="row g-3 mt-1">
                <div id="divAccountInfo"></div>
            </div>
        </div>
    </div>

    

    <%--<div class="mt-4">
        <div id="divStatement" class="card-body">
            <table id='tblStatement' class="table table-responsive table-striped">
                    
                    <tbody id='bdStatement'>
                    </tbody>
            </table><hr/>
        </div>
    </div> --%>

    <div class="mt-2" id="divStatement" style="padding-left: 10px;padding-right: 10px;padding-bottom: 10px;">
        <div class="table-responsive mt-4 mb30" >
            <table class="table table-bordered" id='tblStatement'>
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Description</th>
                        <th>Doc No</th>
                        <th>Debit</th>
                        <th>Credit</th>
                        <th>Balance</th>
                        <th>Int. Debit</th>
                        <th>Int. Credit</th>
                        <th>Balance</th>
                    </tr>
                </thead>
                <tbody id='bdStatement'>
                </tbody>
            </table><hr/>
        </div>
    </div>
    </form>
    
    <%-- <table border="1" style="padding: 3px; margin: 2px;">
        <tr>
            <td colspan="4"><b>Financial Period</b></td>
        </tr>
        <tr><td>Financial Year:</td><td colspan="3"><select id="cboYear"><option value="selectyear">SELECT YEAR</option></select></td></tr>
        <tr><td>Format:</td><td> <select id="cboFormat"><option value="standard">Standard</option><option value="groupbyloantype" selected>Group By Loan Type</option></select></td><td>Period:</td><td> <select id="cboEndMonth"><option value="selectEndperiod">Select End Period</option></select></td></tr>
        <tr><td>Search By:</td><td><select id="cboSearchBy">
                                        <option value="memberno">MemberNo</option>
                                        <option value="idnumber">IDNo</option>
                                        <option value="payrollno">PayrollNo</option>
                                   </select>
            </td>
            <td>Employer:</td><td><select id="cboEmployer">
                                        <option value="selectemployer">SELECT EMPLOYER</option>
                                   </select>
            </td>
        </tr>
        <tr>
            <td><div id="divSearchDisplay">Search Value</div></td><td><input type="text" id="txtSearchValue"/></td>
        </tr>
        <tr><td></td><td><input type="button" id="btnGetStatement" value="Get Statement"/><input type="button" id="btnPrint" value="Print Statement"/><input type="button" value="test report" id="btnTestReport" hidden="hidden" /><input type="button" value="test print report" id="btnTestPrintReport" hidden="hidden" /></td></tr>
        <tr><td><div id="divPDF">PDF Report</div></td></tr>
        
        <tr><td colspan="4"><b>Member Info</b></td></tr>
        <tr><td colspan="4"><div id="divAccountInfo"></div></td></tr>
    </table><hr/>
    
        <div id="divStatement" class="table-responsive">
            <table id='tblStatement' class="table table-responsive table-striped">
                    <thead>
                        <tr>
                        <th style="text-align: left;padding:7px"><b>Date</b></th>
                        <th style="text-align: left;padding:7px"><b>Description</b></th>
                        <th style="text-align: left;padding:7px"><b>Doc No</b></th>
                        <th style="text-align: right;padding:7px"><b>Debit</b></th>
                        <th style="text-align: right;padding:7px"><b>Credit</b></th>
                        <th style="text-align: right;padding:7px"><b>Balance</b></th>
                        <th style="text-align: right;padding:7px"><b>Int. Debit</b></th>
                        <th style="text-align: right;padding:7px"><b>Int. Credit</b></th>
                        <th style="text-align: right;padding:7px"><b>Int. Balance</b></th>
                        </tr>
                    </thead>
                    <tbody id='bdStatement'>
                    </tbody>
                <tfoot>
                    <tr>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>
                </tfoot>
            </table><hr/>

            
        </div> --%>
    
    
    </div>
</asp:Content>


