﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Members/Views/Shared/MembersMasterBS.Master"
    Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

    <%--<%@ Register
        assembly="Microsoft.ReportViewer.WebForms, Version=11.0.0.0, Culture=neutral, PublicKeyToken=89845dcd8080cc91"
        namespace="Microsoft.Reporting.WebForms" tagprefix="rsweb" %>--%>

        <asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
            Bank Statement
        </asp:Content>
        <asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
            <style type="text/css">
                .td_amount_col {
                    text-align: right;
                }
            </style>
            <script type="text/javascript">
                $(document).ready(function () {
                    $("#cboYear").empty();
                    /*
                    $('#tblStatement').dataTable({
                        "paging": false,
                        "ordering": false,
                        "info": false, 
                        "searching": false
                    });
                    */
                    $("#cboAccount").on('change', function () {
                        LoadFosaStatement();
                    });
                    $("#cboStartMonth").on('change', function () {
                        LoadFosaStatement();
                    });
                    $("#cboEndMonth").on('change', function () {
                        LoadFosaStatement();
                    });

                    $("#btnRefresh").on('click', function () {
                        LoadFosaStatement();
                    });

                    $("#cboYear").on('change', function () {
                        var dbname = $("#cboYear").val();
                        if (dbname == null) { return; }
                        $("#cboStartMonth").empty();
                        $("#cboEndMonth").empty();

                        var csrfToken = $("input[name='__RequestVerificationToken']").val();
                        $.ajax({
                            headers: { __RequestVerificationToken: csrfToken },
                            type: "POST",
                            url: '<%: Url.Content("~/api/MembersSystemApi/GetAllBOSAFinancialMonths") %>',
                            data: JSON.stringify({ 'DBName': $("#cboYear").val() }),
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            success: function (response) {
                                var fmonths = response;
                                var objEnd = document.getElementById("cboEndMonth");
                                var objStart = document.getElementById("cboStartMonth");
                                $("#cboStartMonth").empty();
                                $("#cboEndMonth").empty();
                                $.each(fmonths, function (index, fmonth) {
                                    var opt = document.createElement("option");
                                    opt.value = fmonth.MonthID;
                                    opt.text = fmonth.MonthName;
                                    objEnd.appendChild(opt);
                                    if (fmonth.Status == "OPENED") {
                                        objEnd.selectedIndex = index
                                    }
                                    opt = document.createElement("option");
                                    opt.value = fmonth.MonthID;
                                    opt.text = fmonth.MonthName;
                                    objStart.appendChild(opt);
                                    if (fmonth.MonthID == "01") {
                                        objStart.selectedIndex = index
                                    }
                                });

                                LoadFosaStatement();
                            },
                            error: function (xhr, status, error) {

                                var errorMessage = xhr.status + ': ' + xhr.responseText;
                                alert('Error - ' + errorMessage);
                            }
                        });
                    });

                    // -------------------------------------------------
                    // Print PDF report
                    // -------------------------------------------------
                    $("#btnPrint").click(function () {
                       
                        var pdfLink = $("#divPDF a").attr("href");
                       
                        if (!pdfLink) {
                            toastr["warning"]("PDF report is not available yet load the statement first.");
                            return;
                        }else {
                            toastr["info"]("Printing Report...");
                        }

                        // Open the PDF in a new tab/window and trigger the print dialog
                        var pdfWindow = window.open(pdfLink, "_blank");
                        if (pdfWindow) {
                            // Give the PDF a moment to load before printing
                            pdfWindow.focus();
                            pdfWindow.onload = function () {
                                pdfWindow.print();
                            };
                        } else {
                            alert("Popup blocker prevented opening the PDF. Please allow pop‑ups for this site.");
                        }
                    });

                    $("#downloadPDF").click(function () {
                        var pdfLink = $("#divPDF a").attr("href");
                        if (!pdfLink) {
                            toastr["warning"]("Please load the Statement First.");
                            return;
                        }else {
                            toastr["success"]("Your download will start shortly.");
                        }

                        // Trigger the download
                        var link = document.createElement('a');
                        link.href = pdfLink;
                        link.download = 'FOSA_Statement.pdf';
                        document.body.appendChild(link);
                        link.click();
                        document.body.removeChild(link);
                    });

                    
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: '<%: Url.Content("~/api/MembersSystemApi/GetYears") %>',
                        data: "{}",
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            var years = response;
                            var obj = document.getElementById("cboYear");
                            $.each(years, function (index, yrs) {
                                var opt = document.createElement("option");
                                opt.value = yrs.DBName;
                                opt.text = yrs.UserDefinedYearName;
                                opt.selected = true;
                                obj.appendChild(opt);
                            });
                            $("#cboYear").get(0).selectedIndex = 0;
                            $("#cboYear").trigger('change');
                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            alert('Error - ' + errorMessage);
                        }
                    });

                    // -------------------------------------------------
                    // Populate the Account dropdown
                    // -------------------------------------------------
                    LoadFosaStatementAccounts();

                    // -------------------------------------------------
                    // Load the statement data (also builds the PDF link)
                    // -------------------------------------------------
                    function LoadFosaStatement() {
                        $('#divAccountInfo').html("");
                        $("#tblStatement > tbody:last").children().remove();
                        $("#divPDF").html("PDF Report");

                        if (document.getElementById("cboAccount").selectedIndex == 0) { return; }

                        var csrfToken = $("input[name='__RequestVerificationToken']").val();
                        $.ajax({
                            headers: { __RequestVerificationToken: csrfToken },
                            type: "POST",
                            url: '<%: Url.Content("~/api/MembersSystemApi/GetBankStatement") %>',
                            data: JSON.stringify({
                                'DBName': $("#cboYear").val(),
                                'StartPeriod': $("#cboStartMonth").val(),
                                'EndPeriod': $("#cboEndMonth").val(),
                                'AccountNo': $("#cboAccount").val()
                            }),
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            success: function (response) {
                                $("#accName").text(response.StatementAccount.AccountName);
                                $("#accCode").text(response.StatementAccount.UserCode);
                                $("#accType").text(response.StatementAccount.ParentAccName);

                                if (response.StatementAccount.MemberDetails != null) {
                                    $("#memName").text(response.StatementAccount.MemberDetails.FullNames);
                                    $("#memNo").text(response.StatementAccount.MemberDetails.MemberNo);
                                    $("#payrollNo").text(response.StatementAccount.MemberDetails.PayrollNo);
                                    $("#idNo").text(response.StatementAccount.MemberDetails.IDNumber);
                                }

                                var lineitems = response.StatementItems;
                                var tbl_row = "";
                                var pdf_url = "<a href='" + global_site_root + "/Members/MembersSystem/GetBankStatementReport?DBName=" + $("#cboYear").val() + "&StartPeriod=" + $("#cboStartMonth").val() + "&EndPeriod=" + $("#cboEndMonth").val() + "&AccountNo=" + response.StatementAccount.UserCode + "' target='_blank'>PDF Report</a>";
                                $("#divPDF").html(pdf_url);

                                $.each(lineitems, function (index, lineitem) {
                                    tbl_row = "<tr><td>" + lineitem.Document_Date + "</td><td class='td_description'>" + lineitem.Description + "</td><td class='td_description'>" + lineitem.Document_no + "</td><td class='td_amount_col'>" + lineitem.Debit.formatMoney() + "</td><td class='td_amount_col'>" + lineitem.Credit.formatMoney() + "</td><td class='td_amount_col'>" + lineitem.RunBal.formatMoney() + "</td></tr>";
                                    $("#bdStatement").append(tbl_row);
                                });

                                tbl_row = "<tr><td colspan='6'><p class='text-center'>**************End of Statement***********</p></td></tr>";
                                $("#bdStatement").append(tbl_row);
                            },
                            error: function (xhr, status, error) {
                                var errorMessage = xhr.status + ': ' + xhr.responseText;
                                alert('Error - ' + errorMessage);
                            }
                        });
                    }
                    function LoadFosaStatementAccounts() {
                        $("#cboAccount").empty();
                        $("#cboAccount").append('<option selected>(SELECT ACCOUNT)</option>');

                        $('#divAccountInfo').html("");
                        $("#tblStatement > tbody:last").children().remove();


                        var csrfToken = $("input[name='__RequestVerificationToken']").val();
                        $.ajax({
                            headers: { __RequestVerificationToken: csrfToken },
                            type: "POST",
                            url: '<%: Url.Content("~/api/MembersSystemApi/GetMemberFOSAAccounts") %>',
                            data: "{}",
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            success: function (response) {
                                var bankaccounts = response;
                                var obj = document.getElementById("cboAccount");
                                $.each(bankaccounts, function (index, bankaccount) {
                                    var opt = document.createElement("option");
                                    opt.value = bankaccount.AccountNo;
                                    opt.text = bankaccount.AccountNo;
                                    obj.appendChild(opt);
                                });
                            },
                            error: function (xhr, status, error) {

                                var errorMessage = xhr.status + ': ' + xhr.responseText;
                                alert('Error - ' + errorMessage);
                            }
                        });
                    }
                    function setCookie(c_name, value, expiredays) {
                        var exdate = new Date();
                        exdate.setDate(exdate.getDate() + expiredays);
                        document.

                            e = c_name + "=" + escape(value) +
                            ((expiredays == null) ? "" : ";expires=" + exdate.toUTCString());
                    }
                    function getCookie(c_name) {
                        if (document.cookie.length > 0) {
                            c_start = document.cookie.indexOf(c_name + "=");
                            if (c_start != -1) {
                                c_start = c_start + c_name.length + 1;
                                c_end = document.cookie.indexOf(";", c_start);
                                if (c_end == -1) c_end = document.cookie.length;
                                return unescape(document.cookie.substring(c_start, c_end));
                            }
                        }
                        return "";
                    }

                    $(function () {
                        $("#tabs").tabs();
                    });
                    $(function () {
                        $("#accordion").accordion();
                    });
                });
            </script>
        </asp:Content>


        <asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">


            <div>
                <div>
                    <div class="card">
                        <div id="div1">
                            <form id="frmBankStatement" name="frmBankStatement" >
                                <%= Html.AntiForgeryToken() %>
                                
                                <h6 class="fw-bold p-2 my-2 text-center">FOSA Statement</h6>
                                <hr class="m-0 p-0" />
                                        <div class="row p-3">
                                            <div class="col-md-4">
                                                <label for="Financial Year:" class="form-label">Financial Year</label>
                                                <select id="cboYear" class="form-select">
                                                    <option value="selectyear">SELECT YEAR</option>
                                                </select>
                                            </div>
                                            <div class="col-md-4">
                                                <label for="Start Period" class="form-label">Start Period</label>
                                                <select id="cboStartMonth" class="form-select">
                                                    <option value="selectstartperiod">Select Start Period</option>
                                                </select>
                                            </div>
                                            <div class="col-md-4">
                                                <label for="End Period" class="form-label">End Period:</label>
                                                <select id="cboEndMonth" class="form-select">
                                                    <option value="selectEndperiod">Select End Period</option>
                                                </select>
                                            </div>
                                            <div class="col-md-4">
                                                <label for=" Select Account" class="form-label"> Select Account</label>
                                                <select id="cboAccount" class="form-select">
                                                    <option>SELECT ACCOUNT</option>
                                                </select>
                                            </div>

                                            <div class="col-md">
                                                <div class="col-md">
                                                    
                                                </div>
                                                <div class="col-md">
                                                    <div class="btn btn-primary d-none" id="divPDF" ></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="gap-3 d-md-block m-2">
                                            <div id="btnPrint" class="btn btn-primary">
                                                    Print Statement <i class="fa-solid fa-print"></i> 
                                            </div>
                                            
                                            <div class=" btn btn-secondary" id="downloadPDF">
                                                Download <i class="fa-solid fa-download"></i></div>
                                        </div>
                            </form>
                        </div>
                    </div>

                    
                    
                    <div  class="table-responsive p-3 bg-white my-2">
                            <table id='tblStatement'
                                class="table table-striped table-bordered row-fluid text-nowrap">
                                <thead>
                                    <tr>
                                        <th style="text-align: left;padding:7px">Date</th>
                                        <th style="text-align: left;padding:7px">Description</th>
                                        <th style="text-align: left;padding:7px">Doc No</th>
                                        <th style="text-align: right;padding:7px">Debit</th>
                                        <th style="text-align: right;padding:7px">Credit</th>
                                        <th style="text-align: right;padding:7px">Balance</th>

                                    </tr>
                                </thead>
                                <tbody id='bdStatement'>
                                </tbody>

                            </table>
                    </div>
</div>


                </div>
            </div>

        </asp:Content>