﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Bank/Views/Shared/StaffMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Debit And Credit Notes
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
     <style type="text/css">
        
         
         tr.row_selected td{background-color:lightgray;}
         
    </style>

    
    <script type="text/javascript"  >
        $(document).ready(function () {

            var drmember = null;
            var crmember = null;


            $('#frmMain').on('mouseup', '[type=text],[type=date]', function (e) { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                e.preventDefault();
            });
            $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).select();
            });
            $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).addClass("textfocused");
            });
            $('#frmMain').on('focusout', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).removeClass("textfocused");
            });

            $("#btnRefresh").on('click', function () {
                DispTransactionsListSummary();
            });
            $("#cboYear").on('change', function () {
                LoadFinancialPeriods()
            });
            $("#cboPeriod").on('change', function () {
                DispTransactionsListSummary();
            });
            $("#cboFilterPostedStatus").on('change', function () {
                DispTransactionsListSummary();
            });
            $("#cboFilterBranches").on('change', function () {
                DispTransactionsListSummary();
            });




            $('#tblTransListSummary tbody').on('click', 'tr', function () {
                $('#tblTransListSummary tbody tr').removeClass('row_selected');
                $(this).addClass('row_selected');
                var DocNo = $(this).find('td').eq(0).text();
                DispTransactionsListDetails(DocNo);
            });

            $("#tblTransListSummary").keydown(function (evt) {
                if (evt.keyCode == 38) { // up
                    $('tbody tr:not(:first).selected').removeClass('row_selected').prev().addClass('row_selected');
                }
                if (evt.keyCode == 40) { // down
                    $('tbody tr:not(:last).selected').removeClass('row_selected').next().addClass('row_selected');
                }
            });

            //$("#tblTransListSummary").dataTable({
            //    bJQueryUI: true,
            //    sPaginationType: "full_numbers",
            //    paging: false,
            //    sScorollX: "900px",
            //    sScrollY: "900px",
            //    bScrollInfinite: true, //this property disables pagination
            //    "bDestroy": true
            //    //oSearch: { "sSearch": "DefaultSearchValue", "bRegex": false, "bSmart": false }
            //});


            $("#txtDate").datepicker({ dateFormat: 'dd/mm/yy' });

            DisableDataEntry();



            $("#cboYear").empty();
            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/BankSystemApi/GetAccountsModulesConfig") %>",
                data: "{}",
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    var years = response.Years;
                    var employers = response.Employers;
                    var saccobranches = response.Branches;
                    SaccoSettings = response.SaccoSettings;
                    var obj = document.getElementById("cboYear");
                    $.each(years, function (index, yrs) {
                        var opt = document.createElement("option");
                        opt.value = yrs.DBName;
                        opt.text = yrs.UserDefinedYearName;
                        opt.selected = true;
                        obj.appendChild(opt);
                    });
                    $("#cboYear").get(0).selectedIndex = 0;
                    var obj = document.getElementById("cboFilterBranches");
                    $.each(saccobranches, function (index, saccobranch) {
                        var opt = document.createElement("option");
                        opt.value = saccobranch.BranchCode;
                        opt.text = saccobranch.BranchName + "(" + saccobranch.BranchCode + ")";
                        obj.appendChild(opt);
                    });
                    LoadFinancialPeriods();
                },
                error: function (xhr, status, error) {
                    var errorMessage = xhr.status + ': ' + xhr.responseText;
                    alert('Error - ' + errorMessage);
                }
            });



            $("#creditaccountno").on('focusout', function () {
                GetAccountName($("#creditaccountno").val()).then(function (data) { $("#divcreditaccountname").html(data); })
            });
            $("#debitaccountno").on('focusout', function () {
                GetAccountName($("#debitaccountno").val()).then(function (data) { $("#divdebitaccountname").html(data); })
            });
            $("#btnSelectDrAcc").on('click', function () {
                xDialogSelectGLAccount("ALL").then(function (data) { $("#debitaccountno").val(data); $("#debitaccountno").trigger('focusout'); });
            });
            $("#btnSelectCrAcc").on('click', function () {
                xDialogSelectGLAccount("ALL").then(function (data) { $("#creditaccountno").val(data); $("#creditaccountno").trigger('focusout'); });
            });
            $("#creditmemberno").on('focusout', function () {
                LoadMemberBalances("cr");
            });
            $("#debitmemberno").on('focusout', function () {
                LoadMemberBalances("dr");
            });
            $("#debitaccountno").on('focus', function () {
                $("#debitaccountno").mask(AccountMask);
            });
            $("#creditaccountno").on('focus', function () {
                $("#creditaccountno").mask(AccountMask);
            });

            $("#cboSelectDebitType").on('change', function () {

                //Clear Everything First
                drmember = null;
                $("#debitmemberno").prop("disabled", true);
                $("#debitmemberno").val("");
                $("#debitaccountno").prop("disabled", true);
                $("#debitaccountno").val("");
                $("#debitmemberdetails").html("");
                $("#btnSelectDrAcc").prop("disabled", true);
                $("#divdebitaccountname").html("");
                $("#debitmpaitems").prop("disabled", true);
                $("#debitmpaitems").empty();
                $("#debitmpaitems").append('<option value="">' + "(SELECT LOAN/SCHEME)" + '</option>');
                $("#divdebitmpadesc").html("");

                var obj = document.getElementById("cboSelectDebitType");
                if ((obj.selectedIndex) == 0) {
                    return;
                } else if ((obj.selectedIndex) == 1) { //NON-MMEBER
                    $("#debitaccountno").prop("disabled", false);
                    $("#btnSelectDrAcc").prop("disabled", false);
                } else if ((obj.selectedIndex) == 2) { //MEMBER
                    $("#debitmemberno").prop("disabled", false);
                    $("#debitmpaitems").prop("disabled", false);
                }


            });

            $("#btnPost").on('click', function () {
                xDialogConfirm("Post Document?", "Confirm").then(function () {
                    xDialogGetUserCredetials().then(function (data) {
                        PostTransactions(data);
                    });
                });
            });


            $("#cboSelectCreditType").on('change', function () {
                //Clear Everything First
                crmember = null;
                $("#creditmemberno").prop("disabled", true);
                $("#creditmemberno").val("");
                $("#creditaccountno").prop("disabled", true);
                $("#creditaccountno").val("");
                $("#creditmemberdetails").html("");
                $("#btnSelectCrAcc").prop("disabled", true);
                $("#divcreditaccountname").html("");
                $("#creditmpaitems").prop("disabled", true);
                $("#creditmpaitems").empty();
                $("#creditmpaitems").append("<option value=''>(SELECT LOAN/SCHEME)</option>");
                $("#divcreditmpadesc").html("");

                var obj = document.getElementById("cboSelectCreditType");
                if ((obj.selectedIndex) == 0) {
                    return;
                } else if ((obj.selectedIndex) == 1) { //NON-MMEBER
                    $("#creditaccountno").prop("disabled", false);
                    $("#btnSelectCrAcc").prop("disabled", false);
                } else if ((obj.selectedIndex) == 2) { //MEMBER
                    $("#creditmemberno").prop("disabled", false);
                    $("#creditmpaitems").prop("disabled", false);
                }
            });



            function LoadMemberBalances(NoteType) {
                var memberno = "";
                var obj;
                var opt;
                var memdiv;
                if (NoteType.toLowerCase().trim() == "dr".toLowerCase().trim()) {
                    memberno = $("#debitmemberno").val();
                    obj = document.getElementById("debitmpaitems");
                    memdiv = document.getElementById("debitmemberdetails");
                } else {
                    memberno = $("#creditmemberno").val();
                    obj = document.getElementById("creditmpaitems");
                    memdiv = document.getElementById("creditmemberdetails");
                }
                $(memdiv).html("");
                $(obj).empty();
                opt = document.createElement("option");
                opt.value = "";
                opt.text = "(SELECT LOAN/SCHEME)";
                obj.appendChild(opt);
                if (memberno.trim().length == 0) {
                    return;
                }
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetMemberBalancesSummary") %>",
                    data: "{'SearchBy' : 'memberno','SearchValue' : '" + memberno + "','EmpCode' : '" + $("#cboEmployer").val() + "','IncludeNegativeLoans' : 'Y'}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var balance = response.MemberBals;
                        var mem_details = response.MemberDetails;
                        if (NoteType.toLowerCase().trim() == "dr".toLowerCase().trim()) {
                            drmember = mem_details;
                        } else {
                            crmember = mem_details;
                        }
                        EmpCode = mem_details.EmployerCode;
                        PayrollNo = mem_details.PayrollNo;
                        SalaryAccount = mem_details.SalaryAccount;

                        $.each(balance, function (index, bal) {
                            opt = document.createElement("option");
                            if (bal.BalType.toLowerCase() != "F".toLowerCase()) {
                                opt.value = bal.BalType + "^" + bal.BalName + "^" + bal.BalCode + "^" + bal.BalAmount;
                                opt.text = bal.BalName + "(" + bal.BalCode + ") Bal=" + bal.BalAmount;
                                obj.appendChild(opt);
                            }
                        });

                        var tbl = "<table><tr><td>EmpCode</td><td>PayrollNo</td><td>MemberNo</td><td>Names</td><td>Details</td></tr>"
                        tbl += "<tr><td>" + mem_details.EmployerCode + "</td><td>" + mem_details.PayrollNo + "</td><td>" + mem_details.MemberNo + "</td><td>" + mem_details.FullNames + "</td><td><a href='" + global_site_root + "/Bank/BankSystem/MembersMasterFile?EditMode=true&EmpCode=" + mem_details.EmployerCode + "&PayrollNo=" + mem_details.PayrollNo + "'>Details</a></td></tr>"
                        $(memdiv).html(tbl);

                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }

                });
            }
            function LoadFinancialPeriods() {
                var dbname = $("#cboYear").val();
                if (dbname == null) { return; }


                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetAllBOSAFinancialMonths") %>",
                    data: JSON.stringify({ 'DBName': $("#cboYear").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var fmonths = response;
                        var objPeriod = document.getElementById("cboPeriod");
                        $("#cboPeriod").empty();
                        $.each(fmonths, function (index, fmonth) {
                            var optn = "<option value='" + fmonth.MonthID + "'>" + fmonth.MonthName + "</option>";
                            $("#cboPeriod").append(optn);
                            if (fmonth.Status == "OPENED") {
                                objPeriod.selectedIndex = index
                            }

                        });
                        DispTransactionsListSummary();
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            }
            function setCookie(c_name, value, expiredays) {
                var exdate = new Date();
                exdate.setDate(exdate.getDate() + expiredays);
                document.

                    e = c_name + "=" + escape(value) +
                ((expiredays == null) ? "" : ";expires=" + exdate.toUTCString());
            }
            function getCookie(c_name) {
                if (document.cookie.length > 0) {
                    c_start = document.cookie.indexOf(c_name + "=");
                    if (c_start != -1) {
                        c_start = c_start + c_name.length + 1;
                        c_end = document.cookie.indexOf(";", c_start);
                        if (c_end == -1) c_end = document.cookie.length;
                        return unescape(document.cookie.substring(c_start, c_end));
                    }
                }
                return "";
            }

            //$(function () {
            //    $("#tabs").tabs();
            //});
            $(function () {
                $("#accordion").accordion();
            });
            $('#tabs').on('tabsactivate', function (event, ui) {
                var newIndex = ui.newTab.index();
                if (newIndex == 1) {
                    DispTransactionsListSummary();
                }
            });

            $("#btnAddToList").on('click', function () {
                var drtype = null;
                var mpa_dr_refCode = null;
                var dr_acc_name = null;
                var dr_mem_names = "";
                var dr_memno = "";

                var crtype = null;
                var mpa_cr_refCode = null;
                var cr_acc_name = null;
                var cr_mem_names = "";
                var cr_memno = "";

                //DR Validation
                var selected_dr_type_index = document.getElementById("cboSelectDebitType").selectedIndex;
                if (selected_dr_type_index == 0) {
                    alert("Select Dr Type");
                    $("#cboSelectDebitType").focus();
                    return;
                }
                else if (selected_dr_type_index == 1) { //Non Member trans
                    if (($("#divdebitaccountname").html().trim()) == "") {
                        alert("Invalid Dr A/C");
                        return;
                    }
                    drtype = "O";
                    mpa_dr_refCode = $("#debitaccountno").val();
                    dr_acc_name = $("#divdebitaccountname").html();
                } else if (selected_dr_type_index == 2) { //Member Trans
                    if (drmember == null) {
                        alert("Invalid Dr Member Details");
                        $("#debitmemberno").focus();
                        return;
                    }
                    if (document.getElementById("debitmpaitems").selectedIndex == 0) {
                        alert("Select DR MPA item");
                        return;
                    }
                    dr_mem_names = drmember.FullNames;
                    dr_memno = drmember.MemberNo;
                    var selected_dr_item = $("#debitmpaitems").val();
                    selected_dr_item = selected_dr_item.split("^");
                    drtype = selected_dr_item[0];
                    mpa_dr_refCode = selected_dr_item[2];
                    dr_acc_name = selected_dr_item[1];

                } else {
                    alert("Select Dr Type");
                    return;
                }


                //CR Validation
                var selected_cr_type_index = document.getElementById("cboSelectCreditType").selectedIndex;
                if (selected_cr_type_index == 0) {
                    alert("Select Cr Type");
                    $("#cboSelectCreditType").focus();
                    return;
                }
                else if (selected_cr_type_index == 1) { //Non Member trans
                    if (($("#divcreditaccountname").html().trim()) == "") {
                        alert("Invalid Cr A/C");
                        return;
                    }
                    crtype = "O";
                    mpa_cr_refCode = $("#creditaccountno").val();
                    cr_acc_name = $("#divcreditaccountname").html();
                } else if (selected_cr_type_index == 2) { //Member Trans
                    if (crmember == null) {
                        alert("Invalid Cr Member Details");
                        $("#creditmemberno").focus();
                        return;
                    }
                    if (document.getElementById("creditmpaitems").selectedIndex == 0) {
                        alert("Select CR MPA item");
                        return;
                    }
                    cr_mem_names = crmember.FullNames;
                    cr_memno = crmember.MemberNo;
                    var selected_cr_item = $("#creditmpaitems").val();
                    selected_cr_item = selected_cr_item.split("^");
                    crtype = selected_cr_item[0];
                    mpa_cr_refCode = selected_cr_item[2];
                    cr_acc_name = selected_cr_item[1];
                } else {
                    alert("Select Cr Type");
                    return;
                }


                //Other Validations

                if (!isNumber($("#txtAmount").val())) {
                    alert("Invalid Amount");
                    return;
                }
                var amt = $("#txtAmount").val();
                if (+amt <= 0) {
                    alert("Invalid Amount");
                    return;
                }
                if (($("#txtDescription").val().trim()) == "") {
                    alert("Enter description");
                    return;
                }
                if (!IsValidDate($("#txtDate").val())) {
                    alert("Invalid Date");
                    return;
                }
                var tbody = document.getElementById('bdDRCRItems');
                var tableRows = tbody.getElementsByTagName('tr');
                var rowCount = tableRows.length + 1;

                var lineitem = "<tr>";
                lineitem += "<td><input type='checkbox' name='chkRow[]'/>" + " " + rowCount + "</td>";
                lineitem += "<td>" + drtype + "</td>";
                lineitem += "<td>" + mpa_dr_refCode + "</td>";
                lineitem += "<td>" + dr_acc_name + "</td>";
                lineitem += "<td>" + dr_memno + "</td>";
                lineitem += "<td>" + dr_mem_names + "</td>";
                lineitem += "<td>" + crtype + "</td>";
                lineitem += "<td>" + mpa_cr_refCode + "</td>";
                lineitem += "<td>" + cr_acc_name + "</td>";
                lineitem += "<td>" + cr_memno + "</td>";
                lineitem += "<td>" + cr_mem_names + "</td>";
                lineitem += "<td>" + $("#txtDescription").val().trim() + "</td>";
                lineitem += "<td>" + $("#txtDate").val() + "</td>";
                lineitem += "<td>" + $("#txtAmount").val() + "</td>";

                lineitem += "</tr>";

                $("#bdDRCRItems").append(lineitem);

                PrepareNextEntry();

            });



            $("#btnDeleteNote").click(function () {

                xDialogConfirm("Delete selected rows?", "Confirm Delete").then(function () {
                    try {
                        var table = document.getElementById('tblDRCRDetails');
                        var rowCount = table.rows.length;

                        for (var i = 0; i < rowCount; i++) {
                            var row = table.rows[i];
                            var chkbox = row.cells[0].childNodes[0];
                            if (null != chkbox && true == chkbox.checked) {
                                table.deleteRow(i);
                                rowCount--;
                                i--;
                            }
                            calcrownumbers();
                        }
                    } catch (err) {
                        alert(err);
                    }
                });
            });
            function calcrownumbers() {
                var table = document.getElementById('tblDRCRDetails');
                var rowCount = table.rows.length;

                for (var i = 0; i < rowCount; i++) {
                    table.rows[i].cells[0].childNodes[1] = i;
                }
            }
            $("#btnSaveDRCR").click(function () {
                xDialogConfirm("Save Document?", "Confirm").then(function () {
                    xDialogGetUserCredetials().then(function (data) {
                        SaveDRCR(data);
                    });
                });
            });

            function SaveDRCR(data) {
                var PostEntries = new Array();
                var tbody = document.getElementById('bdDRCRItems');
                var tableRows = tbody.getElementsByTagName('tr');
                var rowCount = tableRows.length;
                var Entries = 0;
                var TotalAmount = 0;
                var UserName = "";
                var Password = "";

                UserName = data.UserName;
                Password = data.UserPass;

                var pwdslt = getRandomInt(1000, 30000);
                pwdslt = pwdslt.toString();
                var pwd = CryptoJS.MD5(Password).toString();
                pwd = pwd + pwdslt;
                var sltpwd = CryptoJS.MD5(pwd).toString();




                for (var x = 0; x < rowCount; x++) {
                    var PostEntry = {};
                    var lineamount = 0;
                    var myrow = tbody.getElementsByTagName("tr")[x];

                    PostEntry.RefID = x;
                    PostEntry.BranchCode = getCookie("BranchCode");
                    PostEntry.ClassCode = "BOSA";
                    PostEntry.PeriodCode = $("#cboPeriod").val();
                    PostEntry.DateIn = "";
                    PostEntry.Amount = myrow.getElementsByTagName("td")[13].innerHTML;
                    PostEntry.DocumentType = "DrCrNote";
                    PostEntry.DocumentNo = "";
                    PostEntry.DocumentDate = $("#txtDate").val();
                    PostEntry.DrTransType = myrow.getElementsByTagName("td")[1].innerHTML;
                    PostEntry.CrTransType = myrow.getElementsByTagName("td")[6].innerHTML;
                    PostEntry.DrAccount = myrow.getElementsByTagName("td")[2].innerHTML;
                    PostEntry.CrAccount = myrow.getElementsByTagName("td")[7].innerHTML;
                    PostEntry.DrSchemeCode = myrow.getElementsByTagName("td")[2].innerHTML;
                    PostEntry.CrSchemeCode = myrow.getElementsByTagName("td")[7].innerHTML;
                    PostEntry.DrLoanTypeCode = myrow.getElementsByTagName("td")[2].innerHTML;
                    PostEntry.CrLoanTypeCode = myrow.getElementsByTagName("td")[7].innerHTML;
                    PostEntry.DrLoanSerialNumber = myrow.getElementsByTagName("td")[2].innerHTML;
                    PostEntry.CrLoanSerialNumber = myrow.getElementsByTagName("td")[7].innerHTML;
                    PostEntry.DrEmpCode = "";
                    PostEntry.DrPayrollNo = myrow.getElementsByTagName("td")[4].innerHTML;
                    PostEntry.CrEmpCode = "";
                    PostEntry.CrPayrollNo = myrow.getElementsByTagName("td")[9].innerHTML;
                    PostEntry.Description = myrow.getElementsByTagName("td")[11].innerHTML;
                    PostEntry.AppraisalUser = UserName;
                    PostEntry.ApprovalUser = UserName;
                    PostEntry.PostUser = "";
                    PostEntry.AppraisalDate = "";
                    PostEntry.ApprovalDate = "";
                    PostEntry.PostDate = "";
                    PostEntry.Status = "Approved";
                    PostEntry.Posted = "N";
                    PostEntry.ChequeNo = "";
                    PostEntry.UserDocNo = "";

                    TotalAmount = TotalAmount + +PostEntry.Amount;
                    PostEntries[Entries] = PostEntry;

                    Entries++;

                }
                if (Entries == 0) {
                    alert("Nothing to save");
                    return;
                }
                var outData = {
                    'UserID': UserName,
                    'Password': sltpwd,
                    'Salt': pwdslt,
                    'DBName': $("#cboYear").val(),
                    'PeriodCode': $("#cboPeriod").val(),
                    'PostEntries': PostEntries
                }

                outData = JSON.stringify(outData);

                var url = "<%: Url.Content("~/api/BankSystemApi/SaveDrCr") %>";

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: url,
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        //alert("Document Saved successfully");
                        alert(response.toString());
                        ClearAll();
                        //DisableDataEntry(); dont disbale. allow user to continue coz already autheticated.
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            }



            //$("#bdDRCRItems > tbody").html("");
            //$("#bdDRCRItems").find("tr:gt(0)").remove();
            $("#btnNewDrCr").click(function () {
                ConfirmNewDoc();
            });
            $("#btnCancel").click(function () {
                xDialogConfirm("Cancel Current Operation").then(function () {
                    ClearAll();
                    DisableDataEntry();
                });
            });
            function ConfirmNewDoc() {
                xDialogConfirm("Start New Dr/Cr").then(function () {
                    xDialogGetUserCredetials().then(function (data) {
                        var UserName = data.UserName;
                        var Password = data.UserPass;
                        var pwdslt = getRandomInt(1000, 30000);
                        pwdslt = pwdslt.toString();
                        var pwd = CryptoJS.MD5(Password).toString();
                        pwd = pwd + pwdslt;
                        var sltpwd = CryptoJS.MD5(pwd).toString();

                        var outData = {
                            'UserID': UserName,
                            'Password': sltpwd,
                            'Salt': pwdslt,
                            'Privilege': "CreateDrCrNotes"
                        }
                        outData = JSON.stringify(outData);
                        var url = "<%: Url.Content("~/api/BankSystemApi/ValidateWebUserPrivilege") %>";
                        var csrfToken = $("input[name='__RequestVerificationToken']").val();
                        $.ajax({
                            headers: { __RequestVerificationToken: csrfToken },
                            type: "POST",
                            url: url,
                            data: outData,
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            success: function (response) {
                                ClearAll();
                                EnableDataEntry();
                            },
                            error: function (xhr, status, error) {
                                var errorMessage = xhr.status + ': ' + xhr.responseText;
                                alert('Error - ' + errorMessage);
                            }
                        });
                    });
                });
            }

            function ClearAll() {
                $("#tblDRCRDetails > tbody:last").children().remove();
                document.getElementById("cboSelectCreditType").selectedIndex = 0;
                document.getElementById("cboSelectDebitType").selectedIndex = 0;
                $("#cboSelectCreditType").trigger('change');
                $("#cboSelectDebitType").trigger('change');
                $("#txtAmount").val("0");
                $("#txtDescription").val("");
                $("#txtDate").val("");
                $("#cboSelectDebitType").focus();
            }
            function EnableDataEntry() {
                $("#cboYear").prop("disabled", true);
                $("#cboPeriod").prop("disabled", true);
                $("#txtDate").prop("disabled", false);
                $("#cboSelectCreditType").prop("disabled", false);
                $("#cboSelectDebitType").prop("disabled", false);



                $("#txtDescription").prop("disabled", false);
                $("#txtAmount").prop("disabled", false);
                $("#btnSaveDRCR").prop("disabled", false);

            }
            function DisableDataEntry() {
                $("#cboYear").prop("disabled", false);
                $("#cboPeriod").prop("disabled", false);
                $("#txtDate").prop("disabled", true);
                $("#cboSelectCreditType").prop("disabled", true);
                $("#cboSelectDebitType").prop("disabled", true);

                $("#debitmemberno").prop("disabled", true);
                $("#debitmpaitems").prop("disabled", true);

                $("#creditmemberno").prop("disabled", true);
                $("#creditmpaitems").prop("disabled", true);

                $("#btnSelectDrAcc").prop("disabled", true);
                $("#btnSelectCrAcc").prop("disabled", true);

                $("#txtDescription").prop("disabled", true);
                $("#txtAmount").prop("disabled", true);
                $("#btnSaveDRCR").prop("disabled", true);
            }
            function PrepareNextEntry() {
                $("#txtAmount").val("0");
                $("#txtDescription").val("");
                document.getElementById("cboSelectCreditType").selectedIndex = 0;
                document.getElementById("cboSelectDebitType").selectedIndex = 0;
                $("#cboSelectCreditType").trigger('change');
                $("#cboSelectDebitType").trigger('change');

            }



            function DispTransactionsListSummary() {
                $("#tblTransListSummary > tbody:last").children().remove();
                $("#tblTransListDetails > tbody:last").children().remove();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetGeneralTransactionsSummary") %>",
                    data: "{'DBName' : '" + $("#cboYear").val() + "','PeriodCode' : '" + $("#cboPeriod").val() + "','DocumentType' : 'DrCrNote','PostedStatus' : '" + $("#cboFilterPostedStatus").val() + "','BranchCode' : '" + $("#cboFilterBranches").val() + "'}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var row_datas = response;

                        $.each(row_datas, function (index, row_data) {
                            var tbl_row = "<tr>";
                            tbl_row += "<td id='tdDocno[]'><input type='checkbox' id=chk1[]/>" + row_data.DocumentNo + "</td>";
                            tbl_row += "<td>" + row_data.TransCount + "</td>";
                            tbl_row += "<td>" + row_data.DateIn + "</td>";
                            tbl_row += "<td>" + row_data.AppraisalUser + "</td>";
                            tbl_row += "<td>" + row_data.Amount + "</td>";
                            tbl_row += "<td>" + row_data.Status + "</td>";
                            tbl_row += "<td>" + row_data.BranchCode + "</td>";
                            tbl_row += "<td>" + row_data.BranchName + "</td>";
                            tbl_row += "<td>" + row_data.PostUser + "</td>";
                            tbl_row += "<td>" + row_data.PostDate + "</td>";
                            tbl_row += "</tr>";
                            $("#tblTransListSummary").append(tbl_row);
                        });
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }

                });


            }

            function DispTransactionsListDetails(DocNo) {
                $("#tblTransListDetails > tbody:last").children().remove();
                $("#pDocDetails").html("Document No : " + DocNo + " Details");
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetGeneralTransactionsDetails") %>",
                    data: "{'DBName' : '" + $("#cboYear").val() + "','PeriodCode' : '" + $("#cboPeriod").val() + "','DocumentType' : 'DrCrNote','DocumentNo' : '" + DocNo + "'}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var row_datas = response;

                        $.each(row_datas, function (index, row_data) {
                            var tbl_row = "<tr>";
                            tbl_row += "<td><input type='checkbox' id=chkDetails[]/>" + row_data.RefID + "</td>";
                            tbl_row += "<td>" + row_data.DrTransType + "</td>";
                            tbl_row += "<td>" + row_data.DrAccount + "</td>";
                            tbl_row += "<td>" + row_data.DrAccName + "</td>";
                            tbl_row += "<td>" + row_data.DrMemberNo + "</td>";
                            tbl_row += "<td>" + row_data.DrMemberNames + "</td>";

                            tbl_row += "<td>" + row_data.CrTransType + "</td>";
                            tbl_row += "<td>" + row_data.CrAccount + "</td>";
                            tbl_row += "<td>" + row_data.CrAccName + "</td>";
                            tbl_row += "<td>" + row_data.CrMemberNo + "</td>";
                            tbl_row += "<td>" + row_data.CrMemberNames + "</td>";

                            tbl_row += "<td>" + row_data.Description + "</td>";
                            tbl_row += "<td>" + row_data.DocumentDate + "</td>";
                            tbl_row += "<td>" + row_data.Amount + "</td>";
                            tbl_row += "</tr>";
                            $("#tblTransListDetails").append(tbl_row);
                        });
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }

                });
            }

            function PostTransactions(data) {
                var UserName = data.UserName;
                var Password = data.UserPass;
                var csrfToken = $("input[name='__RequestVerificationToken']").val();

                var pwdslt = getRandomInt(1000, 30000);
                pwdslt = pwdslt.toString();
                var pwd = CryptoJS.MD5(Password).toString();
                pwd = pwd + pwdslt;
                var sltpwd = CryptoJS.MD5(pwd).toString();

                var table = document.getElementById('tblTransListSummary');
                var rowCount = table.rows.length;
                if (rowCount == 0) { alert("Nothing to post"); return; }

                for (var i = 0; i < rowCount; i++) {
                    var row = table.rows[i];
                    var chkbox = row.cells[0].childNodes[0];
                    if (null != chkbox && true == chkbox.checked) {
                        var DocNo = row.cells[0].textContent;
                        var outData = {
                            'DBName': $("#cboYear").val(),
                            'PeriodCode': $("#cboPeriod").val(),
                            'DocumentType': 'DrCrNote',
                            'DocumentNo': DocNo,
                            'Password': sltpwd,
                            'Salt': pwdslt
                        }
                        outData = JSON.stringify(outData);
                        $.ajax({
                            headers: { __RequestVerificationToken: csrfToken },
                            type: "POST",
                            url: "<%: Url.Content("~/api/BankSystemApi/PostGeneralTransactions") %>",
                            data: outData,
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            success: function (response) {
                                var docno = response;
                            },
                            error: function (xhr, status, error) {
                                var errorMessage = xhr.status + ': ' + xhr.responseText;
                                alert('Error - ' + errorMessage);
                            }

                        });

                    }
                }
            }
        });
    </script>
</asp:Content>
<asp:Content ID="Content6" ContentPlaceHolderID="FeaturedContent" runat="server">
    <div id="tabs">
        <div class="my-4 mx-auto d-flex justify-content-center col-12 col-md-8 ">
            <div id="customTabs" class="custom-tabs  position-relative">
      <ul class="custom-tabs-nav mb-0 d-flex list-unstyled">
        <li><a href="#tab1" data-tab="tab1" class="custom-tab-label active">Capture DR/CR Notes</a></li>
        <li><a href="#tab2" data-tab="tab2" class="custom-tab-label">DR/CR Notes Listing</a></li>
      </ul>
      <span class="custom-glider position-absolute d-flex" style="transform: translateX(0);"></span>
      </div>
      </div>
    
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <div class="card bg-white">
        <h3 class="p-3 fs-5">Debit And Credit Notes</h3>
        <hr class="m-0 mb-2"/>
    <div class="row mb-3 p-3">
        <div class="col-md-6">
            <label for="cboYear" class="form-label">Financial Year:</label>
            <select id="cboYear" class="form-select"><option value="selectyear">SELECT YEAR</option></select>
        </div>
        <div class="col-md-6">
            <label for="cboPeriod" class="form-label"> DR/CR Period:</label>
            <select id="cboPeriod" class="form-select"><option value="selectperiod" selected>(SELECT PERIOD)</option></select>
        </div>
    </div>
        <hr />
    
    
    <form name="frmMain" id="frmMain">
        <%= Html.AntiForgeryToken() %>
        
        <div id="tab1" class="tab-content-panel active p-3">
        <div>
            <div class="row mb-3">
                <!--Debit Details-->
                <div class="col-md-6">
                    <h5 class="fs-6 text-decoration-underline">DEBIT DETAILS</h5>
                    <div class="col-md-8">
                        <label for="txtType" class="form-label">Type:</label>
                        <select id="cboSelectDebitType" class="form-select">
                                            <option value="selectdebittype" selected>Select Type</option>
                                            <option value="trxnon">NON-MEMBER</option>
                                            <option value="trxmem">MEMBER</option>
                                        </select>
                    </div>
                    <div class="col-md-8">
                        <label for="txtDRMemberNo" class="form-label">DR Member No:</label>
                        <input type="text" id="debitmemberno" class="form-control"/>
                    </div>
                    <div class="col-md-8">
                        <label for="txtMemberDetails" class="form-label">Member Details:</label>
                        <div id="debitmemberdetails"></div>
                    </div>
                    <div class="col-md-8">
                        <input type="button" value="DR A/C?" id="btnSelectDrAcc" class="btn btn-secondary mt-2 mb-2 form-control"/>
                        <input type="text" id="debitaccountno" class="form-control" />
                    </div>
                    <div class="col-md-8">
                        <label for="txtDRA/CName" class="form-label">DR A/C Name:</label>
                        <div id="divdebitaccountname"></div>
                    </div>
                    <div class="col-md-8">
                        <label for="txtSheme/Loan" class="form-label">Scheme/Loan:</label>
                        <select id="debitmpaitems" class="form-select">
                            <option value="selectdebitmpaitems" selected>(SELECT LOAN/SCHEME)</option>
                        </select>
                    </div>
                </div>
                <!--Credit Details-->
                <div class="col-md-6">
                    <h5 class="fs-6 text-decoration-underline">CREDIT DETAILS</h5>
                    <div class="col-md-8">
                        <label for="txtType" class="form-label">Type:</label>
                        <select id="cboSelectCreditType" class="form-select">
                            <option value="selectdebittype" selected>Select Type</option>
                            <option value="trxnon">NON-MEMBER</option>
                            <option value="trxmem">MEMBER</option>
                        </select>
                    </div>
                    <div class="col-md-8">
                        <label for="txtCRMemberNo" class="form-label">CR Member No:</label>
                        <input type="text" id="creditmemberno" class="form-control" />
                    </div>
                    <div class="col-md-8">
                        <label for="txtMemberDetails" class="form-label">Member Details:</label>
                        <div id="creditmemberdetails"></div>
                    </div>
                    <div class="col-md-8">
                        <input type="button" value="CR A/C?" id="btnSelectCrAcc" class="btn btn-secondary mt-2 mb-2 form-control"/>
                        <input type="text" id="creditaccountno" class="form-control" />
                    </div>
                    <div class="col-md-8">
                        <label for="txtCRA/CName" class="form-label">CR A/C Name:</label>
                        <div id="divcreditaccountname"></div>
                    </div>
                    <div class="col-md-8">
                        <label for="txtSchema/Loan" class="form-label">Scheme/Loan:</label>
                        <select id="creditmpaitems" class="form-select">
                            <option value="selectcreditmpaitems" selected>(SELECT LOAN/SCHEME)</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="row mb-3">
                <div class="col-md-12">
                    Transaction Details
                </div>
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="txtDocDate" class="form-label">Doc.Date</label>
                        <input type="text" id="txtDate" class="form-control"/>
                    </div>
                    <div class="col-md-6">
                        <label for="txtDescription" class="form-label">Description</label>
                        <input type="text" id="txtDescription" class="form-control"/>
                    </div>
                </div>
                <div class="row md-3">
                    <div class="col-md-6">
                        <label for="txtAmount" class="form-label">Amount</label>
                        <input type="text" id="txtAmount" class="form-control" />
                    </div>
                    <div class="col-md-6">
                        <label for="txtAddToList" class="form-label" style="visibility: hidden;">Add To List</label>
                        <input type="button" value="Add to List" id="btnAddToList" class="btn btn-secondary form-control" />
                    </div>
                </div>
            </div>
          
        </div>
            <hr />
            Dr/Cr Items
            <hr />
            <div id="divDRCrItemList" style="overflow:auto;width:auto;">
            <table id="tblDRCRDetails" class="table table-bordered text-nowrap" style="width:100%">
                    <thead>
                        <tr>
                        <th>Row_No</th>
                        <th>DR_Type</th>
                        <th>DR_Acc</th>
                        <th>DR_Acc_Name</th>
                        <th>DR_MemberNo</th>
                        <th>DR_Member_Names</th>
                        <th>CR_Type</th>
                        <th>CR_Acc</th>
                        <th>CR_Acc_Name</th>
                        <th>CR_Member_No</th>
                        <th>CR_Member_Names</th>
                        <th>Description</th>
                        <th>Date</th>
                        <th>Amount</th>
                        </tr>
                    </thead>
                    <tbody id='bdDRCRItems'>
                    </tbody>
            </table><hr/>

            </div>
            <hr />      
            <div>
                 <input type="button" value="New DR/CR" id="btnNewDrCr" class="btn btn-secondary me-2" />
                 <input type="button" value="Delete Note" id="btnDeleteNote" class="btn btn-secondary me-2" />
                 <input type="button" value="Cancel" id="btnCancel" class="btn btn-secondary me-2" />
                <input type="button" value="Save List" id="btnSaveDRCR" class="btn btn-secondary"/>
                </div>
        </div>
        <div id="tab2" class="tab-content-panel p-3">
            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="txtPosted" class="form-label">Posted</label>
                    <select id="cboFilterPostedStatus" class="form-select">
                        <option value="UNPOSTED" selected>UNPOSTED</option>
                        <option value="POSTED" >POSTED</option>
                        <option value="" >ALL</option>
                        </select>
                </div>
                <div class="col-md-6">
                    <label for="txtBranch" class="form-label">Branch</label>
                    <select id="cboFilterBranches" class="form-select">
                        <option value="" selected>(ALL)</option>
                        </select>
                </div>
            </div>
             <div id="divTransListSummary" style="height:200px;overflow:auto;width:auto;">
                <table id='tblTransListSummary' class="table table-bordered text-nowrap"  style="width:100%">
                        <thead>
                            <tr>
                            <th>Document No</th>
                            <th>Transactions</th>
                            <th>Doc Date</th>
                            <th>Appraisal User</th>
                            <th>Amount</th>
                            <th>Status</th>
                            <th>Branch</th>
                            <th>Branch Name</th>
                            <th>Post User</th>
                            <th>Post Date</th>
                                
                            </tr>
                        </thead>
                        <tbody id='bdTransListSummary'>
                        </tbody>
                </table><hr/>
            </div>
            <div>
                <input type="button" id="btnRefresh" value="Refresh List" class="btn btn-secondary me-2 mt-2"/>
                <input type="button" id="btnPost" value="Post Selected Documents" class="btn btn-secondary me-2 mt-2" />
                <input type="button" id="btnDeleteDoc" value="Delete Selected Documents" class="btn btn-secondary mt-2"/>
            </div>
            <hr />
            <p id="pDocDetails">Document Details</p>
            <hr />
            <div id="divTransListDetails" style="height:150px;overflow:auto;width:auto;">
                <table id='tblTransListDetails' class="table table-bordered text-nowrap"  style="width:100%">
                        <thead>
                            <tr>
                            <th>Ref_No</th>
                            <th>DR_Type</th>
                            <th>DR_Acc</th>
                            <th>DR_Acc_Name</th>
                            <th>DR_MemberNo</th>
                            <th>DR_Member_Names</th>
                            <th>CR_Type</th>
                            <th>CR_Acc</th>
                            <th>CR_Acc_Name</th>
                            <th>CR_Member_No</th>
                            <th>CR_Member_Names</th>
                            <th>Description</th>
                            <th>Date</th>
                            <th>Amount</th>
                            </tr>
                        </thead>
                        <tbody id='bddivTransListDetails'>
                        </tbody>
                </table><hr/>
                
            </div>
            <div>
                <input type="button" id="btnDeleteSelected" value="Delete Selected Line items" class="btn btn-secondary mt-2"/>
            </div>
            <hr />  
        </div>
    </form>
</div>
</div>
</asp:Content>


