﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Bank/Views/Shared/StaffMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Loans Listing
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css"></style>
    <script type="text/javascript"  >
        
        $(document).ready(function () {
            ChangeInputsDisplayStatus();
            ShowSearchParams();

            $("#btnProcess").hide();


            $("#cboEmployer").empty();
            $("#cboBranch").empty();
            $("#cboLoan").empty();
            $("#cboYear").empty();

            $("#cboLoan").on("change", function () {
                LoadLoansListing();
            });
            $("#cboYear").on("change", function () {
                LoadLoansListing();
            });
            $("#cboPeriod").on("change", function () {
                LoadLoansListing();
            });
            $("#cboBranch").on("change", function () {
                LoadLoansListing();
            });
            $("#cboHRStatus").on("change", function () {
                ChangeInputsDisplayStatus();
                LoadLoansListing();
            });
            $("#cboLoanStatus").on("change", function () {
                ChangeInputsDisplayStatus();
                LoadLoansListing();
            });
            $("#cboSearchBy").on("change", function () {
                ShowSearchParams();
            });
            $("#btnPrint").on("click", function () {
                PrintList('divLoansList');
            });
            $("#btnProcess").on("click", function () {
                ProcessLoans();
            });
            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: '<%: Url.Content("~/api/BankSystemApi/GetLoansListingConfig") %>',
                data: "{}",
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    var employers = response.EmployerList;
                    var obj = document.getElementById("cboEmployer");
                    var opt = document.createElement("option");
                    opt.value = "";
                    opt.text = "(ANY)";
                    obj.appendChild(opt);
                    $.each(employers, function (index, empl) {
                        var opt = document.createElement("option");
                        opt.value = empl.EmployerCode;
                        opt.text = empl.EmployerName;
                        obj.appendChild(opt);
                    });
                    var branches = response.BranchesList;
                    var obj = document.getElementById("cboBranch");
                    var opt = document.createElement("option");
                    opt.value = "";
                    opt.text = "(ANY)";
                    obj.appendChild(opt);
                    $.each(branches, function (index, branch) {
                        var opt = document.createElement("option");
                        opt.value = branch.BranchCode;
                        opt.text = branch.BranchName;
                        obj.appendChild(opt);
                    });
                    var loans = response.LoansList;
                    var obj = document.getElementById("cboLoan");
                    var opt = document.createElement("option");
                    opt.value = "";
                    opt.text = "(ANY)";
                    obj.appendChild(opt);
                    $.each(loans, function (index, loan) {
                        var opt = document.createElement("option");
                        opt.value = loan.LoanTypeCode;
                        opt.text = loan.LoanTypeName;
                        obj.appendChild(opt);
                    });
                    var years = response.YearsList;
                    var obj = document.getElementById("cboYear");
                    $.each(years, function (index, yrs) {
                        var opt = document.createElement("option");
                        opt.value = yrs.DBName;
                        opt.text = yrs.UserDefinedYearName;
                        opt.selected = true;
                        obj.appendChild(opt);
                    });
                    $("#cboYear").get(0).selectedIndex = 0;
                    LoadFinancialPeriods();

                },
                error: function (xhr, status, error) {
                    var errorMessage = xhr.status + ': ' + xhr.responseText;
                    alert('Error - ' + errorMessage);
                }

            });
            

            function ProcessLoans() {
                if ($("#cboLoanStatus").val() == "approvedloans") {
                    ProcessLoanPostings();
                } else {
                    alert("Not implemented");
                }
            }

            function ProcessLoanPostings(UserPass) {

                try {
                    var table = document.getElementById('bdLoansList');
                    if (bdLoansList == null) { alert("nothing to approve"); }
                    var rowCount = table.rows.length;
                    for (var i = 0; i < rowCount; i++) {
                        var row = table.rows[i];
                        var chkbox = row.cells[0].childNodes[0];
                        if (null != chkbox && true == chkbox.checked) {
                            var loanserial = String(row.cells[1].childNodes[0].innerHTML);
                            var memberno = String(row.cells[4].innerHTML);
                            var loantopost = {
                                'LoanSerialNumber': loanserial,
                                'MemberNo': memberno,
                                'DBName': $("#cboYear").val()
                            }
                            PostLoan(loantopost);

                            //table.deleteRow(i);
                            //rowCount--;
                            //i--;
                        }
                    }
                } catch (err) {
                    alert(err);
                }
            }

            function PostLoan(loantopost) {
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: '<%: Url.Content("~/api/BankSystemApi/PostLoan") %>',
                    data: JSON.stringify(loantopost),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var table = document.getElementById('bdLoansList');
                        var rowCount = table.rows.length;
                        for (var i = 0; i < rowCount; i++) {
                            var row = table.rows[i];
                            var chkbox = row.cells[0].childNodes[0];
                            var loanserial = String(row.cells[1].childNodes[0].innerHTML);
                            if (loanserial.toLowerCase() == response.toLowerCase()) {
                                table.deleteRow(i);
                                rowCount--;
                                i--;
                            }
                        }
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }

                });
            }


            function LoadFinancialPeriods() {
                $("#cboPeriod").empty();
                var dbname = $("#cboYear").val();
                if (dbname == null) { return; }

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: '<%: Url.Content("~/api/BankSystemApi/GetAllBOSAFinancialMonths") %>',
                    data: JSON.stringify({ 'DBName': $("#cboYear").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var fmonths = response;
                        var objEnd = document.getElementById("cboPeriod");
                        $.each(fmonths, function (index, fmonth) {
                            var opt = document.createElement("option");
                            opt.value = fmonth.MonthID;
                            opt.text = fmonth.MonthName;
                            objEnd.appendChild(opt);
                            if (fmonth.Status == "OPENED") {
                                objEnd.selectedIndex = index
                            }

                        });
                        LoadLoansListing();
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            }



            function LoadLoansListing() {
                row = 1;
                $("#divLoansList").empty();
                $("#ListingType").html("<b>" + $("#cboLoanStatus option:selected").text() + "</b>");
                $("#btnProcess").hide();
                if ($("#cboPeriod").val() == null) { return; }
                if ($("#cboYear").val() == null) { return; }
                if ($("#cboLoanStatus").val() == null) { return; }
                if ($("#cboPeriod").val() == "") { return; }
                if ($("#cboYear").val() == "") { return; }
                if ($("#cboLoanStatus").val() == "") { return; }
                var Criteria = {
                    "EmpCode": $("#cboEmpCode").val(),
                    "SearchBy": $("#cboSearchBy").val(),
                    "SearchValue": $("#txtSearchValue").val(),
                    "LoanTypeCode": $("#cboLoan").val(),
                    "LoanStatus": $("#cboLoanStatus").val(),
                    "BranchCode": $("#cboBranch").val(),
                    "DBName": $("#cboYear").val(),
                    "LoanPeriod": $("#cboPeriod").val(),
                    "HRApprovedStatus": $("#cboHRStatus").val(),
                    "AppraisalUser": "",
                    "LoanDate": ""
                }
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: '<%: Url.Content("~/api/BankSystemApi/GetLoanListing") %>',
                    data: JSON.stringify(Criteria),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        $('#divLoansList').empty();

                        if ($("#cboLoanStatus").val() == "appraisedloans") {
                            DisplayAppraisedLoans(response);
                        } else if ($("#cboLoanStatus").val() == "approvedloans") {
                            $("#btnProcess").show();
                            DisplayApprovedLoans(response);
                        } else if ($("#cboLoanStatus").val() == "postedloans") {
                            DisplayPostedLoans(response);
                        } else if ($("#cboLoanStatus").val() == "rejectedloans") {
                            DisplayRejectedLoans(response);
                        } else {
                            alert("Unsupported loan status");
                        }
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            }
            
            function DisplayAppraisedLoans(loanlist) {

                var tbl = "<table id='tbLoansList' class='table table-responsive text-nowrap'>";
                tbl += "<thead>";
                tbl += "<tr>";
                tbl += "	<th>Approve</th>";
                tbl += "	<th>Loan Serial No</th>";
                tbl += "	<th>Loan Date</th>";
                tbl += "	<th>Member No</th>";
                tbl += "	<th>EmpCode</th>";
                tbl += "	<th>PayrollNo</th>";
                tbl += "	<th>Names</th>";
                tbl += "	<th>Loan Type</th>";
                tbl += "	<th>Requested Amt</th>";
                tbl += "	<th>Recommended Amt</th>";
                tbl += "	<th>Appraised By</th>";
                tbl += "	<th>HR Approval</th>";
                tbl += "	<th>Approve</th>";
                tbl += "</tr>";
                tbl += "</thead>";
                tbl += "<tbody id='bdLoansList'>";
                $.each(loanlist, function (index, loan) {
                    tbl += "<tr><td><input type='checkbox' class='form-check' name='chkApprove[]'></td><td><a href='" + global_site_root + "/Bank/BankSystem/LoanAppraisalEdit?LoanSerialNumber=" + loan.LoanSerialNumber + "&MemberApplicationNo=&DBName=" + $("#cboYear").val() + "'>" + loan.LoanSerialNumber + "</a></td><td>" + loan.LoanDate + "</td><td>" + loan.MemberNo + "</td><td>" + loan.EmployerCode + "</td><td>" + loan.PayrollNo + "</td><td>" + loan.MemNames + "</td><td>" + loan.LoanTypeName + "</td><td>" + loan.RequestedAmount + "</td><td>" + loan.RecommendedAmount + "</td><td>" + loan.AppraisalUser + "</td><td>" + loan.HRResponse + "</td><td><a href='" + loan.LoanSerialNumber + "' class='approveLink'  >Approve</a></td></tr>"
                });
                tbl += "</tbody></table>";
                $('#divLoansList').html(tbl);
                $('#tbLoansList').dataTable();
            }
            $('body').on('click', '.approveLink', function (e) {
                SaccoApproveLoan(this);
                e.preventDefault();
                return false;
            });
            function SaccoApproveLoan(approvelink) {
                var ApproveLoanSerialNumber = approvelink.getAttribute("href");
                var Criteria = {
                    "LoanSerialNumber": ApproveLoanSerialNumber,
                    "DBName": $("#cboYear").val()
                }
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: '<%: Url.Content("~/api/BankSystemApi/GetLoanDetails") %>',
                    data: JSON.stringify(Criteria),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        ProcessSaccoLoanApproval(response);
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            }


            function ProcessSaccoLoanApproval(LoanToApprove) {
                $('<div id="divApproveLoanDialog"></div>').dialog({
                    modal: true,
                    title: "Approve Loan",
                    height: 600,
                    width: 500,
                    autoOpen: true,
                    show: {
                        effect: "drop",
                        direction: "up",
                        duration: 500
                    },

                    buttons: {
                        'OK': {
                            'text': 'OK',
                            'id': 'btnOK',
                            'click': function () {
                                var approved_amount = $("#txtApprovedAmount").val();
                                var ConfirmMessage = "";
                                if (!isNumber(approved_amount)) {
                                    alert("Invalid Approved Amount");
                                    return;
                                }
                                else if (+approved_amount <= 0) {
                                    alert("Approved Amount should be more than zero");
                                    return;
                                }
                                ConfirmMessage = "Confirm Approval of Request of " + (+approved_amount).formatMoney() + " ?";

                                xDialogConfirm(ConfirmMessage, "Confirm").then(function () {
                                    xDialogMemberCredetials().then(function (data) {
                                        var csrfToken = $("input[name='__RequestVerificationToken']").val();
                                        var Password = data.UserPass;
                                        var pwdslt = getRandomInt(1000, 30000);
                                        pwdslt = pwdslt.toString();
                                        var pwd = CryptoJS.MD5(Password).toString();
                                        pwd = pwd + pwdslt;
                                        var sltpwd = CryptoJS.MD5(pwd).toString();

                                        var outData = {
                                            'DBName': LoanToApprove.DBName,
                                            'MemberNo': LoanToApprove.mLoanAppraisals.MemberNumber,
                                            'LoanSerialNumber': LoanToApprove.LoanSerialNumber,
                                            'Password': sltpwd,
                                            'Salt': pwdslt,
                                            'ApprovedAmount': $("#txtApprovedAmount").val(),
                                            'ApprovedRepaymentPeriod': $("#txtRepaymentPeriod").val(),
                                            'ViolationReason': $("#txtViolationReason").val()
                                        }
                                        outData = JSON.stringify(outData);
                                        $.ajax({
                                            headers: { __RequestVerificationToken: csrfToken },
                                            type: "POST",
                                            url: '<%: Url.Content("~/api/BankSystemApi/ApproveLoan") %>',
                                            data: outData,
                                            contentType: "application/json; charset=utf-8",
                                            dataType: "json",
                                            success: function (response) {
                                                //remove approved row/loan from list
                                                $("#tbLoansList tr").each(function (i) {
                                                    var row = $(this);
                                                    if (row.find('td:eq(1)').text() == LoanToApprove.LoanSerialNumber) {
                                                        $(this).remove();
                                                    }
                                                });
                                                alert("Loan has been successfully approved");
                                                $("#divApproveLoanDialog").dialog("close");

                                            },
                                            error: function (xhr, status, error) {
                                                var errorMessage = xhr.status + ': ' + xhr.responseText;
                                                alert('Error - ' + errorMessage);
                                            }
                                        });
                                    });
                                });
                            }
                        },
                        Cancel: function () {
                            $(this).dialog("close");
                        }
                    },
                    open: function () {
                        var tbl = "<div id='tblApproveLoan' class='row'>";
                        tbl += "";
                        tbl += "<div class='col-md-4'><label ='form-label'>Loan Serial Number:</label><input type='text' class='form-select' id='txtLoanSerialNumber' value='" + LoanToApprove.LoanSerialNumber + "' disabled /></div>";
                        tbl += "<div class='col-md-4'><label ='form-label'>Loanee:</label><input type='text' id='txtLoaneeName' class='form-select' value='" + LoanToApprove.saccoMember.FullNames + "' disabled /></div>";
                        tbl += "<div class='col-md-4'><label ='form-label'>MemberNo:</label><input type='text' id='txtLoaneeMemberNo' class='form-select' value='" + LoanToApprove.saccoMember.MemberNo + "' disabled /></div>";
                        tbl += "<div class='col-md-4'><label ='form-label'>PayrollNo:</label><input type='text' id='txtLoaneePayrollNo' class='form-select' value='" + LoanToApprove.saccoMember.PayrollNo + "' disabled /></div>";
                        tbl += "<div class='col-md-4'><label ='form-label'>Loan Type:</label><input type='text' id='txtLoanType' class='form-select' value='" + LoanToApprove.mLoanType.LoanTypeName + "' disabled /></div>";
                        tbl += "<div class='col-md-4'><label ='form-label'>Requested Amount:</label><input type='text' id='txtRequestedAmount' class='form-select' value='" + (+LoanToApprove.mLoanAppraisals.RequestedAmount).formatMoney() + "' disabled /></div>";
                        tbl += "<div class='col-md-4'><label ='form-label'>Recommended Amount</label><input type='text' id='txtRecommendedAmount' class='form-select' value='" + (+LoanToApprove.mAppraisalReport.RecommendedAmount).formatMoney() + "' disabled /></div>";
                        tbl += "<div class='col-md-4'><label ='form-label'>HR Approved:</label><input type='text' id='txtHRApproved' class='form-select' value='" + LoanToApprove.mLoanAppraisals.HRApproved + "' disabled /></div>";
                        tbl += "<div class='col-md-4'><label ='form-label'>HR Approved Repay:</label><input type='text' id='txtHRRepayAmt' class='form-select' value='" + LoanToApprove.mLoanAppraisals.HRRepayAmt + "' disabled /></div>";
                        tbl += "<div class='col-md-4'><label ='form-label'>Approved Amt:</label><input type='text' id='txtApprovedAmount' class='form-select' value='" + LoanToApprove.mAppraisalReport.RecommendedAmount + "' /></div>";
                        tbl += "<div class='col-md-4'><label ='form-label'>Amt In Words:</label><div id='divApprovedAmountInWords'></div>";
                        tbl += "<div class='col-md-4'><label ='form-label'>Repayment Period:</label><input type='text' id='txtRepaymentPeriod' class='form-select' value='" + LoanToApprove.mAppraisalReport.RepaymentPeriod + "' /></div>";
                        tbl += "<div class='col-md-4'><label ='form-label'>Repayment Amt.:</label><input type='text' id='txtRepaymentAmount' class='form-select' value='" + LoanToApprove.mAppraisalReport.InstallmentAmount + "' disabled /></div>";
                        tbl += "<div class='col-md-4'><label ='form-label'>Violation Reason:</label><textarea id='txtViolationReason'/></textarea></div>";
                        tbl += "</div>";
                        $(this).html(tbl);
                        ShowAmtInWords();
                        $("#txtApprovedAmount").focus;

                    },
                    close: function (event, ui) {
                        $(this).dialog("destroy").remove();
                    }
                });

                $("#txtApprovedAmount").on('change keyup paste mouseup', function () {
                    ShowAmtInWords();
                    CalcRepay();
                });
                $("#txtRepaymentPeriod").on('change keyup paste mouseup', function () {
                    CalcRepay();
                });
                function ShowAmtInWords() {
                    $("#divApprovedAmountInWords").html("");
                    try {
                        $("#divApprovedAmountInWords").html(toWords($("#txtApprovedAmount").val()));
                    } catch (err) {

                    }
                }
                function CalcRepay() {
                    try {
                        var newRepay = $("#txtApprovedAmount").val() / $("#txtRepaymentPeriod").val();
                        $("#txtRepaymentAmount").val((+newRepay).formatMoney());
                    } catch (err) {

                    }
                }

            }


            function DisplayApprovedLoans(loanlist) {

                var tbl = "<table id='tbLoansList' class='table table-bordered' width='100%'>";
                tbl += "<thead>";
                tbl += "<tr>";
                tbl += "	<th><b>Post</b></th>";
                tbl += "	<th><b>Loan Serial No</b></th>";
                tbl += "	<th><b>Loan Date</b></th>";
                tbl += "	<th><b>Approval Date</b></th>";
                tbl += "	<th><b>Member No</b></th>";
                tbl += "	<th><b>EmpCode</b></th>";
                tbl += "	<th><b>PayrollNo</b></th>";
                tbl += "	<th><b>Names</b></th>";
                tbl += "	<th><b>Loan Type</b></th>";
                tbl += "	<th><b>Requested Amt</b></th>";
                tbl += "	<th><b>Recommended Amt</b></th>";
                tbl += "	<th><b>Approved Amount</b></th>";
                tbl += "	<th><b>Approved By</b></th>";
                tbl += "	<th><b>Approval Status</b></th>";
                tbl += "</tr>";
                tbl += "</thead>";
                tbl += "<tbody id='bdLoansList'>";
                $.each(loanlist, function (index, loan) {
                    tbl += "<tr><td><input type='checkbox' name='chkPost[]'></td><td><a href='" + global_site_root + "/Bank/BankSystem/LoanAppraisalEdit?LoanSerialNumber=" + loan.LoanSerialNumber + "&MemberApplicationNo=&DBName=" + $("#cboYear").val() + "&ClassCode=BOSA'>" + loan.LoanSerialNumber + "</a></td><td>" + loan.LoanDate + "</td><td>" + loan.DateOfApproval + "</td><td>" + loan.MemberNo + "</td><td>" + loan.EmployerCode + "</td><td>" + loan.PayrollNo + "</td><td>" + loan.MemNames + "</td><td>" + loan.LoanTypeName + "</td><td>" + loan.RequestedAmount + "</td><td>" + loan.RecommendedAmount + "</td><td>" + loan.ApprovedAmount + "</td><td>" + loan.ApprovalUser + "</td><td>Pending Posting..</td></tr>"
                });
                tbl += "</tbody></table>";
                $('#divLoansList').html(tbl);
                $('#tbLoansList').dataTable();
            }
            function DisplayPostedLoans(loanlist) {
                var tbl = "<table id='tbLoansList' class='table table-bordered' width='100%'>";
                tbl += "<thead>";
                tbl += "<tr>";
                tbl += "	<th><b>Loan Serial No</b></th>";
                tbl += "	<th><b>Date Posted</b></th>";
                tbl += "	<th><b>MemberNo</b></th>";
                tbl += "	<th><b>EmpCode</b></th>";
                tbl += "	<th><b>PayrollNo No</b></th>";
                tbl += "	<th><b>Names</b></th>";
                tbl += "	<th><b>Loan Type</b></th>";
                tbl += "	<th><b>Requested Amt</b></th>";
                tbl += "	<th><b>Posted Amount</b></th>";
                tbl += "	<th><b>Approved By</b></th>";
                tbl += "	<th><b>Posted By</b></th>";
                tbl += "	<th><b>Credit Account</b></th>";
                tbl += "</tr>";
                tbl += "</thead>";
                tbl += "<tbody id='bdLoansList'>";
                $.each(loanlist, function (index, loan) {
                    tbl += "<tr><td><a href='" + global_site_root + "/Bank/BankSystem/LoanAppraisalEdit?LoanSerialNumber=" + loan.LoanSerialNumber + "&MemberApplicationNo=&DBName=" + $("#cboYear").val() + "&ClassCode=BOSA'>" + loan.LoanSerialNumber + "</a></td><td>" + loan.DateOfPosting + "</td><td>" + loan.MemberNo + "</td><td>" + loan.EmployerCode + "</td><td>" + loan.PayrollNo + "</td><td>" + loan.MemNames + "</td><td>" + loan.LoanTypeName + "</td><td>" + loan.RequestedAmount + "</td><td>" + loan.PostedAmount + "</td><td>" + loan.ApproveUser + "</td><td>" + loan.PostUser + "</td><td>" + loan.CreditAccount + "</td></tr>"
                });
                tbl += "</tbody></table>";
                $('#divLoansList').html(tbl);
                $('#tbLoansList').dataTable();
            }
            function DisplayRejectedLoans(loanlist) {
                var tbl = "<table id='tbLoansList' class='table table-bordered' width='100%'>";
                tbl += "<thead>";
                tbl += "<tr>";
                tbl += "	<th><b>Loan Serial No</b></th>";
                tbl += "	<th><b>Loan Date</b></th>";
                tbl += "	<th><b>MemberNo</b></th>";
                tbl += "	<th><b>EmpCode</b></th>";
                tbl += "	<th><b>PayrollNo</b></th>";
                tbl += "	<th><b>Names</b></th>";
                tbl += "	<th><b>Loan Type</b></th>";
                tbl += "	<th><b>Requested Amt</b></th>";
                tbl += "	<th><b>Date Rejected</b></th>";
                tbl += "	<th><b>Reasons</b></th>";
                tbl += "</tr>";
                tbl += "</thead>";
                tbl += "<tbody id='bdLoansList'>";
                $.each(loanlist, function (index, loan) {
                    tbl += "<tr><td><a href='" + global_site_root + "/Bank/BankSystem/LoanAppraisalEdit?LoanSerialNumber=" + loan.LoanSerialNumber + "&MemberApplicationNo=&DBName=" + $("#cboYear").val() + "'>" + loan.LoanSerialNumber + "</a></td><td>" + loan.LoanDate + "</td><td>" + loan.MemberNo + "</td><td>" + loan.EmployerCode + "</td><td>" + loan.PayrollNo + "</td><td>" + loan.MemNames + "</td><td>" + loan.LoanTypeName + "</td><td>" + loan.RequestedAmount + "</td><td>" + loan.DateOfRejection + "</td><td>" + loan.ReasonStatement + "</td></tr>"
                });
                tbl += "</tbody></table>";
                $('#divLoansList').html(tbl);
                $('#tbLoansList').dataTable();
            }
            function setCookie(c_name, value, expiredays) {
                var exdate = new Date();
                exdate.setDate(exdate.getDate() + expiredays);
                document.cookie = c_name + "=" + escape(value) +
                ((expiredays == null) ? "" : ";expires=" + exdate.toUTCString());
            }
            function getCookie(c_name) {
                if (document.cookie.length > 0) {
                    c_start = document.cookie.indexOf(c_name + "=");
                    if (c_start != -1) {
                        c_start = c_start + c_name.length + 1;
                        c_end = document.cookie.indexOf(";", c_start);
                        if (c_end == -1) c_end = document.cookie.length;
                        return unescape(document.cookie.substring(c_start, c_end));
                    }
                }
                return "";
            }

            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion();
            });
            function ShowSearchParams() {
                $('#divSearchDisplay').empty();
                $('#divSearchDisplay').append('Enter ' + $("#cboSearchBy option:selected").text());
            }
            function ChangeInputsDisplayStatus() {
                if ($("#cboLoanStatus").val() == "approvedloans") {
                    $("#btnProcess").prop('value', 'Post Loans');
                } else {
                    $("#btnProcess").prop('value', 'Invalid Operation');
                    $("#btnProcess").hide();
                }

            }

            function PrintList(el) {
                var restorepage = document.body.innerHTML;
                var printcontent = document.getElementById(el).innerHTML;
                //document.body.innerHTML = "<html><body>" + printcontent + "</body></html>";
                document.body.innerHTML = printcontent;
                window.print();
                document.body.innerHTML = restorepage;
            }
        });
    </script>
</asp:Content>
<asp:Content ID="Content6" ContentPlaceHolderID="FeaturedContent" runat="server">
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
<div class="card my-4">
    <h4 class="p-3 fs-5">Loan Listing</h4>
 <hr class='m-0 p-0'/>
    <form id="frmSearch" name="frmSearch" action="#" class="p-3">
        <%= Html.AntiForgeryToken() %>
        <div class="row mb-3">
                <!--row 1-->
                    <div class="col-md-4">
                        <label for="cboYear" class="form-label">Financial Year:</label>
                        <select id="cboYear" class="form-select"><option value="selectyear">SELECT YEAR</option></select>
                    </div>
                    <div class="col-md-4">
                        <label for="cboPeriod" class="form-label">Period:</label>
                        <select id="cboPeriod" class="form-select"><option value="" >Select Period</option></select>
                    </div>
                <!--row 2-->
                    <div class="col-md-4">
                        <label for="cboEmployer" class="form-label">Employer:</label>
                        <select id="cboEmployer" class="form-select">
                            <option value="">SELECT EMPLOYER</option>
                       </select>
                    </div>
                    <div class="col-md-4">
                        <label for="cboLoan" class="form-label">Loan Type:</label>
                        <select id="cboLoan" class="form-select"><option value="">(ANY)</option></select>
                    </div>
                <!--row 3-->
                    <div class="col-md-4">
                        <label for="cboLoanStatus" class="form-label">Loan Status:</label>
                        <select id="cboLoanStatus" class="form-select">
                            <option value="appraisedloans" selected>Appraised Loans</option>
                            <option value="approvedloans">Approved Loans</option>
                            <option value="postedloans">Posted Loans</option>
                            <option value="rejectedloans">Rejected Loans</option>
                            <%--<option value="defferedloans">Deffered Loans</option>--%>
                          </select>
                    </div>
                    <div class="col-md-4">
                        <label for="cboHRStatus" class="form-label">HR Status:</label>
                        <select id="cboHRStatus" class="form-select">
                                <option value="" selected>(ANY)</option>
                                <option value="N">Pending</option>
                                <option value="Y">Approved</option>
                        </select>
                    </div>
                <!--row 4-->
                    <div class="col-md-4">
                        <label for="cboSearchBy" class="form-label">Search By:</label>
                        <select id="cboSearchBy" onchange="javascript:ShowSearchParams();return false;" class="form-select">
                                        <option value="memberno" selected>MemberNo</option>
                                        <option value="idnumber">IDNo</option>
                                        <option value="payrollno">PayrollNo</option>
                                   </select>
                    </div>
                    <div class="col-md-4">
                        <label for="cboBranch" class="form-label">Branch</label>
                        <select id="cboBranch" onkeyup="javascript:LoadLoansListing();return false;" 
                        onchange="javascript:LoadLoansListing();return false;" class="form-select" >
                            <option value="">(ANY)</option></select>
                    </div>
                <!--row 5-->
                    <div class="col-md-4">
                    <div id="divSearchDisplay" class="form-label">Search Value</div>
                    <input type="text" id="txtSearchValue" class="form-control"/>
                  </div>

                  <!--buttons-->
                    <div class="nav nav-pills r-tabs-nav d-flex justify-content-center" style="gap: 10px;margin-left: 17px;margin-block: 15px;">
                        <input type="button" id="btnListLoans" class="btn btn-secondary me-3" onclick="LoadLoansListing(); return false" value="List Loans" />
                        <input type="button" id="btnProcess" value="Process" class="btn btn-secondary me-3" />
                        <input type="button" id="btnPrint" value="Print" class="btn btn-info" />
                    </div>
            </div>
    </form>
      <hr/>
    <div class="mt-3 mx-3">
    <label class="form-label" id="ListingType">Loans List</label>
        <div id="divLoansList" class="table-responsive">
        <table id= "tbLoansList" class="table table-bordered">
            <tr><td></td></tr>
        </table>
        No loans in view</div>
    </div>
 </div>
 </div>   
</asp:Content>

