﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/ExternalUsers/Views/Shared/ExternalUsers.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Approve Loan Offsets
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        tr.row_selected td{background-color:lawngreen;}
    </style>
    <script type="text/javascript"  >
        $(document).ready(function () {
                $("#cboYear").empty();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/ExternalUsersSystemApi/GetYears") %>",
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var years = response;
                        var obj = document.getElementById("cboYear");
                        $.each(years, function (index, yrs) {
                            var opt = document.createElement("option");
                            opt.value = yrs.DBName;
                            opt.text = yrs.UserDefinedYearName;
                            opt.selected = true;
                            obj.appendChild(opt);
                        });
                        LoadLoanRequests();
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                    }
                });

                $("#cboYear").on("change", function () {
                    LoadLoanRequests();
                });
                $("#cboBranch").on("change", function () {
                    LoadLoanRequests();
                });
                $("#cboLoanStatus").on("change", function () {
                    LoadLoanRequests();
                });
                $("#cboHRStatus").on("change", function () {
                    LoadLoanRequests();
                });
                $("#cboPeriod").on("change", function () {
                    LoadLoanRequests();
                });

                $('#tblLoanRequests').dataTable({
                    "paging": true,
                    "ordering": true,
                    "info": true,
                    "searching": true
                });
                $('#tblOffsets').dataTable({
                    "paging": false,
                    "ordering": false,
                    "info": false,
                    "searching": false
                });
                $("#btnApproveOffset").on('click', function () {
                    var OffsetList = new Array();
                    var offset_count = 0;
                    var valid_offset = 0;
                    $("#tblOffsets tbody").find('tr').each(function (i) {
                        var OffsetEntry = {};
                        var row = $(this); //store in variable for faster access
                        OffsetEntry.LoanRefNo = row.find('td:eq(0)').text();
                        OffsetEntry.OffsetType = row.find('td:eq(1)').text();
                        OffsetEntry.SchemeCode = "";
                        OffsetEntry.LoanSerialNo = row.find('td:eq(2)').text();
                        var cboResponse = row.find('td:eq(9)').find('select:eq(0)');
                        OffsetEntry.ApprovalStatus = cboResponse.val();
                        if ((cboResponse.val().toString().toLowerCase() == "accepted") || (cboResponse.val().toString().toLowerCase() == "rejected"))
                        {
                            OffsetList[offset_count] = OffsetEntry;
                            valid_offset++;
                        } else {
                            alert("Invalid Reponse for Loan Serial No " + OffsetEntry.LoanSerialNo);
                            return;
                        }
                        offset_count++;
                    });
                    if (offset_count > 0 && (offset_count == valid_offset)) {
                            var csrfToken = $("input[name='__RequestVerificationToken']").val();
                            var outData = {
                                'DBName': $("#cboYear").val(),
                                'OffSetList': OffsetList
                            }
                            outData = JSON.stringify(outData);
                            $.ajax({
                                headers: { __RequestVerificationToken: csrfToken },
                                type: "POST",
                                url: "<%: Url.Content("~/api/ExternalUsersSystemApi/SaveOffsetApproval") %>",
                            data: outData,
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            success: function (response) {
                                DisplayOffsets(response);
                            },
                            error: function (xhr, status, error) {
                                var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                            }
                        });
                    }
                });
                $('#bdLoanRequests').on('click', 'tr', function (event) {
                    var sel_row = $(this)

                    $('#tblLoanRequests tbody tr').removeClass('row_selected');
                    $(sel_row).addClass('row_selected');

                    var loan_ref_no = sel_row.find('td').eq(0).text();
                    $("#tblOffsets > tbody:last").children().remove();
                    
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    var outData = {
                        'DBName': $("#cboYear").val(),
                        'LoanRefNo': loan_ref_no
                    }
                    outData = JSON.stringify(outData);
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/ExternalUsersSystemApi/GetLoanApplicationDetails") %>",
                        data: outData,
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            $("#tblOffsets > tbody:last").children().remove();
                            DisplayOffsets(response);
                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                        }
                    });

                    return false;
                });
            
                function DisplayOffsets(memLoanApplication) {
                    
                    $("#tblOffsets > tbody:last").children().remove();
                        var tbl_row = "";
                        var row_datas = memLoanApplication.memberLoanApplicationOffset;
                        $.each(row_datas, function (index, row_data) {
                            tbl_row += "<tr>";
                            tbl_row += "<td>" + row_data.LoanRefNo + "</td>";
                            tbl_row += "<td>" + row_data.OffsetType + "</td>";
                            tbl_row += "<td>" + row_data.LoanSerialNo + "</td>";
                            if (row_data.OffsetType.toString().toLowerCase() == "L".toLowerCase()) {
                                tbl_row += "<td>" + row_data.LN_LoanTypeName + "</td>";
                            } else if (row_data.OffsetType.toString().toLowerCase() == "I".toLowerCase()) {
                                tbl_row += "<td>INTEREST " + row_data.LN_LoanTypeName + "</td>";
                            } else {
                                tbl_row += "<td>UNSUPPORTED</td>";
                            }
                            tbl_row += "<td>" + row_data.LN_IssueDate + "</td>";
                            tbl_row += "<td>" + row_data.LN_ElapsedMonths + " month(s)</td>";
                            tbl_row += "<td>" + (+row_data.LN_LoanAmount).formatMoney() + "</td>";
                            tbl_row += "<td>" + (+row_data.LN_LoanBalance).formatMoney() + "</td>";
                            tbl_row += "<td>" + (+row_data.Amount).formatMoney() + "</td>";
                            if (row_data.ApprovalStatus.toString().toLowerCase() == "accepted".toLowerCase()) {
                                tbl_row += "<td><select style='width:100px'><option value='pending'>Pending</option><option value='accepted' selected>Accepted</option><option value='rejected'>Rejected</option></select></td>";
                            } else if (row_data.ApprovalStatus.toString().toLowerCase() == "rejected".toLowerCase()) {
                                tbl_row += "<td><select style='width:100px'><option value='pending'>Pending</option><option value='accepted'>Accepted</option><option value='rejected' selected>Rejected</option></select></td>";
                            } else {
                                tbl_row += "<td><select style='width:100px'><option value='pending'selected>Pending</option><option value='accepted'>Accepted</option><option value='rejected'>Rejected</option></select></td>";
                            }
                            tbl_row += "<td>" + row_data.ApproverUserID + "</td>";
                            tbl_row += "<td>" + row_data.ApproverNames + "</td>";
                            tbl_row += "<td>" + row_data.ApproverDate + "</td>";
                            tbl_row += "</tr>";
                        });
                        $("#bdOffsets").append(tbl_row);
                        //row_datas = memLoanApplication.memberLoanApplication;
                        //tbl_row = "<tr>";
                        //tbl_row += "<td>Manager Comments</td>";
                        //tbl_row += "<td>" + row_datas.ManagerComments + "</td>";
                        //tbl_row += "</tr>";
                        //tbl_row += "<tr>";
                        //tbl_row += "<td>Manager Response Date</td>";
                        //tbl_row += "<td>" + row_datas.ManagerApprovalDate + "</td>";
                        //tbl_row += "</tr>";
                        //$("#bdOtherLoanProperties").append(tbl_row);

                    }
        function LoadLoanRequests() {
            $("#tblLoanRequests > tbody:last").children().remove();
            var dbname = $("#cboYear").val();
            if (dbname == null) { return; }
            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/ExternalUsersSystemApi/GetHRLoanListingForOffset") %>",
                    data: JSON.stringify({ 'DBName': $("#cboYear").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var ManagerLoanRequests = response;
                        var tbl_row = "";
                        $.each(ManagerLoanRequests, function (index, ManagerLoanRequest) {
                            $("#tblLoanRequests > tbody:last").children().remove();
                            tbl_row += "<tr>";
                            tbl_row += "<td>" + ManagerLoanRequest.LoanRefNo + "</td>";
                            tbl_row += "<td>" + ManagerLoanRequest.LoanDate + "</td>";
                            tbl_row += "<td>" + "&nbsp;&nbsp;" + ManagerLoanRequest.MemberNo + "</td>";
                            tbl_row += "<td>" + ManagerLoanRequest.MemberNames + "</td>";
                            tbl_row += "<td>" + ManagerLoanRequest.LoanTypeName + "</td>";
                            tbl_row += "<td>" + (+ManagerLoanRequest.RequestedAmount).formatMoney() + "</td>";
                            tbl_row += "<td>" + (+ManagerLoanRequest.OffsetTotal).formatMoney() + "</td>";
                            tbl_row += "<td>" + ManagerLoanRequest.OffsetCount + "</td>";
                            tbl_row += "</tr>";
                        });
                        if (tbl_row != "") { $("#bdLoanRequests").append(tbl_row); }

                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                    }
                });
            }

            function setCookie(c_name, value, expiredays) {
                var exdate = new Date();
                exdate.setDate(exdate.getDate() + expiredays);
                document.

                    e = c_name + "=" + escape(value) +
                ((expiredays == null) ? "" : ";expires=" + exdate.toUTCString());
            }
            function getCookie(c_name) {
                if (document.cookie.length > 0) {
                    c_start = document.cookie.indexOf(c_name + "=");
                    if (c_start != -1) {
                        c_start = c_start + c_name.length + 1;
                        c_end = document.cookie.indexOf(";", c_start);
                        if (c_end == -1) c_end = document.cookie.length;
                        return unescape(document.cookie.substring(c_start, c_end));
                    }
                }
                return "";
            }

            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion({
                    heightStyle: "content"
                });
            });
        });
    </script>
</asp:Content>
<asp:Content ID="Content6" ContentPlaceHolderID="FeaturedContent" runat="server">
<h3>Approve Loan Offsets</h3>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    
    <form id="frmMain" name="frmMain">
        <%= Html.AntiForgeryToken() %>
    <table border="1" style="padding: 1px; margin: 1px;">
        <tr>
            <td colspan="4"><b>Financial Period</b></td>
        </tr>
        <tr><td>Financial Year:</td><td colspan="3"><select id="cboYear"><option value="selectyear">SELECT YEAR</option></select></td></tr>
        
    </table>
        <div id="divLoanRequests"  style="height:200px;overflow:auto;width:auto">
            Loans With Offsets
            <hr style="color:green" />
            <table id='tblLoanRequests' class='display'>
                    <thead>
                        <tr>
                        <th ><b>Ref.No</b></th>
                        <th ><b>Date</b></th>
                        <th ><b>MemberNo</b></th>
                        <th ><b>Names</b></th>
                        <th ><b>Loan Type</b></th>
                        <th ><b>Loan Amount</b></th>
                        <th ><b>Total Offsets</b></th>
                        <th ><b>Offset Count</b></th>
                        </tr>
                    </thead>
                    <tbody id='bdLoanRequests'>
                    </tbody>
                <tfoot>
                    <tr>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>
                </tfoot>
            </table>
        </div>
        <br />
        
        <div id="divOffsets"  style="height:200px;overflow:auto;width:auto">
            Offset Details
            <hr style="color:green" />
            <table id='tblOffsets' class='display'>
                    <thead>
                        <tr>
                        <th ><b>LNRef</b></th>
                        <th ><b>Type</b></th>
                        <th ><b>Loan SNo.</b></th>
                        <th ><b>Loan Type</b></th>
                        <th ><b>Issue Date</b></th>
                        <th ><b>Elapsed</b></th>
                        <th ><b>Loan Amount</b></th>
                        <th ><b>Loan Balance</b></th>
                        <th ><b>Offset</b></th>
                        <th ><b>Action</b></th>
                        <th ><b>Apprv. By</b></th>
                        <th ><b>Name</b></th>
                        <th ><b>Apprv. Date</b></th>
                            
                        </tr>
                    </thead>
                    <tbody id='bdOffsets'>
                    </tbody>
                <tfoot>
                    <tr>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>
                </tfoot>
            </table>
            <table style="width:100%">
                <tr>
                    <td><input type="button" id="btnApproveOffset" value="Approve/Reject" /></td>
                </tr>
            </table>
        </div>
    </form>
    <div></div>
</asp:Content>


