﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Members/Views/Shared/MembersMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Ekeza Fixed Deposit Calculator
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        
        .td_amount_col {
            text-align: right;
        }
        
    </style>

    
    <script type="text/javascript"  >
        //https://stackoverflow.com/questions/6982692/how-to-set-input-type-dates-default-value-to-today
        //The value field for the input type = input needs to be in the format yyyy-MM-dd. Month and Day should be two digits eg 09 not just 9
        //Note: The displayed date format will differ from the actual value — the displayed date is formatted based on the locale of the user's browser, but the parsed value is always formatted yyyy-mm-dd.
        Date.prototype.toDateInputValue = (function () {
            var local = new Date(this);
            local.setMinutes(this.getMinutes() - this.getTimezoneOffset());
            return local.toJSON().slice(0, 10);
        });
        $(document).ready(function () {
            var dblTaxRate = 5.0;
            SetDefaultDate();
            var fxdIntClasses = Object(<%= Json.Encode(ViewBag.FxdInterestRanges) %>);
            //alert(JSON.stringify(fxdIntClasses));
            //console.log(fxdIntClasses);
            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion({
                    heightStyle: "content"
                });
            });

            

            CalcInterestEarned();
            function CalcInterestEarned() {
                
                try {
                    $("#txtGrossInterest").val("0.00");
                    $("#txtRateUsed").val("0.00");
                    $("#txtTax").val("0.00");
                    $("#txtNetInterest").val("0.00");
                    $("#lblTaxRate").html("Tax Rate " + dblTaxRate + "%");
                    
                    var PrincipalAmt = $("#txtPrincipalAmt").val();
                    var investDays = $("#txtDays").val();
                    
                    if (!isNumber(ConvertMoneyToDouble(PrincipalAmt))) {
                        //alert("Invalid Principal Amount");
                        $("#divAmountInWords").val("Invalid Principal Amount");
                        return;
                    }
                    if (!isNumber(ConvertMoneyToDouble(investDays))) {
                        //alert("Invalid Investment Period");
                        $("#divAmountInWords").val("Invalid Investment Period");
                        return;
                    }
                    if (parseFloat(PrincipalAmt) <= 0.00) {
                        //alert("Invalid Principal Amount");
                        $("#divAmountInWords").val("Invalid Principal Amount");
                        return;
                    }
                    if (parseFloat(investDays) <= 0.00) {
                        //alert("Invalid Investment Period");
                        $("#divAmountInWords").val("Invalid Investment Period");
                        return;
                    }
                    
                    var filteredIntClasses = fxdIntClasses.filter(function (fxdIntClass) {
                        return ((parseFloat(investDays) >= parseFloat(fxdIntClass.FRange)) && (parseFloat(investDays) < parseFloat(fxdIntClass.LRange)));
                    });


                    if (filteredIntClasses.length > 0) {
                        var currFxdIntClass = filteredIntClasses[0];
                        $("#txtRateUsed").val(parseFloat(currFxdIntClass.ChrgAmt));
                        //alert("Rate is " + currFxdIntClass.ChrgAmt);
                        var InterestEarned = (Number(investDays) / 365) * parseFloat(parseFloat(PrincipalAmt) * (parseFloat(currFxdIntClass.ChrgAmt) / 100));
                        $("#txtGrossInterest").val(InterestEarned.formatMoney());
                        var TaxCharged = (dblTaxRate / 100) * InterestEarned;
                        $("#txtTaxAmt").val(Number(TaxCharged).formatMoney());
                        $("#txtNetInterest").val((Number(InterestEarned) - Number(TaxCharged)).formatMoney());
                    }

                    var startDate = $("#txtStartDate").val();
                    let endDate = new Date(startDate);
                    
                    endDate.setDate(endDate.getDate() + Number(investDays));
                    //console.log(endDate);

                    
                    var dd = endDate.getDate();
                    var mm = endDate.getMonth() + 1; //January is 0!
                    var yyyy = endDate.getFullYear();

                    if (dd < 10) {
                        dd = '0' + dd
                    }

                    if (mm < 10) {
                        mm = '0' + mm
                    }

                    //today = yyyy + '/' + mm + '/' + dd;
                    var endDateFormated = dd + '/' + mm + '/' + yyyy;
                    //console.log(endDateFormated);
                    //document.getElementById("txtMaturityDate").value = endDateFormated;
                    
                    $("#txtMaturityDate").val(endDateFormated);
                } catch (err) {
                    //do nothing
                    alert(err);
                }
            }
            $("#txtPrincipalAmt").on('change keyup paste mouseup focusout', function () {
                $("#txtGrossInterest").val("");
                DispAmountInWords();
                CalcInterestEarned();
                
            });
            
            function DispAmountInWords() {
                $("#divAmountInWords").html("");
                try {
                    $("#divAmountInWords").html(toWords($("#txtPrincipalAmt").val()));
                } catch (err) {

                }
            }
            $("#txtDays").on('input change', function () {
                $("#txtGrossInterest").val("");
                CalcInterestEarned();
            });
            //$("#txtPrincipalAmt").on('focusout', function () {
            //    CalcInterestEarned();
            //});
            $("#txtDays").on('focusout change', function () {
                CalcInterestEarned();
            });
            $("#btnCalculate").on('click', function () {
                CalcInterestEarned();
            });

            $("#txtStartDate").on('change', function () {
                CalcInterestEarned();
            });

            $("#txtPrincipalAmt").val(0.00);
            DispAmountInWords();
            
            function SetDefaultDate() {
                $('#txtStartDate').val(new Date().toDateInputValue());
                return;
                //https://teamtreehouse.com/community/html-input-date-field-how-to-set-default-value-to-todays-date
                var today = new Date();
                var dd = today.getDate();
                var mm = today.getMonth() + 1; //January is 0!
                var yyyy = today.getFullYear();

                if (dd < 10) {
                    dd = '0' + dd
                }

                if (mm < 10) {
                    mm = '0' + mm
                }

                //today = yyyy + '/' + mm + '/' + dd;
                today = yyyy + '-' + mm + '-' + dd;
                console.log(today);
                document.getElementById("txtStartDate").value = today;
                //alert(document.getElementById("txtStartDate").value);
            }
        });
    </script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    
        <%= Html.AntiForgeryToken() %> 
        <% XtremeERP.Common.Data.SaccoSettings saccoSettings = ViewBag.saccoSettings as XtremeERP.Common.Data.SaccoSettings; %>
        <% XtremeERP.Common.Data.SaccoMember saccoMember = ViewBag.SaccoMember as XtremeERP.Common.Data.SaccoMember; %>
        <% XtremeERP.Common.Data.MemberPortalSettings portalSettings = ViewBag.PortalSettings as XtremeERP.Common.Data.MemberPortalSettings; %>
        <% List<XtremeERP.Common.Data.ComplexCharges> FxdInterestRanges = ViewBag.FxdInterestRanges as List<XtremeERP.Common.Data.ComplexCharges>; %>
        
        


    <div class="row">
        <div class="col-md-10 col-md-offset-1 table-responsive" id="divFxdIntRanges">
            <h4><u>Fixed Deposit Interest Brackets</u></h4>
            <table id='tblFxdIntRanges' class="table table-striped table-bordered">
                <thead>
                    <tr>
                    <th class="td_amount_col"><b>Min. Days</b></th>
                    <th class="td_amount_col"><b>Max. Days</b></th>
                    <th class="td_amount_col"><b>Int. Rate(%)</b></th>
                    </tr>
                </thead>
                <tbody id='bdFxdIntRanges'>
                    <%foreach (XtremeERP.Common.Data.ComplexCharges fxdInterestRange in FxdInterestRanges)
                        {   %>
                    <tr>
                        <td class="td_amount_col"><%=Html.Encode(fxdInterestRange.FRange)  %></td>
                        <td class="td_amount_col"><%=Html.Encode(fxdInterestRange.LRange)  %></td>
                        <%--<td class="td_amount_col"><%=Html.Encode(XtremeERP.Common.Utilities.Utils.FormatPesa(fxdInterestRange.ChrgAmt))  %></td>--%>
                        <td class="td_amount_col"><%=Html.Encode(fxdInterestRange.ChrgAmt)  %></td>
                        <%}%>
                    </tr>
                </tbody>

            </table>
        </div>
    </div>
    <div class="row">
        <div class="col-md-10 col-md-offset-1 ">
        <h4><u>Interest Calculator</u></h4>
            <form>
        <table class="table table-responsive table-bordered">
            <tr>
                <td><label for="txtStartDate">Start Date:* </label></td><td><input type="date"  id="txtStartDate" name="txtStartDate" /></td>
                <td><label for="txtPrincipalAmt">Amount to Fix* </label></td><td><input type="text" class="td_amount_col" autofocus id="txtPrincipalAmt" name="txtPrincipalAmt"  value="0.00" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1');" /></td>
            </tr>
            <tr>
                <td colspan="4"><div>Amount In words: </div><div id="divAmountInWords"></div></td>
            </tr>
            <tr>
                <td><label for="txtDays">Prefered Duration(Days)* </label></td><td><input type="text" class="td_amount_col" id="txtDays" name="txtDays"  value="1" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1');"/></td>
                <td></td><td></td>
            </tr>
            <tr>
                <td colspan="4"><input type="button" id="btnCalculate" name="btnCalculate" value="Calculate"/></td><td></td>
            </tr>
            <tr>
                <td colspan="4"><b>Results</b></td>
            </tr>
            <tr>
                <td><label for="txtRateUsed">Rate Used (%) </label></td><td><input type="text" class="td_amount_col" id="txtRateUsed" name="txtRateUsed" readonly /></td>
                <td><label for="txtGrossInterest">Gross Interest Earned </label></td><td><input type="text" class="td_amount_col" id="txtGrossInterest" name="txtGrossInterest" readonly /></td>
            </tr>
            <tr>
                <td><label for="txtMaturityDate">Maturity Date </label></td><td><input type="text"  id="txtMaturityDate" name="txtMaturityDate" readonly /></td>
                <td><label for="txtTax" id="lblTaxRate">Tax Amount</label></td><td><input type="text" class="td_amount_col" id="txtTaxAmt" name="txtTaxAmt" readonly /></td>
            </tr>
            <tr>
                <td><label for="txtNetInterest">Net Interest Earned </label></td><td><input type="text" class="td_amount_col" id="txtNetInterest" name="txtNetInterest" readonly /></td><td></td>
            </tr>
        </table>
                </form>
            </div>
        
    </div>
        
        <!--
        <div class="col-md-10 col-md-offset-4 ">
            <h4><u>Interest Calculator</u></h4>
            
            <form>
                <br />
                <br />
                <label for="txtStartDate">Start Date: </label><br /><input type="date"  id="txtStartDate" name="txtStartDate" />
                <br />
                <br />
                <label for="txtPrincipalAmt">Amount to Fix </label><br /><input type="text" class="td_amount_col" autofocus id="txtPrincipalAmt" name="txtPrincipalAmt"  value="0.00" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1');"/>
                <br />
                <div id="divAmountInWords"></div>
                <br />
                <br />
                <label for="txtDays">Prefered Duration(Days) </label><br /><input type="text" class="td_amount_col" id="txtDays" name="txtDays"  value="1" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1');"/>
                <br />
                <br />
                
                <input type="button" id="btnCalculate" name="btnCalculate" value="Calculate"/>
                <br />
                <br />
                <label for="txtRateUsed">Rate Used (%) </label><br /><input type="text" class="td_amount_col" id="txtRateUsed" name="txtRateUsed" readonly />
                <br />
                <br />
                <label for="txtGrossInterest">Interest Earned </label><br /><input type="text" class="td_amount_col" id="txtGrossInterest" name="txtGrossInterest" readonly />
                
                <br />
                <br />
                <label for="txtMaturityDate">Maturity Date </label><br /><input type="text"  id="txtMaturityDate" name="txtMaturityDate" readonly />
                
            </form>
            
            
        </div>
            -->
         
      
    <div id="loading" style="display:none"><img src="<%: Url.Content("~/Content/images/ajax-loader.gif") %>"  alt="Ajax Loader" />Contacting server....</div>
    <div id="divStatementDlg" style="display:none" ><iframe id="ifStatementDlg" style="height:640px;width:1140px"></iframe></div>
    
</asp:Content>
