﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Members/Views/Shared/MembersMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Loan Calculator
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        
        .td_amount_col {
            text-align: right;
        }
        
    </style>

    
    <script type="text/javascript"  >
        $(document).ready(function () {
            var LoanTypeList = null;
            var SchemeBalsList = null;
            var currLoanType = null;
            var LoanBalances = null;
            //note no quotes to avoid 'true' and 'false' strings which will both evaluate to true on if (NoSalaryMazematics) {
            //var NoSalaryMazematics ='<%= ((XtremeERP.Common.Data.MemberPortalSettings)ViewBag.PortalSettings).LoanCalcNoSalaryComputations ? "true" : "false" %>';

            var NoSalaryMazematics =<%= ((XtremeERP.Common.Data.MemberPortalSettings)ViewBag.PortalSettings).LoanCalcNoSalaryComputations ? "true" : "false" %>;
            var bolIsSaccoBalozi =<%= (XtremeERP.Common.Utilities.Utils.bolIsSaccoBalozi ? "true" : "false") %>;

            InitSummary();

            if (NoSalaryMazematics) {
                $('#rowUsesSalary').hide();
                $('#rowNetSalary').hide();
            }
            $('#btnCalculate').on('click', function (event) {
                event.preventDefault();
                if (document.getElementById("cboLoanType").selectedIndex == 0) {
                    alert("Select Loan Type");
                    return;
                }
                if (!isNumber(ConvertMoneyToDouble($("#txtRequestedAmount").val()))) {
                    alert("Invalid Loan Amount");
                    return;
                }
                if (!isNumber(ConvertMoneyToDouble($("#txtSalary").val()))) {
                    alert("Invalid Salary Amount");
                    return;
                }
                if (!isNumber(ConvertMoneyToDouble($("#txtRepaymentPeriod").val()))) {
                    alert("Invalid Repayment Period");
                    return;
                }
                if (+($("#txtRepaymentPeriod").val()) < 1) {
                    alert("Invalid Repayment Period");
                    return;
                }
                var csrfToken = $("input[name='__RequestVerificationToken']").val();


                var outData = {
                    'LoanAmount': $("#txtRequestedAmount").val(),
                    'SalaryAmount': $("#txtSalary").val(),
                    'RepaymentPeriod': $("#txtRepaymentPeriod").val(),
                    'LoanTypeCode': $("#cboLoanType").val(),
                    'Frequency': $("#cboRepaymentMethod").val(),
                }
                outData = JSON.stringify(outData);
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/CalculateMemberQualifingLoanAmount") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        $("#lblRecommendedAmount").text((+response.RecommenedAmount).formatMoney());
                        $("#lblRepaymentAmount").text((+response.RepaymentAmount).formatMoney());
                        $("#pInfo").html(response.Reasons);
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }

                });
            });
            $("#cboLoanType").on('change', function () {
                var LoanTypes = LoanTypeList.filter(function (lnType) {
                    return lnType.LoanTypeCode == $("#cboLoanType").val();
                });
                currLoanType = null;
                $("#lblMaxAmount").text("");
                $("#lblRepaymentPeriod").text("");
                $("#txtRepaymentPeriod").val("");
                $("#lblSchemeUsed").text("");
                $("#lblSchemeBalance").text("");
                $("#lblMultiplier").text("");
                $("#lblSharesMultiplied").text("");
                $("#lblOtherLoansBalances").text("");
                $("#lblRecommendedAmount").text("");
                $("#lblRepaymentAmount").text("");
                
                $("#lblUsesSalary").text("");

                $("#lblInterestRate").text("");
                $("#pInfo").text("");
                

                if (LoanTypes.length > 0) {
                    currLoanType = LoanTypes[0];

                    var SchemeBalance = 0;

                    var SharesMultiplier = currLoanType.LoanNumOfTimesShares;

                    var SchemeUsed = currLoanType.SchemeUsed;
                    var SharesMultiplied = 0;
                    var LoanTiedToSchemeTotals = 0;
                    $("#lblInterestRate").val(currLoanType.Percentage);
                    $("#txtSalary").prop("disabled", (currLoanType.UsesSalary.toUpperCase() == "Y" ? false : true)); 
                    if (currLoanType.UsesSalary.toUpperCase() == "N") {
                        $("#txtSalary").val("0");
                    }
                    $("#lblUsesSalary").text((currLoanType.UsesSalary.toUpperCase()=="Y"?"YES":"NO"));
                    if (SchemeUsed.length > 0) {
                        if (SchemeBalsList != null) {
                            var SchemeList = SchemeBalsList.filter(function (schemeType) {
                                return schemeType.BalCode == SchemeUsed;
                            });
                            if (SchemeList != SchemeList.length > 0) {
                                SchemeBalance = SchemeList[0].BalAmount;
                            }
                        }
                        $("#lblSchemeUsed").text(currLoanType.SchemeUsedName);
                        SharesMultiplied = (+SharesMultiplier) * (+SchemeBalance);
                        if (+SharesMultiplied < 0) {
                            SharesMultiplied = 0;
                        }
                        var LoanBalancesTiedToScheme;
                        LoanTiedToSchemeTotals = 0;
                        if (bolIsSaccoBalozi) {
                            //exclude: M-cash loan(91), Default loan(29), Okoa Advance(31), Quick pesa loans(20) 
                            //exclude: M-cash loan(Z), Default loan(D), Okoa Advance(O), Quick pesa loans(Q) And ADVANCE INTEREST & DIVIDENDS
                            LoanBalancesTiedToScheme = LoanBalances.filter(function (lnType) {
                                return ((lnType.SchemeUsed == SchemeUsed) && (lnType.BalCode.toUpperCase() != "Z" && lnType.BalCode.toUpperCase() != "D" && lnType.BalCode.toUpperCase() != "O" && lnType.BalCode.toUpperCase() != "Q" && lnType.BalCode.toUpperCase() != "A"));
                            });
                            
                        } else {
                            LoanBalancesTiedToScheme = LoanBalances.filter(function (lnType) {
                                return lnType.SchemeUsed == SchemeUsed;
                            });
                        }
                        if (LoanBalancesTiedToScheme.length > 0) {
                            for (var i = 0; i < LoanBalancesTiedToScheme.length; i++){
                                LoanTiedToSchemeTotals += (+LoanBalancesTiedToScheme[i].BalAmount);
                            }
                        }
                    }
                    
                    $("#lblOtherLoansBalances").val((+LoanTiedToSchemeTotals).formatMoney());
                    $("#lblMaxAmount").val((+currLoanType.LoanMaxAmount).formatMoney());
                    $("#lblRepaymentPeriod").val(+currLoanType.LoanMaxDuration);
                    $("#txtRepaymentPeriod").val(+currLoanType.LoanMaxDuration);
                    $("#lblSchemeBalance").val((+SchemeBalance).formatMoney());
                    $("#lblMultiplier").val(SharesMultiplier);
                    $("#lblSharesMultiplied").val((+SharesMultiplied).formatMoney());
                    $("#lblInterestRate").val(+currLoanType.Percentage);
                    
                    
                }
            });

            

            function InitSummary() {

                
                $("#tblAllLoans > tbody:last").children().remove();
                

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/GetMemberLoanSummary") %>",
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        
                        LoanBalances = response.LoanBalances;
                        SchemeBalsList = response.SchemeBalances;
                        
                        var TotalLoanBalance = response.TotalLoanBalance;
                        var tbl_row = "";
                        
                        $.each(LoanBalances, function (index, LoanBalance) {
                            if ((+LoanBalance.BalAmount) != 0) {
                                tbl_row += "<tr><td>" + LoanBalance.BalName + "</td><td class='td_amount_col'>" + (+LoanBalance.BalAmount).formatMoney() + "</td><td>" + LoanBalance.SchemeUsed + "</td></tr>";
                            }
                        });

                        tbl_row += "<tr><td>Total Loan Balance:</td><td class='td_amount_col'>" + (+TotalLoanBalance).formatMoney() + "</td><td></td></tr>";

                        $("#bdAllLoans").append(tbl_row);

                        LoanTypeList = response.CalcLoanTypes;
                        $("#cboLoanType").empty();
                        $("#cboLoanType").append('<option selected>(SELECT LOAN)</option>');
                        $.each(LoanTypeList, function (index, LoanType) {
                            $("#cboLoanType").append("<option value='" + LoanType.LoanTypeCode + "'>" + LoanType.LoanTypeName + "</option'>");
                        });
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });

            }



            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion({
                    heightStyle: "content"
                });
            });

        });
    </script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
        <%= Html.AntiForgeryToken() %> 
        <% XtremeERP.Common.Data.SaccoSettings saccoSettings = ViewBag.saccoSettings as XtremeERP.Common.Data.SaccoSettings; %>
        <% XtremeERP.Common.Data.SaccoMember saccoMember = ViewBag.SaccoMember as XtremeERP.Common.Data.SaccoMember; %>
        <% XtremeERP.Common.Data.MemberPortalSettings portalSettings = ViewBag.PortalSettings as XtremeERP.Common.Data.MemberPortalSettings; %>
        
        
       
              <div class="card m-4"> 

                    
                    <div id="divAllLoans" class="table-responsive">
                       <table id='tblAllLoans' class="table table-bordered table-resposive">
                           
                            <h5 class="fs-6">Current Loan Balances</h5>
                            <thead class="thead-dark">
                                <tr>
                                <th>Loan Type</th>
                                <th class="text-end">Loan Balance</th>
                                <th>Scheme</th>
                                </tr>
                            </thead>
                            <tbody id='bdAllLoans'>
                            </tbody>
                            
                        </table>
                        
                    </div>
                

              <div > 
                
                    <div id="divCalculator" >
                            <h5 class="fs-6">Loan Calculator</h5>
                                
                            <div class="row" id='bdCalculator'>
                                <div class="col-md-4">
                                    <label class='form-label'>Loan Type</label>
                                    <select id="cboLoanType" class="form-select"></select>
                                </div>
                                 <div class="col-md-4">
                                    <label class='form-label'>Max. Loan Amount</label>
                                    <input id="lblMaxAmount" class="form-control"/>
                                </div>
                                <div class="col-md-4">
                                    <label class='form-label'>Max. Repayment Period (Months)</label>
                                    <input id="lblRepaymentPeriod" class="form-control"/>
                                </div>
                                 <div class="col-md-4">
                                    <label class='form-label'>Monthly Interest Rate (%)</label>
                                    <input id="lblInterestRate" class="form-control"/>
                                </div>
                                 <div class="col-md-4">
                                    <label class='form-label'>Scheme Used</label>
                                    <input class="form-control" id="lblSchemeUsed"/>
                                </div>
                                 <div class="col-md-4">
                                    <label class='form-label'>Scheme Balance</label>
                                    <input class="form-control" id="lblSchemeBalance"/>
                                </div>
                                <div class="col-md-4">
                                    <label class='form-label'>Multiplier</label>
                                    <input class="form-control" id="lblMultiplier"/>
                                </div>
                                <div class="col-md-4">
                                    <label class='form-label'>Shares Multiplied</label>
                                    <input class="form-control" id="lblSharesMultiplied" />
                                </div>
                                <div class="col-md-4">
                                    <label class='form-label'>Loan Balances tied to Scheme</label>
                                    <input class="form-control" id="lblOtherLoansBalances" />
                                </div>
                                <div class="col-md-4">
                                    <label class='form-label'>Amount To Borrow</label>
                                    <input type="number" id="txtRequestedAmount" class="form-control" />
                                </div>
                                <div class="col-md-4">
                                    <label class='form-label'>Repayment Period</label>
                                    <input type="number" id="txtRepaymentPeriod" class="form-control" />
                                </div>
                                 <div class="col-md-4">
                                    <label class='form-label'>Repayment Frequency</label>
                                    
                                        <select id="cboRepaymentMethod" class="form-select">
                                            <option value="Monthly" selected>Monthly</option>
                                            <option value="Twice Per month">Twice per Month</option>
                                        </select>
                                    
                                </div>
                                <div class="col-md-4" id="rowUsesSalary">
                                    <label class='form-label'>Uses Salary</label>
                                    <input class="form-control" id="lblUsesSalary"/>
                                </div>
                                <div class="col-md-4" id="rowNetSalary">
                                    <label class='form-label'>Net Salary After Deductions</label>
                                    <input type="number" id="txtSalary" class="form-control" value="0" />
                                </div>
                                 <div class="col-md-4">
                                    <label class='form-label'>Recommended Amount</label>
                                    <input class="form-control" id="lblRecommendedAmount"/>
                                </div>
                                 <div class="col-md-4">
                                    <label class='form-label'>Monthly Repayment</label>
                                    <input class="form-control" id="lblRepaymentAmount"/>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label class='form-label'></label>
                                <input type="button" id="btnCalculate" class="form-control btn-success btn" value="Calculate"/>
                            </div>
                        <p id="pInfo"></p>
                    <p>Disclaimer</p>
                        <p><%: portalSettings.LoanCalcDisclaimer %></p>
                    </div>
                </div> 
    <div id="loading" style="display:none"><img src="<%: Url.Content("~/Content/images/ajax-loader.gif") %>"  alt="Ajax Loader" />Contacting server....</div>
    <div id="divStatementDlg" style="display:none" ><iframe id="ifStatementDlg" style="height:640px;width:1140px"></iframe></div>

</asp:Content>
