﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Members/Views/Shared/MembersMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Loan Witness Requests
</asp:Content>

<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        /* Make dialog table and buttons responsive */
        #tblRespondWitnessRequest input, #tblRespondWitnessRequest select, #tblRespondWitnessRequest textarea {
            width: 100%;
            box-sizing: border-box;
        }
        #tblRespondWitnessRequest button {
            min-width: 80px;
        }
    </style>
    <script type="text/javascript">
        $(document).ready(function () {
            // Load financial years into dropdown
            $("#cboYear").empty();
            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: '<%: Url.Content("~/api/MembersSystemApi/GetYears") %>',
                data: "{}",
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    var obj = document.getElementById("cboYear");
                    $.each(response, function (index, yrs) {
                        var opt = document.createElement("option");
                        opt.value = yrs.DBName;
                        opt.text = yrs.UserDefinedYearName;
                        obj.appendChild(opt);
                    });
                    $("#cboYear").get(0).selectedIndex = 0;
                    LoadWitnessesRequests();
                },
                error: function (xhr, status, error) {
                    alert('Error - ' + xhr.status + ': ' + xhr.responseText);
                }
            });

            $("#cboYear, #cboLnApplicationStatus").on("change", LoadWitnessesRequests);

            $('#tblWitnessesRequests').dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });

            $('#bdWitnessRequests').on('click', 'a', function (event) {
                event.preventDefault();
                var $tr = $(this).closest('tr');
                var ln_ref_no = $tr.find('td').eq(1).text();
                var ln_mem_no = $tr.find('td').eq(2).text();
                var ln_requested_loanee_name = $tr.find('td').eq(3).text();
                var ln_requested_loan_type = $tr.find('td').eq(4).text();
                var ln_loan_amt = $tr.find('td').eq(5).text();

                $('<div id="divWitnessRequestDialog"></div>').dialog({
                    modal: true,
                    title: "Respond to Witness Request",
                    height: 520,
                    width: 500,
                    responsive: true,
                    show: { effect: "drop", direction: "up", duration: 500 },
                    open: function () {
                        var tbl = "<table id='tblRespondWitnessRequest' border=0 style='width:100%;'>";
                        tbl += "<tbody>";
                        tbl += "<tr><td>Loan Ref. No:</td><td><input type='text' id='txtRequestLoanRefNo' value='" + ln_ref_no + "' disabled /></td></tr>";
                        tbl += "<tr><td>Loanee:</td><td><input type='text' id='txtRequestLoaneeName' value='" + ln_requested_loanee_name + "' disabled /></td></tr>";
                        tbl += "<tr><td>Member No:</td><td><input type='text' id='txtRequestLoaneeMemberNo' value='" + ln_mem_no + "' disabled /></td></tr>";
                        tbl += "<tr><td>Loan Type:</td><td><input type='text' id='txtRequestLoanType' value='" + ln_requested_loan_type + "' disabled /></td></tr>";
                        tbl += "<tr><td>Loan Amount:</td><td><input type='text' id='txtRequestLoanAmount' value='" + ln_loan_amt + "' disabled /></td></tr>";
                        tbl += "<tr><td>Response:</td><td><select id='cboWitnesssResponse'><option value='' selected>(SELECT)</option><option value='accepted'>Accept</option><option value='rejected'>Reject</option></select></td></tr>";
                        tbl += "<tr><td>Notes/Reason:</td><td><textarea id='txtResponseReason' disabled></textarea></td></tr>";
                        tbl += "<tr><td colspan='2' style='text-align:center; padding-top:10px;'>";
                        tbl += "<button type='button' id='btnOK' class='btn btn-primary' style='margin-right:10px;'>OK</button>";
                        tbl += "<button type='button' id='btnCancel' class='btn btn-secondary'>Cancel</button>";
                        tbl += "</td></tr>";
                        tbl += "</tbody></table>";
                        $(this).html(tbl);

                        $("#cboWitnesssResponse").on('change', function () {
                            $("#txtResponseReason").val("").prop("disabled", false);
                        });

                        $("#btnCancel").on("click", function () {
                            $("#divWitnessRequestDialog").dialog("close");
                        });

                        $("#btnOK").on("click", function () {
                            var responseIndex = $("#cboWitnesssResponse").prop("selectedIndex");
                            if (responseIndex === 0) {
                                alert("Select Response");
                                return;
                            }
                            var confirmMsg = responseIndex === 1 ?
                                "Confirm Acceptance of Loan Application Witness?" :
                                "Confirm Rejection of Loan Application Request?";

                            xDialogConfirm(confirmMsg, "Confirm").then(function () {
                                xDialogMemberCredetials().then(function (data) {
                                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                                    var pwdslt = getRandomInt(1000, 30000).toString();
                                    var pwd = CryptoJS.MD5(data.UserPass).toString() + pwdslt;
                                    var sltpwd = CryptoJS.MD5(pwd).toString();
                                    var outData = {
                                        'DBName': $("#cboYear").val(),
                                        'LoanRefNo': $("#txtRequestLoanRefNo").val(),
                                        'Response': $("#cboWitnesssResponse").val(),
                                        'Notes': $("#txtResponseReason").val(),
                                        'Password': sltpwd,
                                        'Salt': pwdslt
                                    };
                                    $.ajax({
                                        headers: { __RequestVerificationToken: csrfToken },
                                        type: "POST",
                                        url: '<%: Url.Content("~/api/MembersSystemApi/ProcessMemberLoanApplicationWitnessResponse") %>',
                                        data: JSON.stringify(outData),
                                        contentType: "application/json; charset=utf-8",
                                        dataType: "json",
                                        success: function (response) {
                                            alert(response);
                                            $("#divWitnessRequestDialog").dialog("close");
                                            LoadWitnessesRequests();
                                        },
                                        error: function (xhr) {
                                            alert('Error - ' + xhr.status + ': ' + xhr.responseText);
                                        }
                                    });
                                });
                            });
                        });
                    },
                    close: function () {
                        $(this).dialog("destroy").remove();
                    }
                });
            });

            function LoadWitnessesRequests() {
                $("#tblWitnessesRequests > tbody:last").children().remove();
                var dbname = $("#cboYear").val();
                if (!dbname) return;

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: '<%: Url.Content("~/api/MembersSystemApi/GetMemberWitnessRequests") %>',
                    data: JSON.stringify({ 'DBName': dbname, 'LoanStatus': $("#cboLnApplicationStatus").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var tbl_row = "";
                        $.each(response, function (index, item) {
                            tbl_row += "<tr>";
                            tbl_row += "<td>" + item.LoanDate + "</td>";
                            tbl_row += "<td>" + item.LoanRefNo + "</td>";
                            tbl_row += "<td>" + item.LoaneeMemberNo + "</td>";
                            tbl_row += "<td>" + item.LoaneeNames + "</td>";
                            tbl_row += "<td>" + item.LoanTypeName + "</td>";
                            tbl_row += "<td>" + (+item.RequestedAmount).formatMoney() + "</td>";
                            tbl_row += "<td>" + item.WitnessResponse + "</td>";
                            tbl_row += "<td><a href=''>Respond</a></td>";
                            tbl_row += "<td>" + item.LoanProcessStatus + "</td>";
                            tbl_row += "</tr>";
                        });
                        $("#bdWitnessRequests").append(tbl_row);
                    },
                    error: function (xhr) {
                        alert('Error - ' + xhr.status + ': ' + xhr.responseText);
                    }
                });
            }
        });
    </script>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <div class="card bg-white">
        <h3 class="p-3 fs-5">Loan Witnesses Requests</h3>
        <hr class="m-0 p-0"/>
        <div class="row p-3">
            <div id="div1" class="col-12 col-md-8">
                <form id="frmMain" name="frmMain">
                    <%= Html.AntiForgeryToken() %>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label">Financial Year:</label>
                            <select id="cboYear" class="form-select">
                                <option value="selectyear">SELECT YEAR</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Loan Application Status:</label>
                            <select id="cboLnApplicationStatus" class="form-select">
                                <option value="pending" selected>ACTIVE</option>
                                <option value="">ANY</option>
                            </select>
                        </div>
                    </div>

                    <div id="divWitnessesRequests" class="table-responsive">
                        <table id='tblWitnessesRequests' class='table table-bordered table-responsive text-nowrap'>
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Ref.No</th>
                                    <th>MemberNo</th>
                                    <th>Names</th>
                                    <th>Loan Type</th>
                                    <th>Loan Amount</th>
                                    <th>Status</th>
                                    <th>Respond</th>
                                    <th>Loan Request Status</th>
                                </tr>
                            </thead>
                            <tbody id='bdWitnessRequests'></tbody>
                        </table>
                    </div>
                </form>
            </div>
        </div>
    </div>
</asp:Content>
