﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Bank/Views/Shared/StaffMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Customer Accounts
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        .tblDRCRDetails {
             margin: 1px;
             border: 1em;
             padding-left:1em;
             padding-top:1em;
             border-collapse:separate;
         }
         
         /*use this for to calculate totals*/  
         .colamount {
            text-align:right;
         }
         tr.row_selected td{background-color:lawngreen;}
   </style>

    
    <script type="text/javascript"  >
        //read on closures to minimize global variables collisions
        var CurrDispAccount = null;
        var CustomerAccountTypes = null;
        var CurrentCustomerAccType = null;
        $(document).ready(function () {
            ClearInputs();
            $('#frmMain').on('mouseup', '[type=text],[type=date]', function (e) { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                e.preventDefault();
            });
            $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).select();
            });
            $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).addClass("textfocused");
            });
            $('#frmMain').on('focusout', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).removeClass("textfocused");
            });

            
            $("#txtStartDate").datepicker({ dateFormat: 'dd/mm/yy' });
            $("#tblAccountMembers").dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            $("#tblAccountMembers > tbody:last").children().remove();

            $("#tblMoreDetails").dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            $("#tblMoreDetails > tbody:last").children().remove();

            $("#cboAccountTypeNo").on("change", function () {
                CurrentCustomerAccType = null;
                if ($("#cboAccountTypeNo").val() == "") return;
                if (CustomerAccountTypes == null) {
                    alert("An error has accoured. Please reload");
                    return;
                }
                CurrentCustomerAccType = $.grep(CustomerAccountTypes, function (e) {
                    return e.AccountNo == $("#cboAccountTypeNo").val();
                });
                if (CurrentCustomerAccType[0] !== undefined) {
                    CurrentCustomerAccType = CurrentCustomerAccType[0];
                }
            });


            $('#bdAccountMembers').on('click', 'a', function (event) {
                event.preventDefault();

                var rm_row = $(this).closest('tr');
                var rm_mem_name = rm_row.find('td').eq(5).text();
                var rm_mem_id = rm_row.find('td').eq(4).text();
                xDialogConfirm("Remove Member: " + rm_mem_name + " IDNo: " + rm_mem_id + "?", "Confirm").then(function () {
                    $(rm_row).remove();
                    CalcPettyCashTotals();
                });
                return false;
            });

            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/BankSystemApi/GetMembersAccountsConfig") %>",
                data: "{}",
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    CustomerAccountTypes = response.AccTypes;
                    var saccobranches = response.Branches;
                    SaccoSettings = response.SaccoSettings;
                    $.each(saccobranches, function (index, saccobranch) {
                        $("#cboBranch").append("<option value='" + saccobranch.BranchCode + "'>" + saccobranch.BranchName + "(" + saccobranch.BranchCode + ")</option>");
                    });
                    $.each(CustomerAccountTypes, function (index, accType) {
                        $("#cboAccountTypeNo").append("<option value='" + accType.AccountNo + "'>" + accType.AccountName + "(" + accType.AccountNo + ")</option>");
                    });
                    DisableEdit();
                },
                error: function (xhr, status, error) {
                    var errorMessage = xhr.status + ': ' + xhr.responseText;
                    alert('Error - ' + errorMessage);
                }
            });

            $('#tabs').on('tabsactivate', function (event, ui) {
                var newIndex = ui.newTab.index();
            });
            $("#linkAddMember").on('click', function (e) {
                e.preventDefault();
                e.stopPropagation();
                xDialogSearchMemberRecord(AccountMask).then(function (data) {
                    var new_row = "<tr><td><input type='checkbox'></input></td><td>" + data.MemberNo + "</td><td>" + data.EmployerCode + "</td><td>" + data.PayrollNo + "</td><td>" + data.IDNumber + "</td><td>" + data.MemberNames + "</td><td><a href='#'>Remove</a></td></tr>";
                    $("#bdAccountMembers").append(new_row);
                });
            });
            $("#linkGenerateNo").on('click', function (e) {
                e.preventDefault();
                e.stopPropagation();

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GenerateMemberAccount") %>",
                    data: JSON.stringify({ 'HeaderAccount': $("#cboAccountTypeNo").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        $("#txtAccountNo").val(response);
                        $("#txtAccountNo").focus();
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            });


            $("#btnActivateAcc").on('click', function () {
                ChangeAccountStatus("Active");
            });

            $("#btnSuspendAcc").on('click', function () {
                ChangeAccountStatus("Suspended");
            });
            $("#btnCloseAcc").on('click', function () {
                ChangeAccountStatus("Closed");
            });
            $("#btnSearchAcc").on('click', function () {
                xDialogSearchCustomerAccount(AccountMask).then(function (data) {
                    CurrDispAccount = data.AccountNo;
                    DisplayAccount();
                });
            });
            $("#btnEditAcc").on('click', function () {
                if (CurrDispAccount == null) { alert("Nothing to edit"); return; }
                EnableEdit();
                $("#cboAccountTypeNo").attr("disabled", "disabled");
            });
            $("#btnCancel").on('click', function () {
                DisableEdit();
                ClearInputs();
                DisplayAccount();
            });

            $("#txtAccountNo").mask(AccountMask);
            $("#txtSavingsAccNo").mask(AccountMask);
            $("#txtSavingsAccNo").on('focusout', function () {
                GetAccountName($("#txtSavingsAccNo").val()).then(function (data) { $("#txtSavingsAccountsName").val(data); })
            });
            $("#txtDuration").on('focusout', function () {
                ProcessFXDFutureDate();
                DispFXDResults();
            });
            $("#txtStartDate").on('focusout', function () {
                ProcessFXDFutureDate();
            });
            $("#cboDuration").on('change', function () {
                ProcessFXDFutureDate();
                DispFXDResults();
            });
            $("#txtTaxRate").on('focusout', function () {
                DispFXDResults();
            });
            $("#txtProcessingFees").on('focusout', function () {
                DispFXDResults();
            });
            $("#txtInterestRate").on('focusout', function () {
                DispFXDResults();
            });
            $("#txtContractAmount").on('focusout', function () {
                DispFXDResults();
            });
            $("#cboMethod").on('change', function () {
                DispFXDResults();
            });
            $("#cboDuration").on('change', function () {
                DispFXDResults();
            });
            $("#cboRateType").on('change', function () {
                DispFXDResults();
            });
            
            $("#btnNewAcc").on('click', function () {
                CurrDispAccount = null;
                ClearInputs();
                EnableEdit();

                $("#btnDeleteAcc").attr("disabled", "disabled");
                $("#btnActivateAcc").attr("disabled", "disabled");
                $("#btnCloseAcc").attr("disabled", "disabled");
                $("#btnSuspendAcc").attr("disabled", "disabled");
            });

            $("#btnSaveAcc").on('click', function () {
                xDialogConfirm("Save new/edited account?", "Confirm").then(function () {
                    xDialogGetUserCredetials().then(function (credentials) {

                        var UserName = credentials.UserName;
                        var Password = credentials.UserPass;
                        var pwdslt = getRandomInt(1000, 30000);
                        pwdslt = pwdslt.toString();
                        var pwd = CryptoJS.MD5(Password).toString();
                        pwd = pwd + pwdslt;
                        var sltpwd = CryptoJS.MD5(pwd).toString();

                        //TODO: Add more validation before sending to server


                        if ($("#txtAccountName").val().trim().length < 3) { alert("Invalid Account Name"); return; }
                        var acc_memberCount = 0;
                        var AccMembersList = new Array();
                        var dblTotalAmount = 0;

                        $("#tblAccountMembers tbody").find('tr').each(function (i) {
                            var AccMemberEntry = {};
                            var row = $(this); //store in variable for faster access
                            AccMemberEntry.EmployerCode = row.find('td:eq(2)').text();
                            AccMemberEntry.PayrollNo = row.find('td:eq(3)').text();
                            AccMemberEntry.IsDefaultAccount = row.find('td:eq(0)').find('input:eq(0)').prop('checked');

                            AccMembersList[acc_memberCount] = AccMemberEntry;
                            acc_memberCount++;

                        });
                        if (acc_memberCount <= 0) {
                            alert("Account must have atleast one member");
                            return;
                        }
                        
                        var AccMgrDetails = {
                            'EditAccountNo': CurrDispAccount,
                            'NewAccountNo': $("#txtAccountNo").val(),
                            'AccountName': $("#txtAccountName").val(),
                            'AccountTypeCode': $("#cboAccountTypeNo").val(),
                            'RelatedSavingsAccount': $("#txtSavingsAccNo").val(),
                            'BranchCode': $("#cboBranch").val(),
                            'FileNo': $("#txtFileNo").val(),
                            'Instructions': $("#txtInstructions").val(),
                            'Notes': $("#txtNotes").val(),
                            'IsSigned': $("#chkSigned").prop('checked'),

                            'ContractMaturityDate': $("#txtMaturityDate").val(),
                            'ContractAmount': $("#txtContractAmount").val(),
                            'ContractStartDate': $("#txtStartDate").val(),
                            'ContractDuration': $("#txtDuration").val(),
                            'ContractDurationType': $("#cboDuration").val(),
                            'ContractInterestRate': $("#txtInterestRate").val(),
                            'ContractInterestType': $("#cboRateType").val(),
                            'ProcessingFees': $("#txtProcessingFees").val(),
                            'ContractMethod': $("#cboMethod").val(),
                            'ContractTaxRate': $("#txtTaxRate").val(),
                            'TransferAmount': $("#cboTransferAmt").val(),

                            'AccMembersList': AccMembersList
                        }

                        var outData = {
                            'UserName': UserName,
                            'Password': sltpwd,
                            'Salt': pwdslt,
                            'AccMgrDetails': AccMgrDetails
                        }

                        outData = JSON.stringify(outData);
                        var csrfToken = $("input[name='__RequestVerificationToken']").val();
                        $.ajax({
                            headers: { __RequestVerificationToken: csrfToken },
                            type: "POST",
                            url: "<%: Url.Content("~/api/BankSystemApi/SaveCustomerBankAccount") %>",
                            data: outData,
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            success: function (response) {
                                alert("Saved");
                                CurrDispAccount = $("#txtAccountNo").val();
                                DisplayAccount();
                                DisableEdit();
                                
                                

                            },
                            error: function (xhr, status, error) {
                                var errorMessage = xhr.status + ': ' + xhr.responseText;
                                alert('Error - ' + errorMessage);
                            }
                        });
                    });
                });
            });

            function ProcessFXDFutureDate() {
                if ($("#txtStartDate").val() == "") return;
                if ($("#txtDuration").val() == "") return;

                var outData = {
                    'StartDate': $("#txtStartDate").val(),
                    'PeriodValue': $("#txtDuration").val(),
                    'PeriodType': $("#cboDuration").val()
                }
                outData = JSON.stringify(outData);
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/ProcessFXDMaturityDate") %>",
                            data: outData,
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            success: function (response) {
                                $("#txtMaturityDate").val(response);
                            },
                            error: function (xhr, status, error) {
                                var errorMessage = xhr.status + ': ' + xhr.responseText;
                                alert('Error - ' + errorMessage);
                            }
                        });
            }
            function ChangeAccountStatus(NewAccStatus, StatusReason) {
                NewAccStatus = NewAccStatus || '';
                StatusReason = StatusReason || '';
                if (CurrDispAccount == null) { alert("Nothing to edit"); return; }
                xDialogConfirm("Change account Status to " + NewAccStatus + " for account " + CurrDispAccount + " ?", "Confirm").then(function () {
                    xDialogGetUserCredetials().then(function (credentials) {
                        var UserName = credentials.UserName;
                        var Password = credentials.UserPass;
                        var pwdslt = getRandomInt(1000, 30000);
                        pwdslt = pwdslt.toString();
                        var pwd = CryptoJS.MD5(Password).toString();
                        pwd = pwd + pwdslt;
                        var sltpwd = CryptoJS.MD5(pwd).toString();
                        var outData = {
                            'UserName': UserName,
                            'Password': sltpwd,
                            'Salt': pwdslt,
                            'AccountNo': CurrDispAccount,
                            'NewStatus': NewAccStatus,
                            'StatusReason': StatusReason
                        }

                        outData = JSON.stringify(outData);
                        var csrfToken = $("input[name='__RequestVerificationToken']").val();
                        $.ajax({
                            headers: { __RequestVerificationToken: csrfToken },
                            type: "POST",
                            url: "<%: Url.Content("~/api/BankSystemApi/ChangeCustomerBankAccountStatus") %>",
                            data: outData,
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            success: function (response) {
                                $("#txtStatus").val(NewAccStatus.toUpperCase());
                                DisableEdit();
                                alert("Status Changed");
                            },
                            error: function (xhr, status, error) {
                                var errorMessage = xhr.status + ': ' + xhr.responseText;
                                alert('Error - ' + errorMessage);
                            }
                        });
                    });
                });
            }

            function DisplayAccount() {
                if (CurrDispAccount == null) {
                    ClearInputs();
                    return;
                }
                ClearInputs();
                $("#divCurrAcc").html("A/C No: " + CurrDispAccount);

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: global_site_root + '/api/BankSystemApi/GetDetailedCustomerAccount',
                    data: JSON.stringify({ 'CustomerAccount': CurrDispAccount }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json"
                }).success(function (rtn_account_Details) {
                    var AccountDetails = rtn_account_Details.MemberAcc;
                    $("#txtAccountNo").val(AccountDetails.AccountNo);
                    $("#txtAccountName").val(AccountDetails.AccountName);
                    $("#txtFileNo").val(AccountDetails.FileNo);
                    $("#txtInstructions").val(AccountDetails.Instructions);
                    $("#txtStatus").val(AccountDetails.Status);
                    $("#txtNotes").val(AccountDetails.AccountNotes);
                    $("#cboBranch").val(AccountDetails.BranchCode);
                    $("#cboAccountTypeNo").val(AccountDetails.AccountTypeAccNo);
                    $("#txtSavingsAccNo").val(AccountDetails.SavingsAccount);
                    $("#txtSavingsAccountsName").val(AccountDetails.SavingsAccountName);
                    $("#txtContractNo").val(AccountDetails.ContractNo);
                    $("#txtDuration").val(AccountDetails.InterestDuration);
                    $("#txtMaturityDate").val(AccountDetails.MaturityDate);
                    if (AccountDetails.InterestIsPer.toUpperCase() === "Y".toUpperCase()) { $("#cboRateType").prop('selectedIndex', 0); }
                    if (AccountDetails.InterestIsPer.toUpperCase() === "M".toUpperCase()) { $("#cboRateType").prop('selectedIndex', 1); }
                    if (AccountDetails.InterestIsPer.toUpperCase() === "D".toUpperCase()) { $("#cboRateType").prop('selectedIndex', 2); }
                    $("#txtTaxRate").val(AccountDetails.TaxRate);
                    $("#txtContractAmount").val(AccountDetails.InitialPrincipalRequired.formatMoney());
                    $("#txtStartDate").val(AccountDetails.InterestStartDate);
                    if (AccountDetails.InterestDurationType.toUpperCase() === "Years".toUpperCase()) { $("#cboDuration").prop('selectedIndex', 0); }
                    if (AccountDetails.InterestDurationType.toUpperCase() === "Months".toUpperCase()) { $("#cboDuration").prop('selectedIndex', 1); }
                    if (AccountDetails.InterestDurationType.toUpperCase() === "Days".toUpperCase()) { $("#cboDuration").prop('selectedIndex', 2); }
                    $("#txtInterestRate").val(AccountDetails.InterestRate.formatMoney());
                    $("#txtProcessingFees").val(AccountDetails.ProcessingFees.formatMoney());
                    $("#txtGrossInterest").val(AccountDetails.ComputedInterest.formatMoney());
                    $("#txtTaxCharged").val(AccountDetails.ComputedTax.formatMoney());
                    $("#txtNetInterest").val(AccountDetails.ComputedNetInterest.formatMoney());
                    $("#cboMethod").prop('selectedIndex', 0); 
                    if (AccountDetails.UseSimpleInterest == "N") { $("#cboMethod").prop('selectedIndex', 1); }
                    $("#cboTransferAmt").prop('selectedIndex', 0)

                    if (AccountDetails.IsSigned) { $("#chkSigned").prop('checked', true); }
                    
                    var rtn_members = rtn_account_Details.AccountMembers;
                    var tbl_row = "";
                    $.each(rtn_members, function (index, rtn_member) {
                        tbl_row += "<tr>";
                        tbl_row += "<td><input type='checkbox' " + (rtn_member.SalaryAccount == CurrDispAccount ? "checked" : "") + " /></td>";
                        tbl_row += "<td>" + rtn_member.MemberNo + "</td>";
                        tbl_row += "<td>" + rtn_member.EmployerCode + "</td>";
                        tbl_row += "<td>" + rtn_member.PayrollNo + "</td>";
                        tbl_row += "<td>" + rtn_member.IDNumber + "</td>";
                        tbl_row += "<td>" + rtn_member.FullNames + "</td>";
                        tbl_row += "<td><a href='#'>Remove</a></td>";
                        tbl_row += "</tr>";
                    });
                    $("#bdAccountMembers").append(tbl_row);

                    tbl_row = "";
                    tbl_row += "<tr><td>Account No</td><td>" + AccountDetails.AccountNo + "</td></tr>";
                    tbl_row += "<tr><td>Account Name</td><td>" + AccountDetails.AccountName + "</td></tr>";
                    tbl_row += "<tr><td>Account Type</td><td>" + AccountDetails.AccountType + "</td></tr>";
                    tbl_row += "<tr><td>Type Code</td><td>" + AccountDetails.AccountTypeAccNo + "</td></tr>";
                    tbl_row += "<tr><td>Type Name</td><td>" + AccountDetails.AccountTypeName + "</td></tr>";
                    tbl_row += "<tr><td>Created By</td><td>" + AccountDetails.CreatedBy + "</td></tr>";
                    tbl_row += "<tr><td>Activated By</td><td>" + AccountDetails.ActivatedBy + "</td></tr>";
                    tbl_row += "<tr><td>ATM Card No</td><td>" + AccountDetails.AtmCardNumber + "</td></tr>";
                    tbl_row += "<tr><td>Branch</td><td>" + AccountDetails.BranchCode + "-" + AccountDetails.BranchName + "</td></tr>";
                    tbl_row += "<tr><td>Opening Date</td><td>" + AccountDetails.OpenningDate + "</td></tr>";
                    tbl_row += "<tr><td>Member Count</td><td>" + rtn_members.length + "</td></tr>";
                    tbl_row += "<tr><td>Available Balance</td><td>" + rtn_account_Details.AvailableBalance.formatMoney() + "</td></tr>";
                    tbl_row += "<tr><td>Ledger Balance</td><td>" + rtn_account_Details.LedgerBalance.formatMoney() + "</td></tr>";
                    tbl_row += "<tr><td>UnCleared Cheques</td><td>" + rtn_account_Details.UnclearedCheques + "</td></tr>";


                    $("#txtFxdCurrBal").val(rtn_account_Details.AvailableBalance.formatMoney());
                    //some accounts dont display net amount earned correctly lets try to redisplay for FXD
                    if (AccountDetails.IsFixedDepositAccount) {
                        DispFXDResults();
                    }
                    $("#bdMoreDetails").append(tbl_row);
                    $("#divAccountMembers").find('input,textarea,select,checkbox,a').attr("disabled", "disabled");
                    $("#divContract").find('input,textarea,select,checkbox,a').attr("disabled", "disabled");
                    $('#tblAccountMembers tbody td:nth-child(7),th:nth-child(7)').hide();
                }).error(function (xhr, status, error) {
                    var errorMessage = xhr.status + ': ' + xhr.responseText;
                    alert('Error - ' + errorMessage);
                }).then (function () {
                    
                });



            }
            function LoadComboDisplayText(cboItem, itemvalue) {
                for (var i = 0; i < cboItem.options.length; ++i) {
                    if (cboItem.options[i].value == itemvalue) {
                        cboItem.selectedIndex = i;
                    }
                }
            }
            function ClearInputs() {
                $("#divCurrAcc").html("");
                $("#txtAccountNo").val("");
                $("#txtAccountName").val("");
                $("#chkSigned").prop('checked', false)
                $("#txtStatus").val("");
                $("#txtNotes").empty();
                $("#txtInstructions").val("");
                $("#txtFileNo").val();
                $("#cboAccountTypeNo").prop('selectedIndex', 0)
                $("#cboBranch").prop('selectedIndex', 0)
                $("#txtSavingsAccNo").val("");
                $("#txtSavingsAccountsName").val("");
                $("#txtContractNo").val("");
                $("#txtDuration").val("");
                $("#txtMaturityDate").val("");
                $("#cboRateType").prop('selectedIndex', 0)
                $("#txtTaxRate").val("");
                $("#txtProcessingFees").val("");
                $("#txtContractAmount").val("");
                $("#txtStartDate").val("");
                $("#cboDuration").prop('selectedIndex', 1); //default to months
                $("#txtInterestRate").val("");
                $("#cboMethod").prop('selectedIndex', 0)
                $("#cboTransferAmt").prop('selectedIndex', 0)
                $("#txtFxdCurrBal").val(0);
                
                $("#txtGrossInterest").val("");
                $("#txtTaxCharged").val("");
                $("#txtNetInterest").val("");

                
                $("#tblSignatories > tbody:last").children().remove();
                $("#tblAccountMembers > tbody:last").children().remove();
                $("#tblMoreDetails > tbody:last").children().remove();

            }
            function DispFXDResults() {
                var Zero = 0;
                $("#txtGrossInterest").val(Zero.formatMoney());
                $("#txtTaxCharged").val(Zero.formatMoney());
                $("#txtNetInterest").val(Zero.formatMoney());

                if($("#txtMaturityDate").val()=="")return;
                if($("#txtContractAmount").val()=="")return;
                if($("#txtStartDate").val()=="")return;
                if($("#txtDuration").val()=="")return;
                if($("#cboDuration").val()=="")return;
                if($("#txtInterestRate").val()=="")return;
                if($("#cboRateType").val()=="")return;
                if($("#txtProcessingFees").val()=="")return;
                if($("#cboMethod").val()=="")return;
                if($("#txtTaxRate").val()=="")return;
                

                var AccMgrDetails = {
                    'ContractMaturityDate': $("#txtMaturityDate").val(),
                    'ContractAmount': $("#txtContractAmount").val(),
                    'ContractStartDate': $("#txtStartDate").val(),
                    'ContractDuration': $("#txtDuration").val(),
                    'ContractDurationType': $("#cboDuration").val(),
                    'ContractInterestRate': $("#txtInterestRate").val(),
                    'ContractInterestType': $("#cboRateType").val(),
                    'ProcessingFees': $("#txtProcessingFees").val(),
                    'ContractMethod': $("#cboMethod").val(),
                    'ContractTaxRate': $("#txtTaxRate").val(),
                    'TransferAmount': $("#cboTransferAmt").val(),
                }
                var outData = {
                    'AccMgrDetails': AccMgrDetails
                }
                outData = JSON.stringify(outData);
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/ProcessFixedDepositResults") %>",
                            data: outData,
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            success: function (response) {
                                $("#txtGrossInterest").val(response.ComputedInterest.formatMoney());
                                $("#txtTaxCharged").val(response.ComputedTax.formatMoney());
                                $("#txtNetInterest").val(response.ComputedNetInterest.formatMoney());
                            },
                            error: function (xhr, status, error) {
                                var errorMessage = xhr.status + ': ' + xhr.responseText;
                                alert('Error - ' + errorMessage);
                            }
                        });
            }
            function DisableEdit() {
                //$("#divDataCapture :input").attr("readonly", "readonly");
                //$("#divDataCapture :select").attr("readonly", "readonly");
                //$("#divDataCapture").find('input,textarea,select,checkbox').attr("readonly", "readonly");
                $("#divDataCapture").find('input,textarea,select,checkbox').attr("disabled", "disabled");
                $("#divAccountMembers").find('input,textarea,select,checkbox,a').attr("disabled", "disabled");

                $("#btnSaveAcc").attr("disabled", "disabled");
                $("#btnCancel").attr("disabled", "disabled");
                $("#btnDeleteAcc").attr("disabled", "disabled");
                $("#btnActivateAcc").attr("disabled", "disabled");
                $("#btnCloseAcc").attr("disabled", "disabled");
                $("#btnSuspendAcc").attr("disabled", "disabled");

                $("#btnNewAcc").removeAttr("disabled");
                $("#btnEditAcc").removeAttr("disabled");
                $("#btnSearchAcc").removeAttr("disabled");

                $("#divLinks").hide();
                $('#tblAccountMembers tbody td:nth-child(7),th:nth-child(7)').hide();



            }
            function EnableEdit() {
                //$("#divDataCapture :input").attr("readonly", "readonly");
                //$("#divDataCapture :select").attr("readonly", "readonly");
                //$("#divDataCapture").find('input,textarea,select').attr("readonly", "readonly");
                $("#divContract").find('input,textarea,select,checkbox,a').removeAttr("disabled");
                $("#divDataCapture").find('input,textarea,select').removeAttr("disabled");
                $("#divAccountMembers").find('input,textarea,select,checkbox,a').removeAttr("disabled");
                $("#btnSaveAcc").removeAttr("disabled");
                $("#btnCancel").removeAttr("disabled");
                $("#btnDeleteAcc").removeAttr("disabled");
                $("#btnActivateAcc").removeAttr("disabled");
                $("#btnCloseAcc").removeAttr("disabled");
                $("#btnSuspendAcc").removeAttr("disabled");

                $("#btnNewAcc").attr("disabled", "disabled");
                $("#btnEditAcc").attr("disabled", "disabled");
                $("#btnSearchAcc").attr("disabled", "disabled");

                $("#divLinks").show();
                $('#tblAccountMembers tbody td:nth-child(7),th:nth-child(7)').show();
                $("#txtStatus").attr("disabled", "disabled");
            }

            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion({
                    heightStyle: "content"
                });
            });
        });
    </script>
</asp:Content>
<asp:Content ID="Content6" ContentPlaceHolderID="FeaturedContent" runat="server">
<h3>Customer Accounts</h3>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <div id="divCurrAcc"></div>
    <div id="tabs">
      <ul>
        <li><a href="#tabs-1">Account Details</a></li>
        <li><a href="#tabs-2">Other Details</a></li>
        <li><a href="#tabs-3">Signatories</a></li>
        <li><a href="#tabs-4">Contract Details</a></li>
      </ul>
        <form id="frmMain" name="frmMain">
            <%= Html.AntiForgeryToken() %>
            <div id="tabs-1">
                <div id="divDataCapture">
                <table  border="1" style="padding: 1px; margin: 1px;">
                    <tr>
                        <td>
                            Account Type:
                        </td>
                        <td colspan="3">
                            <select id="cboAccountTypeNo">
                                <option selected value="">(SELECT)</option>
                            </select>
                        </td>
                        
                    </tr>
                    <tr>
                        <td>
                           Account No:
                        </td>
                        <td>
                            <input type="text" id="txtAccountNo" />
                        </td>
                        <td>
                           Account Name:
                        </td>
                        <td>
                            <input type="text" id="txtAccountName" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                           Savings A/C No:
                        </td>
                        <td>
                            <input type="text" id="txtSavingsAccNo" />
                        </td>
                        <td>
                           Savings A/C Name:
                        </td>
                        <td>
                            <input type="text" id="txtSavingsAccountsName" readonly="readonly" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                           Status:
                        </td>
                        <td>
                            <input type="text" id="txtStatus" />
                        </td>
                        <td>
                           Branch:
                        </td>
                        <td>
                            <select id="cboBranch">
                                <option selected value="">(SELECT)</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>
                           FileNo:
                        </td>
                        <td>
                            <input type="text" id="txtFileNo" />
                        </td>
                        <td>
                           Signed:
                        </td>
                        <td>
                            <input type="checkbox" id="chkSigned"  />
                        </td>
                    </tr>
                    <tr>
                        <td>
                           Instructions:
                        </td>
                        <td >
                            <textarea id="txtInstructions" name="txtInstructions" ></textarea>
                        </td>
                        <td>
                           Notes/Caution:
                        </td>
                        <td >
                            <textarea id="txtNotes" name="txtNotes" ></textarea>
                        </td>
                    </tr>
                   </table>
                </div>
                <div id="divAccountMembers" style="height:100px;overflow:auto;width:auto;">
                    <table id='tblAccountMembers' class="table-responsive"  style="width:100%">
                            <thead>
                                <tr>
                                <th>IsDefault</th>
                                <th>MemberNo</th>
                                <th>EmpCode</th>
                                <th>PayrollNo</th>
                                <th>IDNo</th>
                                <th>Name</th>
                                <th>Remove</th>
                                </tr>
                            </thead>
                            <tbody id='bdAccountMembers'>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td></td><td></td><td></td><td></td><td></td><td></td><td></td>
                                </tr>
                            </tfoot>
                    </table>
                    
                    </div>
                <div id="divLinks"> <a id="linkAddMember" href="#">Add Member...</a>
                    &nbsp;&nbsp;&nbsp;<a id="linkGenerateNo" href="#">Generate A/C No...</a>
                </div>
            </div>
            <div id="tabs-2">
                <div id="divMoreDetails" style="height:200px;overflow:auto;width:auto;">
                <table id='tblMoreDetails'  class='display' style="width:100%">
                        <thead>
                            <tr>
                            <th><b>Item</b></th>
                            <th><b>Value</b></th>
                            </tr>
                        </thead>
                        <tbody id='bdMoreDetails'>
                        </tbody>
                    <tfoot>
                        <tr>
                            <td></td><td></td>
                        </tr>
                    </tfoot>
                </table>
                </div>
            </div>
            <div id="tabs-3">
                <div id="divSignatories" style="height:200px;overflow:auto;width:auto;">
                <table id='tblSignatories'  class='display' style="width:100%">
                        <thead>
                            <tr>
                            <th><b>IDNo</b></th>
                            <th><b>Name</b></th>
                            <th><b>Type</b></th>
                            </tr>
                        </thead>
                        <tbody id='bdSignatories'>
                        </tbody>
                    <tfoot>
                        <tr>
                            <td></td><td></td>
                        </tr>
                    </tfoot>
                </table>
                </div>
            </div>
            <div id="tabs-4">
                <div id="divContract" style="height:auto;overflow:auto;width:auto;">
                <table id='tblContract'  class='display' style="width:100%">
                        <tr>
                            <td>Contract No:</td><td><input type="text" id="txtContractNo"></td><td>Start Date:</td><td><input type="text" id="txtStartDate"></td>
                        </tr>
                        <tr>
                                <td>Duration:</td><td><input type="text" id="txtDuration"></td><td>Duration in:</td><td>
                                <select id="cboDuration">
                                    <option value="years">Years</option>
                                    <option selected value="months" >Months</option>
                                    <option value="days">Days</option>
                                </select>
                                </td>
                        </tr>
                        <tr>
                            <td>Maturity:</td><td><input type="text" id="txtMaturityDate" readonly="readonly"></td><td>Interest Rate:</td><td><input type="text" id="txtInterestRate"></td>
                        </tr>
                        <tr>
                            <td>Rate Is Per:</td>
                            <td>
                                <select id="cboRateType">
                                    <option selected value="year">Year</option>
                                    <option value="month">Month</option>
                                    <option value="day">Day</option>
                                </select>
                             </td>
                            <td>Method:</td>
                            <td>
                                <select id="cboMethod">
                                    <option selected value="simple">Simple Interest</option>
                                    <option value="compound">Compound Interest</option>
                                </select>
                            </td>
                        </tr>
                    <tr>
                            <td>Tax Rate:</td><td><input type="text" id="txtTaxRate"></td>
                            <td>Processing Fees:</td><td><input type="text" id="txtProcessingFees"></td>
                    </tr>
                    <tr>
                            <td>Contract Amount:</td>
                            <td>
                                <input type="text" id="txtContractAmount" />
                             </td>
                            <td>Transfer Amt:</td>
                            <td>
                                <select id="cboTransferAmt">
                                    <option selected value="">(SELECT)</option>
                                    <option value="yes">YES</option>
                                    <option value="no">NO</option>
                                </select>
                            </td>
                        </tr>
                    <tr>
                            <td>Gross Interest:</td><td><input type="text" id="txtGrossInterest" readonly="readonly"></td>
                            <td>Tax Charged:</td><td><input type="text" id="txtTaxCharged" readonly="readonly"></td>
                    </tr>
                    <tr>
                            <td>Net Interest:</td><td><input type="text" id="txtNetInterest" readonly="readonly"></td>
                            <td>Current Bal:</td><td><input type="text" id="txtFxdCurrBal" readonly="readonly"></td>
                            
                    </tr>
                </table>
                </div>
            </div>
            <hr style="color:red" />
                <div id="divButtons" style="height:80px;overflow:auto;width:auto;">    
                    <table>
                        <tr>
                            <td><input type="button" value="Search" id="btnSearchAcc" /></td>
                            <td><input type="button" value="New" id="btnNewAcc" /></td>
                            <td><input type="button" value="Edit" id="btnEditAcc" /></td>
                            <td><input type="button" value="Save" id="btnSaveAcc" /></td>
                            <td><input type="button" value="Cancel" id="btnCancel" /></td>
                            <td><input type="button" value="Suspend" id="btnSuspendAcc" /></td>
                            <td><input type="button" value="Close A/C" id="btnCloseAcc" /></td>
                            <td><input type="button" value="Activate" id="btnActivateAcc" /></td>
                            <td><input type="button" value="Delete" id="btnDeleteAcc" /></td>
                        </tr>
                    </table>
                </div>
        </form>
    </div>
    
    
</asp:Content>


