﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Bank/Views/Shared/StaffMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Members Loans Applications
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        .tblDRCRDetails {
             margin: 1px;
             border: 1em;
             padding-left:1em;
             padding-top:1em;
             border-collapse:separate;
         }
         
         /*use this for to calculate totals*/  
         .colamount {
            text-align:right;
         }
         tr.row_selected td{background-color:lawngreen;}
   </style>

    
    <script type="text/javascript"  >
        $(document).ready(function () {
            var LoanToAppraise = null;
            var NominieeApprovalRequired = false;
                $('#frmMain').on('mouseup', '[type=text],[type=date]', function (e) { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                    e.preventDefault();
                });
                $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                    $(this).select();
                });
                $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                    $(this).addClass("textfocused");
                });
                $('#frmMain').on('focusout', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                    $(this).removeClass("textfocused");
                });

                

                $("#cboYear").empty();
                $("#cboBranch").empty();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetAccountsModulesConfig") %>",
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var years = response.Years;
                        var saccobranches = response.Branches;
                        SaccoSettings = response.SaccoSettings;
                        var obj = document.getElementById("cboYear");
                        $.each(years, function (index, yrs) {
                            var opt = document.createElement("option");
                            opt.value = yrs.DBName;
                            opt.text = yrs.UserDefinedYearName;
                            opt.selected = true;
                            obj.appendChild(opt);
                        });
                        
                        var obj = document.getElementById("cboBranch");
                        var opt = document.createElement("option");
                        opt.value = "";
                        opt.text = "(ANY BRANCH)";
                        obj.appendChild(opt);
                        $.each(saccobranches, function (index, saccobranch) {
                            var opt = document.createElement("option");
                            opt.value = saccobranch.BranchCode;
                            opt.text = saccobranch.BranchName + "(" + saccobranch.BranchCode + ")";
                            obj.appendChild(opt);
                        });
                        LoadFinancialPeriods();
                        
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });

                $('#tabs').on('tabsactivate', function (event, ui) {
                    var newIndex = ui.newTab.index();
                    if (newIndex == 1) {
                        
                    }
                });


                $("#btnPrint").on('click', function () {
                    var rptHeader = "<b>" + CompanyName + "<br>" + CompanyAddress + "</br>" + "Members Online Loan Applications";
                    $("#divLoanApplications").printThis({
                        debug: false,
                        pageTitle: "Report",
                        removeInline: true,
                        printContainer: true,
                        importCSS: true,
                        header: rptHeader
                    });

                });
                $("#btnAppraise").on('click', function () {
                    var appraisal_ok = true;
                    if (LoanToAppraise == null) {
                        alert("Select loan to Appraise");
                        appraisal_ok = false;
                        return;
                    }
                    
                    if (NominieeApprovalRequired === true) {
                        if (LoanToAppraise.memberLoanApplication.ManagerApprovalStatus.toString().toLowerCase() != "accepted") {
                            alert("Loan Must be approved/accepted by unit head before proceeding")
                            appraisal_ok = false;
                            return;
                        }
                    }
                    
                    if (LoanToAppraise.memberLoanApplicationGuarantor != null) {
                        var loanGuarantors = LoanToAppraise.memberLoanApplicationGuarantor;
                        $.each(loanGuarantors, function (index, loanGuarantor) {
                            if (loanGuarantor.GuarantorResponse.toString().toLowerCase() == "pending".toLowerCase()) {
                                alert("All guarantors must Repond before appraisal");
                                appraisal_ok = false;
                                return;
                            }
                        });
                    }
                    if (LoanToAppraise.memberLoanApplicationOffset != null) {
                        var loanOffsets = LoanToAppraise.memberLoanApplicationOffset;
                        $.each(loanOffsets, function (index, loanOff) {
                            if (loanOff.ApprovalStatus.toString().toLowerCase() == "pending".toLowerCase()) {
                                alert("All offsets must be approved before appraisal");
                                appraisal_ok = false;
                                return;
                            }
                        });
                    }
                    if (appraisal_ok === true) {
                        var appraisal_url ="/Bank/BankSystem/LoanAppraisalEdit?LoanSerialNumber=&MemberApplicationNo=" + LoanToAppraise.LoanRefNo + "&DBName=" + $("#cboYear").val() + "&ClassCode=BOSA";
                        //document.location = appraisal_url
                        window.location = appraisal_url
                        
                    }
                });
                $("#tblLoanApplications").dataTable({
                    "paging": false,
                    "ordering": false,
                    "info": false,
                    "searching": false
                });
                $('#tblLoanApplications').on('click', 'tr', function (event) {
                    LoanToAppraise = null;
                    var sel_row = $(this)
                    $("#divLoanInfo").html("");
                    $('#tblLoanApplications tbody tr').removeClass('row_selected');
                    $(sel_row).addClass('row_selected');

                    var loan_ref_no = sel_row.find('td').eq(0).text();
                    $("#tblLoanInfo > tbody:last").children().remove();

                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    var outData = {
                        'DBName': $("#cboYear").val(),
                        'LoanRefNo': loan_ref_no
                    }
                    outData = JSON.stringify(outData);
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: "<%: Url.Content("~/api/BankSystemApi/GetLoanApplicationDetails") %>",
                        data: outData,
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            var LoanDetails = response;
                            LoanToAppraise = response;

                            NominieeApprovalRequired = LoanDetails.NormineeApprovalRequired;
                            var tbl = "<table id='tblLoanDetails'  class='display' cellspacing='0' width='100%'>";
                            tbl += "<tbody>";
                            tbl += "<tr><td><b>Loan Application No:</b></td><td><input type='text' id='txtLoanApplicationNo' value='" + LoanDetails.LoanRefNo + "' disabled /></td><td><b>Loanee:</b></td><td><input type='text' id='txtLoaneeName' value='" + LoanDetails.saccoMember.FullNames + "' disabled /></td></tr>";
                            tbl += "<tr><td><b>MemberNo:</b></td><td><input type='text' id='txtLoaneeMemberNo' value='" + LoanDetails.saccoMember.MemberNo + "' disabled /></td><td><b>PayrollNo:</b></td><td><input type='text' id='txtLoaneePayrollNo' value='" + LoanDetails.saccoMember.PayrollNo + "' disabled /></td></tr>";
                            tbl += "<tr><td><b>Loan Type:</b></td><td><input type='text' id='txtLoanType' value='" + LoanDetails.memberLoanApplication.LoanTypeName + "' disabled /></td><td><b>Requested Amount:</b></td><td><input type='text' id='txtRequestedAmount' value='" + (+LoanDetails.memberLoanApplication.RequestedAmount).formatMoney() + "' disabled /></td></tr>";
                            tbl += "<tr><td><b>Approved Status</b></td><td><input type='text' value='" + LoanDetails.memberLoanApplication.ManagerApprovalStatus + "' disabled /></td><td><b>Approved By Date</b></td><td><input type='text' value='" + LoanDetails.memberLoanApplication.ManagerApprovalDate + "' disabled /></td></tr>";
                            tbl += "<tr><td><b>Approved By PF</b></td><td><input type='text' value='" + LoanDetails.memberLoanApplication.ExternalUserID + "' disabled /></td><td><b>Approved By Name</b></td><td><input type='text' value='" + LoanDetails.memberLoanApplication.ExternalUserFullNames + "' disabled /></td></tr>";
                            tbl += "</tbody></table><br/>";

                            tbl += "Loan Offsets<hr style='color:red' />";

                            tbl += "<table id='tblLoanOffset' class='display' cellspacing='0' width='100%'>";
                            tbl += "<thead>";
                            tbl += "<tr>";
                            tbl += "	<th><b>Loan Serial No</b></th>";
                            tbl += "	<th><b>Loan Name</b></th>";
                            tbl += "	<th><b>Loan Date</b></th>";
                            tbl += "	<th><b>Loan Amount</b></th>";
                            tbl += "	<th><b>Balance</b></th>";
                            tbl += "	<th><b>Apprv. Status</b></th>";
                            tbl += "	<th><b>Apprv. By</b></th>";
                            tbl += "	<th><b>Apprv Name</b></th>";
                            tbl += "	<th><b>Type</b></th>";
                            tbl += "</tr>";
                            tbl += "</thead>";
                            tbl += "<tbody id='bdLoansOffset'>";

                            
                            if (LoanDetails.memberLoanApplicationOffset != null) {
                                var loanOffsets = LoanDetails.memberLoanApplicationOffset;
                                $.each(loanOffsets, function (index, loanOff) {
                                    tbl += "<tr><td>" + loanOff.LoanSerialNo + "</td><td>" + loanOff.LN_LoanTypeName + "</td><td>" + loanOff.LN_IssueDate + "</td><td>" + loanOff.LN_LoanAmount + "</td><td>" + loanOff.LN_LoanBalance + "</td><td>" + loanOff.ApprovalStatus + "</td><td>" + loanOff.ApproverUserID + "</td><td>" + loanOff.ApproverNames + "</td><td>" + loanOff.OffsetType + "</td></tr>"
                                });
                            }
                            
                            tbl += "</tbody></table><br/>";

                            tbl += "Guarantors<hr style='color:red' />";

                            tbl += "<table id='tblGuarantors' class='display' cellspacing='0' width='100%'>";
                            tbl += "<thead>";
                            tbl += "<tr>";
                            tbl += "	<th><b>MemberNo</b></th>";
                            tbl += "	<th><b>PayrollNo</b></th>";
                            tbl += "	<th><b>Name</b></th>";
                            tbl += "	<th><b>Amount</b></th>";
                            tbl += "	<th><b>Response</b></th>";
                            tbl += "	<th><b>Comments</b></th>";
                            tbl += "	<th><b>Date</b></th>";
                            tbl += "</tr>";
                            tbl += "</thead>";
                            tbl += "<tbody id='bdLoansOffset'>";


                            if (LoanDetails.memberLoanApplicationGuarantor != null) {
                                var loanGuarantors = LoanDetails.memberLoanApplicationGuarantor;
                                $.each(loanGuarantors, function (index, loanGuarantor) {
                                    tbl += "<tr><td>" + loanGuarantor.GuarantorMemberNo + "</td><td>" + loanGuarantor.GuarantorPayrollNo + "</td><td>" + loanGuarantor.GuarantorName + "</td><td>" + (+loanGuarantor.RequestedAmount).formatMoney() + "</td><td>" + loanGuarantor.GuarantorResponse + "</td><td>" + loanGuarantor.GuarantorNotes + "</td><td>" + loanGuarantor.ResponseDate + "</td></tr>"
                                });
                            }

                            tbl += "</tbody></table>";


                            $("#divLoanInfo").html(tbl);
                            $('#tblLoansOffset').dataTable();
                            
                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            alert('Error - ' + errorMessage);
                        }
                    });

                    return false;
                });
                $("#cboYear").on('change', function () {
                    GetMemberLoanApplicationsListing()
                });
                $("#cboPeriod").on('change', function () {
                    GetMemberLoanApplicationsListing();
                });
                $("#cboProcessStatus").on('change', function () {
                    GetMemberLoanApplicationsListing();
                });
                $("#cboBranch").on('change', function () {
                    GetMemberLoanApplicationsListing();
                });
                $("#btnRefresh").on('click', function () {
                    GetMemberLoanApplicationsListing();
                });

        function GetMemberLoanApplicationsListing() {
            $("#tblLoanApplications > tbody:last").children().remove();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                var outData = {
                    'DBName': $("#cboYear").val(),
                    'PeriodCode': $("#cboPeriod").val(),
                    'BranchCode': $("#cboBranch").val(),
                    'ProcessStatus': $("#cboProcessStatus").val()
                }
                outData = JSON.stringify(outData);
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetMemberLoanApplicationsListing") %>",
                data: outData,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    $("#tblLoanApplications > tbody:last").children().remove();
                    var row_datas = response;
                    var tbl_row = "";
                    $.each(row_datas, function (index, row_data) {
                        tbl_row += "<tr>";
                        tbl_row += "<td>" + row_data.LoanRefNo + "</td>";
                        tbl_row += "<td>" + row_data.MemberNo + "</td>";
                        tbl_row += "<td>" + row_data.MemberNames + "</td>";
                        tbl_row += "<td>" + row_data.LoanTypeName + "</td>";
                        tbl_row += "<td>" + row_data.RequestedAmount.formatMoney() + "</td>";
                        tbl_row += "<td>" + row_data.LoanDate + "</td>";
                        tbl_row += "<td>" + row_data.ProcessStatus + "</td>";
                        tbl_row += "<td>" + row_data.ManagerApprovalStatus + "</td>";
                        tbl_row += "<td>" + row_data.ManagerComments + "</td>";
                        

                        //if (row_data.ManagerApprovalStatus.toLowerCase() == "accepted".toLowerCase()) {
                        //    if(row_data.ProcessStatus.toString().toLowerCase=="pending".toLowerCase()){
                        //        tbl_row += "<td><a href='" + global_site_root + "/Bank/BankSystem/LoanAppraisalEdit?LoanSerialNumber=&MemberApplicationNo=" + row_data.LoanRefNo + "&DBName=" + $("#cboYear").val() + "&ClassCode=BOSA'>Appraise</a></td>";
                        //    }else{
                        //        tbl_row += "<td>----</td>";
                        //    }
                        //} else {
                        //    tbl_row += "<td>----</td>";
                        //}
                        tbl_row += "</tr>";

                    });
                    $("#tblLoanApplications").append(tbl_row);
                },
                error: function (xhr, status, error) {
                    var errorMessage = xhr.status + ': ' + xhr.responseText;
                    alert('Error - ' + errorMessage);
                }

            });
        }

        function LoadFinancialPeriods() {
            var dbname = $("#cboYear").val();
            if (dbname == null) { return; }


            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/BankSystemApi/GetAllBOSAFinancialMonths") %>",
                data: JSON.stringify({ 'DBName': $("#cboYear").val() }),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    var fmonths = response;
                    var objPeriod = document.getElementById("cboPeriod");
                    $("#cboPeriod").empty();
                    $("#cboPeriod").append("<option value='' selected>(ALL)</option>");
                    $.each(fmonths, function (index, fmonth) {
                        $("#cboPeriod").append("<option value='" + fmonth.MonthID + "'>" + fmonth.MonthName + "</option>");
                        if (fmonth.MonthID == SaccoSettings.LatestPeriod) {
                            objPeriod.selectedIndex = index+1;
                        }

                    });
                    GetMemberLoanApplicationsListing();
                },
                error: function (xhr, status, error) {
                    var errorMessage = xhr.status + ': ' + xhr.responseText;
                    alert('Error - ' + errorMessage);
                }
            });
        }
        $(function () {
            $("#tabs").tabs();
        });
        $(function () {
            $("#accordion").accordion({
                heightStyle: "content"
            });
        });
    });
    </script>
</asp:Content>
<asp:Content ID="Content6" ContentPlaceHolderID="FeaturedContent" runat="server">
<h3>Members Loans Applications</h3>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">

    <div id="tabs">
      <ul>
        <li><a href="#tabs-1">Loan Applications</a></li>
        
      </ul>
        <form id="frmMain" name="frmMain">
            <%= Html.AntiForgeryToken() %>
            <div id="tabs-1">
                <table border="1" style="padding: 1px; margin: 1px;" id="tblPeriod">
                    <tr>
                        <td>Financial Year:</td><td><select id="cboYear"><option value="selectyear">SELECT YEAR</option></select></td>
                        <td>
                            Period:
                        </td>
                        <td> 
                            <select id="cboPeriod"><option value="selectperiod" selected>(SELECT PERIOD)</option></select>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            Branch:
                        </td>
                        <td> 
                            <select id="cboBranch"><option value="" selected>(ALL BRANCHES)</option></select>
                        </td>
                        <td>
                            Request Status:
                        </td>
                        <td> 
                            <select id="cboProcessStatus">
                                <option value="">(ALL LOANS)</option>
                                <option value="pending" selected>Pending</option>
                                <option value="appraised">Appraised</option>
                                <option value="rejected">Rejected</option>
                                <option value="submitted">Submitted</option>
                            </select>
                        </td>
                    </tr>
                </table>
                <table>
                    <tr>
                        <td><input type="button" id="btnRefresh" value="Refresh"/></td>
                    </tr>
                </table>
                <div id="divLoanApplications" style="height:200px;overflow:auto;width:auto;">
                    <table id='tblLoanApplications'  class='display' style="width:100%">
                            <thead>
                                <tr>
                                <th><b>RefNo</b></th>
                                <th><b>MemberNo</b></th>
                                <th><b>Name</b></th>
                                <th><b>Loan Type</b></th>
                                <th><b>Amount</b></th>
                                <th><b>Request Date</b></th>
                                <th><b>Loan Status</b></th>
                                <th><b>Mngr Approval</b></th>
                                <th><b>Mngr Comments</b></th>
                                
                                </tr>
                            </thead>
                            <tbody id='bdLoanApplications'>
                            </tbody>
                        <tfoot>
                            <tr>
                                <td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td>
                            </tr>
                        </tfoot>
                    </table>
            <br />
                </div>
                <div>
                    <b>Loan Info</b><hr style="color:red" />
                    <div id="divLoanInfo">

                    </div>
                    <br />
                    <hr style="color:red" />
                    <div>
                        <table style="width:100%">
                            <tr>
                                <td>
                                    <input type="button" id="btnAppraise" value="Appraise Loan"/>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </form>
    </div>
    
    
</asp:Content>


