﻿<%@ Page Title="Members Register" Language="C#" MasterPageFile="~/Areas/Bank/Views/Shared/StaffMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Members Register
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
    </style>
    <script type="text/javascript">
        $(document).ready(function () {

            var editurl = "";
            
            $("#txtDOB").datepicker({ dateFormat: 'dd/mm/yy' });
            $("#txtJoinDate").datepicker({ dateFormat: 'dd/mm/yy' });

            //$("#tblRegister").dataTable({
            //    bJQueryUI: true,
            //    sPaginationType: "full_numbers",
            //    sScorollX: "900px",
            //    sScrollY: "900px",
            //    bScrollInfinite: true, //this property disables pagination
            //    //oSearch: { "sSearch": "DefaultSearchValue", "bRegex": false, "bSmart": false }
            //});

            
            

            function getValueFromHref(urlString, paramName) {
                //var searchString = window.location.search.substring(1),i, val, params = searchString.split("&");
                var searchString = urlString.substring(1), i, val, params = searchString.split("&");
                //alert(searchString);
                for (i = 0; i < params.length; i++) {
                    val = params[i].split("=");
                    if (val[0] == paramName) {
                        return unescape(val[1]);
                    }
                }
                return null;
            }
            $("#divEdit").dialog({
                autoOpen: false,
                show: "fade",
                hide: "fade",
                modal: true,
                open: function (ev, ui) {
                    $('#EditFrame').attr('src', editurl);
                },
                height: 'auto',
                width: 'auto',
                resizable: true,
                title: 'Members Master File',
                close: function () {
                    $('#EditFrame').attr("src", "");
                }
            });



            $("#btnSearch").on('click', function (e) {
                e.preventDefault();
                var input = form2js({ rootNode: 'frmMembersRegister' });
                var data = ({ 'FormData': input });
                $("#tblRegister > tbody:last").children().remove();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: 'POST',
                    url: "<%: Url.Content("~/api/BankSystemApi/MembersRegister") %>",
                    data: data,
                    dataType: 'JSON',
                    success: function (response) {
                        
                        var members = response;
                        
                        var tbl = "";
                        $.each(members, function (index, m) {
                            var ankaid = "anka" + index;
                            var editref = global_site_root + "/Bank/BankSystem/MembersMasterFile?EditMode=true&EmpCode=" + m.EmployerCode + "&PayrollNo=" + m.PayrollNo + "";
                            tbl += "<tr><td>" + (index + (+1)) + "</td><td>" + m.EmployerCode + "</td><td>" + m.PayrollNo + "</td><td class='td_description'><a href='" + editref + "' class='thumb' id='" + ankaid + "'>" + m.FullNames + "</a></td><td>" + m.IDNumber + "</td><td>" + m.MemberNo + "</td><td>" + m.SalaryAccount + "</td><td>" + m.BranchCode + "</td><td>" + m.PhoneNo + "</td><td>" + m.JoinDate + "</td></tr>";
                        });
                        
                        
                        $("#bdRegister").append(tbl);

                    },

                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });

            });
            $("#btnPrint").click(function () {
                //$("#mySelector").printThis({
                //debug: false,              * show the iframe for debugging
                //importCSS: true,           * import page CSS
                //printContainer: true,      * grab outer container as well as the contents of the selector
                //loadCSS: "path/to/my.css", * path to additional css file
                //pageTitle: "",             * add title to print page
                //removeInline: false        * remove all inline styles from print elements

                $("#divRegisterList").printThis({
                    debug: false,
                    pageTitle: "Members Register",
                    removeInline: true,
                    printContainer: true,
                    importCSS: false
                });

            });

            function extractErrors(jqXhr, validator) {
                alert(jqXhr.toUTCString());
                var data = JSON.parse(jqXhr.responseText), // parse the response into a JavaScript object
                    errors = {};

                for (var i = 0; i < data.length; i++) { // add each error to the errors object
                    errors[data[i].key] = data[i].value;
                }
                alert(errors);
                //validator.showErrors(errors); // show the errors using the validator object
            }
            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/BankSystemApi/GetMasterFileConfig") %>",
                data: "{}",
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    var mList = response.EmployerList;
                    var obj = document.getElementById("cboEmployer");
                    $.each(mList, function (index, mListItem) {
                        var opt = document.createElement("option");
                        opt.value = mListItem.EmployerCode;
                        opt.text = mListItem.EmployerName;
                        obj.appendChild(opt);
                    });
                    var mList = response.MainBanksList;
                    var obj = document.getElementById("cboMainBank");
                    $.each(mList, function (index, mListItem) {
                        var opt = document.createElement("option");
                        opt.value = mListItem.MainBankCode;
                        opt.text = mListItem.MainBankName;
                        obj.appendChild(opt);
                    });
                    var mList = response.DistrictList;
                    var obj = document.getElementById("cboHomeDistrict");
                    $.each(mList, function (index, mListItem) {
                        var opt = document.createElement("option");
                        opt.value = mListItem.DistrictsCode;
                        opt.text = mListItem.DistrictsName;
                        obj.appendChild(opt);
                    });
                    var mList = response.DistrictList;
                    var obj = document.getElementById("cboPresentDistrict");
                    $.each(mList, function (index, mListItem) {
                        var opt = document.createElement("option");
                        opt.value = mListItem.DistrictsCode;
                        opt.text = mListItem.DistrictsName;
                        obj.appendChild(opt);
                    });
                    var mList = response.DesignationList;
                    var obj = document.getElementById("cboDesignation");
                    $.each(mList, function (index, mListItem) {
                        var opt = document.createElement("option");
                        opt.value = mListItem.DesgCode;
                        opt.text = mListItem.DesgName;
                        obj.appendChild(opt);
                    });
                    var mList = response.TermsOfServList;
                    var obj = document.getElementById("cboTermsOfService");
                    $.each(mList, function (index, mListItem) {
                        var opt = document.createElement("option");
                        opt.value = mListItem.TermsCode;
                        opt.text = mListItem.TermsName;
                        obj.appendChild(opt);
                    });
                    var mList = response.BranchesList;
                    var obj = document.getElementById("cboBranch");
                    $.each(mList, function (index, mListItem) {
                        var opt = document.createElement("option");
                        opt.value = mListItem.BranchCode;
                        opt.text = mListItem.BranchName;
                        obj.appendChild(opt);
                    });
                    var mList = response.StatusList;
                    var obj = document.getElementById("cboStatus");
                    $.each(mList, function (index, mListItem) {
                        var opt = document.createElement("option");
                        opt.value = mListItem.StatusCode;
                        opt.text = mListItem.StatusName;
                        obj.appendChild(opt);
                    });
                    var mList = response.TitleList;
                    var obj = document.getElementById("cboTitle");
                    $.each(mList, function (index, mListItem) {
                        var opt = document.createElement("option");
                        opt.value = mListItem.TitleCode;
                        opt.text = mListItem.TitleName;
                        obj.appendChild(opt);
                    });
                    var mList = response.MemberTypesList;
                    var obj = document.getElementById("cboMemberType");
                    $.each(mList, function (index, mListItem) {
                        var opt = document.createElement("option");
                        opt.value = mListItem.TypeCode;
                        opt.text = mListItem.TypeName;
                        obj.appendChild(opt);
                    });
                    var mList = response.CategoryList;
                    var obj = document.getElementById("cboCategory");
                    $.each(mList, function (index, mListItem) {
                        var opt = document.createElement("option");
                        opt.value = mListItem.CategoryCode;
                        opt.text = mListItem.CategoryName;
                        obj.appendChild(opt);
                    });
                    var mList = response.GenderList;
                    var obj = document.getElementById("cboGender");
                    $.each(mList, function (index, mListItem) {
                        var opt = document.createElement("option");
                        opt.value = mListItem.GenderType;
                        opt.text = mListItem.GenderType;
                        obj.appendChild(opt);
                    });
                    var mList = response.WorkStationsList;
                    var obj = document.getElementById("cboWorkStation");
                    $.each(mList, function (index, mListItem) {
                        var opt = document.createElement("option");
                        opt.value = mListItem.WorkStationCode;
                        opt.text = mListItem.WorkStationName;
                        obj.appendChild(opt);
                    });
                    var mList = response.BankBranchList;
                    var obj = document.getElementById("cboBankBranch");
                    $.each(mList, function (index, mListItem) {
                        var opt = document.createElement("option");
                        opt.value = mListItem.BranchCode;
                        opt.text = mListItem.BranchName;
                        obj.appendChild(opt);
                    });


                },
                error: function (xhr, status, error) {
                    var errorMessage = xhr.status + ': ' + xhr.responseText;
                    alert('Error - ' + errorMessage);
                }
            });
            

            
            
            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion();
            });
        });
    </script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="FeaturedContent" runat="server">

    <h3>Members Register</h3>


    <%--Use name attributes for form controls (such as <input> and <select>), as that's the identifier used in the POST or GET call that happens on form submission.

Use id attributes whenever you need to address a particular HTML element with CSS, JavaScript or a fragment identifier. It's possible to look up elements by name, too, but it's simpler and more reliable to look them up by ID.--%>
    <%--    id is used for CSS and JavaScript/jQuery (has to be unique in a page)

name is used for form handling in PHP when a form is submitted via HTML (has to be unique in a form)
    --%>
</asp:Content>

<asp:Content ID="Content3" ContentPlaceHolderID="MainContent" runat="server">
    <div id="tabs">
        <ul>
            <li><a href="#tabs-1">General Criteria</a></li>
            <li><a href="#tabs-2">Other Criteria</a></li>
            <li><a href="#tabs-3">More Criteria</a></li>
        </ul>

        <form name="frmMembersRegister" id="frmMembersRegister" method="post" action="/Bank/BankSystem/MembersMasterFile">
            <%= Html.AntiForgeryToken() %>

            <div id="tabs-1">
                <table id="General" border="1">
                    <tr>
                        <td colspan="4"><b>General Criteria</b></td>
                    </tr>
                    <tr>
                        <td>Member No</td>
                        <td>
                            <input type="text" id="txtMemberNo" name="txtMemberNo"></td>
                        <td>Payroll No</td>
                        <td>
                            <input type="text" id="txtPayrollNo" name="txtPayrollNo"></td>
                    </tr>
                    <tr>
                        <td>Account No</td>
                        <td>
                            <input type="text" id="txtAccountNo" name="txtAccountNo"></td>
                        <td>ID No</td>
                        <td>
                            <input type="text" id="txtIDNo" name="txtIDNo"></td>
                    </tr>
                    <tr>
                        <td>ATM Card No</td>
                        <td>
                            <input type="text" id="txtATMCardNo" name="txtATMCardNo"></td>
                        <td>Phone No</td>
                        <td>
                            <input type="text" id="txtPhoneNo" name="txtPhoneNo"></td>
                    </tr>
                    <tr>
                        <td>Names</td>
                        <td colspan="3">
                            <input type="text" id="txtMemNames" name="txtMemNames"></td>

                    </tr>
                </table>
                
            </div>
            <div id="tabs-2">
                <table id="tblCreteria1" border="1">
                    <tr>
                        <td colspan="4"><b>Other Criteria</b></td>
                    </tr>
                    <tr>
                        <td>Member Type:
                        </td>
                        <td>
                            <select id="cboMemberType" name="cboMemberType">
                                <option value="" selected>(ANY)</option>
                            </select>
                        </td>

                        <td>Title:
                        </td>
                        <td>
                            <select id="cboTitle" name="cboTitle">
                                <option value="" selected>
                                (ANY)
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>Gender:
                        </td>
                        <td>
                            <select id="cboGender" name="cboGender">
                                <option value="" selected>
                                (ANY)
                            </select>
                        </td>
                        <td>Member Status:
                        </td>
                        <td>
                            <select id="cboStatus" name="cboStatus">
                                <option value="" selected>
                                (ANY)
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>Branch:
                        </td>
                        <td>
                            <select id="cboBranch" name="cboBranch">
                                <option value="" selected>
                                (ANY)
                            </select>
                        </td>
                        <td>Terms Of Service:
                        </td>
                        <td>
                            <select id="cboTermsOfService" name="cboTermsOfService">
                                <option value="" selected>
                                (ANY)
                            </select>
                        </td>
                    </tr>

                    <tr>
                        <td>Employer:
                        </td>
                        <td colspan="3">
                            <select id="cboEmployer" name="cboEmployer">
                                <option value="" selected>
                                (ANY)
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>Category:
                        </td>
                        <td colspan="3">
                            <select id="cboCategory" name="cboCategory">
                                <option value="" selected>
                                (ANY)
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>WorkStation:
                        </td>
                        <td colspan="3">
                            <select id="cboWorkStation" name="cboWorkStation">
                                <option value="" selected>
                                (ANY)
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>Designation:
                        </td>
                        <td colspan="3">
                            <select id="cboDesignation" name="cboDesignation">
                                <option value="" selected>
                                (ANY)
                            </select>
                        </td>
                    </tr>

                </table>
            </div>
            <div id="tabs-3">
                <table id="tblCreteria2">
                    <tr>
                        <td colspan="4"><b>More Criteria</b></td>
                    </tr>
                    <tr>
                        <td colspan="2">Date of Birth is:
                        </td>
                        <td colspan="3">
                            <select id="cboDOB" name="cboDOB">
                                <option value="" selected>(ANY)</option>
                                <option value="after">After</option>
                                <option value="before">Before</option>
                            </select>
                        </td>
                        <td>
                            <input type="text" id="txtDOB" name="txtDOB" />
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2">Join Date is:
                        </td>
                        <td colspan="3">
                            <select id="cboJoinDate" name="cboJoinDate">
                                <option value="" selected>(ANY)</option>
                                <option value="after">After</option>
                                <option value="before">Before</option>
                            </select>
                        </td>
                        <td>
                            <input type="text" id="txtJoinDate" name="txtJoinDate" />
                        </td>
                    </tr>
                    <tr>

                        <td>Present District:
                        </td>
                        <td>
                            <select id="cboPresentDistrict" name="cboPresentDistrict">
                                <option value="" selected>
                                (ANY)
                            </select>
                        </td>

                        <td>Home District:
                        </td>
                        <td>
                            <select id="cboHomeDistrict" name="cboHomeDistrict">
                                <option value="" selected>
                                (ANY)
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>Bank Name:
                        </td>
                        <td>
                            <select id="cboMainBank" name="cboMainBank">
                                <option value="" selected>
                                (ANY)
                            </select>
                        </td>
                        <td>Bank Branch:
                        </td>
                        <td>
                            <select id="cboBankBranch" name="cboBankBranch">
                                <option value="" selected>
                                (ANY)
                            </select>
                        </td>
                    </tr>

                </table>
            </div>
            <input type="text" id="txtEditEmpCode" name="txtEditEmpCode" hidden />
            <input type="text" id="txtEditPayNo" name="txtEditPayNo" hidden />
            <button id="btnNew" name="btnNew" onclick="javascript:window.location.href = '/Bank/BankSystem/MembersMasterFile'">New Member</button>
            <button id="btnSearch" name="btnSearch">Search</button>
            <button id="btnPrint" name="btnPrint">Print</button>
            
        </form>

    </div>
    <div id="divRegisterList" class="table-responsive">

        <table id='tblRegister' class="table table-responsive table-striped">
            <thead>
                <tr>
                    <th>Row</th>
                    <th>EmpCode</th>
                    <th>PayrollNo</th>
                    <th class="th_description">Names</th>
                    <th>IDNumber</th>
                    <th>MemberNo</th>
                    <th>AccountNo</th>
                    <th>BranchCode</th>
                    <th>PhoneNo</th>
                    <th>Join Date</th>
                </tr>
            </thead>

            <tbody id='bdRegister'>

            </tbody>
            <tfoot>
                <tr>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                </tr>
            </tfoot>
        </table>
    </div>



    <div id="divEdit">
        <iframe id="EditFrame" style="width: 1100px; height: 600px"></iframe>
    </div>
</asp:Content>

