﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Bank/Views/Shared/StaffMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Petty Cash
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        .tblDRCRDetails {
             margin: 1px;
             border: 1em;
             padding-left:1em;
             padding-top:1em;
             border-collapse:separate;
         }
         
         /*use this for to calculate totals*/  
         .colamount {
            text-align:right;
         }
         tr.row_selected td{background-color:lawngreen;}
   </style>

    
    <script type="text/javascript"  >
        
        $(document).ready(function () {

            ClearInputs();
            $("#divDataCapture :input").attr("disabled", "disabled");

            $('#frmMain').on('mouseup', '[type=text],[type=date]', function (e) { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                e.preventDefault();
            });
            $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).select();
            });
            $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).addClass("textfocused");
            });
            $('#frmMain').on('focusout', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).removeClass("textfocused");
            });



            $("#tblPettyCashItems").dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            $("#tblPettyCashDetails").dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            $("#tblPettyCashList").dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            $("#btnSelectDebitAcc").on('click', function (e) {
                e.preventDefault();
                xDialogSelectGLAccount("EXPENDITURE").then(function (data) {
                    var acccode = data;
                    $("#txtDebitAcc").val(acccode);
                    GetAccountName(acccode).then(function (accname) {
                        $("#divDebitAccName").html(accname);
                    });
                });
            });
            $("#txtAmount").on('change keyup paste mouseup', function () {
                $("#divAmountInWords").html("");
                try {
                    $("#divAmountInWords").html(toWords($("#txtAmount").val()));
                } catch (err) {

                }
            });
            $("#txtDebitAcc").on('focusout', function () {
                GetAccountName($(this).val()).then(function (accname) {
                    $("#divDebitAccName").html(accname);
                });
            });
            $("#txtCustomerAcc").on('focusout', function () {
                GetAccountName($(this).val()).then(function (accname) {
                    $("#divCustomerAccName").html(accname);
                });
            });

            $("#btnNewVoucher").on('click', function () {
                $("#divDataCapture :input").removeAttr("disabled");
                ClearInputs();
                $("#cboPettyCashType").focus();

            });
            $("#btnCancelVoucher").on('click', function () {
                xDialogConfirm("Cancel current voucher?", "Confirm").then(function () {
                    $("#divDataCapture :input").attr("disabled", "disabled");
                    ClearInputs();
                });
            });
            $("#btnAddEntry").on('click', function () {
                if (document.getElementById("cboPettyCashType").selectedIndex == 0) {
                    alert("Select Pay Mode");
                    return;
                }
                $("#txtPayableTo").val("");
                if (!isNumber($("#txtAmount").val())) {
                    alert("Invalid amount");
                    return;
                }
                if (($("#txtAmount").val() <= 0)) {
                    alert("Invalid amount");
                    return;
                }
                if ($("#txtNarration").val().length < 4) {
                    alert("Narration is too short")
                    return;
                }
                if ($("#divDebitAccName").html() == "") {
                    alert("Invalid Exp. Acc");
                    return;
                }

                $("#bdPettyCashItems").append(
                    "<tr><td>" + $("#txtNarration").val() + "</td><td>" + $("#txtDebitAcc").val() + "</td><td>" + $("#divDebitAccName").html() + "</td><td class='td_amount_col'>" + $("#txtAmount").val() + "</td><td><a href='#'>Remove</a></td><tr>"
                );
                CalcPettyCashTotals();
                $("#txtAmount").val("0.00");
                $("#txtNarration").val("");
                $("#divAmountInWords").html("");
                $("#txtDebitAcc").val("");
                $("#divDebitAccName").html("");

            });
            $('#bdPettyCashItems').on('click', 'a', function (event) {
                event.preventDefault();
                var rm_account_no = $(this).closest('tr').find('td').eq(0).text();
                var rm_amount = $(this).closest('tr').find('td').eq(3).text();
                var rm_row = $(this).closest('tr');
                xDialogConfirm("Remove Petty Cash Entry: " + rm_account_no + " Amount: " + rm_amount + "?", "Confirm").then(function () {
                    $(rm_row).remove();
                    CalcPettyCashTotals();
                });
                return false;
            });
            $("#cboYear").empty();
            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/BankSystemApi/GetPettyCashModuleConfig") %>",
                data: "{}",
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    var years = response.Years;
                    var chequedeposittypes = response.ChequeDepositsTypes;
                    var saccobranches = response.Branches;
                    var banks = response.Banks;
                    var clearingbanks = response.ClearingBanks

                    SaccoSettings = response.SaccoSettings;
                    var obj = document.getElementById("cboYear");
                    $.each(years, function (index, yrs) {
                        var opt = document.createElement("option");
                        opt.value = yrs.DBName;
                        opt.text = yrs.UserDefinedYearName;
                        opt.selected = true;
                        obj.appendChild(opt);
                    });
                    $("#cboYear").get(0).selectedIndex = 0;
                    var obj = document.getElementById("cboBranch");
                    $.each(saccobranches, function (index, saccobranch) {
                        var opt = document.createElement("option");
                        opt.value = saccobranch.BranchCode;
                        opt.text = saccobranch.BranchName + "(" + saccobranch.BranchCode + ")";
                        obj.appendChild(opt);
                    });
                    LoadFinancialPeriods();
                },
                error: function (xhr, status, error) {
                    var errorMessage = xhr.status + ': ' + xhr.responseText;
                    alert('Error - ' + errorMessage);
                }
            });

            $('#tabs').on('tabsactivate', function (event, ui) {
                var newIndex = ui.newTab.index();
                if (newIndex == 1) {
                    GetPettyCashSummary();
                }
            });



            $("#cboYear").on('change', function () {
                LoadFinancialPeriods()
            });
            $("#cboPeriod").on('change', function () {
                GetPettyCashSummary();
            });
            $("#cboPostedStatus").on('change', function () {
                GetPettyCashSummary();
            });
            $("#cboBranch").on('change', function () {
                GetPettyCashSummary();
            });
            $("#btnRefresh").on('click', function () {
                GetPettyCashSummary();
            });
            $("#cboPayMode").on('change', function () {
                GetPettyCashSummary();
            });

            $("#txtDebitAcc").mask(AccountMask);
            $("#txtCustomerAcc").mask(AccountMask);

            $('#tblPettyCashList').on('click', 'tr', function (event) {
                var sel_row = $(this)
                $('#tblPettyCashList tbody tr').removeClass('row_selected');
                $(sel_row).addClass('row_selected');
                var petty_cash_doc_no = sel_row.find('td').eq(2).text();
                $("#tblPettyCashDetails > tbody:last").children().remove();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                var outData = {
                    'DBName': $("#cboYear").val(),
                    'DocNo': petty_cash_doc_no
                }
                outData = JSON.stringify(outData);
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetPettyCashDocDetails") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var tbl = "<tr>";
                        var row_datas = response;
                        var tbl_row = "";
                        $.each(row_datas, function (index, row_data) {
                            tbl_row += "<tr>";
                            tbl_row += "<td>" + (index + 1).toString() + ") " + row_data.Description + "</td>";
                            tbl_row += "<td>" + row_data.ExpenseAcc + "</td>";
                            tbl_row += "<td>" + row_data.ExpenseAccName + "</td>";
                            tbl_row += "<td class='td_amount_col'>" + row_data.Amount.formatMoney() + "</td>";
                            tbl_row += "</tr>";
                        });
                        $("#bdPettyCashDetails").append(tbl_row);
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            });
            $("#btnApprovePettyCash").on('click', function () {
                xDialogConfirm("Approve Selected Petty Cash Docs?", "Confirm").then(function () {
                    xDialogGetUserCredetials().then(function (data) {
                        ApproveRejectPettyCash(data, "approve", "");
                    });
                });
            });
            $("#btnRejectPettyCash").on('click', function () {
                xDialogConfirm("Reject Selected Petty Cash?", "Confirm").then(function () {
                    xDialogGetUserCredetials().then(function (data) {
                        xDialogInput("Enter rejection reason").then(function (reject_reason) {
                            ApproveRejectPettyCash(data, "reject", reject_reason);
                        });
                    });
                });
            });
            $("#btnPostPettyCash").on('click', function () {
                xDialogConfirm("Post Selected Petty Cash Docs?", "Confirm").then(function () {
                    xDialogGetUserCredetials().then(function (data) {
                        PostNonTellerPettyCash(data);
                    });
                });
            });
            $("#btnSaveVoucher").on('click', function () {
                if (document.getElementById("cboPettyCashType").selectedIndex == 1) { //Teller
                    if ($("#txtPayableTo").val().length == 0) {
                        alert("Enter Payee Name");
                        return;
                    } else if ($("#txtIDNumber").val().length < 5) {
                        alert("Enter IDNumber");
                        return;
                    }
                } else if (document.getElementById("cboPettyCashType").selectedIndex == 2) { //Customer
                    if ($("#divCustomerAccName").html() == "") {
                        alert("Enter Customer Acc");
                        return;
                    }
                } else {
                    alert("Select Petty Cash Pay Mode");
                    return;
                }
                var PTotal = $("#txtTotals").val();
                if (+PTotal <= 0) {
                    alert("Invalid Totals");
                    return;
                }
                xDialogConfirm("Save Petty Cash appraisal?", "Confirm").then(function () {
                    xDialogGetUserCredetials().then(function (data) {
                        SavePettyCashVoucher(data);
                    });
                });
            });

            function CalcPettyCashTotals() {
                var dblTotals = 0;
                $("#bdPettyCashItems").find('tr').each(function (i) {
                    var row = $(this); //store in variable for faster access
                    var row_amount = row.find('td:eq(3)').text();
                    dblTotals += +row_amount;
                });
                $("#txtTotals").val(dblTotals);
            }

            function ApproveRejectPettyCash(credentials, action_type, reject_reason) {
                var PostEntries = new Array();
                var selected_count = 0;
                $("#bdPettyCashList").find('tr').each(function (i) {
                    var PostEntry = {};
                    var row = $(this); //store in variable for faster access
                    var chkbox = row.find('td:eq(0)').find('input:eq(0)');
                    var pt_doc_no = row.find('td:eq(2)').text();
                    if ($(chkbox).prop("checked")) {
                        PostEntry.DocNo = pt_doc_no;
                        PostEntry.RejectionReason = reject_reason;
                        PostEntries[selected_count] = PostEntry;
                        selected_count++;
                    }
                });
                var UserName = credentials.UserName;
                var Password = credentials.UserPass;
                var pwdslt = getRandomInt(1000, 30000);
                pwdslt = pwdslt.toString();
                var pwd = CryptoJS.MD5(Password).toString();
                pwd = pwd + pwdslt;
                var sltpwd = CryptoJS.MD5(pwd).toString();

                var outData = {
                    'PeriodCode': $("#cboPeriod").val(),
                    'DBName': $("#cboYear").val(),
                    'UserName': UserName,
                    'Password': sltpwd,
                    'Salt': pwdslt,
                    'PettyCashList': PostEntries,
                    'ApprovalAction': action_type,
                    'RejectReason': reject_reason
                }
                outData = JSON.stringify(outData);
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/ApproveRejectPettyCash") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        alert("Petty Cash Approved/Rejected successfuly.");
                        GetPettyCashSummary();
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            }
            function PostNonTellerPettyCash(credentials) {
                var PostEntries = new Array();
                var selected_count = 0;

                $("#bdPettyCashList").find('tr').each(function (i) {
                    var PostEntry = {};
                    var row = $(this); //store in variable for faster access
                    var chkbox = row.find('td:eq(0)').find('input:eq(0)');
                    var pt_doc_no = row.find('td:eq(2)').text();
                    //if (chkbox.checked)
                    //if ($(chkbox).prop("checked"))
                    //if ($(chkbox).is(":checked"))
                    if ($(chkbox).prop("checked")) {
                        PostEntry.DocNo = pt_doc_no;
                        PostEntries[selected_count] = PostEntry;
                        selected_count++;
                    }
                });
                var UserName = credentials.UserName;
                var Password = credentials.UserPass;
                var pwdslt = getRandomInt(1000, 30000);
                pwdslt = pwdslt.toString();
                var pwd = CryptoJS.MD5(Password).toString();
                pwd = pwd + pwdslt;
                var sltpwd = CryptoJS.MD5(pwd).toString();

                var outData = {
                    'PeriodCode': $("#cboPeriod").val(),
                    'DBName': $("#cboYear").val(),
                    'UserName': UserName,
                    'Password': sltpwd,
                    'Salt': pwdslt,
                    'PettyCashList': PostEntries,
                }
                outData = JSON.stringify(outData);
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/PostNonTellerPettyCash") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        alert("Petty Cash Posted successfuly.");
                        GetPettyCashSummary();
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            }
            function GetPettyCashSummary() {
                $("#bdPettyCashItems > tbody:last").children().remove();
                $("#tblPettyCashDetails > tbody:last").children().remove();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                var outData = {
                    'DBName': $("#cboYear").val(),
                    'PeriodCode': $("#cboPeriod").val(),
                    'BranchCode': $("#cboBranch").val(),
                    'PostedStatus': $("#cboPostedStatus").val(),
                    'PayMode': $("#cboPayMode").val()
                }
                outData = JSON.stringify(outData);
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetPettyCashSummary") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        $("#tblPettyCashList > tbody:last").children().remove();
                        var row_datas = response;
                        var tbl_row = "";
                        $.each(row_datas, function (index, row_data) {
                            tbl_row += "<tr>";
                            tbl_row += "<td><input type='checkbox'/></td>";
                            tbl_row += "<td>" + row_data.TransDate + "</td>";
                            tbl_row += "<td><a href='" + global_site_root + "/Bank/BankSystem/PettyCashVoucherDoc?DocNo=" + row_data.DocNo + "&DBName=" + $("#cboYear").val() + "&ClassCode=BOSA'>" + row_data.DocNo + "</a></td>";



                            tbl_row += "<td>" + row_data.PayMode + "</td>";
                            tbl_row += "<td class='td_amount_col'>" + row_data.Amount.formatMoney() + "</td>";
                            if (row_data.PayMode.toLowerCase() == "customer".toLowerCase()) {
                                tbl_row += "<td>" + row_data.CustomerAcc + "</td>";
                                tbl_row += "<td>" + row_data.CustomerAccName + "</td>";
                            } else if (row_data.PayMode.toLowerCase() == "teller".toLowerCase()) {
                                tbl_row += "<td>" + row_data.TellerAcc + "</td>";
                                tbl_row += "<td>" + row_data.TellerAccName + "</td>";
                            } else if (row_data.PayMode.toLowerCase() == "other".toLowerCase()) {
                                tbl_row += "<td>" + row_data.OtherAcc + "</td>";
                                tbl_row += "<td>" + row_data.OtherAccName + "</td>";
                            }
                            tbl_row += "<td>" + row_data.PaidTo + "</td>";
                            tbl_row += "<td>" + row_data.IDNumber + "</td>";
                            tbl_row += "<td>" + row_data.Status + "</td>";
                            tbl_row += "<td>" + row_data.PostUser + "</td>";
                            tbl_row += "</tr>";

                        });
                        $("#bdPettyCashList").append(tbl_row);
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }

                });
            }


            function SavePettyCashVoucher(credetials) {

                var UserName = credetials.UserName;
                var Password = credetials.UserPass;
                var csrfToken = $("input[name='__RequestVerificationToken']").val();

                var pwdslt = getRandomInt(1000, 30000);
                pwdslt = pwdslt.toString();
                var pwd = CryptoJS.MD5(Password).toString();
                pwd = pwd + pwdslt;
                var sltpwd = CryptoJS.MD5(pwd).toString();

                var PostEntries = new Array();
                var selected_count = 0;

                $("#bdPettyCashItems").find('tr').each(function (i) {
                    var PostEntry = {};

                    var row = $(this); //store in variable for faster access
                    var _narration = row.find('td:eq(0)').text();
                    var _account_no = row.find('td:eq(1)').text();
                    var _amount = row.find('td:eq(3)').text();

                    if (+_amount > 0) {
                        PostEntry.ExpenseAcc = _account_no;
                        PostEntry.CustomerAcc = $("#txtCustomerAcc").val();
                        PostEntry.PayMode = $("#cboPettyCashType").val().toUpperCase();
                        PostEntry.Description = _narration;
                        PostEntry.Amount = _amount;
                        PostEntry.PaidTo = $("#txtPayableTo").val();
                        PostEntry.IDNumber = $("#txtIDNumber").val();
                        PostEntry.OtherAcc = "";

                        PostEntries[selected_count] = PostEntry;

                        selected_count++;
                    }

                });
                if (selected_count == 0) { alert("Nothing to Save"); }

                var outData = {
                    'PettyCashList': PostEntries,
                    'UserName': UserName,
                    'Password': sltpwd,
                    'Salt': pwdslt
                }
                outData = JSON.stringify(outData);
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/SavePettyCash") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        alert("Petty Cash Saved");
                        $("#divDataCapture :input").attr("disabled", "disabled");
                        ClearInputs();
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }

                });

            }

            function ClearInputs() {
                $("#txtIDNumber").val("");
                $("#txtPayableTo").val("");
                $("#txtAmount").val("0.00");
                $("#divCustomerAccName").empty();
                $("#txtCustomerAcc").val("");
                $("#txtNarration").val("");
                $("#divAmountInWords").empty();
                $("#txtDebitAcc").val("");
                $("#divDebitAccName").empty();
                document.getElementById("cboPettyCashType").selectedIndex = 0;
                $("#tblPettyCashItems > tbody:last").children().remove();

            }



            function LoadFinancialPeriods() {
                var dbname = $("#cboYear").val();
                if (dbname == null) { return; }
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetAllBOSAFinancialMonths") %>",
                    data: JSON.stringify({ 'DBName': $("#cboYear").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var fmonths = response;
                        var objPeriod = document.getElementById("cboPeriod");
                        $("#cboPeriod").empty();
                        $.each(fmonths, function (index, fmonth) {
                            var optn = "<option value='" + fmonth.MonthID + "'>" + fmonth.MonthName + "</option>";
                            $("#cboPeriod").append(optn);
                            if (fmonth.Status == "OPENED") {
                                objPeriod.selectedIndex = index
                            }

                        });
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            }
            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion({
                    heightStyle: "content"
                });
            });
        });
    </script>
</asp:Content>
<asp:Content ID="Content6" ContentPlaceHolderID="FeaturedContent" runat="server">
<h3>Petty Cash</h3>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">

    <div id="tabs">
      <ul>
        <li><a href="#tabs-1">Petty Cash</a></li>
        <li><a href="#tabs-2">Approve/Post</a></li>
      </ul>
        <form id="frmMain" name="frmMain">
            <%= Html.AntiForgeryToken() %>
            <div id="tabs-1">
                <div id="divDataCapture">
                <table  border="1" style="padding: 1px; margin: 1px;">
                    <tr>
                        <td>
                            Post Payment By:
                        </td>
                        <td>
                            <select id="cboPettyCashType">
                                <option selected value="">(SELECT)</option>
                                <option value="teller">TELLER</option>
                                <option value="customer">CUSTOMER</option>
                            </select>
                        </td>
                        <td>
                            Payable To:
                        </td>
                        <td>
                            <input type="text" id="txtPayableTo" />
                        </td>
                        
                    </tr>
                    
                    <tr>
                        <td>
                           Customer A/C:
                        </td>
                        <td>
                            <input type="text" id="txtCustomerAcc" />
                        </td>
                        <td>
                           ID Number:
                        </td>
                        <td>
                            <input type="text" id="txtIDNumber" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                           Customer Name:
                        </td>
                        <td colspan="3">
                            <div id="divCustomerAccName"></div>
                        </td>
                        
                    </tr>
                    
                    <tr><td>Petty Cash Items</td><td colspan ="3"><hr style="color:red" /></td></tr>
                    
                    <tr>
                        <td>Narration</td><td colspan="2"><input type="text" id="txtNarration" style="width:100%" value="" /></td>
                    </tr>
                    <tr>
                        <td><input type="button" id="btnSelectDebitAcc" value="Exp. A/C" /></td><td><input type="text" id="txtDebitAcc"/><div id="divDebitAccName"></div></td>
                    </tr>
                    <tr>
                        <td>Amount</td><td><input type="text" id="txtAmount" /></td><td><input type="button" value="Add Entry" id="btnAddEntry" /></td>
                    </tr>
                   </table>
                </div>
                <div id="divPettyCashItems" style="height:200px;overflow:auto;width:auto;">
                    <table id='tblPettyCashItems' class="display"  style="width:100%">
                            <thead>
                                <tr>
                                <th>Narration</th>
                                <th>Account</th>
                                <th>Acc Name</th>
                                <th class="td_amount_col">Amount</th>
                                <th></th>
                                </tr>
                            </thead>
                            <tbody id='bdPettyCashItems'>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td></td><td></td><td></td><td></td><td></td>
                                </tr>
                            </tfoot>
                    </table>
                </div>
                <table>
                    <tr>
                        <td><input type="button" value="New Voucher" id="btnNewVoucher" /></td>
                        <td><input type="button" value="Cancel Voucher" id="btnCancelVoucher" /></td>
                        <td><input type="button" value="Save Voucher" id="btnSaveVoucher" />&nbsp;&nbsp;TOTALS:&nbsp;&nbsp;<input type="text" id="txtTotals"  class="numbertext" readonly="true"/></td>
                    </tr>
                </table>
            </div>
            <div id="tabs-2">
                <table border="1" style="padding: 1px; margin: 1px;" id="tblPeriod">
                    <tr>
                        <td>Financial Year:</td><td><select id="cboYear"><option value="selectyear">SELECT YEAR</option></select></td>
                        <td>
                            Period:
                        </td>
                        <td> 
                            <select id="cboPeriod"><option value="" selected>(SELECT PERIOD)</option></select>
                        </td>
                        <td>
                            PayMode:
                        </td>
                        <td> 
                            <select id="cboPayMode"><option value="" selected>(ANY)</option>
                                <option value="teller">TELLER</option>
                                <option value="customer">CUSTOMER</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            Branch:
                        </td>
                        <td> 
                            <select id="cboBranch"><option value="" selected>(ALL BRANCHES)</option></select>
                        </td>
                        <td>
                            Status:
                        </td>
                        <td> 
                            <select id="cboPostedStatus">
                                <option value="">(ALL)</option>
                                <option value="appraised" selected>Appraised</option>
                                <option value="approved">Approved</option>
                                <option value="posted">Posted</option>
                                <option value="rejected">Rejected</option>
                            </select>
                        </td>
                    </tr>
                </table>
                <table>
                    <tr>
                        <td><input type="button" id="btnRefresh" value="Refresh"/></td>
                        <td><input type="button" id="btnPostPettyCash" value="Post"/></td>
                        <td><input type="button" id="btnApprovePettyCash" value="Approve"/></td>
                        <td><input type="button" id="btnRejectPettyCash" value="Reject"/></td>
                        <td><input type="button" id="btnPrintDoc" value="Print Voucher"/></td>
                        <td><input type="button" id="btnPrintList" value="Print List"/></td>
                    </tr>
                </table>
                <div id="divPettyCashList" style="height:200px;overflow:auto;width:auto;">
                <table id='tblPettyCashList'  class='display' style="width:100%">
                        <thead>
                            <tr>
                            <th><b>X</b></th>
                            <th><b>DocDate</b></th>
                            <th><b>DocNo</b></th>
                            <th><b>PayMode</b></th>
                            <th class='td_amount_col'><b>Amount</b></th>
                            <th><b>A/C</b></th>
                            <th><b>A/C Name</b></th>
                            <th><b>Payee</b></th>
                            <th><b>ID Number</b></th>
                            <th><b>Status</b></th>
                            <th><b>PostedBy</b></th>
                            </tr>
                        </thead>
                        <tbody id='bdPettyCashList'>
                        </tbody>
                    <tfoot>
                        <tr>
                            <td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td>
                        </tr>
                    </tfoot>
                </table>
                </div>

                <div id="divPettyCashDetails" style="height:200px;overflow:auto;width:auto;">
                <table id='tblPettyCashDetails'  class='display' style="width:100%">
                        <thead>
                            <tr>
                            <th><b>Narration</b></th>
                            <th><b>A/C No</b></th>
                            <th><b>A/C Name</b></th>
                            <th class='td_amount_col'><b>Amount</b></th>
                            </tr>
                        </thead>
                        <tbody id='bdPettyCashDetails'>
                        </tbody>
                    <tfoot>
                        <tr>
                            <td></td><td></td><td></td><td></td>
                        </tr>
                    </tfoot>
                </table>
                </div>

            </div>
        </form>
    </div>
    
    
</asp:Content>


