﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Bank/Views/Shared/StaffMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Refunds And MPA Credit
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
     <style type="text/css">
        .auto-style1 {
            width: 153px;
        }
        .alert
        {
            font-size: 1.3em;
            padding: 1em;
            text-align: center;
            white-space: nowrap;
            width: auto;
            word-wrap: normal;
        }
         .tblDRCRDetails {
             margin: 1px;
             border: 1em;
             padding-left:1em;
             padding-top:1em;
             border-collapse:separate;
         }
         
         tr.row_selected td{background-color:lawngreen;}
    </style>

    
    <!--Reference the SignalR library. -->
    <script src="/Scripts/jquery.signalR-2.2.0.js"></script>
    <!--Reference the autogenerated SignalR hub script. -->
    <script src="/signalr/hubs"></script>
    <!--Add script to update the page and send messages.--> 
    <script type="text/javascript">

    </script>
    
    <script type="text/javascript"  >
        $(document).ready(function () {

            $("#btnProcessBatch").attr("disabled", true);
            // Declare a proxy to reference the hub. 
            var progresProxy = $.connection.progressHub; //note name of class starts with lower case (SignalRChart.SignalRChat.progressHub)
            progresProxy.client.processingProgress = function (progressMessage, progressPercentage) {
                $("#txtProgress").val(progressMessage);
                $("#prgProgress").css("width", progressPercentage + "%").text(progressMessage).attr('aria-valuenow', progressPercentage);
            };
            progresProxy.client.processingComplete = function (data) {
                alert(data);
            };

            $.connection.hub.start().done(function () {
                var connectionId = $.connection.hub.id;
                
                $('#btnProcessBatch').attr("disabled", false);
            });


            $.connection.hub.error(function (error) {
                console.log('SignalR error: ' + error)
            });
            $("#btnProcessBatch").on('click', function () {
                var connectionId = $.connection.hub.id;
                //alert(connectionId);
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/ProcessSalaryFile") %>",
                    data: JSON.stringify({ 'SignalR_ID': connectionId }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        alert("OK");
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            });
            var transmember = null;
            var cashaccounts = null;
            var bankaccounts = null;
            ClearAll();
            DisableDataEntry();

            $("#txtDate").datepicker({ dateFormat: 'dd/mm/yy' });

            $('#frmMain').on('mouseup', '[type=text],[type=date]', function (e) { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                e.preventDefault();
            });
            $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).select();
            });
            $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).addClass("textfocused");
            });
            $('#frmMain').on('focusout', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).removeClass("textfocused");
            });


            $('#tabs').on('tabsactivate', function (event, ui) {
                var newIndex = ui.newTab.index();
                if (newIndex == 1) {
                    DispTransactionsListSummary();
                }
            });

            $('#tblTransactionDetails').on('input', '[type=text]', function () { //calc totals
                CalcTotals();
            });

            $("#btnRefresh").on('click', function () {
                DispTransactionsListSummary();
            });
            $("#cboTransType").on('change', function () {
                DispTransactionsListSummary();
            });

            $("#cboYear").on('change', function () {
                LoadFinancialPeriods();
            });
            $("#cboPeriod").on('change', function () {
                DispTransactionsListSummary();
            });
            $("#cboFilterPostedStatus").on('change', function () {
                DispTransactionsListSummary();
            });
            $("#cboFilterBranches").on('change', function () {
                DispTransactionsListSummary();
            });


            $('#tblTransListSummary tbody').on('click', 'tr', function () {
                $('#tblTransListSummary tbody tr').removeClass('row_selected');
                $(this).addClass('row_selected');
                var DocNo = $(this).find('td').eq(0).text();
                DispTransactionsListDetails(DocNo);
            });

            $("#tblTransListSummary").keydown(function (evt) {
                if (evt.keyCode == 38) { // up
                    $('tbody tr:not(:first).selected').removeClass('row_selected').prev().addClass('row_selected');
                }
                if (evt.keyCode == 40) { // down
                    $('tbody tr:not(:last).selected').removeClass('row_selected').next().addClass('row_selected');
                }
            });


            $("#btnPost").on('click', function () {
                xDialogConfirm("Post Document?", "Confirm").then(function () {
                    xDialogGetUserCredetials().then(function (data) {
                        PostTransactions(data);
                    });
                });
            });
            //end important



            $("#cboYear").empty();
            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/BankSystemApi/GetAccountsModulesConfig") %>",
                data: "{}",
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    var years = response.Years;
                    var employers = response.Employers;
                    cashaccounts = response.CashAccounts;
                    bankaccounts = response.BankAccounts;
                    SaccoSettings = response.SaccoSettings;

                    var obj = document.getElementById("cboYear");
                    $.each(years, function (index, yrs) {
                        var opt = document.createElement("option");
                        opt.value = yrs.DBName;
                        opt.text = yrs.UserDefinedYearName;
                        opt.selected = true;
                        obj.appendChild(opt);
                    });
                    $("#cboYear").get(0).selectedIndex = 0;
                    var obj = document.getElementById("cboEmployer");
                    $.each(employers, function (index, empl) {
                        var opt = document.createElement("option");
                        opt.value = empl.EmployerCode;
                        opt.text = empl.EmployerName;
                        obj.appendChild(opt);
                    });
                    LoadFinancialPeriods();
                },
                error: function (xhr, status, error) {

                    var errorMessage = xhr.status + ': ' + xhr.responseText;
                    alert('Error - ' + errorMessage);
                }
            });

            $("#btnNew").on('click', function () {
                var selectedtransindex = document.getElementById("cboTransType").selectedIndex;
                var Priv = "";
                if (selectedtransindex == 0) {
                    alert("Select Transaction Type");
                    return;
                } else if (selectedtransindex == 1) {
                    Priv = "CreateRefunds";
                } else if (selectedtransindex == 2) {
                    Priv = "CreateMPACredit";
                }
                xDialogConfirm("Start a new " + $("#cboTransType option:selected").text() + " batch?").then(function () {
                    xDialogGetUserCredetials().then(function (data) {
                        var UserName = data.UserName;
                        var Password = data.UserPass;
                        var pwdslt = getRandomInt(1000, 30000);
                        pwdslt = pwdslt.toString();
                        var pwd = CryptoJS.MD5(Password).toString();
                        pwd = pwd + pwdslt;
                        var sltpwd = CryptoJS.MD5(pwd).toString();



                        var outData = {
                            'UserID': UserName,
                            'Password': sltpwd,
                            'Salt': pwdslt,
                            'Privilege': Priv
                        }
                        outData = JSON.stringify(outData);
                        var url = "<%: Url.Content("~/api/BankSystemApi/ValidateWebUserPrivilege") %>";
                        var csrfToken = $("input[name='__RequestVerificationToken']").val();
                        $.ajax({
                            headers: { __RequestVerificationToken: csrfToken },
                            type: "POST",
                            url: url,
                            data: outData,
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            success: function (response) {
                                ClearAll();
                                EnableDataEntry();
                            },
                            error: function (xhr, status, error) {
                                var errorMessage = xhr.status + ': ' + xhr.responseText;
                                alert('Error - ' + errorMessage);
                            }
                        });
                    })
                });
            });

            $("#btnSave").on('click', function () {
                SaveTransactions();

            });


            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion();
            });

            $(function () {
                $("#cboSearchBy").trigger('change');
            });


            $("#cboSearchBy").on('change', function () {
                $("#divSearchValue").html($("#cboSearchBy option:selected").text());
                if ($("#cboSearchBy").val() == "accountno") {
                    $("#txtSearchValue").mask(AccountMask);
                } else {
                    $("#txtSearchValue").unmask();
                }
            });

            $("#btnCancel").on('click', function () {
                xDialogConfirm("Cancel current batch?", "Confirm").then(function () {
                    ClearAll();
                    DisableDataEntry();
                });
            });







            $("#txtSearchValue").on('focusout', function (e) {
                LoanMemberBalances();
            });
            $("#txtSearchValue").on('change', function () {
                transmember = null;
                $("#divMemberDetails").html("");
                ClearTransTableRows();
                $("#cboAccount").empty();
                $("#cboAccount").append("<option selected value='selectaccount' >(SELECT ACCOUNT)</option'>");
                LoadAccounts();
            });
            $("#cboSearchBy").on('focusout', function () {
                LoanMemberBalances();
            });

            $("#cboTransMode").on('change', function () {
                LoadAccounts();
            });

            $("#btnAddAccount").on('click', function () {
                xDialogSelectGLAccount("ALL").then(function (data) {
                    var acccode = data;
                    var tbody = document.getElementById('bdTransactionItems');
                    var tableRows = tbody.getElementsByTagName('tr');
                    var rowCount = tableRows.length + 1;
                    var accname = "";
                    GetAccountName(acccode).then(function (acname) {
                        accname = acname;
                        var tbl_row = "<tr>";
                        tbl_row += "<td>" + rowCount + "</td>";
                        tbl_row += "<td>O</td>";
                        tbl_row += "<td>" + acccode + "</td>";
                        tbl_row += "<td>" + accname + "</td>";
                        tbl_row += "<td>N/A</td>";
                        tbl_row += "<td><input type='text' name ='txtAmount[]' value='0.00' class='numbertext' /></td>";
                        tbl_row += "</tr>";

                        $("#tblTransactionDetails").append(tbl_row);
                    });

                });
            });

            function LoadAccounts() {
                $("#cboAccount").empty();
                $("#cboAccount").append("<option selected value='selectaccount' >(SELECT ACCOUNT)</option'>");
                var TransMode = $("#cboTransMode").val().toString().toLowerCase();
                if (TransMode == "FOSA".toLowerCase()) {
                    if (transmember != null) {
                        if (transmember.SalaryAccount != null) {
                            $("#cboAccount").append("<option selected value='" + transmember.SalaryAccount + "'>" + transmember.SalaryAccount + "</option'>");
                        }
                    }
                }
                else if (TransMode == "CASH".toLowerCase()) {
                    if (cashaccounts != null) {
                        $.each(cashaccounts, function (index, cashaccount) {
                            $("#cboAccount").append("<option value='" + cashaccount.UserCode + "'>" + cashaccount.AccountName + "(" + cashaccount.UserCode + ")" + "</option'>");
                        });
                    }
                }
                else {
                    if (bankaccounts != null) {
                        $.each(bankaccounts, function (index, bankaccount) {
                            $("#cboAccount").append("<option value='" + bankaccount.UserCode + "'>" + bankaccount.AccountName + "(" + bankaccount.UserCode + ")" + "</option'>");
                        });
                    }
                }
            }

            function LoanMemberBalances() {
                transmember = null;
                ClearTransTableRows();
                $("#txtTotals").val("0.00");
                $("#divMemberDetails").html("");
                if ($("#txtSearchValue").val().toString().trim().length == 0) {
                    return;
                }
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetMemberBalancesSummary") %>",
                    data: "{'SearchBy' : '" + $("#cboSearchBy").val() + "','SearchValue' : '" + $("#txtSearchValue").val() + "','EmpCode' : '" + $("#cboEmployer").val() + "','IncludeNegativeLoans' : 'Y'}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var balance = response.MemberBals;
                        transmember = response.MemberDetails;

                        LoadAccounts();

                        $.each(balance, function (index, bal) {
                            if (bal.BalType.toString().toLowerCase() != "F".toLowerCase()) {
                                var tbl_row = "<tr>";
                                tbl_row += "<td>" + index + "</td>";
                                tbl_row += "<td>" + bal.BalType + "</td>";
                                tbl_row += "<td>" + bal.BalCode + "</td>";
                                tbl_row += "<td>" + bal.BalName + "</td>";
                                tbl_row += "<td>" + bal.BalAmount + "</td>";
                                tbl_row += "<td><input type='text' name ='txtAmount[]' value='0.00' class='numbertext' /></td>";
                                tbl_row += "</tr>";

                                $("#tblTransactionDetails").append(tbl_row);
                            }
                        });

                        var tbl = "<table><tr><td><b>EmpCode</b></td><td><b>PayrollNo</b></td><td><b>MemberNo</b></td><td><b>Names</b></td><td><b>Details</b></td></tr>"
                        tbl += "<tr><td>" + transmember.EmployerCode + "</td><td>" + transmember.PayrollNo + "</td><td>" + transmember.MemberNo + "</td><td>" + transmember.FullNames + "</td><td><a href='" + global_site_root + "/Bank/BankSystem/MembersMasterFile?EditMode=true&EmpCode=" + transmember.EmployerCode + "&PayrollNo=" + transmember.PayrollNo + "'>Details</a></td></tr>"
                        $("#divMemberDetails").html(tbl);

                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                        //$("#txtSearchValue").focus(); do not uncomment does wonders alerts in a loop!!!
                    }

                });
            }

            function ClearAll() {
                document.getElementById("cboEmployer").selectedIndex = 0;
                $("#txtSearchValue").val("");
                $("#txtChequeNo").val("");
                $("#txtTotals").val("0.00");
                $("#cboAccount").empty();
                $("#cboAccount").append("<option value='selectaccount' selected>(SELECT ACCOUNT)</option>");
                $("#divMemberDetails").html("");
                ClearTransTableRows();

            }
            function EnableDataEntry() {
                $("#cboTransType").prop('disabled', true);
                $("#cboYear").prop('disabled', true);
                $("#cboPeriod").prop('disabled', true);
                $("#btnSave").prop('disabled', false);
                $("#btnAddAccount").prop('disabled', false);
                $("#btnCancel").prop('disabled', false);
                $("#btnNew").prop('disabled', true);

                $("#cboEmployer").prop('disabled', false);
                $("#cboSearchBy").prop('disabled', false);
                $("#txtSearchValue").prop('disabled', false);
                $("#txtDate").prop('disabled', false);
                $("#cboTransMode").prop('disabled', false);
                $("#txtChequeNo").prop('disabled', false);
                $("#cboAccount").prop('disabled', false);

                ClearTransTableRows();

                $("#txtSearchValue").focus();
            }
            function DisableDataEntry() {
                document.getElementById("cboTransType").selectedIndex = 0;

                $("#cboTransType").prop('disabled', false);
                $("#cboYear").prop('disabled', false);
                $("#cboPeriod").prop('disabled', false);
                $("#btnSave").prop('disabled', true);
                $("#btnAddAccount").prop('disabled', true);
                $("#btnCancel").prop('disabled', true);
                $("#btnNew").prop('disabled', false);

                $("#cboEmployer").prop('disabled', true);
                $("#cboSearchBy").prop('disabled', true);
                $("#txtSearchValue").prop('disabled', true);
                $("#txtDate").prop('disabled', true);
                $("#cboTransMode").prop('disabled', true);
                $("#txtChequeNo").prop('disabled', true);
                $("#cboAccount").prop('disabled', true);

                ClearTransTableRows();

            }
            function ClearTransTableRows() {
                $("#tblTransactionDetails > tbody:last").children().remove();
            }
            function CalcTotals() {
                var totals = 0;
                $("#tblTransactionDetails").find(".numbertext").each(function () {
                    if (isNumber($(this).val())) {
                        totals += parseFloat($(this).val());
                    }
                });
                $("#txtTotals").val(totals.toFixed(2));
            }
            function LoadFinancialPeriods() {
                var dbname = $("#cboYear").val();
                if (dbname == null) { return; }
                $("#cboStartMonth").empty();
                $("#cboEndMonth").empty();

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetAllBOSAFinancialMonths") %>",
                    data: JSON.stringify({ 'DBName': $("#cboYear").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var fmonths = response;
                        var objPeriod = document.getElementById("cboPeriod");


                        $("#cboPeriod").empty();
                        $.each(fmonths, function (index, fmonth) {
                            var optn = "<option value='" + fmonth.MonthID + "'>" + fmonth.MonthName + "</option>";
                            $("#cboPeriod").append(optn);

                            if (fmonth.Status == "OPENED") {
                                objPeriod.selectedIndex = index
                            }
                        });
                        DispTransactionsListSummary();
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });

            }
            function setCookie(c_name, value, expiredays) {
                var exdate = new Date();
                exdate.setDate(exdate.getDate() + expiredays);
                document.

                    e = c_name + "=" + escape(value) +
                ((expiredays == null) ? "" : ";expires=" + exdate.toUTCString());
            }
            function getCookie(c_name) {
                if (document.cookie.length > 0) {
                    c_start = document.cookie.indexOf(c_name + "=");
                    if (c_start != -1) {
                        c_start = c_start + c_name.length + 1;
                        c_end = document.cookie.indexOf(";", c_start);
                        if (c_end == -1) c_end = document.cookie.length;
                        return unescape(document.cookie.substring(c_start, c_end));
                    }
                }
                return "";
            }


            function SaveTransactions() {

                CalcTotals();
                var totals = $("#txtTotals").val();

                if (!isNumber(totals)) {
                    alert("Invalid Totals");
                    return;
                }

                if (+totals <= 0) {
                    alert("Invalid totals");
                    return;
                }


                if (document.getElementById("cboAccount").selectedIndex == 0) {
                    alert("Select Account");
                    return;
                }
                if (document.getElementById("cboTransType").selectedIndex == 0) {
                    alert("Select Account");
                    return;
                }
                if (($("#cboAccount").val().trim()) == "") {
                    alert("Select Account");
                    return;
                }
                if (!IsValidDate($("#txtDate").val())) {
                    alert("Invalid Date");
                    return;
                }
                if (transmember == null) {
                    alert("Specify member record");
                    return;
                }
                var PostEntries = new Array();
                var tbody = document.getElementById('bdTransactionItems');
                var tableRows = tbody.getElementsByTagName('tr');
                var rowCount = tableRows.length;
                var Entries = 0;
                var TotalAmount = 0;
                var UserName = "";
                var Password = "";
                var RowsWithMoreThanZero = 0;
                var UserName = getCookie("StaffLoginName");
                var url = "<%: Url.Content("~/api/BankSystemApi/SaveRefundsAndMPATransactions") %>";



                for (var x = 0; x < rowCount; x++) {
                    var PostEntry = {};
                    var lineamount = 0;
                    var myrow = tbody.getElementsByTagName("tr")[x];
                    var mycel = myrow.getElementsByTagName("td")[5];
                    lineamount = mycel.childNodes.item(0).value;

                    if (!isNumber(lineamount)) {
                        alert("Invalid Line Amount " + lineamount + " at row " + x);
                        return;
                    }
                    lineamount = +lineamount;
                    if (lineamount < 0) {
                        alert(" Amount " + lineamount + " should be more than or equal to Zero. At row " + x);
                        return;
                    }

                    PostEntry.RefID = x;
                    PostEntry.BranchCode = getCookie("BranchCode");
                    PostEntry.ClassCode = "BOSA";
                    PostEntry.PeriodCode = $("#cboPeriod").val();
                    PostEntry.DateIn = "";
                    PostEntry.Amount = lineamount;
                    PostEntry.DocumentType = $("#cboTransType option:selected").text();
                    PostEntry.DocumentNo = "";
                    PostEntry.DocumentDate = $("#txtDate").val();
                    if (document.getElementById("cboTransType").selectedIndex == 1) { //REFUNDS CR ACC DR MPA
                        PostEntry.DrTransType = myrow.getElementsByTagName("td")[1].innerHTML;
                        PostEntry.CrTransType = "O";
                        PostEntry.DrAccount = myrow.getElementsByTagName("td")[2].innerHTML;
                        PostEntry.CrAccount = $("#cboAccount").val();
                        PostEntry.DrSchemeCode = myrow.getElementsByTagName("td")[2].innerHTML;
                        PostEntry.CrSchemeCode = "";
                        PostEntry.DrLoanTypeCode = myrow.getElementsByTagName("td")[2].innerHTML;
                        PostEntry.CrLoanTypeCode = "";
                        PostEntry.DrLoanSerialNumber = myrow.getElementsByTagName("td")[2].innerHTML;
                        PostEntry.CrLoanSerialNumber = "";
                        PostEntry.DrEmpCode = transmember.EmployerCode;
                        PostEntry.DrPayrollNo = transmember.PayrollNo;
                        PostEntry.CrEmpCode = transmember.EmployerCode;
                        PostEntry.CrPayrollNo = transmember.PayrollNo;
                    } else if (document.getElementById("cboTransType").selectedIndex == 2) { //MPA CREDIT CR MPA DR ACC 
                        PostEntry.DrTransType = "O"
                        PostEntry.CrTransType = myrow.getElementsByTagName("td")[1].innerHTML;
                        PostEntry.DrAccount = $("#cboAccount").val();
                        PostEntry.CrAccount = myrow.getElementsByTagName("td")[2].innerHTML;
                        PostEntry.DrSchemeCode = "";
                        PostEntry.CrSchemeCode = myrow.getElementsByTagName("td")[2].innerHTML;
                        PostEntry.DrLoanTypeCode = "";
                        PostEntry.CrLoanTypeCode = myrow.getElementsByTagName("td")[2].innerHTML;
                        PostEntry.DrLoanSerialNumber = "";
                        PostEntry.CrLoanSerialNumber = myrow.getElementsByTagName("td")[2].innerHTML;
                        PostEntry.DrEmpCode = transmember.EmployerCode;
                        PostEntry.DrPayrollNo = transmember.PayrollNo;
                        PostEntry.CrEmpCode = transmember.EmployerCode;
                        PostEntry.CrPayrollNo = transmember.PayrollNo;
                    } else {
                        alert("Invalid Trans type");
                        return;
                    }
                    PostEntry.Description = "";
                    PostEntry.AppraisalUser = UserName;
                    PostEntry.ApprovalUser = UserName;
                    PostEntry.PostUser = "";
                    PostEntry.AppraisalDate = "";
                    PostEntry.ApprovalDate = "";
                    PostEntry.PostDate = "";
                    PostEntry.Status = "Approved";
                    PostEntry.Posted = "N";
                    PostEntry.ChequeNo = "";
                    PostEntry.UserDoc = "";
                    if (lineamount > 0) {
                        TotalAmount = TotalAmount + +PostEntry.Amount;
                        PostEntries[Entries] = PostEntry;
                        Entries++;
                    }

                }
                if (Entries == 0) {
                    alert("Nothing to save");
                    return;
                }
                var outData = {
                    'DBName': $("#cboYear").val(),
                    'PeriodCode': $("#cboPeriod").val(),
                    'PostEntries': PostEntries
                }

                outData = JSON.stringify(outData);
                var yy = 0;
                xDialogConfirm("Transactions Type: " + $("#cboTransType option:selected").text() + ", Total Amount = " + $("#txtTotals").val() + " Member: " + transmember.FullNames + " PayrollNo " + transmember.PayrollNo + " Member No: " + transmember.MemberNo + "?", "Confirm").then(function () {
                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                    $.ajax({
                        headers: { __RequestVerificationToken: csrfToken },
                        type: "POST",
                        url: url,
                        data: outData,
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            //alert("Document Saved successfully");
                            ClearAll();
                            yy++;
                            console.log(yy);
                            xDialogMessage("Document Saved successfully", "Document Saved").then(function () {
                                $("#txtSearchValue").focus();
                                //DisableDataEntry(); allow user to continue data entry
                            });

                        },
                        error: function (xhr, status, error) {
                            var errorMessage = xhr.status + ': ' + xhr.responseText;
                            alert('Error - ' + errorMessage);
                        }
                    });
                });
            }

            function DispTransactionsListSummary() {
                $("#tblTransListSummary > tbody:last").children().remove();
                $("#tblTransListDetails > tbody:last").children().remove();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetGeneralTransactionsSummary") %>",
                    data: "{'DBName' : '" + $("#cboYear").val() + "','PeriodCode' : '" + $("#cboPeriod").val() + "','DocumentType' : '" + $("#cboTransType").val() + "','PostedStatus' : '" + $("#cboFilterPostedStatus").val() + "','BranchCode' : '" + $("#cboFilterBranches").val() + "'}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var row_datas = response;

                        $.each(row_datas, function (index, row_data) {
                            var tbl_row = "<tr>";
                            tbl_row += "<td id='tdDocno[]'><input type='checkbox' id=chk1[]/>" + row_data.DocumentNo + "</td>";
                            tbl_row += "<td>" + row_data.TransCount + "</td>";
                            tbl_row += "<td>" + row_data.DateIn + "</td>";
                            tbl_row += "<td>" + row_data.AppraisalUser + "</td>";
                            tbl_row += "<td>" + row_data.Amount + "</td>";
                            tbl_row += "<td>" + row_data.Status + "</td>";
                            tbl_row += "<td>" + row_data.BranchCode + "</td>";
                            tbl_row += "<td>" + row_data.BranchName + "</td>";
                            tbl_row += "<td>" + row_data.PostUser + "</td>";
                            tbl_row += "<td>" + row_data.PostDate + "</td>";
                            tbl_row += "</tr>";
                            $("#tblTransListSummary").append(tbl_row);
                        });
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }

                });


            }

            function DispTransactionsListDetails(DocNo) {
                $("#tblTransListDetails > tbody:last").children().remove();
                $("#pDocDetails").html("Document No : " + DocNo + " Details");
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetGeneralTransactionsDetails") %>",
                    data: "{'DBName' : '" + $("#cboYear").val() + "','PeriodCode' : '" + $("#cboPeriod").val() + "','DocumentType' : '" + $("#cboTransType").val() + "','DocumentNo' : '" + DocNo + "'}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var row_datas = response;

                        $.each(row_datas, function (index, row_data) {
                            var tbl_row = "<tr>";
                            tbl_row += "<td><input type='checkbox' id=chkDetails[]/>" + row_data.RefID + "</td>";
                            tbl_row += "<td>" + row_data.DrTransType + "</td>";
                            tbl_row += "<td>" + row_data.DrAccount + "</td>";
                            tbl_row += "<td>" + row_data.DrAccName + "</td>";
                            tbl_row += "<td>" + row_data.DrMemberNo + "</td>";
                            tbl_row += "<td>" + row_data.DrMemberNames + "</td>";

                            tbl_row += "<td>" + row_data.CrTransType + "</td>";
                            tbl_row += "<td>" + row_data.CrAccount + "</td>";
                            tbl_row += "<td>" + row_data.CrAccName + "</td>";
                            tbl_row += "<td>" + row_data.CrMemberNo + "</td>";
                            tbl_row += "<td>" + row_data.CrMemberNames + "</td>";

                            tbl_row += "<td>" + row_data.Description + "</td>";
                            tbl_row += "<td>" + row_data.DocumentDate + "</td>";
                            tbl_row += "<td>" + row_data.Amount + "</td>";
                            tbl_row += "</tr>";
                            $("#tblTransListDetails").append(tbl_row);
                        });
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }

                });
            }

            function PostTransactions(data) {
                var UserName = data.UserName;
                var Password = data.UserPass;
                var csrfToken = $("input[name='__RequestVerificationToken']").val();

                var pwdslt = getRandomInt(1000, 30000);
                pwdslt = pwdslt.toString();
                var pwd = CryptoJS.MD5(Password).toString();
                pwd = pwd + pwdslt;
                var sltpwd = CryptoJS.MD5(pwd).toString();

                var table = document.getElementById('tblTransListSummary');
                var rowCount = table.rows.length;
                if (rowCount == 0) { alert("Nothing to post"); return; }

                for (var i = 0; i < rowCount; i++) {
                    var row = table.rows[i];
                    var chkbox = row.cells[0].childNodes[0];
                    if (null != chkbox && true == chkbox.checked) {
                        var DocNo = row.cells[0].textContent;
                        var outData = {
                            'DBName': $("#cboYear").val(),
                            'PeriodCode': $("#cboPeriod").val(),
                            'DocumentType': $("#cboTransType").val(),
                            'DocumentNo': DocNo,
                            'Password': sltpwd,
                            'Salt': pwdslt
                        }
                        outData = JSON.stringify(outData);
                        $.ajax({
                            headers: { __RequestVerificationToken: csrfToken },
                            type: "POST",
                            url: "<%: Url.Content("~/api/BankSystemApi/PostGeneralTransactions") %>",
                            data: outData,
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            success: function (response) {
                                var docno = response;
                            },
                            error: function (xhr, status, error) {
                                var errorMessage = xhr.status + ': ' + xhr.responseText;
                                alert('Error - ' + errorMessage);
                            }

                        });

                    }
                }
            }
        });
    </script>
</asp:Content>
<asp:Content ID="Content6" ContentPlaceHolderID="FeaturedContent" runat="server">
    <h3>Refunds And MPA Credit</h3>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <table>
        <tr>
            <td>
                Year:
            </td>
            <td>
                <select id="cboYear"><option value="selectyear">SELECT YEAR</option></select>
            </td>
            <td>
                Month:
            </td>
            <td> 
                <select id="cboPeriod"><option value="selectstartperiod" selected>(SELECT PERIOD)</option></select>
            </td>
            <td>Type:</td>
            <td><select id="cboTransType">
                <option value="selecttype" selected>(SELECT TYPE)</option>
                <option value="REFUND">REFUND</option>
                <option value="MPA CREDIT">MPA CREDIT</option>
                </select>
            </td>
        </tr>
    </table>
    <hr />
    <div id="tabs">
      <ul>
        <li><a href="#tabs-1">Capture Transactions</a></li>
        <li><a href="#tabs-2">Transactions Listing</a></li>
      </ul>

    <form name="frmMain" id="frmMain">
        <%= Html.AntiForgeryToken() %>
        
        <div id="tabs-1">
        <table id="tblDetails" border="1">
            
            
            <tr><td colspan="6"><b>Member Details</b></td></tr>
            <tr>
                <td colspan="6"><hr /></td>
            </tr>
            <tr>
                <td>Employer</td>
                <td colspan="5"><select id="cboEmployer"><option value="selectemployer" selected>(SELECT EMPLOYER)</option></select></td>
            </tr>
            <tr>
                <td>
                    Search By
                </td>
                <td >
                    <select id="cboSearchBy">
                        <option value="memberno" selected>Member No</option>
                        <option value="payrollno" >Payroll No</option>
                        <option value="idnumber" >ID No</option>
                        <option value="accountno" >Account No</option>
                    </select>
                </td>
                <td>
                    <div id="divSearchValue"> Search Value:</div>
                </td>
                <td>
                    <input type="text" id="txtSearchValue" value="" />
                </td>
            </tr>
            <tr>
                <td colspan="6">
                    <div id="divMemberDetails">...</div>
                </td>
            </tr>
            
            
         
        </table>
            
            <b>Transactions</b>
            <hr />
            <table>
                <tr>
                    <td>Doc. Date</td><td><input type="text" id="txtDate"/></td>
                    <td>Mode</td><td>
                        <select id="cboTransMode">
                            <option value="fosa" selected>FOSA</option>
                            <option value="cash">CASH</option>
                            <option value="bank">BANK</option>
                            <option value="sto">STO</option>
                            <option value="eft">EFT</option>
                            <option value="rtgs">RTGS</option>
                        </select></td>
                    <td>Cheque No</td>
                    <td><input type="text" id="txtChequeNo"/></td>
                </tr>
                <tr>
                    <td>Account</td><td><select id="cboAccount"><option value="selectaccount">(SELECT ACCOUNT)</option></select></td>
                    <td>TOTALS</td><td><input type="text" id="txtTotals"  class="numbertext" readonly="true"/></td>
                </tr>
            </table>
            <hr />
            <div id="divTransactionItemList" style="height:150px;overflow:auto;width:auto;">
               
            <table id='tblTransactionDetails' class="table table-striped tblTransactionDetails">
                    <thead>
                        <tr>
                        <th><b>Row_No</b></th>
                        <th><b>Type</b></th>
                        <th><b>Item Reference</b></th>
                        <th><b>Item Name</b></th>
                        <th><b>Balance</b></th>
                        <th><b>Amount</b></th>
                        </tr>
                    </thead>
                    <tbody id='bdTransactionItems'>
                    </tbody>
                <tfoot>
                    <tr>
                        <td>
                            
                        </td>
                        <td>
                            
                        </td>
                        <td>
                            
                        </td>
                        
                    </tr>
                </tfoot>
            </table>
                
            </div>
            <hr />      
             <table>
                    <tr>
                        <td><input type="button" value="New Batch" id="btnNew" /></td>
                        <td><input type="button" value="Cancel Batch" id="btnCancel" /></td>
                        <td><input type="button" value="Add Other Accounts" id="btnAddAccount" /></td>
                        <td><input type="button" value="Save Batch" id="btnSave" /></td>
                    </tr>
                </table>
        </div>
        <div id="tabs-2">
        <table id="tblListing" border="1" >
            <tr>
                <td>Posted</td>
                <td>
                    <select id="cboFilterPostedStatus">
                    <option value="UNPOSTED" selected>UNPOSTED</option>
                    <option value="POSTED" >POSTED</option>
                    <option value="" >ALL</option>
                    </select>
                </td>
                <td>Branch</td>
                <td>
                    <select id="cboFilterBranches">
                    <option value="" selected>(ALL)</option>
                    </select>
                </td>
            </tr>
            
        </table>
             <div id="divTransListSummary" style="height:200px;overflow:auto;width:auto;" class="row">
                <table id='tblTransListSummary' class="table table-striped">
                        <thead>
                            <tr>
                            <th><b>Document No</b></th>
                            <th><b>Transactions</b></th>
                            <th><b>Doc Date</b></th>
                            <th><b>Appraisal User</b></th>
                            <th><b>Amount</b></th>
                            <th><b>Status</b></th>
                            <th><b>Branch</b></th>
                            <th><b>Branch Name</b></th>
                            <th><b>Post User</b></th>
                            <th><b>Post Date</b></th>
                                
                            </tr>
                        </thead>
                        <tbody id='bdTransListSummary'>
                        </tbody>
                    <tfoot>
                        <tr>
                            <td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
            <table>
                <tr>
                    <td><input type="button" id="btnRefresh" value="Refresh List" /></td>
                    <td><input type="button" id="btnPost" value="Post Selected Documents" /></td>
                    <td><input type="button" id="btnDeleteDoc" value="Delete Selected Documents" /></td>
                </tr>
            </table>
            <hr />
            <p id="pDocDetails">Document Details</p>
            <hr />
            <div id="divTransListDetails" style="height:150px;overflow:auto;width:auto;">
                <table id='tblTransListDetails' class="table table-striped">
                        <thead>
                            <tr>
                            <th><b>Ref_No</b></th>
                            <th><b>DR_Type</b></th>
                            <th><b>DR_Acc</b></th>
                            <th><b>DR_Acc_Name</b></th>
                            <th><b>DR_MemberNo</b></th>
                            <th><b>DR_Member_Names</b></th>
                            <th><b>CR_Type</b></th>
                            <th><b>CR_Acc</b></th>
                            <th><b>CR_Acc_Name</b></th>
                            <th><b>CR_Member_No</b></th>
                            <th><b>CR_Member_Names</b></th>
                            <th><b>Description</b></th>
                            <th><b>Date</b></th>
                            <th><b>Amount</b></th>
                            </tr>
                        </thead>
                        <tbody id='bddivTransListDetails'>
                        </tbody>
                    <tfoot>
                        <tr>
                            <td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td>
                        </tr>
                    </tfoot>
                </table>
                
            </div>
            <table>
                <tr>
                    <td>
                        <input type="button" id="btnDeleteSelected" value="Delete Selected Line items" />
                    </td>
                </tr>
            </table>
            <hr />  
        </div>

    </form>
        <div class="container">
        <br />
        <br />
        <input type="button" id="btnProcessBatch" value="Process Batch" />
        <input type="text" id="txtProgress" />
        <br />
        <br />
        <div class="progress">
            <div id="prgProgress" class="progress-bar  progress-bar-striped" role="progressbar" aria-valuenow="0"
                aria-valuemin="0" aria-valuemax="100" style="min-width:1px">
            </div>
        </div>
        <br />
        <br />
    </div>
</div>

</asp:Content>


