﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Bank/Views/Shared/StaffMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Treasury Management
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        .tblDRCRDetails {
             margin: 1px;
             border: 1em;
             padding-left:1em;
             padding-top:1em;
             border-collapse:separate;
         }
         
         /*use this for to calculate totals*/  
         .colamount {
            text-align:right;
         }
         tr.row_selected td{background-color:lawngreen;}
   </style>

    
    <script type="text/javascript"  >
        $(document).ready(function () {

            var treasury_accounts = null;
            var bank_accounts = null;
            var teller_accounts = null;


            $('#frmMain').on('mouseup', '[type=text],[type=date]', function (e) { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                e.preventDefault();
            });
            $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).select();
            });
            $('#frmMain').on('focus', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).addClass("textfocused");
            });
            $('#frmMain').on('focusout', '[type=text],[type=date]', function () { //attach handler to body or parent for the dynamically created input box (attach to the nearest parent ie table
                $(this).removeClass("textfocused");
            });

            $("#txtAmount").on('change keyup paste mouseup', function () {
                $("#divAmountInWords").html("");
                try {
                    $("#divAmountInWords").html(toWords($("#txtAmount").val()));
                } catch (err) {

                }
            });
            $("#cboTreasuryAccount").on('change', function () {
                $("#divTreasuryBalance").empty();
                $("#divContraAccBal").empty();
                $("#cboContraAccount").empty();
                $("#cboContraAccount").append("<option value='' selected>(SELECT)</option>");
                $("#cboTransType").prop('selectedIndex', 0);
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetAccountBalance") %>",
                    data: JSON.stringify({ 'AccountNo': $("#cboTreasuryAccount").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        $("#divTreasuryBalance").html("<b>&nbsp;&nbsp;Balance: ( " + SaccoSettings.CurrencySymbol + ") : " + response.formatMoney() + "</b>");

                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                    }
                });
            });
            $("#cboContraAccount").on('change', function () {
                $("#divContraAccBal").empty();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetAccountBalance") %>",
                    data: JSON.stringify({ 'AccountNo': $("#cboContraAccount").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        $("#divContraAccBal").html("<b>&nbsp;&nbsp;Balance: ( " + SaccoSettings.CurrencySymbol + ") : " + response.formatMoney() + "</b>");
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                    }
                });
            });

            $("#cboYear").empty();
            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/BankSystemApi/GetTreasuryManagementModuleConfig") %>",
                data: "{}",
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    var years = response.Years;
                    treasury_accounts = response.TreasuryAccounts;
                    bank_accounts = response.BankAccounts;
                    teller_accounts = response.Tellers;
                    var saccobranches = response.Branches;
                    SaccoSettings = response.SaccoSettings;
                    var obj = document.getElementById("cboYear");
                    $.each(years, function (index, yrs) {
                        var opt = document.createElement("option");
                        opt.value = yrs.DBName;
                        opt.text = yrs.UserDefinedYearName;
                        opt.selected = true;
                        obj.appendChild(opt);
                    });
                    $("#cboYear").get(0).selectedIndex = 0;
                    var obj = document.getElementById("cboBranch");
                    $.each(saccobranches, function (index, saccobranch) {
                        var opt = document.createElement("option");
                        opt.value = saccobranch.BranchCode;
                        opt.text = saccobranch.BranchName + "(" + saccobranch.BranchCode + ")";
                        obj.appendChild(opt);
                    });
                    $("#cboTreasuryAccount").empty();
                    var obj = document.getElementById("cboTreasuryAccount");
                    var opt = document.createElement("option");
                    opt.value = "";
                    opt.text = "(SELECT)";
                    obj.appendChild(opt);
                    $.each(treasury_accounts, function (index, treasury_account) {
                        var opt = document.createElement("option");
                        opt.value = treasury_account.TreasuryAcc;
                        opt.text = treasury_account.AccountName + "(" + treasury_account.TreasuryAcc + ")";
                        obj.appendChild(opt);
                    });
                    LoadFinancialPeriods();
                },
                error: function (xhr, status, error) {

                    var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                }
            });
            $("#cboTransType").on('change', function (e) {
                $("#divContraAccBal").empty();
                $("#cboContraAccount").empty();
                $("#cboContraAccount").append("<option value='' selected>(SELECT)</option>");
                var selected_trans_index = $("#cboTransType option:selected").index();
                if (selected_trans_index == 1) {
                    LoadBanks(); //cashfrombank
                } else if (selected_trans_index == 2) {
                    LoadBanks(); //cashtobank
                } else if (selected_trans_index == 3) {
                    LoadTreasuries(); //fromothertreasury
                } else if (selected_trans_index == 4) {
                    LoadTreasuries(); //toothertreasury
                } else if (selected_trans_index == 5) {
                    LoadTellers(); //fromteller
                } else if (selected_trans_index == 6) {
                    LoadTellers(); //toteller
                }
            });
            $('#tabs').on('tabsactivate', function (event, ui) {
                var newIndex = ui.newTab.index();
                if (newIndex == 1) {
                    GetCustomerChequeSalesReport();
                }
            });

            $("#btnRefresh").on('click', function () {
                GetCustomerChequeSalesReport();
            });
            $("#btnPrint").on('click', function () {
                var rptHeader = "<b>" + CompanyName + "<br>" + CompanyAddress + "</br>" + "Customer Cheque Sales Report";
                $("#divChequeSalesList").printThis({
                    debug: false,
                    pageTitle: "Report",
                    removeInline: true,
                    printContainer: true,
                    importCSS: true,
                    header: rptHeader
                });

            });

            $("#tblChequeSalesList").dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });

            $("#cboYear").on('change', function () {
                LoadFinancialPeriods()
            });
            $("#cboPeriod").on('change', function () {
                GetCustomerChequeSalesReport();
            });
            $("#cboBranch").on('change', function () {
                GetCustomerChequeSalesReport();
            });
            $("#btnRefresh").on('click', function () {
                GetCustomerChequeSalesReport();
            });
            $("#btnClear").on('click', function () {
                ClearInputs();
            });

            $("#txtAccountNo").mask(AccountMask);

            $("#btnPost").on('click', function () {
                if ($("#cboTransType option:selected").index() == 0) {
                    alert("Select Transaction Type");
                    return;
                }
                if ($("#cboTreasuryAccount option:selected").index() == 0) {
                    alert("Select Treasury");
                    return;
                }
                if ($("#cboContraAccount option:selected").index() == 0) {
                    alert("Select Contra Account");
                    return;
                }
                if (!isNumber($("#txtAmount").val())) {
                    alert("Invalid Amount");
                    return;
                }
                xDialogConfirm("Transaction: " + $("#cboTransType option:selected").text() + "<br/>Treasury: " + $("#cboTreasuryAccount option:selected").text() + "<br/>Amount=" + $("#txtAmount").val() + "<br/>Contra Account No " + $("#cboContraAccount option:selected").text() + "<br/>Post Transaction?", "Confirm").then(function () {
                    xDialogGetUserCredetials().then(function (data) {
                        PostTreasuryTransaction(data);
                    });
                });
            });

            function LoadBanks() {
                $("#cboContraAccount").empty();
                $("#cboContraAccount").append("<option value='' selected>(SELECT)</opt>");
                $.each(bank_accounts, function (index, bank_account) {
                    $("#cboContraAccount").append("<option value='" + bank_account.UserCode + "'>" + bank_account.AccountName + " ( " + bank_account.UserCode + ") </opt>");
                });
            }
            function LoadTellers() {
                var treasAcc = $("#cboTreasuryAccount").val();
                if (treasAcc == "") {
                    alert("Select treasury");
                    return;
                }
                $("#cboContraAccount").empty();
                $("#cboContraAccount").append("<option value='' selected>(SELECT)</opt>");
                $.each(teller_accounts, function (index, teller_account) {
                    if (treasAcc == teller_account.TreasuryAccount) {
                        $("#cboContraAccount").append("<option value='" + teller_account.AccountCode + "'>" + teller_account.UserName + " ( " + teller_account.AccountCode + ") </opt>");
                    }
                });
            }
            function LoadTreasuries() {
                $("#cboContraAccount").empty();
                $("#cboContraAccount").append("<option value='' selected>(SELECT)</opt>");
                $.each(treasury_accounts, function (index, treasury_account) {
                    $("#cboContraAccount").append("<option value='" + treasury_account.TreasuryAcc + "'>" + treasury_account.AccountName + " ( " + treasury_account.TreasuryAcc + ") </opt>");
                });
            }

            function PostTreasuryTransaction(credetials) {

                var UserName = credetials.UserName;
                var Password = credetials.UserPass;
                var csrfToken = $("input[name='__RequestVerificationToken']").val();

                var pwdslt = getRandomInt(1000, 30000);
                pwdslt = pwdslt.toString();
                var pwd = CryptoJS.MD5(Password).toString();
                pwd = pwd + pwdslt;
                var sltpwd = CryptoJS.MD5(pwd).toString();

                var outData = {
                    'TransType': $("#cboTransType").val(),
                    'TreasuryAccount': $("#cboTreasuryAccount").val(),
                    'ContraAccount': $("#cboContraAccount").val(),
                    'Amount': $("#txtAmount").val(),
                    'DocumentNo': $("#txtDocNo").val(),
                    'ChequeNo': $("#txtChequeNo").val(),
                    'UserName': UserName,
                    'Password': sltpwd,
                    'Salt': pwdslt
                }
                outData = JSON.stringify(outData);
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/PostTreasuryTransaction") %>",
                    data: outData,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        alert("Posted");
                        ClearInputs();
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                    }

                });
            }

            function ClearInputs() {
                $("#cboTreasuryAccount").prop('selectedIndex', 0);
                $("#cboTransType").prop('selectedIndex', 0);
                $("#cboContraAccount").prop('selectedIndex', 0);
                $("#cboTransType").on('change');
                $("#txtAmount").val("0.00");
                $("#txtChequeNo").val("");
                $("#divTreasuryBalance").empty();
                $("#divContraAccBal").empty();
                $("#txtDocNo").val("");
                $("#divAmountInWords").empty();
            }



            function LoadFinancialPeriods() {
                var dbname = $("#cboYear").val();
                if (dbname == null) { return; }


                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/BankSystemApi/GetAllBOSAFinancialMonths") %>",
                    data: JSON.stringify({ 'DBName': $("#cboYear").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var fmonths = response;
                        var objPeriod = document.getElementById("cboPeriod");
                        $("#cboPeriod").empty();
                        $.each(fmonths, function (index, fmonth) {
                            var optn = "<option value='" + fmonth.MonthID + "'>" + fmonth.MonthName + "</option>";
                            $("#cboPeriod").append(optn);
                            if (fmonth.Status == "OPENED") {
                                objPeriod.selectedIndex = index
                            }

                        });
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                    }
                });
            }
            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion({
                    heightStyle: "content"
                });
            });
        });
    </script>
</asp:Content>
<asp:Content ID="Content6" ContentPlaceHolderID="FeaturedContent" runat="server">
<h3>Treasury Management</h3>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">

    <div id="tabs">
      <ul>
        <li><a href="#tabs-1">Transactions</a></li>
        <li><a href="#tabs-2">Reports</a></li>
      </ul>
        <form id="frmMain" name="frmMain" method="post">
            <%= Html.AntiForgeryToken() %>
            <div id="tabs-1">
                <table>
                    <tr>
                        <td> 
                            Treasury A/C:
                        </td>
                        <td>
                            <select id="cboTreasuryAccount"><option selected>(SELECT)</option></select>
                        </td>
                        <td>
                            <div id="divTreasuryBalance"></div>
                        </td>
                    </tr>
                    <tr>
                        <td> 
                            Trans. Type:
                        </td>
                        <td>
                            <select id="cboTransType">
                                <option value="" selected>(SELECT)</option>
                                <option value="cashfrombank">Cash From Bank</option>
                                <option value="cashtobank">Cash To Bank</option>
                                <option value="fromothertreasury">From Other Treasury</option>
                                <option value="toothertreasury">To Other Treasury</option>
                                <option value="fromteller">From Teller</option>
                                <option value="toteller">To Teller</option>
                            </select>
                        </td>
                        <td></td>
                    </tr>
                    
                    <tr>
                        <td>
                            Contra A/C:
                        </td>
                        <td>
                            <select id="cboContraAccount"></select>
                        </td>
                        <td>
                            <div id="divContraAccBal"></div>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                        Amount:
                        </td>
                        <td>
                        <input type="text" id="txtAmount" />
                        </td>
                        <td></td>
                    </tr>
                    <tr>
                        <td colspan="2">
                            <div id="divAmountInWords"></div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                        Cheque Number:
                        </td>
                        <td>
                        <input type="text" id="txtChequeNo" />
                        </td>
                        <td></td>
                    </tr>
                    <tr>
                        <td>
                        Document Number:
                        </td>
                        <td>
                        <input type="text" id="txtDocNo" />
                        </td>
                        <td></td>
                    </tr>
                    <tr>
                        <td>
                        <input type="button" value="Clear" id="btnClear" />
                        </td>
                        <td>
                        <input type="button" value="Post" id="btnPost" />
                        </td>
                        <td></td>
                    </tr>
                </table>
            </div>
            <div id="tabs-2">
                <table border="1" style="padding: 1px; margin: 1px;" id="tblPeriod">
                    <tr>
                        <td>Financial Year:</td><td><select id="cboYear"><option value="selectyear">SELECT YEAR</option></select></td>
                        <td>
                            Period:
                        </td>
                        <td> 
                            <select id="cboPeriod"><option value="selectperiod" selected>(SELECT PERIOD)</option></select>
                        </td>
                        <td>
                            Branch:
                        </td>
                        <td> 
                            <select id="cboBranch"><option value="" selected>(ALL BRANCHES)</option></select>
                        </td>
                    </tr>
                    <tr>
                        <td><input type="button" id="btnRefresh" value="Refresh"/></td>
                        <td><input type="button" id="btnPrint" value="Print"/></td>
                    </tr>
                </table>
                <div id="divChequeSalesList" style="height:200px;overflow:auto;width:auto;">
                <table id='tblChequeSalesList'  class='display'>
                        <thead>
                            <tr>
                            <th><b>Date</b></th>
                            <th><b>ChequeNo</b></th>
                            <th><b>AccountNo</b></th>
                            <th><b>A/C Name</b></th>
                            <th><b>Amount</b></th>
                            <th><b>User</b></th>
                            <th><b>Bank</b></th>
                            <th><b>Bank Name</b></th>
                            <th><b>Branch</b></th>
                            <th><b>Payee</b></th>
                                
                            </tr>
                        </thead>
                        <tbody id='bdTransactionsList'>
                        </tbody>
                    <tfoot>
                        <tr>
                            <td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
            </div>
        </form>
    </div>
    
    
</asp:Content>


