﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Members/Views/Shared/MembersMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Approve Loans for Appraisal
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
<style type="text/css"></style>
<script type="text/javascript"  >
    $(document).ready(function () {
        $("#cboYear").empty();
        var csrfToken = $("input[name='__RequestVerificationToken']").val();
        $.ajax({
            headers: { __RequestVerificationToken: csrfToken },
            type: "POST",
            url: "<%: Url.Content("~/api/MembersSystemApi/GetYears") %>",
            data: "{}",
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            success: function (response) {
                var years = response;
                var obj = document.getElementById("cboYear");
                $.each(years, function (index, yrs) {
                    var opt = document.createElement("option");
                    opt.value = yrs.DBName;
                    opt.text = yrs.UserDefinedYearName;
                    opt.selected = true;
                    obj.appendChild(opt);
                });
                LoadLoanRequests();
            },
            error: function (xhr, status, error) {

                var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
            }
        });

        $("#cboYear").on("change", function () {
            LoadLoanRequests();
        });

        $('#tblLoanRequests').dataTable({
            "paging": false,
            "ordering": false,
            "info": false,
            "searching": false
        });
        $('#bdLoanRequests').on('click', 'a', function (event) {
            event.preventDefault();
            var ln_ref_no = $(this).closest('tr').find('td').eq(1).text();
            var ln_mem_no = $(this).closest('tr').find('td').eq(2).text();
            var ln_requested_loanee_name = $(this).closest('tr').find('td').eq(3).text();
            var ln_requested_loan_type = $(this).closest('tr').find('td').eq(4).text();
            var ln_loan_amt = $(this).closest('tr').find('td').eq(5).text();

            var ln_requested_amt = $(this).closest('tr').find('td').eq(6).text();
            $('<div id="divManagerApprovalDialog"></div>').dialog({
                modal: true,
                title: "Approve/Reject Loan Request",
                height: 520,
                width: 500,
                autoOpen: true,
                show: {
                    effect: "drop",
                    direction: "up",
                    duration: 500
                },

                buttons: {
                    'OK': {
                        'text': 'OK',
                        'id': 'btnOK',
                        'click': function () {
                            var accepted_amount = $("#txtAcceptedAmt").val();
                            var ConfirmMessage = "";
                            if (document.getElementById("cboManagersResponse").selectedIndex == 1) {
                                ConfirmMessage = "Confirm Loan Approval of " + ln_loan_amt + " for " + ln_requested_loanee_name + " ?";
                            } else if (document.getElementById("cboManagersResponse").selectedIndex == 2) {
                                ConfirmMessage = "Confirm Rejection of Loan Appraisal for " + ln_requested_loanee_name + " ?";
                            } else if (document.getElementById("cboManagersResponse").selectedIndex == 0) {
                                alert("Select Response");
                                return;
                            }
                            xDialogConfirm(ConfirmMessage, "Confirm").then(function () {
                                xDialogMemberCredetials().then(function (data) {
                                    var csrfToken = $("input[name='__RequestVerificationToken']").val();
                                    var Password = data.UserPass;
                                    var pwdslt = getRandomInt(1000, 30000);
                                    pwdslt = pwdslt.toString();
                                    var pwd = CryptoJS.MD5(Password).toString();
                                    pwd = pwd + pwdslt;
                                    var sltpwd = CryptoJS.MD5(pwd).toString();
                                    var outData = {
                                        'DBName': $("#cboYear").val(),
                                        'LoanRefNo': $("#txtRequestLoanRefNo").val(),
                                        'Response': $("#cboManagersResponse").val(),
                                        'Notes': $("#txtResponseReason").val(),
                                        'Password': sltpwd,
                                        'Salt': pwdslt
                                    }
                                    outData = JSON.stringify(outData);
                                    $.ajax({
                                        headers: { __RequestVerificationToken: csrfToken },
                                        type: "POST",
                                        url: "<%: Url.Content("~/api/MembersSystemApi/ManagerApprovalResponse") %>",
                                        data: outData,
                                        contentType: "application/json; charset=utf-8",
                                        dataType: "json",
                                        success: function (response) {
                                            alert(response);
                                            $("#divManagerApprovalDialog").dialog("close");
                                            LoadLoanRequests();
                                        },
                                        error: function (xhr, status, error) {
                                            var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                                        }
                                    });
                                });
                            });
                        }
                    },
                    Cancel: function () {
                        $(this).dialog("close");
                    }
                },
                open: function () {
                    var tbl = "<table id='tblRespondLoanRequest' border=1>";
                    tbl += "<tbody>";
                    tbl += "<tr><td><b>Loan Ref. No:</b></td><td><input type='text' id='txtRequestLoanRefNo' value='" + ln_ref_no + "' disabled /></td></tr>";
                    tbl += "<tr><td><b>Loanee:</b></td><td><input type='text' id='txtRequestLoaneeName' value='" + ln_requested_loanee_name + "' disabled /></td></tr>";
                    tbl += "<tr><td><b>Loane MemberNo:</b></td><td><input type='text' id='txtRequestLoaneeMemberNo' value='" + ln_mem_no + "' disabled /></td></tr>";
                    tbl += "<tr><td><b>Loan Type:</b></td><td><input type='text' id='txtRequestLoanType' value='" + ln_requested_loan_type + "' disabled /></td></tr>";
                    tbl += "<tr><td><b>Loan Amount:</b></td><td><input type='text' id='txtRequestLoanAmount' value='" + ln_loan_amt + "' disabled /></td></tr>";
                    tbl += "<tr><td><b>Reponse:</b></td><td><select id='cboManagersResponse'><option value='' selected>(SELECT)</option><option value='accepted'>Accept</option><option value='rejected'>Reject</option></select></td></tr>";
                    tbl += "<tr><td><b>Notes/Reason:</b></td><td><textarea id='txtResponseReason' disabled/></textarea></td></tr>";
                    tbl += "</tbody></table>";
                    $(this).html(tbl);
                    $("#cboManagersResponse").focus;
                },
                close: function (event, ui) {
                    $(this).dialog("destroy").remove();
                }
            });

            $("#txtAcceptedAmt").on('change keyup paste mouseup', function () {
                $("#divAcceptedAmtInWords").html("");
                try {
                    $("#divAcceptedAmtInWords").html(toWords($(this).val()));
                } catch (err) {

                }
            });
            $("#cboManagersResponse").on('change', function () {
                $("#txtResponseReason").attr("disabled", true);
                $("#txtResponseReason").val("");
                if ($("#cboManagersResponse option:selected").index() == 1) {
                    $("#txtResponseReason").attr("disabled", false);
                }
                else if ($("#cboManagersResponse option:selected").index() == 2) {
                    $("#txtResponseReason").attr("disabled", false);
                }
            });
        });
        function LoadLoanRequests() {
            $("#tblLoanRequests > tbody:last").children().remove();
            var dbname = $("#cboYear").val();
            if (dbname == null) { return; }
            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/MembersSystemApi/GetManagerLoanRequests") %>",
                data: JSON.stringify({ 'DBName': $("#cboYear").val() }),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    var ManagerLoanRequests = response;
                    var tbl_row = "";
                    $.each(ManagerLoanRequests, function (index, ManagerLoanRequest) {
                        $("#tblLoanRequests > tbody:last").children().remove();
                        tbl_row += "<tr>";
                        tbl_row += "<td>" + ManagerLoanRequest.LoanDate + "</td>";
                        tbl_row += "<td>" + ManagerLoanRequest.LoanRefNo + "</td>";
                        tbl_row += "<td>" + ManagerLoanRequest.MemberNo + "</td>";
                        tbl_row += "<td>" + ManagerLoanRequest.MemberNames + "</td>";
                        tbl_row += "<td>" + ManagerLoanRequest.LoanTypeName + "</td>";
                        tbl_row += "<td>" + (+ManagerLoanRequest.RequestedAmount).formatMoney() + "</td>";
                        tbl_row += "<td>" + ManagerLoanRequest.ManagerApprovalDate + "</td>";
                        tbl_row += "<td>" + ManagerLoanRequest.ManagerApprovalStatus + "</td>";
                        tbl_row += "<td><a href=''>Respond</td>";
                        tbl_row += "<td>" + ManagerLoanRequest.ManagerComments + "</td>";
                        tbl_row += "</tr>";
                    });
                    if (tbl_row != "") { $("#bdLoanRequests").append(tbl_row); }

                },
                error: function (xhr, status, error) {
                    var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                }
            });
        }

        function setCookie(c_name, value, expiredays) {
            var exdate = new Date();
            exdate.setDate(exdate.getDate() + expiredays);
            document.

                e = c_name + "=" + escape(value) +
            ((expiredays == null) ? "" : ";expires=" + exdate.toUTCString());
        }
        function getCookie(c_name) {
            if (document.cookie.length > 0) {
                c_start = document.cookie.indexOf(c_name + "=");
                if (c_start != -1) {
                    c_start = c_start + c_name.length + 1;
                    c_end = document.cookie.indexOf(";", c_start);
                    if (c_end == -1) c_end = document.cookie.length;
                    return unescape(document.cookie.substring(c_start, c_end));
                }
            }
            return "";
        }

        $(function () {
            $("#tabs").tabs();
        });
        $(function () {
            $("#accordion").accordion({
                heightStyle: "content"
            });
        });
    });

    </script>
</asp:Content>

<%--<asp:Content ID="Content6" ContentPlaceHolderID="FeaturedContent" runat="server">
<h3>Approve Loans for Appraisal</h3>
</asp:Content>--%>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    
    <form id="frmMain" name="frmMain">
        <%= Html.AntiForgeryToken() %>
    <table border="1" style="padding: 1px; margin: 1px;">
        <tr>
            <td colspan="4"><b>Financial Period</b></td>
        </tr>
        <tr><td>Financial Year:</td><td colspan="3"><select id="cboYear"><option value="selectyear">SELECT YEAR</option></select></td></tr>
        
    </table>
    
        <div id="divLoanRequests">
            <table id='tblLoanRequests' class='display'>
                    <thead>
                        <tr>
                        <th ><b>Date</b></th>
                        <th ><b>Ref.No</b></th>
                        <th ><b>MemberNo</b></th>
                        <th ><b>Names</b></th>
                        <th ><b>Loan Type</b></th>
                        <th ><b>Loan Amount</b></th>
                        <th ><b>ResponseDate</b></th>
                        <th ><b>Status</b></th>
                        <th ><b>Respond</b></th>
                        <th ><b>Comments</b></th>
                        </tr>
                    </thead>
                    <tbody id='bdLoanRequests'>
                    </tbody>
                <tfoot>
                    <tr>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </form>
    <div></div>
</asp:Content>


