﻿<%@ Page Title="Member Summary" Language="C#" MasterPageFile="~/Areas/Members/Views/Shared/MembersMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="TitleContent" ContentPlaceHolderID="TitleContent" runat="server">
    Member Summary
</asp:Content>

<asp:Content ID="MainContent" ContentPlaceHolderID="MainContent" runat="server">
  <style>
/* === FIXED SIDEBAR ON DESKTOP === */
.sidebar {
    position: fixed;
    top: 0;
    left: 0;
    height: 100vh;
    width: 250px;
    background: #fff;
    overflow-y: auto;
    box-shadow: 2px 0 5px rgba(0,0,0,0.1);
    z-index: 1000;
}

/* === DESKTOP MAIN CONTENT AREA === */
.main-content {
    margin-left: 250px;
    padding: 20px;
    max-width: 1400px;
    margin-right: auto;
}

/* === CARD DESIGN === */
.card {
    margin-bottom: 24px;
    border: 1px solid #ddd;
    border-radius: 8px;
    box-shadow: 0 1px 3px rgba(0,0,0,0.08);
    background: #fff;
    width: 100%; /* ensures cards take full width of column */
}

.card-header {
    font-size: 15px;
    font-weight: 600;
    background: #f8f9fa;
    padding: 12px 16px;
    border-bottom: 1px solid #ddd;
}

.card-body {
    padding: 12px 16px;
}

.card-body.table-responsive {
    width: 100%;
    overflow-x: auto;
    overflow-y: hidden;
    -webkit-overflow-scrolling: touch;
}

/* === TABLE STYLING (DESKTOP DEFAULT) === */
.table {
    width: 100%;
    border-collapse: collapse;
    font-size: 14px;
    min-width: 750px;
    background: #fff;
}

.table th, 
.table td {
    padding: 10px 12px;
    border: 1px solid #ddd;
    text-align: left;
    vertical-align: middle;
    white-space: nowrap;
}

.table th {
    background: #f2f2f2;
    font-weight: 600;
    color: #333;
}

.table tbody tr:nth-child(odd) {
    background-color: #fafafa;
}

.table tbody tr:hover {
    background-color: #eef6ff;
}

.td_amount_col {
    text-align: right;
}

/* === TABLE HEADER STICKINESS === */
.card-body.table-responsive {
    position: relative;
}

.card-body.table-responsive table thead th {
    position: sticky;
    top: 0;
    z-index: 2;
}

/* === TEXT === */
h3 {
    font-size: 20px;
    margin-bottom: 8px;
}

p {
    font-size: 15px;
    color: #333;
    margin-bottom: 16px;
}

/* === GRID FIX FOR TABLES + CARDS === */
.row {
    display: flex;
    flex-wrap: wrap;
    gap: 16px;
}

.col-md-4 {
    flex: 1 1 calc(33.333% - 16px);
    min-width: 280px;
}

/* === TABLET VIEW === */
@media (max-width: 1199px) and (min-width: 769px) {
    .main-content {
        margin-left: 220px;
        padding: 20px;
    }

    .table {
        font-size: 13px;
        min-width: 650px;
    }
}

/* === MOBILE VIEW === */
@media (max-width: 768px) {
    .sidebar {
        position: sticky;
        width: 100%;
        height: auto;
        box-shadow: 0 2px 6px rgba(0,0,0,0.15);
        text-align: center;
        padding: 10px 0;
    }

    .main-content {
        margin-left: 0;
        padding: 10px;
    }

    .row {
        display: block; /* stack everything vertically */
    }

    .col-md-4 {
        width: 100% !important; /* ensure full width on mobile */
        flex: 1 1 100%;
        max-width: 100%;
        padding: 0; /* remove padding gaps */
    }

    .card {
        width: 100% !important;
        margin: 0 0 16px 0; /* spacing between stacked cards */
    }

    .table {
        font-size: 14px;
        min-width: 550px;
    }

    .card-body.table-responsive {
        overflow-x: auto;
    }

    h3 {
        font-size: 14px;
        color: blue;
    }

    p {
        font-size: 14px;
    }
}

/* === FIX FOR EXTRA LEFT SPACE IN MOBILE SCROLL === */
@media (max-width: 768px) {
    .card-body.table-responsive {
        overflow-x: auto;
        overflow-y: hidden;
        -webkit-overflow-scrolling: touch;
        padding-left: 0 !important;
        margin-left: 0 !important;
    }

    .card {
        margin-left: 0 !important;
        padding-left: 0 !important;
    }

    .col-md-4 {
        padding-left: 0 !important;
        margin-left: 0 !important;
    }

    .main-content {
        padding-left: 0 !important;
        margin-left: 0 !important;
    }

    body, html {
        overflow-x: hidden !important;
    }
}
</style>




    <!-- <div class="dashboard-wrapper">
        <div class="sidebar">
            <h2><%= Html.Encode(((XtremeERP.Common.Data.SaccoSettings)ViewBag.SaccoSettings).CompanyName) %></h2>
            <a href="/Members/MembersSystem/Home" class="active">🏠 Dashboard</a>
            <a href="/Members/MembersSystem/LoanApplication">💰 Loan Application</a>
            <a href="/Members/MembersSystem/GuarantorsRequest">🧾 Guarantorship</a>
            <a href="/Members/MembersSystem/WitnessRequest">🫱 Witness Requests</a>
            <a href="/Members/MembersSystem/MemberChats">💬 Support</a>
            <a href="/Account/Logout" style="margin-top:auto; background:var(--suluhu-red); color:#fff;">🚪 Logout</a>
        </div> -->

        <div class="main-content">
            <%= Html.AntiForgeryToken() %>
            <% var saccoSettings = ViewBag.SaccoSettings as XtremeERP.Common.Data.SaccoSettings;
               var saccoMember = ViewBag.SaccoMember as XtremeERP.Common.Data.SaccoMember; %>

            <!-- <h3>Welcome, <%= Html.Encode(saccoMember.FullNames) %></h3> -->
            <p>Welcome to <b><%= Html.Encode(saccoSettings.CompanyName) %></b> online portal.</p>

            <!-- MEMBER DETAILS -->
            <div class="row">
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">Member Details</div>
                        <div class="card-body table-responsive">
                            <table id='tblMemberDetails' class="table table-bordered table-striped">
                                <tbody id='bdMemberDetails'></tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="card"><div class="card-header">Photo</div><div class="card-body" id="divMemberPhoto"></div></div>
                </div>
                <div class="col-md-4">
                    <div class="card"><div class="card-header">Signature</div><div class="card-body" id="divMemberSignature"></div></div>
                </div>
            </div>

            <!-- BALANCES SUMMARY -->
             <div class="row">
            <div class="col-md-4">
                    <div class="card">
                <div class="card-header">Balances Summary</div>
                <div class="card-body table-responsive">
                    <table id='tblBalances' class="table table-bordered table-hover">
                        <thead><tr><th>Type</th><th>Code</th><th>Description</th><th class="td_amount_col">Balance</th></tr></thead>
                        <tbody id='bdBalances'></tbody>
                    </table>
                </div>
            </div>
            </div>

            <!-- LOANS DETAILS -->
             <div class="row">
            <div class="col-md-4">
             <div class="card">
                <div class="card-header">Loans Details</div>
                <div class="card-body table-responsive">
                    <table id='tblLoansDetails' class="table table-bordered table-hover">
                        <thead>
                            <tr>
                                <th>Loan No</th><th>Loan Name</th><th>Issue Date</th><th>End Date</th>
                                <th>Amount</th><th>Balance</th><th>Repayment</th><th>Months</th>
                                <th>Interest (%)</th><th>Defaulted</th>
                            </tr>
                        </thead>
                        <tbody id='bdLoansDetails'></tbody>
                    </table>
                </div>
            </div>
        </div>
         </div>
    </div>
</asp:Content>

<asp:Content ID="ScriptsSection" ContentPlaceHolderID="ScriptsSection" runat="server">
    <script type="text/javascript">
        $(function () {
            if (typeof global_site_root === "undefined") {
                window.global_site_root = "<%= Url.Content("~/") %>".replace(/\/$/, "");
            }

            InitSummary();

            function LoadImageFromUrl(path, width, height, target) {
                var fullPath = global_site_root + path;
                $(target).empty().append($("<img>", {
                    src: fullPath, width, height, class: "img-fluid rounded"
                }));
            }

            function InitSummary() {
                $("#bdMemberDetails, #bdBalances, #bdLoansDetails").empty();

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/GetMemberSummary") %>",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        const det = response.GeneralSummary.MemberDetails;
                        const bals = response.GeneralSummary.MemberBals;
                        LoadImageFromUrl(response.PhotoPath, 290, 290, "#divMemberPhoto");
                        LoadImageFromUrl(response.SignaturePath, 290, 290, "#divMemberSignature");

                        $("#bdMemberDetails").html(`
                            <tr><td data-label="Surname">Surname</td><td data-label="Value">${det.Surname}</td></tr>
                            <tr><td data-label="Other Names">Other Names</td><td data-label="Value">${det.OtherNames}</td></tr>
                            <tr><td data-label="Member No">Member No</td><td data-label="Value">${det.MemberNo}</td></tr>
                            <tr><td data-label="Employer">Employer</td><td data-label="Value">${det.EmployerName}</td></tr>
                            <tr><td data-label="Phone">Phone</td><td data-label="Value">${det.PhoneNo}</td></tr>
                            <tr><td data-label="Email">Email</td><td data-label="Value">${det.EMailAddress}</td></tr>
                        `);

                        bals.forEach(b =>
                            $("#bdBalances").append(`
                                <tr>
                                    <td data-label="Type">${b.BalType}</td>
                                    <td data-label="Code">${b.BalCode}</td>
                                    <td data-label="Description">${b.Description}</td>
                                    <td data-label="Balance" class='td_amount_col'>${(+b.BalAmount).toLocaleString()}</td>
                                </tr>`
                            )
                        );

                        response.LoansInService.forEach(l =>
                            $("#bdLoansDetails").append(`
                                <tr>
                                    <td data-label="Loan No">${l.LoanSerialNumber}</td>
                                    <td data-label="Loan Name">${l.LoanTypeName}</td>
                                    <td data-label="Issue Date">${l.IssueDate}</td>
                                    <td data-label="End Date">${l.ExpectedEndDate}</td>
                                    <td data-label="Amount" class='td_amount_col'>${(+l.LoanAmount).toLocaleString()}</td>
                                    <td data-label="Balance" class='td_amount_col'>${(+l.LoanBalance).toLocaleString()}</td>
                                    <td data-label="Repayment" class='td_amount_col'>${(+l.InstallmentAmount).toLocaleString()}</td>
                                    <td data-label="Months">${l.RepaymentPeriod}</td>
                                    <td data-label="Interest (%)">${l.Interest}</td>
                                    <td data-label="Defaulted">${l.DefaultedAmount}</td>
                                </tr>`
                            )
                        );
                    },
                    error: function (xhr) {
                        console.error("Error fetching summary:", xhr.responseText);
                    }
                });
            }
        });
    </script>
</asp:Content>
