﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Members/Views/Shared/MembersMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    BOSA Statement
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        .td_amount_col {
            text-align: right;
        }
        .statementFooter{
            text-align:center;
        }
        /* === RESPONSIVE TABLE FOR MOBILE (BOSA STATEMENT) === */
@media (max-width: 768px) {
    #tblStatement thead {
        display: none; /* hide table header */
    }

    #tblStatement, 
    #tblStatement tbody, 
    #tblStatement tr, 
    #tblStatement td {
        display: block;
        width: 100%;
    }

    #tblStatement tr {
        margin-bottom: 1rem;
        border: 1px solid #ddd;
        border-radius: 8px;
        padding: 10px;
        background: #fff;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    }

    #tblStatement td {
        text-align: left !important;
        padding-left: 45%;
        position: relative;
        border: none;
        border-bottom: 1px solid #eee;
        font-size: 0.9rem;
        white-space: normal;
        word-wrap: break-word;
    }

    #tblStatement td:last-child {
        border-bottom: none;
    }

    /* Add labels before each data cell */
    #tblStatement td:nth-child(1)::before { content: "Date: "; }
    #tblStatement td:nth-child(2)::before { content: "Description: "; }
    #tblStatement td:nth-child(3)::before { content: "Doc No: "; }
    #tblStatement td:nth-child(4)::before { content: "Debit: "; }
    #tblStatement td:nth-child(5)::before { content: "Credit: "; }
    #tblStatement td:nth-child(6)::before { content: "Balance: "; }
    #tblStatement td:nth-child(7)::before { content: "Int. Debit: "; }
    #tblStatement td:nth-child(8)::before { content: "Int. Credit: "; }
    #tblStatement td:nth-child(9)::before { content: "Int. Balance: "; }

    #tblStatement td::before {
        position: absolute;
        top: 6px;
        left: 10px;
        width: 40%;
        font-weight: 600;
        white-space: nowrap;
        color: #1a5d3f;
    }
}
/* === Align the financial period controls horizontally === */
#frmBOSAStatement table {
    width: 100%;
}

#frmBOSAStatement table tr {
    display: flex;
    flex-wrap: wrap;
    align-items: center;
    justify-content: flex-start;
    border: none;
}

#frmBOSAStatement table td {
    flex: 1 1 auto;
    padding: 6px 10px;
    border: none;
    min-width: 150px;
    font-size: 0.95rem;
}

/* Make labels bold and keep spacing tidy */
#frmBOSAStatement table td:first-child {
    font-weight: 600;
    white-space: nowrap;
}

/* Button and PDF align side by side */
#frmBOSAStatement #btnPrint {
    width: 100%;
    max-width: 180px;
}

#divPDF {
    font-weight: 600;
}

/* === Responsive behavior for mobile === */
@media (max-width: 768px) {
    #frmBOSAStatement table tr {
        flex-direction: column;
        align-items: flex-start;
    }

    #frmBOSAStatement table td {
        width: 100%;
        padding: 5px 0;
    }

    #frmBOSAStatement #btnPrint {
        width: 100%;
    }
}


    </style>
    <script type="text/javascript"  >
        $(document).ready(function () {
            
            $("#btnPrint").toggle();
            $("#btnPrint").click(function () {
                var rptHeader = "<b>" + CompanyName + "<br>" + CompanyAddress + "</br>" + "BOSA Statement" + "</b>" + $("#divAccountInfo").html();
                
                $("#divStatement").printThis({
                    debug: false,
                    pageTitle: "Report",
                    removeInline: true,
                    printContainer: true,
                    importCSS: true,
                    header: rptHeader
                });

            });
            
            $("#cboYear").empty();
            var bolIsLoading = true;
            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/MembersSystemApi/GetYears") %>",
                data: "{}",
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    var years = response;
                    var obj = document.getElementById("cboYear");
                    $.each(years, function (index, yrs) {
                        var opt = document.createElement("option");
                        opt.value = yrs.DBName;
                        opt.text = yrs.UserDefinedYearName;
                        opt.selected = true;
                        obj.appendChild(opt);
                    });
                    //$("#cboYear option:first").attr('selected', true);
                    $("#cboYear").get(0).selectedIndex = 0;
                    LoadFinancialPeriods();
                },
                error: function (xhr, status, error) {

                    var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                }
            });

            $("#cboYear").on("change", function () {
                LoadFinancialPeriods();
            });
            $("#cboEndMonth").on("change", function () {
                LoadBOSAStatement();
            });
            $("#cboFormat").on("change", function () {
                LoadBOSAStatement();
            });

            $('#tblStatement').dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            
            function LoadFinancialPeriods() {
                var dbname = $("#cboYear").val();
                if (dbname == null) { return; }
                $("#cboEndMonth").empty();
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/GetAllBOSAFinancialMonths") %>",
                    data: JSON.stringify({ 'DBName': $("#cboYear").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var fmonths = response;
                        var objEnd = document.getElementById("cboEndMonth");


                        $("#cboEndMonth").empty();
                        $.each(fmonths, function (index, fmonth) {
                            var opt = document.createElement("option");
                            opt.value = fmonth.MonthID;
                            opt.text = fmonth.MonthName;
                            objEnd.appendChild(opt);
                            if (fmonth.Status == "OPENED") {
                                objEnd.selectedIndex = index
                            }
                        });
                        if (dbname.trim().toLowerCase() !== SaccoSettings.LatestDB.trim().toLowerCase()) //not test
                        {
                            $("#cboEndMonth option:last").attr('selected', true);
                            //$("#cboEndMonth option:last").attr('selected', 'selected');
                            //or depending on jq version
                            //$("#cboEndMonth option:last").prop('selected', 'selected');
                        }
                        $("#cboFormat").val(PortalSettings.DefaultBOSAStatementView.toLowerCase()); //this will trigger LoadBOSAStatement() if val is not the same; TODO add variable isLoading

                        bolIsLoading = false;
                        LoadBOSAStatement();
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                    }
                });
            }



            function LoadBOSAStatement() {
                if (bolIsLoading) return;
                
                row = 1;
                $('#divAccountInfo').html("");
                $("#tblStatement > tbody:last").children().remove();
                $("#divPDF").html("PDF Report");

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/GetBOSAStatement") %>",
                    data: JSON.stringify({ 'DBName': $("#cboYear").val(), 'StatementFormat': $("#cboFormat").val(), 'EndPeriod': $("#cboEndMonth").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        row = 1;
                        $('#divAccountInfo').empty();
                        $("#tblStatement > tbody:last").children().remove();
                        if (response.StatementMember != null) {
                            $('#divAccountInfo').append('<p><strong>MemberName: ' + response.StatementMember.FullNames + '<br>'
                                + 'MemberNo: ' + response.StatementMember.MemberNo + '<br>'
                                + 'PayrollNo: ' + response.StatementMember.PayrollNo + '<br>'
                                + 'IDNo: ' + response.StatementMember.IDNumber + '<br>'
                                + '</strong></p>');
                        }

                        var lineitems = response.StatementItems;
                        var statref = "";
                        var total = 0;
                        var inttotal = 0;
                        var tbl_row = "";

                        var pdf_url = "<b><a target='_blank' href='" + global_site_root + "/Members/MembersSystem/BOSAStatementReport?DBName=" + $("#cboYear").val() + "&EndPeriod=" + $("#cboEndMonth").val() + "&StatementFormat=" + $("#cboFormat").val() + "'>PDF Report</a></b>";
                        $("#divPDF").html(pdf_url);

                        $.each(lineitems, function (index, lineitem) {
                            row = row + index;
                            if (statref != lineitem.StatRef) {
                                total = 0;
                                inttotal = 0;
                                statref = lineitem.StatRef;

                                if (index != 0) {
                                    tbl_row = "<tr>";
                                    tbl_row += "<td colspan=8><hr/></td>";
                                    tbl_row += "</tr>";
                                }

                                tbl_row = "<tr>";
                                tbl_row += "<td style='text-align: left;'><b>" + lineitem.RefCode + "</b></td>";
                                tbl_row += "<td style='text-align: left;'><b>" + lineitem.RefName + "</b></td>";
                                tbl_row += "<td style='text-align: left;'><b>Doc. No.</b></td>";
                                tbl_row += "<td class='td_amount_col' ><b>Debit</b></td>";
                                tbl_row += "<td class='td_amount_col' ><b>Credit</b></td>";
                                tbl_row += "<td class='td_amount_col' ><b>Balance</b></td>";
                                tbl_row += "<td class='td_amount_col' ><b>Int. Debit</b></td>";
                                tbl_row += "<td class='td_amount_col' ><b>Int. Credit</b></td>";
                                tbl_row += "<td class='td_amount_col' ><b>Balance</b></td>";
                                tbl_row += "</tr>";
                                $("#bdStatement").append(tbl_row);
                            }

                            if (statref.substring(0, 1) == "S") {
                                total = +total - +lineitem.Debit + +lineitem.Credit;
                                inttotal = +inttotal - +lineitem.IntDebit + +lineitem.IntCredit;
                            } else {
                                total = +total + +lineitem.Debit - +lineitem.Credit;
                                inttotal = +inttotal + +lineitem.IntDebit - +lineitem.IntCredit;
                            }

                            tbl_row = "<tr>";

                            tbl_row += "<td style='text-align: left;'>" + lineitem.DocDate + "</td>";
                            tbl_row += "<td style='text-align: left;'>" + lineitem.Description + "</td>";
                            tbl_row += "<td style='text-align: left;'>" + lineitem.DocNo + "</td>";
                            tbl_row += "<td class='td_amount_col' >" + lineitem.Debit.formatMoney() + "</td>";
                            tbl_row += "<td class='td_amount_col' >" + lineitem.Credit.formatMoney() + "</td>";
                            tbl_row += "<td class='td_amount_col' >" + total.formatMoney() + "</td>";
                            tbl_row += "<td class='td_amount_col ColIntDebit' >" + lineitem.IntDebit.formatMoney() + "</td>";
                            tbl_row += "<td class='td_amount_col ColIntCredit' >" + lineitem.IntCredit.formatMoney() + "</td>";
                            tbl_row += "<td class='td_amount_col ColIntBalance' >" + inttotal.formatMoney() + "</td>";

                            tbl_row += "</tr>";
                            $("#bdStatement").append(tbl_row);



                        });


                        tbl_row = "<tr>";
                        tbl_row += "<td colspan=9 class='statementFooter'><i>**************End of Statement***********</i></td>";
                        tbl_row += "</tr>";
                        $("#bdStatement").append(tbl_row);

                        //hide InterestDR,InterestCr,InterestBal
                        if (PortalSettings.LoansAndInterestAreCombinedInSystem) {
                            $('#tblStatement tr').find('td:eq(6),th:eq(6)').hide();
                            $('#tblStatement tr').find('td:eq(7),th:eq(7)').hide();
                            $('#tblStatement tr').find('td:eq(8),th:eq(8)').hide();
                        }
                        
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                    }
                });


            }

            function setCookie(c_name, value, expiredays) {
                var exdate = new Date();
                exdate.setDate(exdate.getDate() + expiredays);
                document.

                    e = c_name + "=" + escape(value) +
                ((expiredays == null) ? "" : ";expires=" + exdate.toUTCString());
            }
            function getCookie(c_name) {
                if (document.cookie.length > 0) {
                    c_start = document.cookie.indexOf(c_name + "=");
                    if (c_start != -1) {
                        c_start = c_start + c_name.length + 1;
                        c_end = document.cookie.indexOf(";", c_start);
                        if (c_end == -1) c_end = document.cookie.length;
                        return unescape(document.cookie.substring(c_start, c_end));
                    }
                }
                return "";
            }

            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion({
                    heightStyle: "content"
                });
            });

        });
    </script>
</asp:Content>


<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    
    <div class="container" style="padding-top:2px"> 
        <h3>(MPA) Statement</h3>
        <div id="div1" class="col-md-12 table-responsive">
            <form id="frmBOSAStatement" name="frmBOSAStatement">
                <%= Html.AntiForgeryToken() %>
                <table class="table table-bordered table-sm">
                    <caption>Financial Period</caption>
          
                    <tr><td>Financial Year:</td><td ><select id="cboYear"><option value="selectyear">SELECT YEAR</option></select></td></tr>
                    <tr><td>Period:</td><td ><select id="cboEndMonth"><option value="selectEndperiod">Select End Period</option></select></td></tr>
                    <tr><td>Format:</td><td> <select id="cboFormat"><option value="standard">Standard</option><option value="groupbyloantype">Group By Loan Type</option></select> </td></tr>
                    <tr><td><input type="button" id="btnPrint" value="Print Statement" class="btn btn-success"/></td><td><div id="divPDF">PDF Report</div></td></tr>
                    
                    
                </table>
            </form>
        </div>
        <br />
        <div class="col-md-12" >
            <p>Member Info</p><br />
            <div id="divAccountInfo"></div>
        </div>
        <div id="divStatement"  class="col-md-12 table-responsive">
            <table id='tblStatement'  class="table table-striped table-bordered table-sm row-fluid">
                    <thead>
                        <tr>
                        <th style="text-align: left;"><b>Date</b></th>
                        <th style="text-align: left;"><b>Description</b></th>
                        <th style="text-align: left;"><b>Doc No</b></th>
                        <th style="text-align: right;"><b>Debit</b></th>
                        <th style="text-align: right;"><b>Credit</b></th>
                        <th style="text-align: right;"><b>Balance</b></th>
                        <th style="text-align: right;" class="ColHDIntDebit"><b>Int. Debit</b></th>
                        <th style="text-align: right;" class="ColHDIntCredit"><b>Int. Credit</b></th>
                        <th style="text-align: right;" class="ColHDIntBalance"><b>Int. Balance</b></th>
                        </tr>
                    </thead>
                    <tbody id='bdStatement'>
                    </tbody>
                <tfoot style="display:none">
                    <tr>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td class="td_amount_col"></td>
                        <td class="td_amount_col"></td>
                        <td class="td_amount_col"></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    
    </div>
   </asp:Content>


