﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Members/Views/Shared/MembersMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Dividends Report
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
    .td_amount_col {
        text-align: right;
    }

    .statementFooter {
        text-align: center;
    }

    /* --- Make table responsive for mobile devices --- */
    @media (max-width: 768px) {
        #tblDividends thead {
            display: none;
        }

        #tblDividends,
        #tblDividends tbody,
        #tblDividends tr,
        #tblDividends td {
            display: block;
            width: 100%;
        }

        #tblDividends tr {
            margin-bottom: 1rem;
            border: 1px solid #ddd;
            border-radius: 8px;
            background-color: #fafafa;
            padding: 10px;
        }

        #tblDividends td {
            text-align: left !important;
            padding-left: 45%;
            position: relative;
            border: none !important;
            border-bottom: 1px solid #eee;
        }

        #tblDividends td::before {
            content: attr(data-label);
            position: absolute;
            left: 10px;
            width: 40%;
            font-weight: bold;
            white-space: nowrap;
        }
    }
</style>

    <script type="text/javascript"  >
        $(document).ready(function () {
            $("#btnPrint").click(function () {
                //$("#mySelector").printThis({
                //debug: false,              * show the iframe for debugging
                //importCSS: true,           * import page CSS
                //printContainer: true,      * grab outer container as well as the contents of the selector
                //loadCSS: "path/to/my.css", * path to additional css file
                //pageTitle: "",             * add title to print page
                //removeInline: false        * remove all inline styles from print elements

                var rptHeader = "<b>" + CompanyName + "<br>" + CompanyAddress + "</br>" + "Dividends Report: " + $("#cboYear option:selected").text() + "</b>" + $("#divAccountInfo").html();
                $("#divDividends").printThis({
                    debug: false,
                    pageTitle: "Report",
                    removeInline: true,
                    printContainer: true,
                    importCSS: true,
                    header: rptHeader
                });

            });
            $("#cboYear").empty();
            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/MembersSystemApi/GetYears") %>",
                data: "{}",
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    var years = response;
                    var obj = document.getElementById("cboYear");
                    $.each(years, function (index, yrs) {
                        var opt = document.createElement("option");
                        opt.value = yrs.DBName;
                        opt.text = yrs.UserDefinedYearName;
                        opt.selected = true;
                        obj.appendChild(opt);
                    });
                    $("#cboYear").get(0).selectedIndex = 0;
                    DispDividends();
                },
                error: function (xhr, status, error) {
                    var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                }
            });

            $("#cboYear").on("change", function () {
                DispDividends();
            });
            

            

            function DispDividends() {
                row = 1;
                $('#divAccountInfo').html("");
                $("#tblDividends > tbody:last").children().remove();
                

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/GetMemberDividendsDetails") %>",
                    data: JSON.stringify({ 'DBName': $("#cboYear").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        row = 1;
                        $('#divAccountInfo').empty();
                        $("#tblDividends > tbody:last").children().remove();
                        if (response.MemberDetails != null) {
                            $('#divAccountInfo').append('<p><strong>MemberName: ' + response.MemberDetails.FullNames + '<br>'
                                                                + 'MemberNo: ' + response.MemberDetails.MemberNo + '<br>'
                                                                + 'PayrollNo: ' + response.MemberDetails.PayrollNo + '<br>'
                                                            + 'IDNo: ' + response.MemberDetails.IDNumber + '<br>'
                                                             + '</strong></p>');
                        }

                        var lineitems = response.DividendsItems;
                        var statref = "";
                        var total = 0;
                        var inttotal = 0;
                        var tbl_row = "";

                        

                        $.each(lineitems, function (index, lineitem) {
                            row = row + index;
                            /*
                            if (statref != lineitem.StatRef) {
                                total = 0;
                                inttotal = 0;
                                statref = lineitem.StatRef;

                                if (index != 0) {
                                    tbl_row = "<tr>";
                                    tbl_row += "<td colspan=8><hr/></td>";
                                    tbl_row += "</tr>";
                                }

                                tbl_row = "<tr>";
                                tbl_row += "<td style='text-align: left;padding:7px'><b>" + lineitem.RefCode + "</b></td>";
                                tbl_row += "<td style='text-align: left;padding:7px'><b>" + lineitem.RefName + "</b></td>";
                                tbl_row += "<td style='text-align: left;padding:7px'><b>Doc. No.</b></td>";
                                tbl_row += "<td class='td_amount_col' style='padding:7px'><b>Debit</b></td>";
                                tbl_row += "<td class='td_amount_col' style='padding:7px'><b>Credit</b></td>";
                                tbl_row += "<td class='td_amount_col' style='padding:7px'><b>Balance</b></td>";
                                tbl_row += "<td class='td_amount_col' style='padding:7px'><b>Int. Debit</b></td>";
                                tbl_row += "<td class='td_amount_col' style='padding:7px'><b>Int. Credit</b></td>";
                                tbl_row += "<td class='td_amount_col' style='padding:7px'><b>Balance</b></td>";
                                tbl_row += "</tr>";
                                $("#bdDividends").append(tbl_row);
                            }

                            if (statref.substring(0, 1) == "S") {
                                total = +total + +lineitem.Debit + +lineitem.Credit;
                                inttotal = +inttotal + +lineitem.IntDebit + +lineitem.IntCredit;
                            } else {
                                total = +total + +lineitem.Debit - +lineitem.Credit;
                                inttotal = +inttotal + +lineitem.IntDebit - +lineitem.IntCredit;
                            }
                            */

                            tbl_row += "<tr>";
                            tbl_row += "<td style='text-align: left;padding:7px'>" + lineitem.SchemeCode + "</td>";
                            tbl_row += "<td style='text-align: left;padding:7px'>" + lineitem.SchemeName + "</td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'>" + lineitem.TotalDeposits.formatMoney() + "</td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'>" + lineitem.Rate.formatMoney() + "</td>";
                            tbl_row += "<td style='text-align: left;padding:7px'>" + lineitem.MethodUsed + "</td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'>" + lineitem.GrossAmount.formatMoney() + "</td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'>" + lineitem.TotalTaxCharged.formatMoney() + "</td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'>" + lineitem.ProcessingFees.formatMoney() + "</td>";
                            tbl_row += "<td class='td_amount_col' style='padding:7px'>" + lineitem.NetAmount.formatMoney() + "</td>";
                            tbl_row += "</tr>";
                            
                            

                        });


                        tbl_row += "<tr>";
                        tbl_row += "<td colspan=9><i>**************End of Report***********</i></td>";
                        tbl_row += "</tr>";
                        $("#bdDividends").append(tbl_row);
                        // After table is populated
$("#tblDividends tbody tr").each(function() {
    $(this).find("td").eq(0).attr("data-label", "Code");
    $(this).find("td").eq(1).attr("data-label", "Type");
    $(this).find("td").eq(2).attr("data-label", "Amount Used");
    $(this).find("td").eq(3).attr("data-label", "Rate");
    $(this).find("td").eq(4).attr("data-label", "Method");
    $(this).find("td").eq(5).attr("data-label", "Gross");
    $(this).find("td").eq(6).attr("data-label", "Tax");
    $(this).find("td").eq(7).attr("data-label", "Fees");
    $(this).find("td").eq(8).attr("data-label", "Net");
});

                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                    }
                });


            }

            function setCookie(c_name, value, expiredays) {
                var exdate = new Date();
                exdate.setDate(exdate.getDate() + expiredays);
                document.

                    e = c_name + "=" + escape(value) +
                ((expiredays == null) ? "" : ";expires=" + exdate.toUTCString());
            }
            function getCookie(c_name) {
                if (document.cookie.length > 0) {
                    c_start = document.cookie.indexOf(c_name + "=");
                    if (c_start != -1) {
                        c_start = c_start + c_name.length + 1;
                        c_end = document.cookie.indexOf(";", c_start);
                        if (c_end == -1) c_end = document.cookie.length;
                        return unescape(document.cookie.substring(c_start, c_end));
                    }
                }
                return "";
            }

            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion({
                    heightStyle: "content"
                });
            });
            
        });
    </script>
</asp:Content>




<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <div class="container">
    <h3>Dividends Report</h3>
        <div class="row">
            <div id="div1" class="col-md-12 table-responsive">
                <form id="frmDividends" name="frmDividends">
                <%= Html.AntiForgeryToken() %>
                    <table border="1" class="table table-striped table-bordered table-sm row-fluid">
                        <tr>
                            <td colspan="4"><b>Financial Period</b></td>
                        </tr>
                        <tr><td>Financial Year:</td><td colspan="3"><select id="cboYear"><option value="selectyear">SELECT YEAR</option></select></td></tr>
                        <tr><td></td><td><input type="button" id="btnPrint" value="Print Report" class="btn btn-success"/></td></tr>
                        
                        <tr><td colspan="4"><b>Member Info</b></td></tr>
                        <tr><td colspan="4"><div id="divAccountInfo"></div></td></tr>
                    </table>
                </form>
            </div>
        </div>
       <br />
        <div class="row">
            <div class="col-md-12 table-responsive" id="divDividends">
                <table id='tblDividends' class="table table-striped table-bordered table-sm row-fluid">
                        <thead>
                            <tr>
                            <th style="text-align: left;padding:7px"><b>Code</b></th>
                            <th style="text-align: left;padding:7px"><b>Type</b></th>
                            <th style="text-align: right;padding:7px"><b>Amount Used</b></th>
                            <th style="text-align: right;padding:7px"><b>Rate</b></th>
                            <th style="text-align: left;padding:7px"><b>Method</b></th>
                            <th style="text-align: right;padding:7px"><b>Gross</b></th>
                            <th style="text-align: right;padding:7px"><b>Tax</b></th>
                            <th style="text-align: right;padding:7px"><b>Fees</b></th>
                            <th style="text-align: right;padding:7px"><b>Net</b></th>
                            </tr>
                        </thead>
                        <tbody id='bdDividends'>
                        </tbody>
                    <tfoot>
                        <tr>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    
    </div>
</asp:Content>


