﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Members/Views/Shared/MembersMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Dividends Report
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        .td_amount_col {
            text-align: right;
        }
        .statementFooter{
            text-align:center;
        }
    </style>
    <script type="text/javascript"  >
        $(document).ready(function () {
            $("#btnPrint").click(function () {
                //$("#mySelector").printThis({
                //debug: false,              * show the iframe for debugging
                //importCSS: true,           * import page CSS
                //printContainer: true,      * grab outer container as well as the contents of the selector
                //loadCSS: "path/to/my.css", * path to additional css file
                //pageTitle: "",             * add title to print page
                //removeInline: false        * remove all inline styles from print elements

                var rptHeader = "<b>" + CompanyName + "<br>" + CompanyAddress + "</br>" + "Dividends Report: " + $("#cboYear option:selected").text() + "</b>" + $("#divAccountInfo").html();
                $("#divDividends").printThis({
                    debug: false,
                    pageTitle: "Dividends Report",
                    removeInline: false,
                    printContainer: false,
                    importCSS: true,
                    header: rptHeader
                });

            });
            $("#cboYear").empty();
            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/MembersSystemApi/GetYears") %>",
                data: "{}",
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    var years = response;
                    var obj = document.getElementById("cboYear");
                    $.each(years, function (index, yrs) {
                        var opt = document.createElement("option");
                        opt.value = yrs.DBName;
                        opt.text = yrs.UserDefinedYearName;
                        opt.selected = true;
                        obj.appendChild(opt);
                    });
                    $("#cboYear").get(0).selectedIndex = 0;
                    DispDividends();
                },
                error: function (xhr, status, error) {
                    var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                }
            });

            $("#cboYear").on("change", function () {
                DispDividends();
            });
            $("#btnRefresh").on("click", function () {
                DispDividends();
            });
            function DispDividends() {
                row = 1;
                $('#divAccountInfo').html("");
                $("#tblDividends > tbody:last").children().remove();
                $("#tblOffsets > tbody:last").children().remove();
                $("#divSummary").html("");

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/GetMemberDividendsSlipDetailed") %>",
                    data: JSON.stringify({ 'DBName': $("#cboYear").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        row = 1;
                        $('#divAccountInfo').empty();
                        $("#tblDividends > tbody:last").children().remove();
                        if (response.MemberDetails != null) {
                            $('#divAccountInfo').append('<p><strong>Member Name: ' + response.MemberDetails.FullNames + '<br>'
                                + 'MemberNo: ' + response.MemberDetails.MemberNo + '<br>'
                                + 'PayrollNo: ' + response.MemberDetails.PayrollNo + '<br>'
                                + 'IDNo: ' + response.MemberDetails.IDNumber + '<br>'
                                + '</strong></p>');
                        }

                        var lineitems = response.ReportItems;
                        var statref = "";
                        var total = 0;
                        var inttotal = 0;
                        var tbl_row = "";



                        $.each(lineitems, function (index, lineitem) {
                            row = row + index;
                            
                            tbl_row += "<tr>";
                            tbl_row += "<td>" + lineitem.Description + "</td>";
                            tbl_row += "<td>" + lineitem.Period + "</td>";
                            tbl_row += "<td class='td_amount_col'>" + lineitem.DepositsRate.formatMoney() + "</td>";
                            tbl_row += "<td class='td_amount_col'>" + lineitem.DepositsAmount.formatMoney() + "</td>";
                            tbl_row += "<td class='td_amount_col'>" + lineitem.IntOnDeposits.formatMoney() + "</td>";
                            tbl_row += "<td class='td_amount_col'>" + lineitem.SharesRate.formatMoney() + "</td>";
                            tbl_row += "<td class='td_amount_col'>" + lineitem.SharesAmount.formatMoney() + "</td>";
                            tbl_row += "<td class='td_amount_col'>" + lineitem.DividendsOnShares.formatMoney() + "</td>";

                            tbl_row += "</tr>";

                            

                        });


                        tbl_row += "<tr>";
                        tbl_row += "<td colspan=9 style='text-align:center'><i>**************End of Contribution Report***********</i></td>";
                        tbl_row += "</tr>";

                        $("#bdDividends").append(tbl_row);
                        var totalOffsets = 0.00;
                        if (response.DivInstructions) {
                            lineitems = response.DivInstructions;

                            tbl_row = "";

                            $.each(lineitems, function (index, lineitem) {
                                row = row + index;

                                tbl_row += "<tr>";
                                tbl_row += "<td>" + lineitem.Description + "</td>";
                                tbl_row += "<td class='td_amount_col'>" + lineitem.Amount.formatMoney() + "</td>";
                                tbl_row += "</tr>";

                                totalOffsets += lineitem.Amount;

                            });
                            if (totalOffsets > 0) {
                                tbl_row += "<tr>";
                                tbl_row += "<td>TOTAL DEDUCTIONS</td>";
                                tbl_row += "<td class='td_amount_col'>" + totalOffsets.formatMoney() + "</td>";
                                tbl_row += "</tr>";
                            }
                            $("#bdOffsets").append(tbl_row);
                        }
                        var slipSummary = "<p>Gross : " + response.TotalGross.formatMoney() + "</p><p>Tax   : " + response.TotalTax.formatMoney() + "</p><p>Processing Fees   : " + response.TotalProcesingFees.formatMoney() + "</p><p>Net Dividends   : " + response.TotalNet.formatMoney() + "</p><p>Deductions   : " + response.TotalDeductions.formatMoney() + "</p> <p>Dividends Payable After Deductions   : " + response.TotalNetAfterDeductions.formatMoney() + "</p>";
                        $("#divSummary").append(slipSummary);
                       
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });


            }

            function setCookie(c_name, value, expiredays) {
                var exdate = new Date();
                exdate.setDate(exdate.getDate() + expiredays);
                document.

                    e = c_name + "=" + escape(value) +
                    ((expiredays == null) ? "" : ";expires=" + exdate.toUTCString());
            }
            function getCookie(c_name) {
                if (document.cookie.length > 0) {
                    c_start = document.cookie.indexOf(c_name + "=");
                    if (c_start != -1) {
                        c_start = c_start + c_name.length + 1;
                        c_end = document.cookie.indexOf(";", c_start);
                        if (c_end == -1) c_end = document.cookie.length;
                        return unescape(document.cookie.substring(c_start, c_end));
                    }
                }
                return "";
            }

            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion({
                    heightStyle: "content"
                });
            });

        });
    </script>
</asp:Content>




<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <div class="container">
    <h3>Dividends Report</h3>
        <div class="row">
            <div id="div1" class="col-md-12 table-responsive">
                <form id="frmDividends" name="frmDividends">
                <%= Html.AntiForgeryToken() %>
                    <table border="1"  class="table table-striped table-bordered table-sm row-fluid">
                        <tr>
                            <td colspan="4"><b>Financial Period</b></td>
                        </tr>
                        <tr><td>Financial Year:</td><td colspan="3"><select id="cboYear"><option value="selectyear">SELECT YEAR</option></select></td></tr>
                        <tr><td></td><td><input type="button" id="btnPrint" value="Print Report" class="btn btn-primary"/>&nbsp &nbsp<input type="button" id="btnRefresh" value="Refresh" class="btn btn-primary"/></td></tr>
                        
                        
                        <tr><td colspan="4"><b>Member Info</b></td></tr>
                        <tr><td colspan="4" style="text-align:center"><div id="divAccountInfo"></div></td></tr>
                    </table>
                </form>
            </div>
        </div>
       <br />
        <div class="row">
            <div class="col-md-12 table-responsive" id="divDividends">
                <table id='tblDividends' class="table table-striped table-bordered table-sm row-fluid">
                        <thead>
                            <tr>
                            <th style="text-align:left"><b>Description</b></th>
                            <th><b>Period</b></th>
                            <th class="td_amount_col"><b>Rate(Deposits)</b></th>
                            <th class="td_amount_col"><b>Deposits</b></th>
                            <th class="td_amount_col"><b>Interest</b></th>
                            <th class="td_amount_col"><b>Rate(Shares)</b></th>
                            <th class="td_amount_col"><b>Shares</b></th>
                            <th class="td_amount_col"><b>Dividends</b></th>
                            </tr>
                        </thead>
                        <tbody id='bdDividends'>
                        </tbody>
                    
                </table>
                <hr style="color:black" />
                <table id='tblOffsets' class="table table-striped table-bordered table-sm row-fluid">
                        <thead>
                            <tr>
                            <th style="text-align:left"><b>Deductions</b></th>
                            <th class="td_amount_col"><b>Amount</b></th>
                            </tr>
                        </thead>
                        <tbody id='bdOffsets'>
                        </tbody>
                    
                </table>
                <span id="divSummary">

                </span>
                <p><i><small>Note: All Amounts in Ksh</small></i></p>
            </div>
        </div>
    
    </div>
</asp:Content>


