﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Areas/Members/Views/Shared/MembersMasterBS.Master" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<%--<%@ Register assembly="Microsoft.ReportViewer.WebForms, Version=11.0.0.0, Culture=neutral, PublicKeyToken=89845dcd8080cc91" namespace="Microsoft.Reporting.WebForms" tagprefix="rsweb" %>--%>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Bank Statement
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsSection" runat="server">
   <style type="text/css">
    .td_amount_col {
        text-align: right;
    }

    /* ✅ Desktop view (default) */
    #tblStatement {
        width: 100%;
        border-collapse: collapse;
    }

    /* ✅ Responsive table design for mobile view */
    @media (max-width: 768px) {
        #tblStatement thead {
            display: none;
        }

        #tblStatement,
        #tblStatement tbody,
        #tblStatement tr,
        #tblStatement td {
            display: block;
            width: 100%;
        }

        #tblStatement tr {
            margin-bottom: 1rem;
            border: 1px solid #ddd;
            border-radius: 10px;
            background-color: #fafafa;
            padding: 10px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.05);
        }

        #tblStatement td {
            text-align: left !important;
            padding-left: 45%;
            position: relative;
            border: none !important;
            border-bottom: 1px solid #eee;
        }

        #tblStatement td::before {
            content: attr(data-label);
            position: absolute;
            left: 10px;
            width: 40%;
            font-weight: bold;
            white-space: nowrap;
        }
    }

    /* ✅ Always use desktop layout when printing */
    @media print {
        #tblStatement thead {
            display: table-header-group !important;
        }
        #tblStatement,
        #tblStatement tbody,
        #tblStatement tr,
        #tblStatement td,
        #tblStatement th {
            display: table-row-group !important;
            width: auto !important;
            border: 1px solid #000 !important;
        }

        #tblStatement tr,
        #tblStatement td,
        #tblStatement th {
            box-shadow: none !important;
            background: #fff !important;
            padding: 4px !important;
        }

        #tblStatement td::before {
            content: none !important;
        }
    }
</style>


    </style>
    <script type="text/javascript"  >
        $(document).ready(function () {
            $("#cboYear").empty();
            /*
            $('#tblStatement').dataTable({
                "paging": false,
                "ordering": false,
                "info": false,
                "searching": false
            });
            */
            $("#cboAccount").on('change', function () {
                LoadFosaStatement();
            });
            $("#cboStartMonth").on('change', function () {
                LoadFosaStatement();
            });
            $("#cboEndMonth").on('change', function () {
                LoadFosaStatement();
            });

            $("#btnRefresh").on('click', function () {
                LoadFosaStatement();
            });

            $("#cboYear").on('change', function () {
                var dbname = $("#cboYear").val();
                if (dbname == null) { return; }
                $("#cboStartMonth").empty();
                $("#cboEndMonth").empty();

                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/GetAllBOSAFinancialMonths") %>",
                    data: JSON.stringify({ 'DBName': $("#cboYear").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var fmonths = response;
                        var objEnd = document.getElementById("cboEndMonth");
                        var objStart = document.getElementById("cboStartMonth");
                        $("#cboStartMonth").empty();
                        $("#cboEndMonth").empty();
                        $.each(fmonths, function (index, fmonth) {
                            var opt = document.createElement("option");
                            opt.value = fmonth.MonthID;
                            opt.text = fmonth.MonthName;
                            objEnd.appendChild(opt);
                            if (fmonth.Status == "OPENED") {
                                objEnd.selectedIndex = index
                            }
                            opt = document.createElement("option");
                            opt.value = fmonth.MonthID;
                            opt.text = fmonth.MonthName;
                            objStart.appendChild(opt);
                            if (fmonth.MonthID == "01") {
                                objStart.selectedIndex = index
                            }
                        });
                        
                        LoadFosaStatement();
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
                        alert('Error - ' + errorMessage);
                    }
                });
            });

            $("#btnPrint").click(function () {
                //$("#mySelector").printThis({
                //debug: false,              * show the iframe for debugging
                //importCSS: true,           * import page CSS
                //printContainer: true,      * grab outer container as well as the contents of the selector
                //loadCSS: "path/to/my.css", * path to additional css file
                //pageTitle: "",             * add title to print page
                //removeInline: false        * remove all inline styles from print elements

                var rptHeader = "<b>" + CompanyName + "<br>" + CompanyAddress + "</br>" + "Bank Statement" + "</b>";
                $("#divStatement").printThis({
                    debug: false,
                    pageTitle: "Report",
                    removeInline: true,
                    printContainer: true,
                    importCSS: true,
                    header: rptHeader
                });

            });


            var csrfToken = $("input[name='__RequestVerificationToken']").val();
            $.ajax({
                headers: { __RequestVerificationToken: csrfToken },
                type: "POST",
                url: "<%: Url.Content("~/api/MembersSystemApi/GetYears") %>",
                data: "{}",
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    var years = response;
                    var obj = document.getElementById("cboYear");
                    $.each(years, function (index, yrs) {
                        var opt = document.createElement("option");
                        opt.value = yrs.DBName;
                        opt.text = yrs.UserDefinedYearName;
                        opt.selected = true;
                        obj.appendChild(opt);
                    });
                    $("#cboYear").get(0).selectedIndex = 0;
                    $("#cboYear").trigger('change');
                },
                error: function (xhr, status, error) {

                    var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                }
            });

            LoadFosaStatementAccounts();



            function LoadFosaStatement() {
                $('#divAccountInfo').html("");
                $("#tblStatement > tbody:last").children().remove();
                $("#divPDF").html("PDF Report");
                if (document.getElementById("cboAccount").selectedIndex == 0) { return; }
                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/GetBankStatement") %>",
                    data: JSON.stringify({ 'DBName': $("#cboYear").val(), 'StartPeriod': $("#cboStartMonth").val(), 'EndPeriod': $("#cboEndMonth").val(), 'AccountNo': $("#cboAccount").val() }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        $('#divAccountInfo').html('<p><strong>Account Name: ' + response.StatementAccount.AccountName + '<br>'
                                                            + 'Account Code: ' + response.StatementAccount.UserCode + '<br>'
                                                            + 'Account Type: ' + response.StatementAccount.ParentAccName + '<br>'

                                                             + '</strong></p>');
                        if (response.StatementAccount.MemberDetails != null) {
                            $('#divAccountInfo').append('<p><strong>MemberName: ' + response.StatementAccount.MemberDetails.FullNames + '<br>'
                                                                + 'MemberNo: ' + response.StatementAccount.MemberDetails.MemberNo + '<br>'
                                                                + 'PayrollNo: ' + response.StatementAccount.MemberDetails.PayrollNo + '<br>'
                                                            + 'IDNo: ' + response.StatementAccount.MemberDetails.IDNumber + '<br>'
                                                             + '</strong></p>');
                        }

                        var lineitems = response.StatementItems;
                        var tbl_row = "";
                        var pdf_url = "<b><a href='" + global_site_root + "/Members/MembersSystem/GetBankStatementReport?DBName=" + $("#cboYear").val() + "&StartPeriod=" + $("#cboStartMonth").val() + "&EndPeriod=" + $("#cboEndMonth").val() + "&AccountNo=" + response.StatementAccount.UserCode + "'>PDF Report</a></b>";
                        $("#divPDF").html(pdf_url);
                        $.each(lineitems, function (index, lineitem) {
                           tbl_row = "<tr>"
    + "<td data-label='Date'>" + lineitem.Document_Date + "</td>"
    + "<td data-label='Description' class='td_description'>" + lineitem.Description + "</td>"
    + "<td data-label='Doc No' class='td_description'>" + lineitem.Document_no + "</td>"
    + "<td data-label='Debit' class='td_amount_col'>" + lineitem.Debit.formatMoney() + "</td>"
    + "<td data-label='Credit' class='td_amount_col'>" + lineitem.Credit.formatMoney() + "</td>"
    + "<td data-label='Balance' class='td_amount_col'>" + lineitem.RunBal.formatMoney() + "</td>"
    + "</tr>";

                            $("#bdStatement").append(tbl_row);
                        });

                        tbl_row = "<tr>";
                        tbl_row += "<td colspan=6><i>**************End of Statement***********</i></td>";
                        tbl_row += "</tr>";
                        $("#bdStatement").append(tbl_row);
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                    }
                });
            }
            function LoadFosaStatementAccounts() {
                $("#cboAccount").empty();
                $("#cboAccount").append('<option selected>(SELECT ACCOUNT)</option>');

                $('#divAccountInfo').html("");
                $("#tblStatement > tbody:last").children().remove();


                var csrfToken = $("input[name='__RequestVerificationToken']").val();
                $.ajax({
                    headers: { __RequestVerificationToken: csrfToken },
                    type: "POST",
                    url: "<%: Url.Content("~/api/MembersSystemApi/GetMemberFOSAAccounts") %>",
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var bankaccounts = response;
                        var obj = document.getElementById("cboAccount");
                        $.each(bankaccounts, function (index, bankaccount) {
                            var opt = document.createElement("option");
                            opt.value = bankaccount.AccountNo;
                            opt.text = bankaccount.AccountNo;
                            obj.appendChild(opt);
                        });
                    },
                    error: function (xhr, status, error) {

                        var errorMessage = xhr.status + ': ' + xhr.responseText;
 alert('Error - ' + errorMessage);
                    }
                });
            }
            function setCookie(c_name, value, expiredays) {
                var exdate = new Date();
                exdate.setDate(exdate.getDate() + expiredays);
                document.

                    e = c_name + "=" + escape(value) +
                ((expiredays == null) ? "" : ";expires=" + exdate.toUTCString());
            }
            function getCookie(c_name) {
                if (document.cookie.length > 0) {
                    c_start = document.cookie.indexOf(c_name + "=");
                    if (c_start != -1) {
                        c_start = c_start + c_name.length + 1;
                        c_end = document.cookie.indexOf(";", c_start);
                        if (c_end == -1) c_end = document.cookie.length;
                        return unescape(document.cookie.substring(c_start, c_end));
                    }
                }
                return "";
            }

            $(function () {
                $("#tabs").tabs();
            });
            $(function () {
                $("#accordion").accordion();
            });
        });
    </script>
</asp:Content>


<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <div class="container" style="padding-top:2px"> 
    <h3>Bank Statement</h3>
        <br />
        <div class="row">
            <div id="div1" class="col-md-12 table-responsive">
                <form id="frmBankStatement" name="frmBankStatement">
                <%= Html.AntiForgeryToken() %>
                <%--<table border="1" style="padding: 1px; margin: 1px;">--%>
                <table class="table table-bordered table-sm">
                    <caption><b>Financial Period</b></caption>
                    
                    <tr><td>Financial Year:</td><td colspan="3"><select id="cboYear"><option value="selectyear">SELECT YEAR</option></select></td></tr>
                    <tr><td>Start Period:</td><td> <select id="cboStartMonth"><option value="selectstartperiod">Select Start Period</option></select></td><td>End Period:</td><td> <select id="cboEndMonth"><option value="selectEndperiod">Select End Period</option></select></td></tr>
        
        
                    <tr><td>Select Account</td><td><select id="cboAccount"><option>SELECT ACCOUNT</option></select></td><td></td><td></td></tr>
                    <tr><td><div id="divPDF">PDF Report</div></td></tr>

                </table >
                    <table class="table table-bordered table-sm">
                        <tr><td><input type="button" id="btnRefresh" value="Refresh" class="btn btn-success"/></td><td><input type="button" id="btnPrint" value="Print Statement" class="btn"/></td></tr>
                    </table>
                </form>
            </div>
        </div>
        <br />
    <div class="row">
    <div id="divAccountInfo" class="col-md-12 table-responsive"></div>
    <div id="divStatement" class="col-md-12 table-responsive">
        
        <table id='tblStatement' class="table table-striped table-bordered table-sm row-fluid">
                    <thead>
                        <tr>
                        <th style="text-align: left;padding:7px"><b>Date</b></th>
                        <th style="text-align: left;padding:7px"><b>Description</b></th>
                        <th style="text-align: left;padding:7px"><b>Doc No</b></th>
                        <th style="text-align: right;padding:7px"><b>Debit</b></th>
                        <th style="text-align: right;padding:7px"><b>Credit</b></th>
                        <th style="text-align: right;padding:7px"><b>Balance</b></th>
                        
                        </tr>
                    </thead>
                    <tbody id='bdStatement'>
                    </tbody>
                <tfoot>
                    <tr>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>
                </tfoot>
            </table>
    </div>
    </div>
    </div>
    

</asp:Content>


