﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Views/Shared/LoginMaster.Master" Inherits="System.Web.Mvc.ViewPage<XtremeERP.WEB.MemberCredentials>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    Xtreme-ERP.Net - Verification
</asp:Content>

<asp:Content ID="Content3" ContentPlaceHolderID="ScriptsSection" runat="server">
    <style type="text/css">
        body {
            background: linear-gradient(to right, #e9f0f7, #ffffff);
        }

        .verification-wrapper {
            min-height: 80vh;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .verification-card {
            background-color: #fff;
            border-radius: 12px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            padding: 40px 30px;
            width: 100%;
            max-width: 420px;
        }

        .verification-card h3 {
            color: #0056b3;
            font-weight: 600;
            text-align: center;
            margin-bottom: 25px;
        }

        #txtVerificationCode {
            text-transform: uppercase;
            letter-spacing: 2px;
            font-weight: 600;
            text-align: center;
        }

        #btnVerify {
            font-weight: 600;
            border-radius: 8px;
            padding: 10px;
        }

        #linkBacktoMemberLogin {
            display: block;
            margin-top: 10px;
            text-align: center;
        }

        #lblMessage {
            color: #d9534f;
            text-align: center;
        }
    </style>

    <script type="text/javascript">
        var SaccoMember = Object(<%= Json.Encode(ViewBag.SaccoMember) %>);

        $(document).ready(function () {
            var noscripts = document.getElementsByClassName("noscript");
            for (var i = 0; i < noscripts.length; i++) {
                noscripts[i].parentNode.removeChild(noscripts[i]);
            }

            $('#ReturnURL').val(getUrlParameter("ReturnUrl"));

            $('#txtVerificationCode').keypress(function (e) {
                if (e.keyCode == 13 || e.which == 13) {
                    e.preventDefault();
                    $('#frmLogin').submit();
                }
            });
        });

        function SubmitForm() {
            if ($('#txtVerificationCode').val().trim() == '') {
                ShowMessage("Enter Verification Code");
                $('#txtVerificationCode').focus();
                return false;
            } else if ($('#txtVerificationCode').val().trim().length < 4) {
                ShowMessage("Code must be at least 4 characters");
                $('#txtVerificationCode').focus();
                return false;
            } else {
                $("#lblMessage").html("<b>Verifying... Please wait</b>");
                return true;
            }
        }

        function ShowMessage(strMsg) {
            $("#lblMessage").html("<b>" + strMsg + "</b>");
        }

        function getUrlParameter(paramName) {
            var searchString = window.location.search.substring(1),
                i, val, params = searchString.split("&");

            for (i = 0; i < params.length; i++) {
                val = params[i].split("=");
                if (val[0] == paramName) {
                    return unescape(val[1]);
                }
            }
            return null;
        }
    </script>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <% XtremeERP.Common.Data.SaccoMember saccoMember = ViewBag.SaccoMember as XtremeERP.Common.Data.SaccoMember; %>

    <div class="verification-wrapper">
        <div class="verification-card">
            <h3>Member Login Verification</h3>

            <form id="frmLogin" method="post" autocomplete="off"
                  action="<%: Url.Content("~/Login/MemberLoginVerification") %>"
                  onsubmit="return SubmitForm()">

                <%= Html.AntiForgeryToken() %>

                <div class="form-group mb-3">
                    <label for="txtVerificationCode" class="form-label">Verification Code:</label>
                    <input class="form-control text-center"
                           type="text"
                           name="txtVerificationCode"
                           id="txtVerificationCode"
                           placeholder="Enter Code"
                           autocomplete="off" />
                </div>

                <p class="text-center mb-3">
                    Dear <b><%: saccoMember.FullNames.ToUpper() %></b>,<br />
                    Please enter the code sent to your phone or email.
                </p>

                <% if (!String.IsNullOrWhiteSpace(ViewBag.Message)) { %>
                <div id="divError" class="mb-3">
                    <p id="lblMessage"><b><%: ViewBag.Message %></b></p>
                </div>
                <% } else { %>
                <p id="lblMessage"></p>
                <% } %>

                <div class="form-group">
                    <input type="submit" value="Verify" id="btnVerify" class="btn btn-success form-control" />
                </div>

                <a href="<%: Url.Action("Member", "Login", new { Area = "" }) %>"
                   id="linkBacktoMemberLogin">
                   Back to Login
                </a>
            </form>
        </div>
    </div>
</asp:Content>
